/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.core.distributed.raft;

import com.alibaba.nacos.consistency.entity.Response;
import com.alipay.sofa.jraft.Closure;
import com.alipay.sofa.jraft.Status;
import com.alipay.sofa.jraft.error.RaftError;
import com.google.protobuf.Message;

public class NacosClosure
implements Closure {
    private final Message message;
    private final Closure closure;
    private final NacosStatus nacosStatus = new NacosStatus();

    public NacosClosure(Message message, Closure closure) {
        this.message = message;
        this.closure = closure;
    }

    public void run(Status status) {
        this.nacosStatus.setStatus(status);
        this.closure.run((Status)this.nacosStatus);
    }

    public void setResponse(Response response) {
        this.nacosStatus.setResponse(response);
    }

    public void setThrowable(Throwable throwable) {
        this.nacosStatus.setThrowable(throwable);
    }

    public Message getMessage() {
        return this.message;
    }

    public static class NacosStatus
    extends Status {
        private Status status;
        private Response response = null;
        private Throwable throwable = null;

        public void setStatus(Status status) {
            this.status = status;
        }

        public void reset() {
            this.status.reset();
        }

        public boolean isOk() {
            return this.status.isOk();
        }

        public int getCode() {
            return this.status.getCode();
        }

        public void setCode(int code) {
            this.status.setCode(code);
        }

        public RaftError getRaftError() {
            return this.status.getRaftError();
        }

        public void setError(int code, String fmt, Object ... args) {
            this.status.setError(code, fmt, args);
        }

        public void setError(RaftError error, String fmt, Object ... args) {
            this.status.setError(error, fmt, args);
        }

        public String toString() {
            return this.status.toString();
        }

        public Status copy() {
            NacosStatus copy = new NacosStatus();
            copy.status = this.status;
            copy.response = this.response;
            copy.throwable = this.throwable;
            return copy;
        }

        public String getErrorMsg() {
            return this.status.getErrorMsg();
        }

        public void setErrorMsg(String errMsg) {
            this.status.setErrorMsg(errMsg);
        }

        public Response getResponse() {
            return this.response;
        }

        public void setResponse(Response response) {
            this.response = response;
        }

        public Throwable getThrowable() {
            return this.throwable;
        }

        public void setThrowable(Throwable throwable) {
            this.throwable = throwable;
        }
    }
}

