/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.core.distributed.id;

import com.alibaba.nacos.consistency.IdGenerator;
import com.alibaba.nacos.sys.env.EnvUtil;
import com.alibaba.nacos.sys.utils.InetUtils;
import com.google.common.base.Preconditions;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SnowFlowerIdGenerator
implements IdGenerator {
    public static final long EPOCH = 1533429240000L;
    private static final Logger logger = LoggerFactory.getLogger(SnowFlowerIdGenerator.class);
    private static final long SEQUENCE_BITS = 12L;
    private static final long WORKER_ID_BITS = 10L;
    private static final long SEQUENCE_MASK = 4095L;
    private static final long WORKER_ID_LEFT_SHIFT_BITS = 12L;
    private static final long TIMESTAMP_LEFT_SHIFT_BITS = 22L;
    private static final long WORKER_ID_MAX_VALUE = 1024L;
    private long workerId;
    private long sequence;
    private long lastTime;
    private long currentId;

    public SnowFlowerIdGenerator() {
        long workerId = ((Integer)EnvUtil.getProperty((String)"nacos.core.snowflake.worker-id", Integer.class, (Object)-1)).intValue();
        if (workerId != -1L) {
            this.workerId = workerId;
        } else {
            InetAddress address;
            try {
                address = InetAddress.getByName(InetUtils.getSelfIP());
            }
            catch (UnknownHostException e) {
                throw new IllegalStateException("Cannot get LocalHost InetAddress, please check your network!", e);
            }
            byte[] ipAddressByteArray = address.getAddress();
            this.workerId = ((ipAddressByteArray[ipAddressByteArray.length - 2] & 3) << 8) + (ipAddressByteArray[ipAddressByteArray.length - 1] & 0xFF);
        }
    }

    public void init() {
        this.initialize(this.workerId);
    }

    public long currentId() {
        return this.currentId;
    }

    public synchronized long nextId() {
        long currentMillis = System.currentTimeMillis();
        Preconditions.checkState((this.lastTime <= currentMillis ? 1 : 0) != 0, (String)"Clock is moving backwards, last time is %d milliseconds, current time is %d milliseconds", (Object[])new Object[]{this.lastTime, currentMillis});
        if (this.lastTime == currentMillis) {
            ++this.sequence;
            if (0L == (this.sequence &= 0xFFFL)) {
                currentMillis = this.waitUntilNextTime(currentMillis);
            }
        } else {
            this.sequence = 0L;
        }
        this.lastTime = currentMillis;
        logger.debug("{}-{}-{}", new Object[]{new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS").format(new Date(this.lastTime)), this.workerId, this.sequence});
        this.currentId = currentMillis - 1533429240000L << 22 | this.workerId << 12 | this.sequence;
        return this.currentId;
    }

    public Map<Object, Object> info() {
        HashMap<Object, Object> info = new HashMap<Object, Object>(4);
        info.put("currentId", this.currentId);
        info.put("workerId", this.workerId);
        return info;
    }

    public void initialize(long workerId) {
        if (workerId > 1024L || workerId < 0L) {
            throw new IllegalArgumentException(String.format("worker Id can't be greater than %d or less than 0, current workId %d", 1024L, workerId));
        }
        this.workerId = workerId;
    }

    private long waitUntilNextTime(long lastTimestamp) {
        long time = System.currentTimeMillis();
        while (time <= lastTimestamp) {
            time = System.currentTimeMillis();
        }
        return time;
    }
}

