/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.core.distributed.distro.task.verify;

import com.alibaba.nacos.consistency.DataOperation;
import com.alibaba.nacos.core.cluster.Member;
import com.alibaba.nacos.core.cluster.ServerMemberManager;
import com.alibaba.nacos.core.distributed.distro.component.DistroComponentHolder;
import com.alibaba.nacos.core.distributed.distro.entity.DistroData;
import com.alibaba.nacos.core.utils.Loggers;
import java.util.List;

public class DistroVerifyTask
implements Runnable {
    private final ServerMemberManager serverMemberManager;
    private final DistroComponentHolder distroComponentHolder;

    public DistroVerifyTask(ServerMemberManager serverMemberManager, DistroComponentHolder distroComponentHolder) {
        this.serverMemberManager = serverMemberManager;
        this.distroComponentHolder = distroComponentHolder;
    }

    @Override
    public void run() {
        try {
            List<Member> targetServer = this.serverMemberManager.allMembersWithoutSelf();
            if (Loggers.DISTRO.isDebugEnabled()) {
                Loggers.DISTRO.debug("server list is: {}", targetServer);
            }
            for (String each : this.distroComponentHolder.getDataStorageTypes()) {
                this.verifyForDataStorage(each, targetServer);
            }
        }
        catch (Exception e) {
            Loggers.DISTRO.error("[DISTRO-FAILED] verify task failed.", (Throwable)e);
        }
    }

    private void verifyForDataStorage(String type, List<Member> targetServer) {
        DistroData distroData = this.distroComponentHolder.findDataStorage(type).getVerifyData();
        if (null == distroData) {
            return;
        }
        distroData.setType(DataOperation.VERIFY);
        for (Member member : targetServer) {
            try {
                this.distroComponentHolder.findTransportAgent(type).syncVerifyData(distroData, member.getAddress());
            }
            catch (Exception e) {
                Loggers.DISTRO.error(String.format("[DISTRO-FAILED] verify data for type %s to %s failed.", type, member.getAddress()), (Throwable)e);
            }
        }
    }
}

