/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.core.controller;

import com.alibaba.nacos.common.model.RestResult;
import com.alibaba.nacos.common.model.RestResultUtils;
import com.alibaba.nacos.core.distributed.ProtocolManager;
import com.alibaba.nacos.core.distributed.id.IdGeneratorManager;
import java.util.HashMap;
import java.util.Map;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/core/ops"})
public class CoreOpsController {
    private final ProtocolManager protocolManager;
    private final IdGeneratorManager idGeneratorManager;

    public CoreOpsController(ProtocolManager protocolManager, IdGeneratorManager idGeneratorManager) {
        this.protocolManager = protocolManager;
        this.idGeneratorManager = idGeneratorManager;
    }

    @PostMapping(value={"/raft"})
    public RestResult<String> raftOps(@RequestBody Map<String, String> commands) {
        return this.protocolManager.getCpProtocol().execute(commands);
    }

    @GetMapping(value={"/idInfo"})
    public RestResult<Map<String, Map<Object, Object>>> idInfo() {
        HashMap info = new HashMap(10);
        this.idGeneratorManager.getGeneratorMap().forEach((resource, idGenerator) -> info.put(resource, idGenerator.info()));
        return RestResultUtils.success(info);
    }
}

