/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.core.cluster.lookup;

import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.common.http.HttpClientBeanHolder;
import com.alibaba.nacos.common.http.HttpRestResult;
import com.alibaba.nacos.common.http.client.NacosRestTemplate;
import com.alibaba.nacos.common.http.param.Header;
import com.alibaba.nacos.common.http.param.Query;
import com.alibaba.nacos.common.model.RestResult;
import com.alibaba.nacos.common.utils.ExceptionUtil;
import com.alibaba.nacos.core.cluster.AbstractMemberLookup;
import com.alibaba.nacos.core.cluster.MemberUtil;
import com.alibaba.nacos.core.utils.GenericType;
import com.alibaba.nacos.core.utils.GlobalExecutor;
import com.alibaba.nacos.core.utils.Loggers;
import com.alibaba.nacos.sys.env.EnvUtil;
import java.io.Reader;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;

public class AddressServerMemberLookup
extends AbstractMemberLookup {
    private final GenericType<RestResult<String>> genericType = new GenericType<RestResult<String>>(){};
    public String domainName;
    public String addressPort;
    public String addressUrl;
    public String envIdUrl;
    public String addressServerUrl;
    private volatile boolean isAddressServerHealth = true;
    private int addressServerFailCount = 0;
    private int maxFailCount = 12;
    private final NacosRestTemplate restTemplate = HttpClientBeanHolder.getNacosRestTemplate((Logger)Loggers.CORE);
    private volatile boolean shutdown = false;

    @Override
    public void start() throws NacosException {
        if (this.start.compareAndSet(false, true)) {
            this.maxFailCount = Integer.parseInt(EnvUtil.getProperty((String)"maxHealthCheckFailCount", (String)"12"));
            this.initAddressSys();
            this.run();
        }
    }

    private void initAddressSys() {
        String envDomainName = System.getenv("address_server_domain");
        this.domainName = StringUtils.isBlank((CharSequence)envDomainName) ? EnvUtil.getProperty((String)"address.server.domain", (String)"jmenv.tbsite.net") : envDomainName;
        String envAddressPort = System.getenv("address_server_port");
        this.addressPort = StringUtils.isBlank((CharSequence)envAddressPort) ? EnvUtil.getProperty((String)"address.server.port", (String)"8080") : envAddressPort;
        String envAddressUrl = System.getenv("address_server_url");
        this.addressUrl = StringUtils.isBlank((CharSequence)envAddressUrl) ? EnvUtil.getProperty((String)"address.server.url", (String)(EnvUtil.getContextPath() + "/serverlist")) : envAddressUrl;
        this.addressServerUrl = "http://" + this.domainName + ":" + this.addressPort + this.addressUrl;
        this.envIdUrl = "http://" + this.domainName + ":" + this.addressPort + "/env";
        Loggers.CORE.info("ServerListService address-server port:" + this.addressPort);
        Loggers.CORE.info("ADDRESS_SERVER_URL:" + this.addressServerUrl);
    }

    private void run() throws NacosException {
        boolean success = false;
        Throwable ex = null;
        int maxRetry = (Integer)EnvUtil.getProperty((String)"nacos.core.address-server.retry", Integer.class, (Object)5);
        for (int i = 0; i < maxRetry; ++i) {
            try {
                this.syncFromAddressUrl();
                success = true;
                break;
            }
            catch (Throwable e) {
                ex = e;
                Loggers.CLUSTER.error("[serverlist] exception, error : {}", (Object)ExceptionUtil.getAllExceptionMsg((Throwable)ex));
                continue;
            }
        }
        if (!success) {
            throw new NacosException(500, ex);
        }
        GlobalExecutor.scheduleByCommon(new AddressServerSyncTask(), 5000L);
    }

    @Override
    public void destroy() throws NacosException {
        this.shutdown = true;
    }

    @Override
    public Map<String, Object> info() {
        HashMap<String, Object> info = new HashMap<String, Object>(4);
        info.put("addressServerHealth", this.isAddressServerHealth);
        info.put("addressServerUrl", this.addressServerUrl);
        info.put("envIdUrl", this.envIdUrl);
        info.put("addressServerFailCount", this.addressServerFailCount);
        return info;
    }

    private void syncFromAddressUrl() throws Exception {
        HttpRestResult result = this.restTemplate.get(this.addressServerUrl, Header.EMPTY, Query.EMPTY, this.genericType.getType());
        if (result.ok()) {
            this.isAddressServerHealth = true;
            StringReader reader = new StringReader((String)result.getData());
            try {
                this.afterLookup(MemberUtil.readServerConf(EnvUtil.analyzeClusterConf((Reader)reader)));
            }
            catch (Throwable e) {
                Loggers.CLUSTER.error("[serverlist] exception for analyzeClusterConf, error : {}", (Object)ExceptionUtil.getAllExceptionMsg((Throwable)e));
            }
            this.addressServerFailCount = 0;
        } else {
            ++this.addressServerFailCount;
            if (this.addressServerFailCount >= this.maxFailCount) {
                this.isAddressServerHealth = false;
            }
            Loggers.CLUSTER.error("[serverlist] failed to get serverlist, error code {}", (Object)result.getCode());
        }
    }

    class AddressServerSyncTask
    implements Runnable {
        AddressServerSyncTask() {
        }

        @Override
        public void run() {
            if (AddressServerMemberLookup.this.shutdown) {
                return;
            }
            try {
                AddressServerMemberLookup.this.syncFromAddressUrl();
            }
            catch (Throwable ex) {
                AddressServerMemberLookup.this.addressServerFailCount++;
                if (AddressServerMemberLookup.this.addressServerFailCount >= AddressServerMemberLookup.this.maxFailCount) {
                    AddressServerMemberLookup.this.isAddressServerHealth = false;
                }
                Loggers.CLUSTER.error("[serverlist] exception, error : {}", (Object)ExceptionUtil.getAllExceptionMsg((Throwable)ex));
            }
            finally {
                GlobalExecutor.scheduleByCommon(this, 5000L);
            }
        }
    }
}

