/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.core.cluster;

import com.alibaba.nacos.common.utils.ExceptionUtil;
import com.alibaba.nacos.common.utils.IPUtil;
import com.alibaba.nacos.common.utils.Objects;
import com.alibaba.nacos.core.cluster.Member;
import com.alibaba.nacos.core.cluster.MemberMetaDataConstants;
import com.alibaba.nacos.core.cluster.NodeState;
import com.alibaba.nacos.core.cluster.ServerMemberManager;
import com.alibaba.nacos.core.utils.Loggers;
import com.alibaba.nacos.sys.env.EnvUtil;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class MemberUtil {
    protected static final String TARGET_MEMBER_CONNECT_REFUSE_ERRMSG = "Connection refused";

    public static void copy(Member newMember, Member oldMember) {
        oldMember.setIp(newMember.getIp());
        oldMember.setPort(newMember.getPort());
        oldMember.setState(newMember.getState());
        oldMember.setExtendInfo(newMember.getExtendInfo());
        oldMember.setAddress(newMember.getAddress());
    }

    public static Member singleParse(String member) {
        int defaultPort = 8848;
        String address = member;
        int port = defaultPort;
        String[] info = IPUtil.splitIPPortStr((String)address);
        if (info.length > 1) {
            address = info[0];
            port = Integer.parseInt(info[1]);
        }
        Member target = Member.builder().ip(address).port(port).state(NodeState.UP).build();
        HashMap<String, Object> extendInfo = new HashMap<String, Object>(4);
        extendInfo.put("raftPort", String.valueOf(MemberUtil.calculateRaftPort(target)));
        target.setExtendInfo(extendInfo);
        return target;
    }

    public static int calculateRaftPort(Member member) {
        return member.getPort() - 1000;
    }

    public static Collection<Member> multiParse(Collection<String> addresses) {
        ArrayList<Member> members = new ArrayList<Member>(addresses.size());
        for (String address : addresses) {
            Member member = MemberUtil.singleParse(address);
            members.add(member);
        }
        return members;
    }

    public static void onSuccess(ServerMemberManager manager, Member member) {
        NodeState old = member.getState();
        manager.getMemberAddressInfos().add(member.getAddress());
        member.setState(NodeState.UP);
        member.setFailAccessCnt(0);
        if (!Objects.equals((Object)((Object)old), (Object)((Object)member.getState()))) {
            manager.notifyMemberChange();
        }
    }

    public static void onFail(ServerMemberManager manager, Member member) {
        MemberUtil.onFail(manager, member, ExceptionUtil.NONE_EXCEPTION);
    }

    public static void onFail(ServerMemberManager manager, Member member, Throwable ex) {
        manager.getMemberAddressInfos().remove(member.getAddress());
        NodeState old = member.getState();
        member.setState(NodeState.SUSPICIOUS);
        member.setFailAccessCnt(member.getFailAccessCnt() + 1);
        int maxFailAccessCnt = (Integer)EnvUtil.getProperty((String)"nacos.core.member.fail-access-cnt", Integer.class, (Object)3);
        if (member.getFailAccessCnt() > maxFailAccessCnt || StringUtils.containsIgnoreCase((CharSequence)ex.getMessage(), (CharSequence)TARGET_MEMBER_CONNECT_REFUSE_ERRMSG)) {
            member.setState(NodeState.DOWN);
        }
        if (!Objects.equals((Object)((Object)old), (Object)((Object)member.getState()))) {
            manager.notifyMemberChange();
        }
    }

    public static void syncToFile(Collection<Member> members) {
        try {
            StringBuilder builder = new StringBuilder();
            builder.append("#").append(LocalDateTime.now()).append("\n");
            for (String member : MemberUtil.simpleMembers(members)) {
                builder.append(member).append("\n");
            }
            EnvUtil.writeClusterConf((String)builder.toString());
        }
        catch (Throwable ex) {
            Loggers.CLUSTER.error("cluster member node persistence failed : {}", (Object)ExceptionUtil.getAllExceptionMsg((Throwable)ex));
        }
    }

    public static Collection<Member> kRandom(Collection<Member> members, Predicate<Member> filter, int k) {
        HashSet<Member> kMembers = new HashSet<Member>();
        int totalSize = members.size();
        Member[] membersArray = members.toArray(new Member[totalSize]);
        ThreadLocalRandom threadLocalRandom = ThreadLocalRandom.current();
        for (int i = 0; i < 3 * totalSize && kMembers.size() < k; ++i) {
            int idx = threadLocalRandom.nextInt(totalSize);
            Member member = membersArray[idx];
            if (!filter.test(member)) continue;
            kMembers.add(member);
        }
        return kMembers;
    }

    public static Collection<Member> readServerConf(Collection<String> members) {
        HashSet<Member> nodes = new HashSet<Member>();
        for (String member : members) {
            Member target = MemberUtil.singleParse(member);
            nodes.add(target);
        }
        return nodes;
    }

    public static Set<Member> selectTargetMembers(Collection<Member> members, Predicate<Member> filter) {
        return members.stream().filter(filter).collect(Collectors.toSet());
    }

    public static List<String> simpleMembers(Collection<Member> members) {
        return members.stream().map(Member::getAddress).sorted().collect(ArrayList::new, ArrayList::add, ArrayList::addAll);
    }

    public static boolean isBasicInfoChanged(Member actual, Member expected) {
        if (null == expected) {
            return null == actual;
        }
        if (!expected.getIp().equals(actual.getIp())) {
            return true;
        }
        if (expected.getPort() != actual.getPort()) {
            return true;
        }
        if (!expected.getAddress().equals(actual.getAddress())) {
            return true;
        }
        if (!expected.getState().equals((Object)actual.getState())) {
            return true;
        }
        return MemberUtil.isBasicInfoChangedInExtendInfo(expected, actual);
    }

    private static boolean isBasicInfoChangedInExtendInfo(Member expected, Member actual) {
        for (String each : MemberMetaDataConstants.BASIC_META_KEYS) {
            if (expected.getExtendInfo().containsKey(each) != actual.getExtendInfo().containsKey(each)) {
                return true;
            }
            if (Objects.equals((Object)expected.getExtendVal(each), (Object)actual.getExtendVal(each))) continue;
            return true;
        }
        return false;
    }
}

