/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.config.server.utils;

import org.apache.commons.lang3.CharUtils;

public class RegexParser {
    private static final char QUESTION_MARK = '?';

    public static String regexFormat(String regex) {
        if (regex == null) {
            throw new NullPointerException("regex string can't be null");
        }
        StringBuilder result = new StringBuilder();
        result.append("^");
        for (int i = 0; i < regex.length(); ++i) {
            char ch = regex.charAt(i);
            if (CharUtils.isAsciiAlphanumeric((char)ch) || CharUtils.isAsciiNumeric((char)ch)) {
                result.append(ch);
                continue;
            }
            if (ch == '*') {
                result.append(".*");
                continue;
            }
            if (ch == '?') {
                int j;
                for (j = 0; j < regex.length() - i && ch == '?'; ++j) {
                    ch = regex.charAt(i + j);
                }
                if (j == regex.length() - i) {
                    result.append(".{" + j + "}");
                    break;
                }
                result.append(".{" + --j + "}");
                i += j - 1;
                continue;
            }
            result.append("\\" + ch);
        }
        result.append("$");
        return result.toString();
    }

    public static boolean containsWildcard(String regex) {
        return regex.contains("?") || regex.contains("*");
    }
}

