/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.config.server.service.trace;

import com.alibaba.nacos.common.utils.MD5Utils;
import com.alibaba.nacos.config.server.monitor.MetricsMonitor;
import com.alibaba.nacos.config.server.utils.LogUtil;
import com.alibaba.nacos.sys.utils.InetUtils;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class ConfigTraceService {
    public static final String PERSISTENCE_EVENT_PUB = "pub";
    public static final String PERSISTENCE_EVENT_REMOVE = "remove";
    public static final String PERSISTENCE_EVENT_MERGE = "merge";
    public static final String NOTIFY_EVENT_OK = "ok";
    public static final String NOTIFY_EVENT_ERROR = "error";
    public static final String NOTIFY_EVENT_UNHEALTH = "unhealth";
    public static final String NOTIFY_EVENT_EXCEPTION = "exception";
    public static final String DUMP_EVENT_OK = "ok";
    public static final String DUMP_EVENT_REMOVE_OK = "remove-ok";
    public static final String DUMP_EVENT_ERROR = "error";
    public static final String PULL_EVENT_OK = "ok";
    public static final String PULL_EVENT_NOTFOUND = "not-found";
    public static final String PULL_EVENT_CONFLICT = "conflict";
    public static final String PULL_EVENT_ERROR = "error";

    public static void logPersistenceEvent(String dataId, String group, String tenant, String requestIpAppName, long ts, String handleIp, String type, String content) {
        if (!LogUtil.TRACE_LOG.isInfoEnabled()) {
            return;
        }
        if (StringUtils.isBlank((CharSequence)tenant)) {
            tenant = null;
        }
        String md5 = content == null ? null : MD5Utils.md5Hex((String)content, (String)"UTF-8");
        LogUtil.TRACE_LOG.info("{}|{}|{}|{}|{}|{}|{}|{}|{}|{}|{}", new Object[]{InetUtils.getSelfIP(), dataId, group, tenant, requestIpAppName, ts, handleIp, "persist", type, -1, md5});
    }

    public static void logNotifyEvent(String dataId, String group, String tenant, String requestIpAppName, long ts, String handleIp, String type, long delayed, String targetIp) {
        if (!LogUtil.TRACE_LOG.isInfoEnabled()) {
            return;
        }
        MetricsMonitor.getNotifyRtTimer().record(delayed, TimeUnit.MILLISECONDS);
        if (StringUtils.isBlank((CharSequence)tenant)) {
            tenant = null;
        }
        LogUtil.TRACE_LOG.info("{}|{}|{}|{}|{}|{}|{}|{}|{}|{}|{}", new Object[]{InetUtils.getSelfIP(), dataId, group, tenant, requestIpAppName, ts, handleIp, "notify", type, delayed, targetIp});
    }

    public static void logDumpEvent(String dataId, String group, String tenant, String requestIpAppName, long ts, String handleIp, String type, long delayed, long length) {
        if (!LogUtil.TRACE_LOG.isInfoEnabled()) {
            return;
        }
        if (StringUtils.isBlank((CharSequence)tenant)) {
            tenant = null;
        }
        LogUtil.TRACE_LOG.info("{}|{}|{}|{}|{}|{}|{}|{}|{}|{}|{}", new Object[]{InetUtils.getSelfIP(), dataId, group, tenant, requestIpAppName, ts, handleIp, "dump", type, delayed, length});
    }

    public static void logDumpAllEvent(String dataId, String group, String tenant, String requestIpAppName, long ts, String handleIp, String type) {
        if (!LogUtil.TRACE_LOG.isInfoEnabled()) {
            return;
        }
        if (StringUtils.isBlank((CharSequence)tenant)) {
            tenant = null;
        }
        LogUtil.TRACE_LOG.info("{}|{}|{}|{}|{}|{}|{}|{}|{}|{}", new Object[]{InetUtils.getSelfIP(), dataId, group, tenant, requestIpAppName, ts, handleIp, "dump-all", type, -1});
    }

    public static void logPullEvent(String dataId, String group, String tenant, String requestIpAppName, long ts, String type, long delayed, String clientIp) {
        if (!LogUtil.TRACE_LOG.isInfoEnabled()) {
            return;
        }
        if (StringUtils.isBlank((CharSequence)tenant)) {
            tenant = null;
        }
        LogUtil.TRACE_LOG.info("{}|{}|{}|{}|{}|{}|{}|{}|{}|{}", new Object[]{InetUtils.getSelfIP(), dataId, group, tenant, requestIpAppName, ts, "pull", type, delayed, clientIp});
    }
}

