/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.config.server.service.notify;

import com.alibaba.nacos.common.model.RestResult;
import com.alibaba.nacos.common.task.NacosTask;
import com.alibaba.nacos.common.task.NacosTaskProcessor;
import com.alibaba.nacos.config.server.monitor.MetricsMonitor;
import com.alibaba.nacos.config.server.service.notify.NotifyService;
import com.alibaba.nacos.config.server.service.notify.NotifyTask;
import com.alibaba.nacos.config.server.service.trace.ConfigTraceService;
import com.alibaba.nacos.core.cluster.Member;
import com.alibaba.nacos.core.cluster.ServerMemberManager;
import com.alibaba.nacos.sys.env.EnvUtil;
import com.alibaba.nacos.sys.utils.InetUtils;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NotifyTaskProcessor
implements NacosTaskProcessor {
    static final Logger LOGGER = LoggerFactory.getLogger(NotifyTaskProcessor.class);
    static final String URL_PATTERN = "http://{0}{1}/v1/cs/communication/dataChange?dataId={2}&group={3}";
    final ServerMemberManager memberManager;

    public NotifyTaskProcessor(ServerMemberManager memberManager) {
        this.memberManager = memberManager;
    }

    public boolean process(NacosTask task) {
        NotifyTask notifyTask = (NotifyTask)task;
        String dataId = notifyTask.getDataId();
        String group = notifyTask.getGroup();
        String tenant = notifyTask.getTenant();
        long lastModified = notifyTask.getLastModified();
        boolean isok = true;
        for (Member ip : this.memberManager.allMembers()) {
            isok = this.notifyToDump(dataId, group, tenant, lastModified, ip.getAddress()) && isok;
        }
        return isok;
    }

    boolean notifyToDump(String dataId, String group, String tenant, long lastModified, String serverIp) {
        long delayed = System.currentTimeMillis() - lastModified;
        try {
            List<String> headers = Arrays.asList("lastModified", String.valueOf(lastModified), "opHandleIp", InetUtils.getSelfIP());
            String urlString = MessageFormat.format(URL_PATTERN, serverIp, EnvUtil.getContextPath(), dataId, group);
            RestResult<String> result = NotifyService.invokeURL(urlString, headers, "UTF-8");
            if (result.ok()) {
                ConfigTraceService.logNotifyEvent(dataId, group, tenant, null, lastModified, InetUtils.getSelfIP(), "ok", delayed, serverIp);
                MetricsMonitor.getNotifyRtTimer().record(delayed, TimeUnit.MILLISECONDS);
                return true;
            }
            MetricsMonitor.getConfigNotifyException().increment();
            LOGGER.error("[notify-error] {}, {}, to {}, result {}", new Object[]{dataId, group, serverIp, result.getCode()});
            ConfigTraceService.logNotifyEvent(dataId, group, tenant, null, lastModified, InetUtils.getSelfIP(), "error", delayed, serverIp);
            return false;
        }
        catch (Exception e) {
            MetricsMonitor.getConfigNotifyException().increment();
            LOGGER.error("[notify-exception] " + dataId + ", " + group + ", to " + serverIp + ", " + e.toString());
            LOGGER.debug("[notify-exception] " + dataId + ", " + group + ", to " + serverIp + ", " + e.toString(), (Throwable)e);
            ConfigTraceService.logNotifyEvent(dataId, group, tenant, null, lastModified, InetUtils.getSelfIP(), "exception", delayed, serverIp);
            return false;
        }
    }
}

