/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.config.server.controller;

import com.alibaba.nacos.config.server.model.GroupkeyListenserStatus;
import com.alibaba.nacos.config.server.model.SampleResult;
import com.alibaba.nacos.config.server.service.ConfigSubService;
import com.alibaba.nacos.config.server.utils.GroupKey2;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/cs/listener"})
public class ListenerController {
    private final ConfigSubService configSubService;

    @Autowired
    public ListenerController(ConfigSubService configSubService) {
        this.configSubService = configSubService;
    }

    @GetMapping
    public GroupkeyListenserStatus getAllSubClientConfigByIp(@RequestParam(value="ip") String ip, @RequestParam(value="all", required=false) boolean all, @RequestParam(value="tenant", required=false) String tenant, @RequestParam(value="sampleTime", required=false, defaultValue="1") int sampleTime, ModelMap modelMap) throws Exception {
        SampleResult collectSampleResult = this.configSubService.getCollectSampleResultByIp(ip, sampleTime);
        GroupkeyListenserStatus gls = new GroupkeyListenserStatus();
        gls.setCollectStatus(200);
        HashMap<String, String> configMd5Status = new HashMap<String, String>(100);
        if (collectSampleResult.getLisentersGroupkeyStatus() != null) {
            Map<String, String> status = collectSampleResult.getLisentersGroupkeyStatus();
            for (Map.Entry<String, String> config : status.entrySet()) {
                if (!StringUtils.isBlank((CharSequence)tenant)) {
                    if (!config.getKey().contains(tenant)) continue;
                    configMd5Status.put(config.getKey(), config.getValue());
                    continue;
                }
                if (all) {
                    configMd5Status.put(config.getKey(), config.getValue());
                    continue;
                }
                String[] configKeys = GroupKey2.parseKey(config.getKey());
                if (!StringUtils.isBlank((CharSequence)configKeys[2])) continue;
                configMd5Status.put(config.getKey(), config.getValue());
            }
            gls.setLisentersGroupkeyStatus(configMd5Status);
        }
        return gls;
    }
}

