/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.sdk.util;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;

public class ResourceLoader {
    private static final String CLASSPATH = "java.class.path";
    private static final String FILESCHEME = "file:";
    private InputStream inputStream;
    private String name;
    private File file;
    private URL url;

    public ResourceLoader(String name) {
        this.name = name;
    }

    public InputStream getInputStream() throws IOException {
        if (this.inputStream == null) {
            if (!this.searchClasspath(this.name) && !this.searchResourcepath(this.name)) {
                throw new IOException("Resource '" + this.name + "' could not be found");
            }
            if (this.file != null) {
                this.inputStream = new BufferedInputStream(new FileInputStream(this.file));
            } else if (this.url != null) {
                this.inputStream = new BufferedInputStream(this.url.openStream());
            }
        }
        return this.inputStream;
    }

    private boolean searchClasspath(String filename) {
        String classpath = System.getProperty(CLASSPATH);
        String[] paths = classpath.split(File.pathSeparator);
        this.file = ResourceLoader.searchDirectories(paths, filename);
        return this.file != null;
    }

    private static File searchDirectories(String[] paths, String filename) {
        for (String path : paths) {
            File file = new File(path, filename);
            if (!file.exists() || file.isDirectory()) continue;
            return file;
        }
        return null;
    }

    private boolean searchResourcepath(String name) {
        String rootName = "/" + name;
        URL res = ResourceLoader.class.getResource(rootName);
        if (res == null) {
            return false;
        }
        File resFile = ResourceLoader.urlToFile(res);
        if (resFile != null) {
            this.file = resFile;
        } else {
            this.url = res;
        }
        return true;
    }

    private static File urlToFile(URL res) {
        String externalForm = res.toExternalForm();
        if (externalForm.startsWith(FILESCHEME)) {
            return new File(externalForm.substring(5));
        }
        return null;
    }
}

