/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.core.rest;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.paypal.core.ConfigManager;
import com.paypal.core.ConnectionManager;
import com.paypal.core.HttpConfiguration;
import com.paypal.core.HttpConnection;
import com.paypal.core.SDKUtil;
import com.paypal.core.SDKVersion;
import com.paypal.core.codec.binary.Base64;
import com.paypal.core.credential.ICredential;
import com.paypal.core.rest.PayPalRESTException;
import com.paypal.sdk.util.UserAgentHeader;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class OAuthTokenCredential
implements ICredential {
    private static String OAUTH_TOKEN_PATH = "/v1/oauth2/token";
    private String clientID;
    private String clientSecret;
    private String accessToken;
    private Map<String, String> configurationMap;
    private SDKVersion sdkVersion;

    public static void setOAUTH_TOKEN_PATH(String oauthTokenPath) {
        OAUTH_TOKEN_PATH = oauthTokenPath;
    }

    public OAuthTokenCredential(String clientID, String clientSecret) {
        this.clientID = clientID;
        this.clientSecret = clientSecret;
        this.configurationMap = SDKUtil.combineDefaultMap(ConfigManager.getInstance().getConfigurationMap());
        this.sdkVersion = new SDKVersionImpl();
    }

    public OAuthTokenCredential(String clientID, String clientSecret, Map<String, String> configurationMap) {
        this.clientID = clientID;
        this.clientSecret = clientSecret;
        this.configurationMap = SDKUtil.combineDefaultMap(configurationMap);
        this.sdkVersion = new SDKVersionImpl();
    }

    public String getAccessToken() throws PayPalRESTException {
        if (this.accessToken == null) {
            this.accessToken = this.generateAccessToken();
        }
        return this.accessToken;
    }

    public String getAuthorizationHeader() throws PayPalRESTException {
        String base64EncodedString = this.generateBase64String(this.clientID + ":" + this.clientSecret);
        return "Basic " + base64EncodedString;
    }

    private String generateAccessToken() throws PayPalRESTException {
        String generatedToken = null;
        String base64ClientID = this.generateBase64String(this.clientID + ":" + this.clientSecret);
        generatedToken = this.generateOAuthToken(base64ClientID);
        return generatedToken;
    }

    private String generateBase64String(String clientCredentials) throws PayPalRESTException {
        String base64ClientID = null;
        byte[] encoded = null;
        try {
            encoded = Base64.encodeBase64(clientCredentials.getBytes("UTF-8"));
            base64ClientID = new String(encoded, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new PayPalRESTException(e.getMessage(), e);
        }
        return base64ClientID;
    }

    private String generateOAuthToken(String base64ClientID) throws PayPalRESTException {
        HttpConnection connection = null;
        HttpConfiguration httpConfiguration = null;
        String generatedToken = null;
        try {
            connection = ConnectionManager.getInstance().getConnection();
            httpConfiguration = this.getOAuthHttpConfiguration();
            connection.createAndconfigureHttpConnection(httpConfiguration);
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("Authorization", "Basic " + base64ClientID);
            headers.put("Accept", "application/json");
            UserAgentHeader userAgentHeader = new UserAgentHeader(this.sdkVersion != null ? this.sdkVersion.getSDKId() : null, this.sdkVersion != null ? this.sdkVersion.getSDKVersion() : null);
            headers.putAll(userAgentHeader.getHeader());
            String postRequest = this.getRequestPayload();
            String jsonResponse = connection.execute("", postRequest, headers);
            JsonParser parser = new JsonParser();
            JsonElement jsonElement = parser.parse(jsonResponse);
            generatedToken = jsonElement.getAsJsonObject().get("token_type").getAsString() + " " + jsonElement.getAsJsonObject().get("access_token").getAsString();
        }
        catch (Exception e) {
            throw new PayPalRESTException(e.getMessage(), e);
        }
        return generatedToken;
    }

    protected String getRequestPayload() {
        return "grant_type=client_credentials";
    }

    private HttpConfiguration getOAuthHttpConfiguration() {
        String endPointUrl;
        HttpConfiguration httpConfiguration = new HttpConfiguration();
        httpConfiguration.setHttpMethod("POST");
        String string = endPointUrl = this.configurationMap.get("oauth.EndPoint") != null && this.configurationMap.get("oauth.EndPoint").trim().length() >= 0 ? this.configurationMap.get("oauth.EndPoint") : this.configurationMap.get("service.EndPoint");
        if (endPointUrl == null || endPointUrl.trim().length() <= 0) {
            String mode = this.configurationMap.get("mode");
            if ("sandbox".equalsIgnoreCase(mode)) {
                endPointUrl = "https://api.sandbox.paypal.com/";
            } else if ("live".equalsIgnoreCase(mode)) {
                endPointUrl = "https://api.paypal.com/";
            }
        }
        if (Boolean.parseBoolean(this.configurationMap.get("http.UseProxy"))) {
            httpConfiguration.setProxySet(true);
            httpConfiguration.setProxyHost(this.configurationMap.get("http.ProxyHost"));
            httpConfiguration.setProxyPort(Integer.parseInt(this.configurationMap.get("http.ProxyPort")));
            String proxyUserName = this.configurationMap.get("http.ProxyUserName");
            String proxyPassword = this.configurationMap.get("http.ProxyPassword");
            if (proxyUserName != null && proxyPassword != null) {
                httpConfiguration.setProxyUserName(proxyUserName);
                httpConfiguration.setProxyPassword(proxyPassword);
            }
        }
        endPointUrl = endPointUrl.endsWith("/") ? endPointUrl.substring(0, endPointUrl.length() - 1) : endPointUrl;
        endPointUrl = endPointUrl + OAUTH_TOKEN_PATH;
        httpConfiguration.setEndPointUrl(endPointUrl);
        httpConfiguration.setGoogleAppEngine(Boolean.parseBoolean(this.configurationMap.get("http.GoogleAppEngine")));
        return httpConfiguration;
    }

    private static class SDKVersionImpl
    implements SDKVersion {
        private SDKVersionImpl() {
        }

        public String getSDKId() {
            return "paypal-core-java";
        }

        public String getSDKVersion() {
            return "1.5.0";
        }
    }
}

