/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.nio;

import com.orientechnologies.common.directmemory.ODirectMemory;
import com.orientechnologies.nio.CLibrary;
import com.orientechnologies.nio.OCLibraryFactory;
import com.sun.jna.Native;
import com.sun.jna.Pointer;

public class OJNADirectMemory
implements ODirectMemory {
    private static final CLibrary C_LIBRARY = OCLibraryFactory.INSTANCE.library();
    public static final OJNADirectMemory INSTANCE = new OJNADirectMemory();

    public long allocate(byte[] bytes) {
        long pointer = this.allocate(bytes.length);
        this.set(pointer, bytes, 0, bytes.length);
        return pointer;
    }

    public long allocate(long size) {
        return Native.malloc((long)size);
    }

    public void free(long pointer) {
        Native.free((long)pointer);
    }

    public byte[] get(long pointer, int length) {
        return new Pointer(pointer).getByteArray(0L, length);
    }

    public void get(long pointer, byte[] array, int arrayOffset, int length) {
        new Pointer(pointer).read(0L, array, arrayOffset, length);
    }

    public void set(long pointer, byte[] content, int arrayOffset, int length) {
        new Pointer(pointer).write(0L, content, arrayOffset, length);
    }

    public int getInt(long pointer) {
        return new Pointer(pointer).getInt(0L);
    }

    public void setInt(long pointer, int value) {
        new Pointer(pointer).setInt(0L, value);
    }

    public void setShort(long pointer, short value) {
        new Pointer(pointer).setShort(0L, value);
    }

    public short getShort(long pointer) {
        return new Pointer(pointer).getShort(0L);
    }

    public long getLong(long pointer) {
        return new Pointer(pointer).getLong(0L);
    }

    public void setLong(long pointer, long value) {
        new Pointer(pointer).setLong(0L, value);
    }

    public byte getByte(long pointer) {
        return new Pointer(pointer).getByte(0L);
    }

    public void setByte(long pointer, byte value) {
        new Pointer(pointer).setByte(0L, value);
    }

    public void setChar(long pointer, char value) {
        short short_char = (short)value;
        new Pointer(pointer).setShort(0L, short_char);
    }

    public char getChar(long pointer) {
        short short_char = new Pointer(pointer).getShort(0L);
        return (char)short_char;
    }

    public void moveData(long srcPointer, long destPointer, long len) {
        C_LIBRARY.memoryMove(srcPointer, destPointer, len);
    }
}

