/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.resolver;

import java.util.ArrayList;
import java.util.Hashtable;
import oracle.net.jdbc.nl.InvalidSyntaxException;
import oracle.net.jdbc.nl.NLException;
import oracle.net.jdbc.nl.NVFactory;
import oracle.net.jdbc.nl.NVPair;
import oracle.net.ns.NetException;
import oracle.net.resolver.HostnameNamingAdapter;
import oracle.net.resolver.NamingAdapterInterface;
import oracle.net.resolver.TNSNamesNamingAdapter;

public class NameResolver {
    private String tnsAdmin;
    private String[] readPath;
    private Hashtable adapterHash;
    String osuser;
    private static final boolean DEBUG = false;
    private static final String[] DEFAULT_SEARCH_PATH = new String[]{"TNSNAMES", "HOSTNAME"};
    private static final String TNS_ADMIN_PROPERTY = "oracle.net.tns_admin";
    private static final String READ_PATH_PROPERTY = "oracle.net.names.directory_path";

    private NameResolver() {
    }

    protected NameResolver(String string, String string2) throws NetException {
        this.tnsAdmin = string;
        this.bootNameResolver();
        this.osuser = string2;
    }

    public String resolveName(String string) throws NetException {
        if (string == null) {
            throw new NetException(120);
        }
        String string2 = string.trim();
        if (string2.length() == 0) {
            throw new NetException(120);
        }
        String string3 = null;
        if (this.tnsAdmin == null) {
            HostnameNamingAdapter hostnameNamingAdapter = new HostnameNamingAdapter(this.osuser);
            string3 = hostnameNamingAdapter.resolve(string2);
            return string3;
        }
        NamingAdapterInterface namingAdapterInterface = null;
        for (int i2 = 0; string3 == null && i2 < this.readPath.length; ++i2) {
            namingAdapterInterface = (NamingAdapterInterface)this.adapterHash.get(this.readPath[i2]);
            try {
                string3 = namingAdapterInterface.resolve(string2);
                continue;
            }
            catch (NetException netException) {
                // empty catch block
            }
        }
        if (string3 == null) {
            throw new NetException(122, "\"" + string + "\"");
        }
        return string3;
    }

    private void addAdapters() {
        if (this.adapterHash == null) {
            this.adapterHash = new Hashtable();
        }
        this.adapterHash.put("TNSNAMES", new TNSNamesNamingAdapter(this.tnsAdmin));
        this.adapterHash.put("HOSTNAME", new HostnameNamingAdapter(this.osuser));
    }

    private void bootNameResolver() throws NetException {
        if (this.tnsAdmin != null) {
            this.setReadPath();
            this.addAdapters();
        }
    }

    private boolean checkForValidAdapter(String string) {
        int n2 = DEFAULT_SEARCH_PATH.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (!DEFAULT_SEARCH_PATH[i2].equalsIgnoreCase(string)) continue;
            return true;
        }
        return false;
    }

    private void setDefaultPath() {
        this.readPath = DEFAULT_SEARCH_PATH;
    }

    private void setReadPath() throws NetException {
        int n2 = 0;
        String[] stringArray = this.getUserReadPath();
        if (stringArray == null) {
            this.setDefaultPath();
            return;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (n2 = 0; n2 < stringArray.length; ++n2) {
            if (!this.checkForValidAdapter(stringArray[n2])) continue;
            String string = stringArray[n2];
            if (arrayList.contains(string = string.toUpperCase())) continue;
            arrayList.add(stringArray[n2].toUpperCase());
        }
        int n3 = arrayList.size();
        if (n3 == 0) {
            throw new NetException(121, " The Read path did not contain any valid adapters.");
        }
        this.readPath = new String[n3];
        arrayList.toArray(this.readPath);
    }

    private String[] getUserReadPath() throws NetException {
        String[] stringArray = null;
        String string = System.getProperty(READ_PATH_PROPERTY);
        if (string == null) {
            return null;
        }
        if ((string = string.trim()).length() == 0) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer(string);
        if (stringBuffer.charAt(0) == '(') {
            stringBuffer.insert(0, "(path=").append(')');
        } else {
            stringBuffer.insert(0, "(path=(").append("))");
        }
        String string2 = stringBuffer.toString();
        NVFactory nVFactory = new NVFactory();
        NVPair nVPair = null;
        try {
            nVPair = nVFactory.createNVPair(string2);
            if (nVPair.getRHSType() != NVPair.RHS_LIST || nVPair.getListType() != NVPair.LIST_COMMASEP) {
                throw new NetException(121, " Read path specified is " + string);
            }
            int n2 = nVPair.getListSize();
            String[] stringArray2 = new String[n2];
            for (int i2 = 0; i2 < n2; ++i2) {
                stringArray2[i2] = nVPair.getListElement(i2).getName();
            }
            stringArray = stringArray2;
        }
        catch (InvalidSyntaxException invalidSyntaxException) {
            throw new NetException(121, " Read path specified is " + string);
        }
        catch (NLException nLException) {
            throw new NetException(121, " Read path specified is " + string2);
        }
        return stringArray;
    }
}

