/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.SQLException;
import java.util.Vector;
import java.util.concurrent.atomic.AtomicReference;
import oracle.jdbc.driver.DBConversion;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.T4CTypeRep;
import oracle.jdbc.internal.OracleConnection;
import oracle.net.ns.BreakNetException;
import oracle.net.ns.Communication;
import oracle.net.ns.NetException;

class T4CMAREngine {
    static final int TTCC_MXL = 252;
    static final int TTCC_ESC = 253;
    static final int TTCC_LNG = 254;
    static final int TTCC_ERR = 255;
    static final int TTCC_MXIN = 64;
    static final byte TTCLXMULTI = 1;
    static final byte TTCLXMCONV = 2;
    T4CTypeRep types;
    Communication net;
    DBConversion conv;
    short versionNumber = (short)-1;
    short databaseVersion = (short)-1;
    byte proSvrVer;
    boolean sentCancel = false;
    static final int FREE = -1;
    static final int SEND = 1;
    static final int RECEIVE = 2;
    int pipeState = -1;
    InputStream inStream;
    OutputStream outStream;
    final byte[] ignored = new byte[255];
    final byte[] tmpBuffer1 = new byte[1];
    final byte[] tmpBuffer2 = new byte[2];
    final byte[] tmpBuffer3 = new byte[3];
    final byte[] tmpBuffer4 = new byte[4];
    final byte[] tmpBuffer5 = new byte[5];
    final byte[] tmpBuffer6 = new byte[6];
    final byte[] tmpBuffer7 = new byte[7];
    final byte[] tmpBuffer8 = new byte[8];
    final int[] retLen = new int[1];
    AtomicReference<OracleConnection> connForException = new AtomicReference();
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Thu_Aug_28_17:37:41_PDT_2008";
    public static final boolean TRACE = false;
    public static final boolean PRIVATE_TRACE = false;

    static String toHex(long l2, int n2) {
        String string;
        switch (n2) {
            case 1: {
                string = "00" + Long.toString(l2 & 0xFFL, 16);
                break;
            }
            case 2: {
                string = "0000" + Long.toString(l2 & 0xFFFFL, 16);
                break;
            }
            case 3: {
                string = "000000" + Long.toString(l2 & 0xFFFFFFL, 16);
                break;
            }
            case 4: {
                string = "00000000" + Long.toString(l2 & 0xFFFFFFFFL, 16);
                break;
            }
            case 5: {
                string = "0000000000" + Long.toString(l2 & 0xFFFFFFFFFFL, 16);
                break;
            }
            case 6: {
                string = "000000000000" + Long.toString(l2 & 0xFFFFFFFFFFFFL, 16);
                break;
            }
            case 7: {
                string = "00000000000000" + Long.toString(l2 & 0xFFFFFFFFFFFFFFL, 16);
                break;
            }
            case 8: {
                return T4CMAREngine.toHex(l2 >> 32, 4) + T4CMAREngine.toHex(l2, 4).substring(2);
            }
            default: {
                return "more than 8 bytes";
            }
        }
        return "0x" + string.substring(string.length() - 2 * n2);
    }

    static String toHex(byte by) {
        String string = "00" + Integer.toHexString(by & 0xFF);
        return "0x" + string.substring(string.length() - 2);
    }

    static String toHex(short s2) {
        return T4CMAREngine.toHex(s2, 2);
    }

    static String toHex(int n2) {
        return T4CMAREngine.toHex(n2, 4);
    }

    static String toHex(byte[] byArray, int n2) {
        if (byArray == null) {
            return "null";
        }
        if (n2 > byArray.length) {
            return "byte array not long enough";
        }
        String string = "[";
        int n3 = Math.min(64, n2);
        for (int i2 = 0; i2 < n3; ++i2) {
            string = string + T4CMAREngine.toHex(byArray[i2]) + " ";
        }
        if (n3 < n2) {
            string = string + "...";
        }
        return string + "]";
    }

    static String toHex(byte[] byArray) {
        if (byArray == null) {
            return "null";
        }
        return T4CMAREngine.toHex(byArray, byArray.length);
    }

    T4CMAREngine(Communication communication) throws SQLException, IOException {
        if (communication == null) {
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 433);
        }
        this.net = communication;
        try {
            this.inStream = communication.getInputStream();
            this.outStream = communication.getOutputStream();
        }
        catch (NetException netException) {
            throw new IOException(netException.getMessage());
        }
        this.types = new T4CTypeRep();
        this.types.setRep((byte)1, (byte)2);
    }

    void initBuffers() {
    }

    void marshalSB1(byte by) throws IOException {
        this.outStream.write(by);
    }

    void marshalUB1(short s2) throws IOException {
        this.outStream.write((byte)(s2 & 0xFF));
    }

    void marshalSB2(short s2) throws IOException {
        byte by = this.value2Buffer(s2, this.tmpBuffer2, (byte)1);
        if (by != 0) {
            this.outStream.write(this.tmpBuffer2, 0, by);
        }
    }

    void marshalUB2(int n2) throws IOException {
        this.marshalSB2((short)(n2 & 0xFFFF));
    }

    void marshalSB4(int n2) throws IOException {
        byte by = this.value2Buffer(n2, this.tmpBuffer4, (byte)2);
        if (by != 0) {
            this.outStream.write(this.tmpBuffer4, 0, by);
        }
    }

    void marshalUB4(long l2) throws IOException {
        this.marshalSB4((int)(l2 & 0xFFFFFFFFFFFFFFFFL));
    }

    void marshalSB8(long l2) throws IOException {
        byte by = this.value2Buffer(l2, this.tmpBuffer8, (byte)3);
        if (by != 0) {
            this.outStream.write(this.tmpBuffer8, 0, by);
        }
    }

    void marshalSWORD(int n2) throws IOException {
        this.marshalSB4(n2);
    }

    void marshalUWORD(long l2) throws IOException {
        this.marshalSB4((int)(l2 & 0xFFFFFFFFFFFFFFFFL));
    }

    void marshalB1Array(byte[] byArray) throws IOException {
        if (byArray.length > 0) {
            this.outStream.write(byArray);
        }
    }

    void marshalB1Array(byte[] byArray, int n2, int n3) throws IOException {
        if (byArray.length > 0) {
            this.outStream.write(byArray, n2, n3);
        }
    }

    void marshalUB4Array(long[] lArray) throws IOException {
        for (int i2 = 0; i2 < lArray.length; ++i2) {
            this.marshalSB4((int)(lArray[i2] & 0xFFFFFFFFFFFFFFFFL));
        }
    }

    void marshalO2U(boolean bl) throws IOException {
        if (bl) {
            this.addPtr((byte)1);
        } else {
            this.addPtr((byte)0);
        }
    }

    void marshalNULLPTR() throws IOException {
        this.addPtr((byte)0);
    }

    void marshalPTR() throws IOException {
        this.addPtr((byte)1);
    }

    void marshalCHR(byte[] byArray) throws IOException {
        this.marshalCHR(byArray, 0, byArray.length);
    }

    void marshalCHR(byte[] byArray, int n2, int n3) throws IOException {
        if (n3 > 0) {
            if (this.types.isConvNeeded()) {
                this.marshalCLR(byArray, n2, n3);
            } else {
                this.outStream.write(byArray, n2, n3);
            }
        }
    }

    void marshalCLR(byte[] byArray, int n2) throws IOException {
        this.marshalCLR(byArray, 0, n2);
    }

    void marshalCLR(byte[] byArray, int n2, int n3) throws IOException {
        if (n3 > 64) {
            int n4;
            int n5 = 0;
            this.outStream.write(-2);
            do {
                int n6;
                n4 = (n6 = n3 - n5) > 64 ? 64 : n6;
                this.outStream.write((byte)(n4 & 0xFF));
                this.outStream.write(byArray, n2 + n5, n4);
            } while ((n5 += n4) < n3);
            this.outStream.write(0);
        } else {
            this.outStream.write((byte)(n3 & 0xFF));
            if (byArray.length != 0) {
                this.outStream.write(byArray, n2, n3);
            }
        }
    }

    void marshalKEYVAL(byte[][] byArray, int[] nArray, byte[][] byArray2, int[] nArray2, byte[] byArray3, int n2) throws SQLException, IOException {
        for (int i2 = 0; i2 < n2; ++i2) {
            if (byArray[i2] != null && nArray[i2] > 0) {
                this.marshalUB4(nArray[i2]);
                this.marshalCLR(byArray[i2], 0, nArray[i2]);
            } else {
                this.marshalUB4(0L);
            }
            if (byArray2[i2] != null && nArray2[i2] > 0) {
                this.marshalUB4(nArray2[i2]);
                this.marshalCLR(byArray2[i2], 0, nArray2[i2]);
            } else {
                this.marshalUB4(0L);
            }
            if (byArray3[i2] != 0) {
                this.marshalUB4(1L);
                continue;
            }
            this.marshalUB4(0L);
        }
    }

    void marshalKEYVAL(byte[][] byArray, byte[][] byArray2, byte[] byArray3, int n2) throws SQLException, IOException {
        int[] nArray = new int[n2];
        int[] nArray2 = new int[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            if (byArray[i2] != null) {
                nArray[i2] = byArray[i2].length;
            }
            if (byArray2[i2] == null) continue;
            nArray2[i2] = byArray2[i2].length;
        }
        this.marshalKEYVAL(byArray, nArray, byArray2, nArray2, byArray3, n2);
    }

    void marshalDALC(byte[] byArray) throws SQLException, IOException {
        if (byArray == null || byArray.length < 1) {
            this.outStream.write(0);
        } else {
            this.marshalSB4(0xFFFFFFFF & byArray.length);
            this.marshalCLR(byArray, byArray.length);
        }
    }

    void marshalKPDKV(byte[][] byArray, byte[][] byArray2, int[] nArray) throws SQLException, IOException {
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            if (byArray[i2] != null) {
                this.marshalUB4(byArray[i2].length);
                this.marshalCLR(byArray[i2], 0, byArray[i2].length);
            } else {
                this.marshalUB4(0L);
            }
            if (byArray2[i2] != null) {
                this.marshalUB4(byArray2[i2].length);
                this.marshalCLR(byArray2[i2], 0, byArray2[i2].length);
            } else {
                this.marshalUB4(0L);
            }
            this.marshalUB2(nArray[i2]);
        }
    }

    void unmarshalKPDKV(byte[][] byArray, int[] nArray, byte[][] byArray2, int[] nArray2) throws SQLException, IOException {
        int n2 = 0;
        int[] nArray3 = new int[1];
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            n2 = (int)this.unmarshalUB4();
            if (n2 > 0) {
                byArray[i2] = new byte[n2];
                this.unmarshalCLR(byArray[i2], 0, nArray3, n2);
                nArray[i2] = nArray3[0];
            }
            if ((n2 = (int)this.unmarshalUB4()) > 0) {
                byArray2[i2] = new byte[n2];
                this.unmarshalCLR(byArray2[i2], 0, nArray3, n2);
            }
            nArray2[i2] = this.unmarshalUB2();
        }
    }

    void addPtr(byte by) throws IOException {
        if ((this.types.rep[4] & 1) > 0) {
            this.outStream.write(by);
        } else {
            byte by2 = this.value2Buffer(by, this.tmpBuffer4, (byte)4);
            if (by2 != 0) {
                this.outStream.write(this.tmpBuffer4, 0, by2);
            }
        }
    }

    byte value2Buffer(int n2, byte[] byArray, byte by) throws IOException {
        boolean bl = true;
        byte by2 = 0;
        for (int i2 = byArray.length - 1; i2 >= 0; --i2) {
            byArray[by2] = (byte)(n2 >>> 8 * i2 & 0xFF);
            if ((this.types.rep[by] & 1) > 0) {
                if (bl && byArray[by2] == 0) continue;
                bl = false;
                by2 = (byte)(by2 + 1);
                continue;
            }
            by2 = (byte)(by2 + 1);
        }
        if ((this.types.rep[by] & 1) > 0) {
            this.outStream.write(by2);
        }
        if ((this.types.rep[by] & 2) > 0) {
            this.reverseArray(byArray, by2);
        }
        return by2;
    }

    byte value2Buffer(long l2, byte[] byArray, byte by) throws IOException {
        boolean bl = true;
        byte by2 = 0;
        for (int i2 = byArray.length - 1; i2 >= 0; --i2) {
            byArray[by2] = (byte)(l2 >>> 8 * i2 & 0xFFL);
            if ((this.types.rep[by] & 1) > 0) {
                if (bl && byArray[by2] == 0) continue;
                bl = false;
                by2 = (byte)(by2 + 1);
                continue;
            }
            by2 = (byte)(by2 + 1);
        }
        if ((this.types.rep[by] & 1) > 0) {
            this.outStream.write(by2);
        }
        if ((this.types.rep[by] & 2) > 0) {
            this.reverseArray(byArray, by2);
        }
        return by2;
    }

    void reverseArray(byte[] byArray, byte by) {
        for (int i2 = 0; i2 < by / 2; ++i2) {
            byte by2 = byArray[i2];
            byArray[i2] = byArray[by - 1 - i2];
            byArray[by - 1 - i2] = by2;
        }
    }

    byte unmarshalSB1() throws SQLException, IOException {
        byte by = (byte)this.unmarshalUB1();
        return by;
    }

    short unmarshalUB1() throws SQLException, IOException {
        short s2 = 0;
        try {
            this.pipeState = 2;
            s2 = (short)this.inStream.read();
        }
        catch (BreakNetException breakNetException) {
            this.net.sendReset();
            throw breakNetException;
        }
        finally {
            this.pipeState = -1;
        }
        if (s2 < 0) {
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 410);
        }
        return s2;
    }

    short unmarshalSB2() throws SQLException, IOException {
        short s2 = (short)this.unmarshalUB2();
        return s2;
    }

    int unmarshalUB2() throws SQLException, IOException {
        int n2 = (int)this.buffer2Value((byte)1);
        return n2 & 0xFFFF;
    }

    int unmarshalUCS2(byte[] byArray, long l2) throws SQLException, IOException {
        int n2 = this.unmarshalUB2();
        this.tmpBuffer2[0] = (byte)((n2 & 0xFF00) >> 8);
        this.tmpBuffer2[1] = (byte)(n2 & 0xFF);
        if (l2 + 1L < (long)byArray.length) {
            byArray[(int)l2] = this.tmpBuffer2[0];
            byArray[(int)l2 + 1] = this.tmpBuffer2[1];
        }
        return this.tmpBuffer2[0] == 0 ? (this.tmpBuffer2[1] == 0 ? 1 : 2) : 3;
    }

    int unmarshalSB4() throws SQLException, IOException {
        int n2 = (int)this.unmarshalUB4();
        return n2;
    }

    long unmarshalUB4() throws SQLException, IOException {
        long l2 = this.buffer2Value((byte)2);
        return l2;
    }

    int unmarshalSB4(byte[] byArray) throws SQLException, IOException {
        long l2 = this.buffer2Value((byte)2, new ByteArrayInputStream(byArray));
        return (int)l2;
    }

    long unmarshalSB8() throws SQLException, IOException {
        long l2 = this.buffer2Value((byte)3);
        return l2;
    }

    int unmarshalRefCursor(byte[] byArray) throws SQLException, IOException {
        int n2 = this.unmarshalSB4(byArray);
        return n2;
    }

    int unmarshalSWORD() throws SQLException, IOException {
        int n2 = (int)this.unmarshalUB4();
        return n2;
    }

    long unmarshalUWORD() throws SQLException, IOException {
        long l2 = this.unmarshalUB4();
        return l2;
    }

    byte[] unmarshalNBytes(int n2) throws SQLException, IOException {
        byte[] byArray = new byte[n2];
        if (n2 > 0) {
            try {
                this.pipeState = 2;
                if (this.inStream.read(byArray) < 0) {
                    DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 410);
                }
            }
            catch (BreakNetException breakNetException) {
                this.net.sendReset();
                throw breakNetException;
            }
            finally {
                this.pipeState = -1;
            }
        }
        return byArray;
    }

    int unmarshalNBytes(byte[] byArray, int n2, int n3) throws SQLException, IOException {
        int n4;
        for (n4 = 0; n4 < n3; n4 += this.getNBytes(byArray, n2 + n4, n3 - n4)) {
        }
        return n4;
    }

    int getNBytes(byte[] byArray, int n2, int n3) throws SQLException, IOException {
        int n4 = 0;
        try {
            this.pipeState = 2;
            n4 = this.inStream.read(byArray, n2, n3);
            if (n4 < 0) {
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 410);
            }
        }
        catch (BreakNetException breakNetException) {
            this.net.sendReset();
            throw breakNetException;
        }
        finally {
            this.pipeState = -1;
        }
        return n4;
    }

    byte[] getNBytes(int n2) throws SQLException, IOException {
        byte[] byArray = new byte[n2];
        try {
            this.pipeState = 2;
            if (this.inStream.read(byArray) < 0) {
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 410);
            }
        }
        catch (BreakNetException breakNetException) {
            this.net.sendReset();
            throw breakNetException;
        }
        finally {
            this.pipeState = -1;
        }
        return byArray;
    }

    byte[] unmarshalTEXT(int n2) throws SQLException, IOException {
        byte[] byArray;
        int n3 = 0;
        byte[] byArray2 = new byte[n2];
        while (n3 < n2) {
            try {
                this.pipeState = 2;
                if (this.inStream.read(byArray2, n3, 1) < 0) {
                    DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 410);
                }
            }
            catch (BreakNetException breakNetException) {
                this.net.sendReset();
                throw breakNetException;
            }
            finally {
                this.pipeState = -1;
            }
            if (byArray2[n3++] != 0) continue;
        }
        if (byArray2.length == --n3) {
            byArray = byArray2;
        } else {
            byArray = new byte[n3];
            System.arraycopy(byArray2, 0, byArray, 0, n3);
        }
        return byArray;
    }

    byte[] unmarshalCHR(int n2) throws SQLException, IOException {
        byte[] byArray = null;
        if (this.types.isConvNeeded()) {
            byArray = this.unmarshalCLR(n2, this.retLen);
            if (byArray.length != this.retLen[0]) {
                byte[] byArray2 = new byte[this.retLen[0]];
                System.arraycopy(byArray, 0, byArray2, 0, this.retLen[0]);
                byArray = byArray2;
            }
        } else {
            byArray = this.getNBytes(n2);
        }
        return byArray;
    }

    void unmarshalCLR(byte[] byArray, int n2, int[] nArray) throws SQLException, IOException {
        this.unmarshalCLR(byArray, n2, nArray, Integer.MAX_VALUE);
    }

    void unmarshalCLR(byte[] byArray, int n2, int[] nArray, int n3) throws SQLException, IOException {
        this.unmarshalCLR(byArray, n2, nArray, n3, 0);
    }

    void unmarshalCLR(byte[] byArray, int n2, int[] nArray, int n3, int n4) throws SQLException, IOException {
        int n5;
        int n6;
        block23: {
            int n7;
            int n8;
            int n9;
            boolean bl;
            int n10;
            int n11;
            block22: {
                n11 = 0;
                n10 = 0;
                n6 = n2;
                bl = false;
                n5 = 0;
                n9 = 0;
                n8 = 0;
                n7 = -1;
                n11 = this.unmarshalUB1();
                if (n11 < 0) {
                    DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 401);
                }
                if (n11 == 0) {
                    nArray[0] = 0;
                    return;
                }
                if (this.escapeSequenceNull(n11)) {
                    nArray[0] = 0;
                    return;
                }
                if (n11 == 254) break block22;
                if (n4 - n8 >= n11) {
                    this.unmarshalBuffer(this.ignored, 0, n11);
                    n8 += n11;
                    n11 = 0;
                } else if (n4 - n8 > 0) {
                    this.unmarshalBuffer(this.ignored, 0, n4 - n8);
                    n11 -= n4 - n8;
                    n8 += n4 - n8;
                }
                if (n11 <= 0) break block23;
                n9 = Math.min(n3 - n5, n11);
                n6 = this.unmarshalBuffer(byArray, n6, n9);
                n5 += n9;
                int n12 = n11 - n9;
                if (n12 <= 0) break block23;
                this.unmarshalBuffer(this.ignored, 0, n12);
                break block23;
            }
            n7 = -1;
            block5: while (n7 == -1 || (n11 = this.unmarshalUB1()) > 0) {
                if (n11 == 254) {
                    switch (n7) {
                        case -1: {
                            n7 = 1;
                            continue block5;
                        }
                        case 1: {
                            n7 = 0;
                            break;
                        }
                        case 0: {
                            if (bl) {
                                n7 = 0;
                                break;
                            }
                            n7 = 0;
                            continue block5;
                        }
                    }
                }
                if (n6 == -1) {
                    this.unmarshalBuffer(this.ignored, 0, n11);
                } else {
                    n10 = n11;
                    if (n4 - n8 >= n10) {
                        this.unmarshalBuffer(this.ignored, 0, n10);
                        n8 += n10;
                        n10 = 0;
                    } else if (n4 - n8 > 0) {
                        this.unmarshalBuffer(this.ignored, 0, n4 - n8);
                        n10 -= n4 - n8;
                        n8 += n4 - n8;
                    }
                    if (n10 > 0) {
                        n9 = Math.min(n3 - n5, n10);
                        n6 = this.unmarshalBuffer(byArray, n6, n9);
                        n5 += n9;
                        int n13 = n10 - n9;
                        if (n13 > 0) {
                            this.unmarshalBuffer(this.ignored, 0, n13);
                        }
                    }
                }
                n7 = 0;
                if (n11 <= 252) continue;
                bl = true;
            }
        }
        if (nArray != null) {
            nArray[0] = n6 != -1 ? n5 : byArray.length - n2;
        }
    }

    byte[] unmarshalCLR(int n2, int[] nArray) throws SQLException, IOException {
        byte[] byArray = new byte[n2 * this.conv.c2sNlsRatio];
        this.unmarshalCLR(byArray, 0, nArray, n2);
        return byArray;
    }

    int[] unmarshalKEYVAL(byte[][] byArray, byte[][] byArray2, int n2) throws SQLException, IOException {
        byte[] byArray3 = new byte[1000];
        int[] nArray = new int[1];
        int[] nArray2 = new int[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            int n3 = this.unmarshalSB4();
            if (n3 > 0) {
                this.unmarshalCLR(byArray3, 0, nArray);
                byArray[i2] = new byte[nArray[0]];
                System.arraycopy(byArray3, 0, byArray[i2], 0, nArray[0]);
            }
            if ((n3 = this.unmarshalSB4()) > 0) {
                this.unmarshalCLR(byArray3, 0, nArray);
                byArray2[i2] = new byte[nArray[0]];
                System.arraycopy(byArray3, 0, byArray2[i2], 0, nArray[0]);
            }
            nArray2[i2] = this.unmarshalSB4();
        }
        byArray3 = null;
        return nArray2;
    }

    int unmarshalBuffer(byte[] byArray, int n2, int n3) throws SQLException, IOException {
        if (n3 <= 0) {
            return n2;
        }
        if (byArray.length < n2 + n3) {
            this.unmarshalNBytes(byArray, n2, byArray.length - n2);
            this.unmarshalNBytes(this.ignored, 0, n2 + n3 - byArray.length);
            n2 = -1;
        } else {
            this.unmarshalNBytes(byArray, n2, n3);
            n2 += n3;
        }
        return n2;
    }

    byte[] unmarshalCLRforREFS() throws SQLException, IOException {
        short s2 = 0;
        short s3 = 0;
        byte[] byArray = null;
        Vector<byte[]> vector = new Vector<byte[]>(10, 10);
        short s4 = this.unmarshalUB1();
        if (s4 < 0) {
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 401);
        }
        if (s4 == 0) {
            return null;
        }
        if (!this.escapeSequenceNull(s4)) {
            byte[] byArray2;
            if (s4 == 254) {
                while ((s2 = this.unmarshalUB1()) > 0) {
                    if (s2 == 254 && this.types.isServerConversion()) continue;
                    s3 = (short)(s3 + s2);
                    byArray2 = new byte[s2];
                    this.unmarshalBuffer(byArray2, 0, s2);
                    vector.addElement(byArray2);
                }
            } else {
                s3 = s4;
                byArray2 = new byte[s4];
                this.unmarshalBuffer(byArray2, 0, s4);
                vector.addElement(byArray2);
            }
            byArray = new byte[s3];
            int n2 = 0;
            while (vector.size() > 0) {
                int n3 = ((byte[])vector.elementAt(0)).length;
                System.arraycopy(vector.elementAt(0), 0, byArray, n2, n3);
                n2 += n3;
                vector.removeElementAt(0);
            }
        } else {
            byArray = null;
        }
        return byArray;
    }

    boolean escapeSequenceNull(int n2) throws SQLException {
        boolean bl = false;
        switch (n2) {
            case 0: {
                bl = true;
                break;
            }
            case 253: {
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 401);
            }
            case 255: {
                bl = true;
                break;
            }
            case 254: {
                break;
            }
        }
        return bl;
    }

    int processIndicator(boolean bl, int n2) throws SQLException, IOException {
        short s2 = this.unmarshalSB2();
        int n3 = 0;
        if (!bl) {
            n3 = s2 == 0 ? n2 : (s2 == -2 || s2 > 0 ? (int)s2 : 65536 + s2);
        }
        return n3;
    }

    long unmarshalDALC(byte[] byArray, int n2, int[] nArray) throws SQLException, IOException {
        long l2 = this.unmarshalUB4();
        if (l2 > 0L) {
            this.unmarshalCLR(byArray, n2, nArray);
        }
        return l2;
    }

    byte[] unmarshalDALC() throws SQLException, IOException {
        long l2 = this.unmarshalUB4();
        byte[] byArray = new byte[(int)(0xFFFFFFFFFFFFFFFFL & l2)];
        if (byArray.length > 0) {
            if ((byArray = this.unmarshalCLR(byArray.length, this.retLen)) == null) {
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 401);
            }
        } else {
            byArray = new byte[]{};
        }
        return byArray;
    }

    byte[] unmarshalDALC(int[] nArray) throws SQLException, IOException {
        long l2 = this.unmarshalUB4();
        byte[] byArray = new byte[(int)(0xFFFFFFFFFFFFFFFFL & l2)];
        if (byArray.length > 0) {
            if ((byArray = this.unmarshalCLR(byArray.length, nArray)) == null) {
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 401);
            }
        } else {
            byArray = new byte[]{};
        }
        return byArray;
    }

    long buffer2Value(byte by) throws SQLException, IOException {
        byte[] byArray;
        int n2 = 0;
        long l2 = 0L;
        boolean bl = false;
        if ((this.types.rep[by] & 1) > 0) {
            try {
                this.pipeState = 2;
                n2 = this.inStream.read();
            }
            catch (BreakNetException breakNetException) {
                this.net.sendReset();
                throw breakNetException;
            }
            finally {
                this.pipeState = -1;
            }
            if ((n2 & 0x80) > 0) {
                n2 &= 0x7F;
                bl = true;
            }
            if (n2 < 0) {
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 410);
            }
            if (n2 == 0) {
                return 0L;
            }
            if (by == 1 && n2 > 2 || by == 2 && n2 > 4 || by == 3 && n2 > 8) {
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 412);
            }
        } else if (by == 1) {
            n2 = 2;
        } else if (by == 2) {
            n2 = 4;
        } else if (by == 3) {
            n2 = 8;
        }
        switch (n2) {
            case 1: {
                byArray = this.tmpBuffer1;
                break;
            }
            case 2: {
                byArray = this.tmpBuffer2;
                break;
            }
            case 3: {
                byArray = this.tmpBuffer3;
                break;
            }
            case 4: {
                byArray = this.tmpBuffer4;
                break;
            }
            case 5: {
                byArray = this.tmpBuffer5;
                break;
            }
            case 6: {
                byArray = this.tmpBuffer6;
                break;
            }
            case 7: {
                byArray = this.tmpBuffer7;
                break;
            }
            case 8: {
                byArray = this.tmpBuffer8;
                break;
            }
            default: {
                byArray = new byte[n2];
            }
        }
        try {
            this.pipeState = 2;
            if (this.inStream.read(byArray) < 0) {
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 410);
            }
        }
        catch (BreakNetException breakNetException) {
            this.net.sendReset();
            throw breakNetException;
        }
        finally {
            this.pipeState = -1;
        }
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            long l3 = (this.types.rep[by] & 2) > 0 ? (long)(byArray[byArray.length - 1 - i2] & 0xFF) & 0xFFL : (long)(byArray[i2] & 0xFF) & 0xFFL;
            l2 |= l3 << 8 * (byArray.length - 1 - i2);
        }
        if (by != 3) {
            l2 &= 0xFFFFFFFFFFFFFFFFL;
        }
        if (bl) {
            l2 = -l2;
        }
        return l2;
    }

    long buffer2Value(byte by, ByteArrayInputStream byteArrayInputStream) throws SQLException, IOException {
        byte[] byArray;
        int n2 = 0;
        long l2 = 0L;
        boolean bl = false;
        if ((this.types.rep[by] & 1) > 0) {
            n2 = byteArrayInputStream.read();
            if ((n2 & 0x80) > 0) {
                n2 &= 0x7F;
                bl = true;
            }
            if (n2 < 0) {
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 410);
            }
            if (n2 == 0) {
                return 0L;
            }
            if (by == 1 && n2 > 2 || by == 2 && n2 > 4) {
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 412);
            }
        } else if (by == 1) {
            n2 = 2;
        } else if (by == 2) {
            n2 = 4;
        }
        if (byteArrayInputStream.read(byArray = new byte[n2]) < 0) {
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 410);
        }
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            short s2 = (this.types.rep[by] & 2) > 0 ? (short)(byArray[byArray.length - 1 - i2] & 0xFF) : (short)(byArray[i2] & 0xFF);
            l2 |= (long)(s2 << 8 * (byArray.length - 1 - i2));
        }
        l2 &= 0xFFFFFFFFFFFFFFFFL;
        if (bl) {
            l2 = -l2;
        }
        return l2;
    }

    protected OracleConnection getConnectionDuringExceptionHandling() {
        return this.connForException.get();
    }

    protected void setConnectionDuringExceptionHandling(OracleConnection oracleConnection) {
        this.connForException.set(oracleConnection);
    }
}

