/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.auth.internal;

import com.oracle.bmc.auth.ResourcePrincipalAuthenticationDetailsProvider;
import com.oracle.bmc.auth.SessionKeySupplier;
import com.oracle.bmc.auth.internal.AbstractFederationClient;
import com.oracle.bmc.auth.internal.AuthUtils;
import com.oracle.bmc.auth.internal.FixedContentResourcePrincipalFederationClient;
import com.oracle.bmc.auth.internal.GetResourcePrincipalSessionTokenRequest;
import com.oracle.bmc.auth.internal.GetResourcePrincipalTokenResponse;
import com.oracle.bmc.auth.internal.SecurityTokenAdapter;
import com.oracle.bmc.auth.internal.X509FederationClient;
import com.oracle.bmc.circuitbreaker.CircuitBreakerConfiguration;
import com.oracle.bmc.circuitbreaker.OciCircuitBreaker;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.client.HttpClient;
import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.internal.ClientCall;
import com.oracle.bmc.http.signing.DefaultRequestSigner;
import com.oracle.bmc.http.signing.RequestSigner;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.util.internal.StringUtils;
import java.lang.invoke.LambdaMetafactory;
import java.security.KeyPair;
import java.security.interfaces.RSAPublicKey;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourcePrincipalsV3FederationClient
extends AbstractFederationClient {
    private static final Logger LOG = LoggerFactory.getLogger(ResourcePrincipalsV3FederationClient.class);
    private final ClientConfigurator clientConfigurator;
    private final ResourcePrincipalAuthenticationDetailsProvider leafAuthDetailsProvider;
    private final String resourcePrincipalTokenUrl;
    private final String resourcePrincipalSessionTokenEndpoint;
    private final String OPC_PARENT_RPT_URL_HEADER = "opc-parent-rpt-url";

    public ResourcePrincipalsV3FederationClient(String resourcePrincipalTokenUrl, String resourcePrincipalSessionTokenEndpoint, SessionKeySupplier sessionKeySupplier, ResourcePrincipalAuthenticationDetailsProvider leafAuthDetailsProvider, ClientConfigurator clientConfigurator, CircuitBreakerConfiguration circuitBreakerConfiguration) {
        super(resourcePrincipalTokenUrl, null, resourcePrincipalSessionTokenEndpoint, sessionKeySupplier, leafAuthDetailsProvider, clientConfigurator, circuitBreakerConfiguration, new ArrayList<ClientConfigurator>());
        this.resourcePrincipalTokenUrl = resourcePrincipalTokenUrl;
        this.resourcePrincipalSessionTokenEndpoint = resourcePrincipalSessionTokenEndpoint;
        this.leafAuthDetailsProvider = leafAuthDetailsProvider;
        this.clientConfigurator = clientConfigurator;
    }

    @Override
    public String getSecurityToken() {
        if (this.securityTokenAdapter != null && this.securityTokenAdapter.isValid()) {
            return this.securityTokenAdapter.getSecurityToken();
        }
        return this.refreshAndGetSecurityTokenInner(false, Optional.empty(), true);
    }

    @Override
    public String refreshAndGetSecurityTokenIfExpiringWithin(Duration time, boolean refreshKeys) {
        return this.refreshAndGetSecurityTokenInner(true, Optional.of(time), refreshKeys);
    }

    @Override
    public String refreshAndGetSecurityTokenIfExpiringWithin(Duration time) {
        return this.refreshAndGetSecurityTokenInner(true, Optional.of(time), true);
    }

    @Override
    protected SecurityTokenAdapter getSecurityTokenFromServer() {
        LOG.info("Getting/Refreshing RPST leaf from the auth server");
        this.leafAuthDetailsProvider.refresh();
        KeyPair keyPair = this.sessionKeySupplier.getKeyPair();
        if (keyPair == null) {
            throw new IllegalStateException("Keypair for session was not provided");
        }
        RSAPublicKey publicKey = (RSAPublicKey)keyPair.getPublic();
        if (publicKey == null) {
            throw new IllegalArgumentException("Public key is not present");
        }
        SecurityTokenAdapter finalSecurityTokenAdapter = this.getSecurityTokenFromServerInner(publicKey, 1, this.resourcePrincipalTokenUrl, this.resourcePrincipalTokenClient, this.federationClient);
        return finalSecurityTokenAdapter;
    }

    protected SecurityTokenAdapter getSecurityTokenFromServerInner(RSAPublicKey publicKey, int depth, String lastResourcePrincipalTokenUrl, HttpClient resourcePrincipalTokenClient, HttpClient federationClient) {
        GetResourcePrincipalTokenResponse.ResponseWrapper getResourcePrincipalTokenResponseWrapper = this.prepareRptCall(resourcePrincipalTokenClient).method(Method.GET).logger(LOG, "ResourcePrincipalsFederationClient").callSync();
        GetResourcePrincipalTokenResponse getResourcePrincipalTokenResponse = getResourcePrincipalTokenResponseWrapper.body;
        Map<String, List<String>> headers = getResourcePrincipalTokenResponseWrapper.getHeaders();
        String opcParentUrlHeader = null;
        if (headers != null && !headers.isEmpty()) {
            opcParentUrlHeader = headers.get("opc-parent-rpt-url") != null ? headers.get("opc-parent-rpt-url").get(0) : null;
        }
        String servicePrincipalSessionToken = getResourcePrincipalTokenResponse.getServicePrincipalSessionToken();
        String resourcePrincipalToken = getResourcePrincipalTokenResponse.getResourcePrincipalToken();
        SecurityTokenAdapter securityTokenAdapter = this.requestSessionToken(federationClient, new GetResourcePrincipalSessionTokenRequest(resourcePrincipalToken, servicePrincipalSessionToken, AuthUtils.base64EncodeNoChunking(publicKey)));
        if (depth > 9) {
            return securityTokenAdapter;
        }
        if (StringUtils.isBlank(opcParentUrlHeader) || !StringUtils.isBlank(opcParentUrlHeader) && opcParentUrlHeader.equalsIgnoreCase(lastResourcePrincipalTokenUrl)) {
            return securityTokenAdapter;
        }
        ResourcePrincipalAuthenticationDetailsProvider tempAuthProvider = new ResourcePrincipalAuthenticationDetailsProvider(new FixedContentResourcePrincipalFederationClient(securityTokenAdapter.getSecurityToken(), this.sessionKeySupplier), this.sessionKeySupplier, this.leafAuthDetailsProvider.getRegion());
        RequestSigner requestSigner = DefaultRequestSigner.createRequestSigner(tempAuthProvider);
        HttpClient resourcePrincipalTokenClientForNextCall = this.makeClient(opcParentUrlHeader, requestSigner);
        HttpClient federationClientForNextCall = this.makeClient(this.resourcePrincipalSessionTokenEndpoint, requestSigner);
        SecurityTokenAdapter innerSecurityTokenAdapter = this.getSecurityTokenFromServerInner(publicKey, depth + 1, opcParentUrlHeader, resourcePrincipalTokenClientForNextCall, federationClientForNextCall);
        return innerSecurityTokenAdapter;
    }

    protected ClientCall<?, GetResourcePrincipalTokenResponse.ResponseWrapper, ?> prepareRptCall(HttpClient resourcePrincipalTokenClient) {
        return ClientCall.builder(resourcePrincipalTokenClient, new BmcRequest(), GetResourcePrincipalTokenResponse.ResponseWrapper.Builder::new).handleBody(GetResourcePrincipalTokenResponse.class, (w, b) -> {
            w.body = b;
        }).handleResponseHeaderString("opc-parent-rpt-url", (responseBuilder, headerValue) -> {
            ArrayList<String> headerList = new ArrayList<String>();
            headerList.add((String)headerValue);
            HashMap<String, List<String>> headersMap = new HashMap<String, List<String>>();
            headersMap.put("opc-parent-rpt-url", headerList);
            responseBuilder.headers(headersMap);
        }).clientConfigurator(this.clientConfigurator).circuitBreaker(this.circuitBreaker);
    }

    protected SecurityTokenAdapter requestSessionToken(HttpClient federationClient, final GetResourcePrincipalSessionTokenRequest getResourcePrincipalSessionTokenRequest) {
        X509FederationClient.SecurityToken securityToken = ((X509FederationClient.FederationResponseWrapper)ClientCall.builder((HttpClient)federationClient, new BmcRequest<GetResourcePrincipalSessionTokenRequest>(){

            @Override
            public GetResourcePrincipalSessionTokenRequest getBody$() {
                return getResourcePrincipalSessionTokenRequest;
            }
        }, (Supplier<X509FederationClient.FederationResponseWrapper.Builder>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, <init>(), ()Lcom/oracle/bmc/auth/internal/X509FederationClient$FederationResponseWrapper$Builder;)()).method((Method)Method.POST).logger((Logger)ResourcePrincipalsV3FederationClient.LOG, (String)"ResourcePrincipalsFederationClient").handleBody(X509FederationClient.SecurityToken.class, (BiConsumer<X509FederationClient.FederationResponseWrapper.Builder, X509FederationClient.SecurityToken>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)V, lambda$requestSessionToken$2(com.oracle.bmc.auth.internal.X509FederationClient$FederationResponseWrapper$Builder com.oracle.bmc.auth.internal.X509FederationClient$SecurityToken ), (Lcom/oracle/bmc/auth/internal/X509FederationClient$FederationResponseWrapper$Builder;Lcom/oracle/bmc/auth/internal/X509FederationClient$SecurityToken;)V)()).clientConfigurator((ClientConfigurator)this.clientConfigurator).appendPathPart((String)"v1").appendPathPart((String)"resourcePrincipalSessionToken").circuitBreaker((OciCircuitBreaker)this.circuitBreaker).hasBody().callSync()).token;
        return new SecurityTokenAdapter(securityToken.getToken(), this.sessionKeySupplier);
    }

    private static /* synthetic */ void lambda$requestSessionToken$2(X509FederationClient.FederationResponseWrapper.Builder w, X509FederationClient.SecurityToken t) {
        w.token = t;
    }
}

