/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.http.client.pki;

import com.oracle.bmc.http.client.pki.Eraser;
import com.oracle.bmc.http.client.pki.Sensitive;
import com.oracle.bmc.http.client.pki.Text;
import com.oracle.bmc.http.client.pki.Utf8Utils;
import java.io.IOException;
import java.nio.Buffer;
import java.nio.CharBuffer;
import java.nio.channels.ReadableByteChannel;

interface Utf8
extends CharSequence,
Sensitive {
    public static Utf8 of(byte[] bytes) {
        return new Chars(CharBuffer.wrap(Text.chars(bytes)));
    }

    public static Utf8 of(ReadableByteChannel content) throws IOException {
        return Utf8Utils.of(content);
    }

    public static Utf8 of(String text) {
        return new Wrapper(text);
    }

    @Override
    public Utf8 subSequence(int var1, int var2);

    default public boolean contains(String text) {
        return this.indexOf(text) != -1;
    }

    default public int indexOf(String text) {
        return this.indexOf(text, 0);
    }

    default public int indexOf(String text, int offset) {
        int fromIndex = offset;
        int sourceCount = this.length();
        int targetCount = text.length();
        int targetOffset = 0;
        int sourceOffset = 0;
        if (fromIndex >= sourceCount) {
            return targetCount == 0 ? sourceCount : -1;
        }
        if (fromIndex < 0) {
            fromIndex = 0;
        }
        if (targetCount == 0) {
            return fromIndex;
        }
        char first = text.charAt(targetOffset);
        int max = sourceOffset + (sourceCount - targetCount);
        for (int i = sourceOffset + fromIndex; i <= max; ++i) {
            if (this.charAt(i) != first) {
                while (++i <= max && this.charAt(i) != first) {
                }
            }
            if (i > max) continue;
            int j = i + 1;
            int end = j + targetCount - 1;
            int k = targetOffset + 1;
            while (j < end && this.charAt(j) == text.charAt(k)) {
                ++j;
                ++k;
            }
            if (j != end) continue;
            return i - sourceOffset;
        }
        return -1;
    }

    default public Utf8 trim() {
        int st;
        int len = this.length();
        for (st = 0; st < len && this.charAt(st) <= ' '; ++st) {
        }
        while (st < len && this.charAt(len - 1) <= ' ') {
            --len;
        }
        return st > 0 || len < this.length() ? this.subSequence(st, len) : this;
    }

    public byte[] bytes();

    public Utf8 removeWhitespace();

    public static class Chars
    implements Utf8 {
        private final transient CharBuffer text;

        private Chars(CharBuffer text) {
            this.text = text;
        }

        @Override
        public void close() {
            Eraser.erase(this.text.array());
        }

        @Override
        public int length() {
            return this.text.length();
        }

        @Override
        public char charAt(int index) {
            char c = this.text.charAt(index);
            return c;
        }

        @Override
        public Utf8 subSequence(int beginIndex, int endIndex) {
            if (beginIndex == 0 && endIndex == this.text.length()) {
                return this;
            }
            CharBuffer subSequence = this.text.subSequence(beginIndex, endIndex);
            return new Chars(this.copyOf(subSequence));
        }

        private CharBuffer copyOf(CharBuffer existing) {
            CharBuffer copy = CharBuffer.allocate(existing.remaining());
            CharBuffer temp = existing.asReadOnlyBuffer();
            copy.put(temp);
            ((Buffer)copy).flip();
            return copy;
        }

        @Override
        public byte[] bytes() {
            return Text.bytes(this.text);
        }

        @Override
        public Utf8 removeWhitespace() {
            CharBuffer modified = CharBuffer.allocate(this.text.remaining());
            for (int i = 0; i < this.text.remaining(); ++i) {
                char c = this.text.charAt(i);
                if (c <= ' ') continue;
                modified.put(c);
            }
            ((Buffer)modified).flip();
            return new Chars(modified);
        }

        @Override
        public String toString() {
            return this.text.toString();
        }
    }

    public static class Wrapper
    implements Utf8 {
        private final String target;

        private Wrapper(String target) {
            this.target = target;
        }

        @Override
        public void close() {
        }

        @Override
        public int length() {
            return this.target.length();
        }

        @Override
        public char charAt(int index) {
            return this.target.charAt(index);
        }

        @Override
        public Utf8 subSequence(int start, int end) {
            return Utf8.of(this.target.substring(start, end));
        }

        @Override
        public int indexOf(String text, int offset) {
            return this.target.indexOf(text, offset);
        }

        @Override
        public Utf8 trim() {
            return Utf8.of(this.target.trim());
        }

        @Override
        public byte[] bytes() {
            return Text.bytes(this.target);
        }

        @Override
        public Utf8 removeWhitespace() {
            return Utf8.of(this.target.replaceAll("\\s+", ""));
        }
    }
}

