/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.xpath;

import java.util.ArrayList;
import java.util.LinkedList;
import javax.xml.namespace.QName;
import oracle.xml.parser.v2.DefaultXMLDocumentHandler;
import oracle.xml.util.FastVector;
import oracle.xml.xpath.PathExpr;
import oracle.xml.xpath.XPathAxis;
import oracle.xml.xpath.XPathPredicate;
import oracle.xml.xpath.XPathStep;
import oracle.xml.xpath.XSLExprBase;
import oracle.xml.xpath.XSLNodeSetExpr;
import oracle.xml.xslt.XSLException;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class XMLPathTable
extends DefaultXMLDocumentHandler
implements ContentHandler {
    private static final int UNINITIALIZED_XPATH_AXIS_TYPE = -1;
    private static final int TOTAL_PATHS = 100;
    private static final int TOTAL_LEVELS = 10;
    private static final int REPLACED = 1;
    private static final int RELATIVE = 2;
    private int curpaths = 0;
    private ArrayList<QName> trackpath;
    private ArrayList<QName>[] table;
    private ArrayList<QName>[] segmentlist;
    private LinkedList<ArrayList<QName>[]> segmentlists;
    private QName lseqn;
    private boolean debug = false;

    public boolean getDebug() {
        return this.debug;
    }

    void init() {
        if (this.table == null) {
            this.table = new ArrayList[100];
        }
        if (this.trackpath == null) {
            this.trackpath = new ArrayList(10);
        }
    }

    public void reset(boolean bl) {
        if (!bl) {
            for (int i = 0; i < this.curpaths; ++i) {
                this.table[i].clear();
            }
        }
        this.curpaths = 0;
        this.lseqn = null;
        if (bl) {
            this.trackpath = null;
            this.table = null;
        } else {
            this.trackpath.clear();
        }
    }

    private ArrayList<QName>[] expand() {
        int n = this.curpaths;
        ArrayList[] arrayListArray = new ArrayList[n * 2];
        for (int i = 0; i < n; ++i) {
            arrayListArray[i] = this.table[i];
        }
        return arrayListArray;
    }

    private boolean isDuplicateXPath(ArrayList<QName> arrayList) {
        if (this.curpaths == 0) {
            return false;
        }
        for (int i = 0; i < this.curpaths; ++i) {
            int n;
            ArrayList<QName> arrayList2 = this.table[i];
            if (arrayList2.size() != arrayList.size()) continue;
            for (n = 0; n < arrayList.size() && this.equal(arrayList2.get(n), arrayList.get(n)); ++n) {
            }
            if (n != arrayList.size()) continue;
            return true;
        }
        return false;
    }

    private boolean equal(QName qName, QName qName2) {
        return qName.getNamespaceURI().equals(qName2.getNamespaceURI()) && qName.getLocalPart().equals(qName2.getLocalPart());
    }

    private static void print(QNamePlusSep[] qNamePlusSepArray) {
        if (qNamePlusSepArray == null) {
            System.out.println("THIS QNamePlusSep[] IS NULL!!!");
            return;
        }
        for (int i = 0; i < qNamePlusSepArray.length; ++i) {
            QNamePlusSep qNamePlusSep = qNamePlusSepArray[i];
            if (qNamePlusSep.sep == 6 || qNamePlusSep.axistype == 5) {
                System.out.print("//");
            } else if (qNamePlusSep.sep == 5 || qNamePlusSep.axistype == 3) {
                System.out.print("/");
            }
            String string = qNamePlusSep.qname.getNamespaceURI();
            if (string != null && string.length() > 0) {
                System.out.print("{" + string + "}");
            }
            System.out.print(qNamePlusSep.qname.getLocalPart());
        }
        System.out.println();
    }

    private static void print(ArrayList<QName> arrayList) {
        if (arrayList == null) {
            System.out.println("THIS ROW IS NULL!!!");
            return;
        }
        System.out.print("/");
        for (int i = 0; i < arrayList.size(); ++i) {
            String string = arrayList.get(i).getPrefix();
            if (string != null && string.length() > 0) {
                System.out.print(string + ":");
            }
            System.out.print(arrayList.get(i).getLocalPart());
            if (i == arrayList.size() - 1) {
                System.out.println();
                continue;
            }
            System.out.print("/");
        }
    }

    private static void print(ArrayList<QName>[] arrayListArray, int n) {
        System.out.println("%%%%%%%%% " + n + " xpaths %%%%%%%%%%%%%%%%%");
        for (int i = 0; i < n; ++i) {
            ArrayList<QName> arrayList = arrayListArray[i];
            XMLPathTable.print(arrayList);
        }
        System.out.println("%%%%%%%%% XPath Table Generated %%%%%%%%%%%%%%%%%");
    }

    public static void print(FastVector fastVector, int n) {
        if (fastVector == null) {
            return;
        }
        int n2 = fastVector.size();
        if (n2 == 0) {
            return;
        }
        switch (n) {
            case 1: {
                System.out.print("(replaced by)-->");
                break;
            }
            case 2: {
                System.out.print("(relative xpath is)--> .");
                break;
            }
            default: {
                System.out.print("(PathExpr)--> .");
            }
        }
        for (int i = 0; i < n2; ++i) {
            XPathStep xPathStep = (XPathStep)fastVector.elementAt(i);
            String string = xPathStep.getNormalizedExpr();
            System.out.print(string);
        }
        System.out.println();
    }

    @Override
    public void startDocument() throws SAXException {
        this.init();
    }

    @Override
    public void endDocument() throws SAXException {
        if (this.debug) {
            XMLPathTable.print(this.table, this.curpaths);
        }
    }

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        QName qName;
        this.lseqn = qName = new QName(string, string2, this.getPrefix(string3));
        this.trackpath.add(qName);
    }

    @Override
    public void endElement(String string, String string2, String string3) throws SAXException {
        QName qName = new QName(string, string2, this.getPrefix(string3));
        if (this.equal(qName, this.lseqn)) {
            ArrayList<QName> arrayList = new ArrayList<QName>(this.trackpath.size());
            for (int i = 0; i < this.trackpath.size(); ++i) {
                arrayList.add(this.trackpath.get(i));
            }
            if (!this.isDuplicateXPath(arrayList)) {
                if (this.curpaths + 1 > this.table.length) {
                    this.table = this.expand();
                }
                this.table[this.curpaths++] = arrayList;
            }
        }
        this.trackpath.remove(this.trackpath.size() - 1);
        if (this.trackpath.size() >= 1) {
            this.lseqn = this.trackpath.get(this.trackpath.size() - 1);
        }
    }

    private PathExpr isPossibleNPE(PathExpr pathExpr) {
        FastVector fastVector = pathExpr.getStepVector();
        if (fastVector == null || fastVector.size() == 0) {
            return pathExpr;
        }
        int n = fastVector.size();
        for (int i = 0; i < n; ++i) {
            Object object = fastVector.elementAt(i);
            if (!(object instanceof XPathStep)) {
                return pathExpr;
            }
            XPathStep xPathStep = (XPathStep)object;
            if (xPathStep.getLocalName() != null && xPathStep.getNamespace() != null) continue;
            return pathExpr;
        }
        return null;
    }

    private String getPrefix(String string) {
        if (string == null || string.length() < 3) {
            return "";
        }
        int n = string.indexOf(58);
        if (n == -1) {
            return "";
        }
        return string.substring(0, n);
    }

    private Object replaceStepVector(FastVector fastVector) {
        ArrayList<QName> arrayList;
        XPathStep xPathStep;
        int n;
        XPathStep xPathStep2 = null;
        int n2 = fastVector.size();
        if (n2 == 0) {
            return fastVector;
        }
        QNamePlusSep[] qNamePlusSepArray = new QNamePlusSep[n2];
        for (n = 0; n < n2; ++n) {
            Object object = fastVector.elementAt(n);
            if (!(object instanceof XPathStep)) {
                return fastVector;
            }
            xPathStep = (XPathStep)object;
            if (xPathStep.getNodeTestType() != 451) {
                return fastVector;
            }
            arrayList = xPathStep.axisClass;
            if (arrayList != null && !((XPathAxis)((Object)arrayList)).isForward()) {
                return fastVector;
            }
            qNamePlusSepArray[n] = new QNamePlusSep();
            qNamePlusSepArray[n].sep = xPathStep.getPrevSeparator();
            qNamePlusSepArray[n].qname = new QName(xPathStep.getNamespace(), xPathStep.getLocalName());
            qNamePlusSepArray[n].axistype = arrayList != null ? ((XPathAxis)((Object)arrayList)).axisType : -1;
        }
        arrayList = null;
        int n3 = this.curpaths;
        ArrayList<QName> arrayList2 = null;
        int n4 = 0;
        this.segmentlists = null;
        for (n = 0; n < n3; ++n) {
            arrayList = this.table[n];
            arrayList2 = this.matching(arrayList, qNamePlusSepArray);
            if (arrayList2 == null || this.isDuplicatedSegmentList(this.segmentlist, this.segmentlists)) continue;
            if (this.debug) {
                XMLPathTable.print(qNamePlusSepArray);
                System.out.print("row " + (n + 1) + " (converted to)--> ");
                XMLPathTable.print(arrayList2);
            }
            if (++n4 == 1) {
                this.segmentlists = new LinkedList();
                this.segmentlists.add(this.segmentlist);
                continue;
            }
            this.segmentlists.add(this.segmentlist);
        }
        if (this.segmentlists != null) {
            int n5 = this.segmentlists.size();
            FastVector[] fastVectorArray = null;
            if (n5 > 1) {
                fastVectorArray = new FastVector[n5];
            }
            FastVector fastVector2 = null;
            for (int i = 0; i < n5; ++i) {
                this.segmentlist = this.segmentlists.get(i);
                fastVector2 = new FastVector();
                int[] nArray = this.stepCounts(this.segmentlist);
                PredicatePlusPos[] predicatePlusPosArray = new PredicatePlusPos[nArray.length];
                int n6 = 0;
                for (n = 0; n < n2; ++n) {
                    xPathStep = (XPathStep)fastVector.elementAt(n);
                    int n7 = xPathStep.getPrevSeparator();
                    if (xPathStep.axisClass != null && xPathStep.axisClass.axisType == 5) {
                        n7 = 6;
                    }
                    if (n7 == 6) {
                        int n8 = this.segmentlist[n6].size();
                        for (int j = 0; j < n8; ++j) {
                            if (j + 1 == nArray[n6]) {
                                xPathStep2 = xPathStep.clone(true);
                                XPathPredicate xPathPredicate = this.getPredicateFromSet(j + 1, predicatePlusPosArray);
                                if (xPathPredicate != null) {
                                    xPathStep2.predicates = xPathPredicate;
                                } else {
                                    predicatePlusPosArray[n6] = new PredicatePlusPos(j + 1, xPathStep.predicates);
                                }
                            } else {
                                xPathStep2 = xPathStep.clone(false);
                            }
                            xPathStep2.setPrevSeparator(5);
                            xPathStep2.setLocalName(this.segmentlist[n6].get(j).getLocalPart());
                            xPathStep2.setNamespace(this.segmentlist[n6].get(j).getNamespaceURI());
                            fastVector2.addElement(xPathStep2);
                        }
                        ++n6;
                        continue;
                    }
                    fastVector2.addElement(xPathStep);
                }
                if (this.debug) {
                    XMLPathTable.print(fastVector2, 1);
                }
                if (n5 == 1) {
                    return fastVector2;
                }
                fastVectorArray[i] = fastVector2;
            }
            return fastVectorArray;
        }
        return fastVector;
    }

    private XPathPredicate getPredicateFromSet(int n, PredicatePlusPos[] predicatePlusPosArray) {
        if (predicatePlusPosArray == null) {
            return null;
        }
        for (int i = 0; i < predicatePlusPosArray.length && predicatePlusPosArray[i] != null; ++i) {
            if (predicatePlusPosArray[i].pos != n) continue;
            return predicatePlusPosArray[i].pred;
        }
        return null;
    }

    private int[] stepCounts(ArrayList<QName>[] arrayListArray) {
        if (arrayListArray == null || arrayListArray.length == 0) {
            return null;
        }
        int[] nArray = new int[arrayListArray.length];
        for (int i = 0; i < arrayListArray.length; ++i) {
            nArray[i] = arrayListArray[i].size();
        }
        return nArray;
    }

    private boolean isDuplicatedSegmentList(ArrayList<QName>[] arrayListArray, LinkedList<ArrayList<QName>[]> linkedList) {
        if (linkedList == null) {
            return false;
        }
        int n = linkedList.size();
        for (int i = 0; i < n; ++i) {
            ArrayList<QName>[] arrayListArray2 = linkedList.get(i);
            if (this.isSame(arrayListArray2, arrayListArray)) continue;
            return false;
        }
        return true;
    }

    private boolean isSame(ArrayList<QName>[] arrayListArray, ArrayList<QName>[] arrayListArray2) {
        if (arrayListArray.length != arrayListArray2.length) {
            return false;
        }
        for (int i = 0; i < arrayListArray.length; ++i) {
            ArrayList<QName> arrayList = arrayListArray[i];
            ArrayList<QName> arrayList2 = arrayListArray2[i];
            if (arrayList.size() != arrayList2.size()) {
                return false;
            }
            for (int j = 0; j < arrayList.size(); ++j) {
                QName qName = arrayList.get(j);
                QName qName2 = arrayList2.get(j);
                if (qName.getLocalPart().equals(qName2.getLocalPart()) && qName.getNamespaceURI().equals(qName2.getNamespaceURI())) continue;
                return false;
            }
        }
        return true;
    }

    private ArrayList<QName> matching(ArrayList<QName> arrayList, QNamePlusSep[] qNamePlusSepArray) {
        QName qName;
        Object object;
        int n;
        int n2 = qNamePlusSepArray.length;
        boolean bl = false;
        ArrayList<QName> arrayList2 = new ArrayList<QName>(arrayList.size());
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        this.segmentlist = null;
        if (n2 == 0) {
            return null;
        }
        for (n = 0; n < qNamePlusSepArray.length; ++n) {
            if (qNamePlusSepArray[n].sep != 6 && qNamePlusSepArray[n].axistype != 5) continue;
            ++n3;
        }
        if (n3 == 0) {
            return null;
        }
        this.segmentlist = new ArrayList[n3];
        for (n = 0; n < n3; ++n) {
            this.segmentlist[n] = new ArrayList();
        }
        int n6 = 0;
        int n7 = 0;
        for (n = 0; n < n2; ++n) {
            object = qNamePlusSepArray[n];
            qName = ((QNamePlusSep)object).qname;
            n6 = ((QNamePlusSep)object).sep;
            if (((QNamePlusSep)object).axistype == 5) {
                n6 = 6;
            }
            block9: for (int i = n7; i < arrayList.size(); ++i) {
                QName qName2 = arrayList.get(i);
                switch (n6) {
                    case 3: {
                        continue block9;
                    }
                    case 4: {
                        return null;
                    }
                    case 5: {
                        if (this.equal(qName2, qName)) {
                            arrayList2.add(qName2);
                            i = arrayList.size();
                            n7 = n + 1;
                            ++n5;
                            continue block9;
                        }
                        return null;
                    }
                    case 6: {
                        if (!this.equal(qName2, qName)) {
                            arrayList2.add(qName2);
                            this.segmentlist[n4].add(qName2);
                            ++n7;
                            continue block9;
                        }
                        arrayList2.add(qName2);
                        i = arrayList.size();
                        this.segmentlist[n4].add(qName2);
                        ++n4;
                        ++n7;
                        continue block9;
                    }
                    default: {
                        return null;
                    }
                }
            }
        }
        if (n3 == n4) {
            if (arrayList2.size() < arrayList.size() && n6 == 6) {
                object = arrayList2.get(arrayList2.size() - 1);
                if (this.equal((QName)object, qName = arrayList.get(arrayList.size() - 1))) {
                    this.segmentlist[n4 - 1] = this.getRowsRemainingItems(arrayList, this.segmentlist, n4, n5);
                    return arrayList;
                }
                return null;
            }
            return arrayList2;
        }
        return null;
    }

    private ArrayList<QName> getRowsRemainingItems(ArrayList<QName> arrayList, ArrayList<QName>[] arrayListArray, int n, int n2) {
        int n3;
        if (n == 0 || arrayListArray == null || arrayList == null) {
            return arrayList;
        }
        int n4 = 0;
        for (n3 = 0; n3 < n - 1; ++n3) {
            n4 += arrayListArray[n3].size();
        }
        n3 = arrayList.size() - n4 - n2;
        ArrayList<QName> arrayList2 = new ArrayList<QName>(n3);
        for (int i = 0; i < n3; ++i) {
            arrayList2.add(arrayList.get(i + n4 + n2));
        }
        return arrayList2;
    }

    XSLExprBase getReplacePath(PathExpr pathExpr) throws XSLException {
        Object object;
        FastVector fastVector = pathExpr.getStepVector();
        if (fastVector != (object = this.replaceStepVector(fastVector))) {
            if (object instanceof FastVector) {
                pathExpr.setStepVector((FastVector)object);
                return pathExpr;
            }
            FastVector[] fastVectorArray = (FastVector[])object;
            int n = fastVectorArray.length;
            PathExpr[] pathExprArray = new PathExpr[n];
            for (int i = 0; i < n; ++i) {
                pathExprArray[i] = pathExpr.clone(false);
                pathExprArray[i].setStepVector(fastVectorArray[i]);
            }
            XSLNodeSetExpr xSLNodeSetExpr = XSLNodeSetExpr.union(pathExprArray);
            return xSLNodeSetExpr;
        }
        return pathExpr;
    }

    public void printXMLPathTable() {
        XMLPathTable.print(this.table, this.curpaths);
    }

    public XSLExprBase getReplacePath(XSLExprBase xSLExprBase) throws XSLException {
        if (xSLExprBase instanceof PathExpr) {
            PathExpr pathExpr = (PathExpr)xSLExprBase;
            return this.getReplacePath(pathExpr);
        }
        return xSLExprBase;
    }

    class PredicatePlusPos {
        XPathPredicate pred;
        int pos;

        PredicatePlusPos(int n, XPathPredicate xPathPredicate) {
            this.pos = n;
            this.pred = xPathPredicate;
        }
    }

    class QNamePlusSep {
        QName qname;
        int sep;
        int axistype;

        QNamePlusSep() {
        }
    }
}

