/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.jdwp;

import java.util.Hashtable;
import oracle.xml.jdwp.LineTable;
import oracle.xml.jdwp.VariableTable;
import oracle.xml.jdwp.XSLJDWPCommandSet;
import oracle.xml.jdwp.XSLJDWPException;
import oracle.xml.jdwp.XSLJDWPPacket;
import oracle.xml.jdwp.XSLJDWPPacketStream;

public class XSLJDWPMethod
extends XSLJDWPCommandSet {
    Hashtable variableTables = new Hashtable();
    Hashtable lineTables = new Hashtable();

    @Override
    XSLJDWPPacket execute(XSLJDWPPacket xSLJDWPPacket) {
        this.cmd = xSLJDWPPacket;
        this.cmdStrm = new XSLJDWPPacketStream(this.cmd);
        XSLJDWPPacket xSLJDWPPacket2 = null;
        switch (this.cmd.cmd) {
            case 1: {
                xSLJDWPPacket2 = this.lineTableCmd();
                break;
            }
            case 2: {
                xSLJDWPPacket2 = this.variableTableCmd();
                break;
            }
            default: {
                xSLJDWPPacket2 = this.cmd.createErrorReply((short)99);
            }
        }
        return xSLJDWPPacket2;
    }

    XSLJDWPPacket lineTableCmd() {
        XSLJDWPPacketStream xSLJDWPPacketStream = new XSLJDWPPacketStream(this.cmd.createReply());
        LineTable lineTable = this.getLineTable(this.cmdStrm.readReferenceType(), this.cmdStrm.readMethodID());
        xSLJDWPPacketStream.writeLong(lineTable.getStart());
        xSLJDWPPacketStream.writeLong(lineTable.getEnd());
        int n = lineTable.getLines();
        xSLJDWPPacketStream.writeInt(n);
        long[] lArray = lineTable.getLineCodeIndex();
        int[] nArray = lineTable.getLineNumber();
        for (int i = 0; i < n; ++i) {
            xSLJDWPPacketStream.writeLong(lArray[i]);
            xSLJDWPPacketStream.writeInt(nArray[i]);
        }
        xSLJDWPPacketStream.close();
        return xSLJDWPPacketStream.packet();
    }

    XSLJDWPPacket variableTableCmd() {
        XSLJDWPPacketStream xSLJDWPPacketStream = new XSLJDWPPacketStream(this.cmd.createReply());
        try {
            VariableTable variableTable = this.getVariableTable(this.cmdStrm.readReferenceType(), this.cmdStrm.readMethodID());
            xSLJDWPPacketStream.writeInt(variableTable.getArgCnt());
            int n = variableTable.getSlots();
            xSLJDWPPacketStream.writeInt(n);
            long[] lArray = variableTable.getCodeIndex();
            String[] stringArray = variableTable.getName();
            String[] stringArray2 = variableTable.getSignature();
            int[] nArray = variableTable.getLength();
            int[] nArray2 = variableTable.getSlot();
            for (int i = 0; i < n; ++i) {
                xSLJDWPPacketStream.writeLong(lArray[i]);
                xSLJDWPPacketStream.writeString(stringArray[i]);
                xSLJDWPPacketStream.writeString(stringArray2[i]);
                xSLJDWPPacketStream.writeInt(nArray[i]);
                xSLJDWPPacketStream.writeInt(nArray2[i]);
            }
        }
        catch (XSLJDWPException xSLJDWPException) {
            return this.cmd.createErrorReply(xSLJDWPException.errorCode());
        }
        xSLJDWPPacketStream.close();
        return xSLJDWPPacketStream.packet();
    }

    public synchronized void makeLineTable(LineTable lineTable) {
        int n = lineTable.getClassID();
        int n2 = lineTable.getMethodID();
        long l = (long)n << 32;
        Long l2 = new Long(l += (long)n2);
        this.lineTables.put(l2, lineTable);
    }

    LineTable getLineTable(int n, int n2) {
        long l = (long)n << 32;
        Long l2 = new Long(l += (long)n2);
        LineTable lineTable = (LineTable)this.lineTables.get(l2);
        return lineTable;
    }

    public synchronized void makeVariableTable(VariableTable variableTable) {
        int n = variableTable.getClassID();
        int n2 = variableTable.getMethodID();
        long l = (long)n << 32;
        Long l2 = new Long(l += (long)n2);
        this.variableTables.put(l2, variableTable);
    }

    VariableTable getVariableTable(int n, int n2) {
        long l = (long)n << 32;
        Long l2 = new Long(l += (long)n2);
        VariableTable variableTable = (VariableTable)this.variableTables.get(l2);
        if (variableTable != null) {
            variableTable.setSignaturesAndArgCnt();
        }
        return variableTable;
    }

    void clearVariableTable() {
        this.variableTables.clear();
    }
}

