/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.cert.ext;

import java.io.IOException;
import java.io.InputStream;
import oracle.security.crypto.asn1.ASN1BitString;
import oracle.security.crypto.asn1.ASN1Boolean;
import oracle.security.crypto.asn1.ASN1ConstructedInputStream;
import oracle.security.crypto.asn1.ASN1FormatException;
import oracle.security.crypto.asn1.ASN1GenericConstructed;
import oracle.security.crypto.asn1.ASN1GenericPrimitive;
import oracle.security.crypto.asn1.ASN1Object;
import oracle.security.crypto.asn1.ASN1ObjectID;
import oracle.security.crypto.asn1.ASN1Sequence;
import oracle.security.crypto.asn1.ASN1SequenceInputStream;
import oracle.security.crypto.cert.CRLDistPointName;
import oracle.security.crypto.cert.CRLReason;
import oracle.security.crypto.cert.PKIX;
import oracle.security.crypto.cert.X509Extension;
import oracle.security.crypto.util.Streamable;
import oracle.security.crypto.util.UnsyncByteArrayInputStream;
import oracle.security.crypto.util.Utils;

public class IssuingDistPointExtension
extends X509Extension {
    private static final ASN1ObjectID TYPE = PKIX.id_ce_issuingDistributionPoint;
    private CRLDistPointName distPointName = null;
    private boolean onlyContainsUserCerts = false;
    private boolean onlyContainsCACerts = false;
    private boolean[] reasons;
    private int reasonsCount;
    private boolean indirectCRL = false;

    public IssuingDistPointExtension() {
        super(TYPE);
    }

    public IssuingDistPointExtension(boolean critical) {
        super(TYPE, critical);
        this.setValue(this.toByteArray());
    }

    public IssuingDistPointExtension(InputStream is) throws IOException {
        super(is);
    }

    public CRLDistPointName getDistPointName() {
        if (!this.isDecoded) {
            this.decodeValue();
        }
        return this.distPointName;
    }

    public void setDistPointName(CRLDistPointName distPointName) {
        this.distPointName = distPointName;
        this.setValue(this.toByteArray());
    }

    public boolean onlyContainsUserCerts() {
        if (!this.isDecoded) {
            this.decodeValue();
        }
        return this.onlyContainsUserCerts;
    }

    public void setOnlyContainsUserCerts(boolean value) {
        this.onlyContainsUserCerts = value;
        this.setValue(this.toByteArray());
    }

    public boolean onlyContainsCACerts() {
        if (!this.isDecoded) {
            this.decodeValue();
        }
        return this.onlyContainsCACerts;
    }

    public void setOnlyContainsCACerts(boolean value) {
        this.onlyContainsCACerts = value;
        this.setValue(this.toByteArray());
    }

    public boolean isIndirectCRL() {
        if (!this.isDecoded) {
            this.decodeValue();
        }
        return this.indirectCRL;
    }

    public void setIsIndirectCRL(boolean value) {
        this.indirectCRL = value;
        this.setValue(this.toByteArray());
    }

    public boolean hasReasonFlag(CRLReason reason) {
        if (!this.isDecoded) {
            this.decodeValue();
        }
        int i = reason.getValue();
        return this.reasons != null && i < this.reasons.length ? this.reasons[i] : false;
    }

    public void setReasonFlag(CRLReason reason) {
        this.doSetReasonFlag(reason);
        this.setValue(this.toByteArray());
    }

    public void setReasonFlags(CRLReason[] crlReasons) {
        int len = crlReasons.length;
        for (int i = 0; i < len; ++i) {
            this.doSetReasonFlag(crlReasons[i]);
        }
        this.setValue(this.toByteArray());
    }

    public void clearReasonFlag(CRLReason reason) {
        int i = reason.getValue();
        if (this.reasons != null && i < this.reasons.length) {
            this.reasons[i] = false;
        }
        this.setValue(this.toByteArray());
    }

    public void clearAllReasonFlags() {
        if (this.reasons != null) {
            int len = this.reasons.length;
            for (int i = 0; i < len; ++i) {
                this.reasons[i] = false;
            }
            this.setValue(this.toByteArray());
        }
    }

    private void doSetReasonFlag(CRLReason reason) {
        if (this.reasons == null || this.reasons.length < CRLReason.LIST.length) {
            boolean[] newReasons = new boolean[CRLReason.LIST.length];
            if (this.reasons != null) {
                System.arraycopy(this.reasons, 0, newReasons, 0, this.reasons.length);
            }
            this.reasons = newReasons;
        }
        this.reasons[reason.getValue()] = true;
        ++this.reasonsCount;
    }

    private byte[] toByteArray() {
        Object b;
        ASN1Sequence seq = new ASN1Sequence();
        if (this.distPointName != null) {
            seq.addElement((ASN1Object)new ASN1GenericConstructed((ASN1Object)this.distPointName, 0));
        }
        if (this.onlyContainsUserCerts) {
            seq.addElement((ASN1Object)new ASN1GenericPrimitive((ASN1Object)new ASN1Boolean(true), 1));
        }
        if (this.onlyContainsCACerts) {
            seq.addElement((ASN1Object)new ASN1GenericPrimitive((ASN1Object)new ASN1Boolean(true), 2));
        }
        if (this.reasons != null && this.reasonsCount > 0) {
            b = new ASN1BitString(this.reasons.length);
            for (int i = 0; i < this.reasons.length; ++i) {
                if (!this.reasons[i]) continue;
                b.setBit(i);
            }
            seq.addElement((ASN1Object)new ASN1GenericPrimitive((ASN1Object)b, 3));
        }
        if (this.indirectCRL) {
            seq.addElement((ASN1Object)new ASN1GenericPrimitive((ASN1Object)new ASN1Boolean(true), 4));
        }
        b = Utils.toBytes((Streamable)seq);
        this.isDecoded = true;
        return b;
    }

    private void decodeValue() {
        try {
            UnsyncByteArrayInputStream is;
            ASN1SequenceInputStream sis;
            if (this.getValue() == null) {
                this.setValue(this.toByteArray());
            }
            if ((sis = new ASN1SequenceInputStream((InputStream)(is = new UnsyncByteArrayInputStream(this.getValue())))).hasMoreData() && sis.getCurrentTag() == 0) {
                ASN1ConstructedInputStream cis = new ASN1ConstructedInputStream((InputStream)sis, 0);
                this.distPointName = new CRLDistPointName((InputStream)cis);
                cis.terminate();
            } else {
                this.distPointName = null;
            }
            if (sis.hasMoreData() && sis.getCurrentTag() == 1) {
                sis.setCurrentTag(1);
                this.onlyContainsUserCerts = ASN1Boolean.inputValue((InputStream)sis);
            } else {
                this.onlyContainsUserCerts = false;
            }
            if (sis.hasMoreData() && sis.getCurrentTag() == 2) {
                sis.setCurrentTag(1);
                this.onlyContainsCACerts = ASN1Boolean.inputValue((InputStream)sis);
            } else {
                this.onlyContainsCACerts = false;
            }
            if (sis.hasMoreData() && sis.getCurrentTag() == 3) {
                int i;
                sis.setCurrentTag(3);
                ASN1BitString b = new ASN1BitString((InputStream)sis);
                this.reasons = new boolean[b.bitLength()];
                try {
                    for (i = 0; i < this.reasons.length; ++i) {
                        this.reasons[i] = b.testBit(i);
                        ++this.reasonsCount;
                    }
                }
                catch (ArrayIndexOutOfBoundsException ex) {
                    throw new ASN1FormatException("Unknown reasons flag: " + i);
                }
            } else {
                this.reasons = null;
                this.reasonsCount = 0;
            }
            if (sis.hasMoreData() && sis.getCurrentTag() == 4) {
                sis.setCurrentTag(1);
                this.indirectCRL = ASN1Boolean.inputValue((InputStream)sis);
            } else {
                this.indirectCRL = false;
            }
            sis.terminate();
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex.toString());
        }
        this.isDecoded = true;
    }

    public String toString() {
        if (!this.isDecoded) {
            this.decodeValue();
        }
        StringBuffer s = new StringBuffer("issuingDistPointExtension {oid = " + TYPE.toStringCompact() + ", critical = " + this.getCritical() + ", value = [");
        boolean began = false;
        if (this.getDistPointName() != null) {
            s.append("distPointName = " + this.getDistPointName());
            began = true;
        }
        if (began) {
            s.append(", ");
        }
        s.append("onlyContainsUserCerts = " + this.onlyContainsUserCerts());
        s.append(", onlyContainsCACerts = " + this.onlyContainsCACerts());
        s.append(", onlySomeReasons = {");
        if (this.reasons != null) {
            boolean mid = false;
            for (int i = 0; i < this.reasons.length; ++i) {
                if (mid) {
                    s.append(", ");
                }
                if (this.reasons[i]) {
                    s.append(CRLReason.LIST[i]);
                }
                mid = true;
            }
        } else {
            s.append("null");
        }
        s.append("}");
        s.append(", indirectCRL = " + this.isIndirectCRL());
        s.append("]}");
        return s.toString();
    }
}

