/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.cert.ext;

import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Vector;
import oracle.security.crypto.asn1.ASN1FormatException;
import oracle.security.crypto.asn1.ASN1ObjectID;
import oracle.security.crypto.asn1.ASN1Sequence;
import oracle.security.crypto.asn1.ASN1SequenceInputStream;
import oracle.security.crypto.cert.GeneralName;
import oracle.security.crypto.cert.PKIX;
import oracle.security.crypto.cert.X509Extension;
import oracle.security.crypto.util.Streamable;
import oracle.security.crypto.util.UnsyncByteArrayInputStream;
import oracle.security.crypto.util.Utils;

public class CRLCertificateIssuerExtension
extends X509Extension {
    private static final ASN1ObjectID TYPE = PKIX.id_ce_certificateIssuer;
    private Vector certificateIssuer = new Vector();

    public CRLCertificateIssuerExtension() {
        super(TYPE);
    }

    public CRLCertificateIssuerExtension(GeneralName certificateIssuer) {
        this(certificateIssuer, true);
    }

    public CRLCertificateIssuerExtension(GeneralName certificateIssuer, boolean critical) {
        super(TYPE, critical);
        this.certificateIssuer.addElement(certificateIssuer);
        this.setValue(this.toByteArray());
    }

    public CRLCertificateIssuerExtension(Vector certificateIssuer) {
        this(certificateIssuer, true);
    }

    public CRLCertificateIssuerExtension(Vector certificateIssuer, boolean critical) {
        super(TYPE, critical);
        this.certificateIssuer = certificateIssuer;
        this.setValue(this.toByteArray());
    }

    public CRLCertificateIssuerExtension(InputStream is) throws IOException {
        super(is);
    }

    public Enumeration certificateIssuer() {
        if (!this.isDecoded) {
            this.decodeValue();
        }
        return this.certificateIssuer.elements();
    }

    public void addIssuerName(GeneralName name) {
        this.certificateIssuer.addElement(name);
        this.setValue(this.toByteArray());
    }

    private byte[] toByteArray() {
        byte[] b = Utils.toBytes((Streamable)new ASN1Sequence(this.certificateIssuer));
        this.isDecoded = true;
        return b;
    }

    private void decodeValue() {
        try {
            UnsyncByteArrayInputStream is = new UnsyncByteArrayInputStream(this.getValue());
            ASN1SequenceInputStream sis = new ASN1SequenceInputStream((InputStream)is);
            this.certificateIssuer = new Vector();
            while (sis.hasMoreData()) {
                this.certificateIssuer.addElement(new GeneralName((InputStream)sis));
            }
            sis.terminate();
            if (this.certificateIssuer.size() == 0) {
                throw new ASN1FormatException("No GeneralName defined for extension");
            }
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex.toString());
        }
        this.isDecoded = true;
    }

    public String toString() {
        if (!this.isDecoded) {
            this.decodeValue();
        }
        StringBuffer s = new StringBuffer("CRLCertificateIssuerExtension {oid = " + TYPE.toStringCompact() + ", critical = " + this.getCritical() + ", value = [");
        if (this.certificateIssuer != null) {
            s.append("certificateIssuers = {");
            boolean mid = false;
            int size = this.certificateIssuer.size();
            for (int i = 0; i < size; ++i) {
                if (mid) {
                    s.append(", ");
                }
                s.append(((GeneralName)this.certificateIssuer.elementAt(i)).toString());
                mid = true;
            }
            s.append("}");
        }
        s.append("]}");
        return s.toString();
    }
}

