/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.cert;

import java.io.Externalizable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.math.BigInteger;
import java.net.URL;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import oracle.security.crypto.asn1.ASN1BitString;
import oracle.security.crypto.asn1.ASN1ConstructedInputStream;
import oracle.security.crypto.asn1.ASN1Date;
import oracle.security.crypto.asn1.ASN1GenericConstructed;
import oracle.security.crypto.asn1.ASN1Integer;
import oracle.security.crypto.asn1.ASN1Object;
import oracle.security.crypto.asn1.ASN1ObjectID;
import oracle.security.crypto.asn1.ASN1Sequence;
import oracle.security.crypto.asn1.ASN1SequenceInputStream;
import oracle.security.crypto.cert.RevokedCertificate;
import oracle.security.crypto.cert.X500Name;
import oracle.security.crypto.cert.X509;
import oracle.security.crypto.cert.X509Extension;
import oracle.security.crypto.cert.X509ExtensionSet;
import oracle.security.crypto.core.AlgorithmIdentifier;
import oracle.security.crypto.core.AlgorithmIdentifierException;
import oracle.security.crypto.core.AuthenticationException;
import oracle.security.crypto.core.InvalidKeyException;
import oracle.security.crypto.core.PrivateKey;
import oracle.security.crypto.core.PublicKey;
import oracle.security.crypto.core.RandomBitsSource;
import oracle.security.crypto.core.Signature;
import oracle.security.crypto.core.SignatureException;
import oracle.security.crypto.util.CryptoUtils;
import oracle.security.crypto.util.InvalidInputException;
import oracle.security.crypto.util.OutputGenerationException;
import oracle.security.crypto.util.Streamable;
import oracle.security.crypto.util.StreamableOutputException;
import oracle.security.crypto.util.UnsyncByteArrayInputStream;
import oracle.security.crypto.util.Utils;

public class CRL
implements ASN1Object,
Externalizable {
    private ASN1Sequence tbsCertList = null;
    private AlgorithmIdentifier sigAlgID = null;
    private byte[] sigBytes = null;
    private X500Name issuer;
    private Date thisUpdate = new Date();
    private Date nextUpdate = null;
    private Hashtable revokedCertificates = null;
    private Vector serialNo = null;
    private X509ExtensionSet extensions = null;
    private PrivateKey privKey;
    private PublicKey pubKey;
    private X509 issuerCert;
    private ASN1Sequence contents = null;

    public CRL() {
    }

    public CRL(InputStream is) throws IOException {
        this();
        this.input(is);
    }

    public CRL(File f) throws IOException {
        this(new FileInputStream(f));
    }

    public CRL(URL url) throws IOException {
        this(url.openStream());
    }

    public CRL(X509 issuer) {
        this.setIssuer(issuer.getSubject());
        this.setPublicKey(issuer.getPublicKey());
    }

    public CRL(X509 issuer, InputStream is) throws IOException {
        this(issuer);
        this.input(is);
    }

    public CRL(X509 issuer, File f) throws FileNotFoundException, IOException {
        this(issuer);
        FileInputStream fis = new FileInputStream(f);
        this.input(fis);
        fis.close();
    }

    public CRL(X509 issuer, URL url) throws IOException {
        this(issuer);
        InputStream uis = url.openStream();
        this.input(uis);
        uis.close();
    }

    public CRL(X500Name issuer, PrivateKey privKey, Date thisUpdate, Date nextUpdate, Vector revokedCertificates) {
        this(issuer, privKey);
        this.setDates(thisUpdate, nextUpdate);
        this.setRevokedCertificates(revokedCertificates);
    }

    public CRL(X500Name issuer, PrivateKey privKey, int days) {
        this(issuer, privKey);
        if (days > 0) {
            this.setDates(days);
        }
    }

    public CRL(X500Name issuer, PrivateKey privKey, int days, AlgorithmIdentifier sigAlg) {
        this(issuer, privKey, days);
        this.setSigAlgID(sigAlg);
    }

    public CRL(X500Name issuer, PrivateKey privKey) {
        this.setIssuer(issuer);
        this.setPrivateKey(privKey);
    }

    public void setIssuer(X500Name issuer) {
        this.issuer = issuer;
        this.reset();
    }

    public void setIssuerCertificate(X509 issuerCert) {
        this.issuerCert = issuerCert;
        if (this.issuer == null) {
            this.issuer = issuerCert.getSubject();
        }
        this.setPublicKey(issuerCert.getPublicKey());
    }

    public X500Name getIssuer() {
        return this.issuer;
    }

    public void setPublicKey(PublicKey key) {
        this.pubKey = key;
    }

    public void setPrivateKey(PrivateKey key) {
        this.setPrivateKey(key, null);
    }

    public void setPrivateKey(PrivateKey key, AlgorithmIdentifier sigAlgID) {
        this.privKey = key;
        this.setSigAlgID(sigAlgID);
    }

    public void setSigAlgID(AlgorithmIdentifier sigAlgID) {
        this.sigAlgID = sigAlgID;
        this.reset();
    }

    public Date getDate() {
        return this.thisUpdate;
    }

    public Date getNextDate() {
        return this.nextUpdate;
    }

    public Vector getRevokedCertificates() {
        Vector v = null;
        if (this.revokedCertificates != null) {
            v = new Vector();
            Enumeration e = this.serialNo.elements();
            while (e.hasMoreElements()) {
                v.addElement(this.revokedCertificates.get(e.nextElement()));
            }
        }
        return v;
    }

    public Enumeration revokedSerialNos() {
        return this.serialNo != null ? this.serialNo.elements() : new Vector().elements();
    }

    public void setRevokedCertificates(Vector rcs) {
        if (rcs != null && rcs.size() > 0) {
            this.revokedCertificates = new Hashtable();
            this.serialNo = new Vector();
            Enumeration e = rcs.elements();
            while (e.hasMoreElements()) {
                RevokedCertificate rc = (RevokedCertificate)e.nextElement();
                if (this.revokedCertificates.put(rc.getSerialNo(), rc) != null) {
                    this.serialNo.removeElement(rc.getSerialNo());
                }
                this.serialNo.addElement(rc.getSerialNo());
            }
            this.reset();
        }
    }

    public void setDate(Date thisUpdate) {
        this.thisUpdate = thisUpdate;
        this.reset();
    }

    public void setDates(Date thisUpdate, Date nextUpdate) {
        this.thisUpdate = thisUpdate;
        this.nextUpdate = nextUpdate;
        this.reset();
    }

    public void setDates(int days) {
        this.setDates(new Date(), Utils.daysFromNow((int)days));
    }

    public void addCertificate(BigInteger sn) {
        this.addCertificate(sn, new Date());
    }

    public void addCertificate(BigInteger sn, Date d) {
        this.addCertificate(new RevokedCertificate(sn, d));
    }

    public void addCertificate(RevokedCertificate rc) {
        if (this.revokedCertificates == null) {
            this.revokedCertificates = new Hashtable();
            this.serialNo = new Vector();
        }
        if (this.revokedCertificates.put(rc.getSerialNo(), rc) != null) {
            this.serialNo.removeElement(rc.getSerialNo());
        }
        this.serialNo.addElement(rc.getSerialNo());
        this.reset();
    }

    public X509ExtensionSet getExtensionSet() {
        return this.extensions;
    }

    public X509Extension getExtension(ASN1ObjectID type) {
        return this.extensions != null ? this.extensions.getExtension(type) : null;
    }

    public void setExtensions(X509ExtensionSet exts) {
        this.extensions = exts;
        this.reset();
    }

    public void addExtension(X509Extension ext) {
        if (this.extensions == null) {
            this.extensions = new X509ExtensionSet();
        }
        this.extensions.addExtension(ext);
        this.reset();
    }

    public RevokedCertificate getRevokedCertificate(BigInteger sn) {
        return this.revokedCertificates != null ? (RevokedCertificate)this.revokedCertificates.get(sn) : null;
    }

    public Date revocationDate(BigInteger sn) {
        RevokedCertificate rc = this.getRevokedCertificate(sn);
        return rc != null ? rc.getRevocationDate() : null;
    }

    public boolean isRevoked(BigInteger sn) {
        return this.getRevokedCertificate(sn) != null;
    }

    public boolean hasUnrecognizedCriticalExtension() {
        if (this.extensions != null && this.extensions.hasUnrecognizedCriticalExtension()) {
            return true;
        }
        if (this.revokedCertificates != null) {
            Enumeration e = this.revokedSerialNos();
            while (e.hasMoreElements()) {
                X509ExtensionSet extSet;
                RevokedCertificate rc = this.getRevokedCertificate((BigInteger)e.nextElement());
                if (rc == null || (extSet = rc.getExtensionSet()) == null || !extSet.hasUnrecognizedCriticalExtension()) continue;
                return true;
            }
        }
        return false;
    }

    public boolean verify() throws AuthenticationException {
        if (this.hasUnrecognizedCriticalExtension()) {
            return false;
        }
        if (!this.verifyDate()) {
            return false;
        }
        return this.verifySignature();
    }

    public boolean verifyDate() {
        Date now = new Date();
        if (now.before(this.thisUpdate)) {
            return false;
        }
        return this.nextUpdate == null || !now.after(this.nextUpdate);
    }

    public boolean verifySignature() throws AuthenticationException {
        try {
            return CryptoUtils.verifySignedASN1((ASN1Sequence)this.toASN1Sequence(), (PublicKey)this.pubKey);
        }
        catch (SignatureException ex) {
            throw new AuthenticationException(ex.toString());
        }
    }

    public void sign() throws SignatureException {
        this.sign(RandomBitsSource.getDefault());
    }

    public void sign(RandomBitsSource rbs) throws SignatureException {
        ASN1Sequence tbs = this.getTBSCertList();
        try {
            Signature sig = Signature.getInstance((AlgorithmIdentifier)this.sigAlgID);
            sig.setPrivateKey(this.privKey);
            sig.setRandomBitsSource(rbs);
            sig.setDocument(Utils.toBytes((Streamable)tbs));
            this.sigBytes = sig.sign();
        }
        catch (AlgorithmIdentifierException ex) {
            throw new SignatureException(ex.toString());
        }
        catch (InvalidKeyException ex) {
            throw new SignatureException(ex.toString());
        }
        finally {
            this.resetContents();
        }
    }

    public byte[] getSigBytes() throws SignatureException {
        if (this.sigBytes == null) {
            this.sign();
        }
        return this.sigBytes;
    }

    private ASN1Sequence getTBSCertList() {
        if (this.tbsCertList == null) {
            ASN1Sequence s = new ASN1Sequence();
            if (this.extensions != null && this.extensions.size() > 0) {
                s.addElement((ASN1Object)new ASN1Integer(1L));
            } else if (this.revokedCertificates != null && this.revokedCertificates.size() > 0) {
                Enumeration e = this.serialNo.elements();
                while (e.hasMoreElements()) {
                    RevokedCertificate r = (RevokedCertificate)this.revokedCertificates.get(e.nextElement());
                    if (r.getExtensions() == null || r.getExtensions().size() <= 0) continue;
                    s.addElement((ASN1Object)new ASN1Integer(1L));
                    break;
                }
            }
            if (this.sigAlgID == null) {
                try {
                    this.sigAlgID = Signature.getInstance((PrivateKey)this.privKey).getAlgID();
                }
                catch (SignatureException ex) {
                    throw new IllegalStateException(ex.toString());
                }
                catch (NullPointerException ex) {
                    throw new IllegalStateException("Issuer signing key must be set befor output");
                }
            }
            s.addElement((ASN1Object)this.sigAlgID);
            s.addElement((ASN1Object)this.issuer);
            Calendar t = Calendar.getInstance();
            t.setTime(this.thisUpdate);
            s.addElement((ASN1Object)new ASN1Date(this.thisUpdate, t.get(1) > 2049));
            if (this.nextUpdate != null) {
                Calendar n = Calendar.getInstance();
                n.setTime(this.nextUpdate);
                s.addElement((ASN1Object)new ASN1Date(this.nextUpdate, n.get(1) > 2049));
            }
            if (this.revokedCertificates != null && this.revokedCertificates.size() > 0) {
                ASN1Sequence rcl = new ASN1Sequence();
                Enumeration e = this.serialNo.elements();
                while (e.hasMoreElements()) {
                    rcl.addElement((ASN1Object)((RevokedCertificate)this.revokedCertificates.get(e.nextElement())));
                }
                s.addElement((ASN1Object)rcl);
            }
            if (this.extensions != null && this.extensions.size() > 0) {
                s.addElement((ASN1Object)new ASN1GenericConstructed((ASN1Object)this.extensions, 0));
            }
            this.tbsCertList = s;
        }
        return this.tbsCertList;
    }

    private ASN1Sequence toASN1Sequence() throws SignatureException {
        if (this.contents == null) {
            ASN1Sequence seq = new ASN1Sequence();
            seq.addElement((ASN1Object)this.getTBSCertList());
            seq.addElement((ASN1Object)this.sigAlgID);
            seq.addElement((ASN1Object)new ASN1BitString(this.getSigBytes()));
            this.contents = seq;
        }
        return this.contents;
    }

    public void output(OutputStream os) throws IOException {
        try {
            this.toASN1Sequence().output(os);
        }
        catch (SignatureException ex) {
            throw new OutputGenerationException(ex.toString());
        }
    }

    public void input(InputStream is) throws IOException {
        AlgorithmIdentifier tbsSigAlgID;
        this.reset();
        ASN1SequenceInputStream sis = new ASN1SequenceInputStream(is);
        this.tbsCertList = new ASN1Sequence((InputStream)sis);
        this.sigAlgID = new AlgorithmIdentifier((InputStream)sis);
        this.sigBytes = ASN1BitString.inputValue((InputStream)sis);
        sis.terminate();
        ASN1SequenceInputStream tbs = new ASN1SequenceInputStream(Utils.toStream((Streamable)this.tbsCertList));
        if (tbs.getCurrentTag() == 2) {
            BigInteger version = ASN1Integer.inputValue((InputStream)tbs);
        }
        if (!(tbsSigAlgID = new AlgorithmIdentifier((InputStream)tbs)).equals((Object)this.sigAlgID)) {
            throw new IOException("Inconsistent signature algorithm IDs");
        }
        X500Name issuer2 = new X500Name((InputStream)tbs);
        if (this.issuer == null) {
            this.issuer = issuer2;
        } else if (!this.issuer.equals(issuer2)) {
            throw new IOException("Expected issuer {" + this.issuer + "}, got issuer {" + issuer2 + "}");
        }
        this.thisUpdate = ASN1Date.inputValue((InputStream)tbs);
        this.nextUpdate = tbs.getCurrentTag() == 23 || tbs.getCurrentTag() == 24 ? ASN1Date.inputValue((InputStream)tbs) : null;
        if (tbs.getCurrentTag() == 16) {
            ASN1SequenceInputStream crl = new ASN1SequenceInputStream((InputStream)tbs);
            this.revokedCertificates = new Hashtable();
            this.serialNo = new Vector();
            while (crl.hasMoreData()) {
                RevokedCertificate rc = new RevokedCertificate((InputStream)crl);
                if (this.revokedCertificates.put(rc.getSerialNo(), rc) != null) {
                    this.serialNo.removeElement(rc.getSerialNo());
                }
                this.serialNo.addElement(rc.getSerialNo());
            }
            crl.terminate();
        } else {
            this.revokedCertificates = null;
            this.serialNo = null;
        }
        if (tbs.getCurrentTag() == 0) {
            ASN1ConstructedInputStream ext = new ASN1ConstructedInputStream((InputStream)tbs);
            this.extensions = new X509ExtensionSet((InputStream)ext);
            ext.terminate();
        } else {
            this.extensions = null;
        }
        tbs.terminate();
    }

    private void reset() {
        this.resetContents();
        this.tbsCertList = null;
        this.sigBytes = null;
    }

    private void resetContents() {
        this.contents = null;
    }

    public int length() {
        try {
            return this.toASN1Sequence().length();
        }
        catch (SignatureException ex) {
            throw new StreamableOutputException(ex.toString());
        }
    }

    public boolean equals(Object o) {
        if (o != null && o instanceof CRL) {
            return this.equals((CRL)o);
        }
        return false;
    }

    private boolean equals(CRL c) {
        return Utils.areEqual((byte[])Utils.toBytes((Streamable)this), (byte[])Utils.toBytes((Streamable)c));
    }

    public String toString() {
        String s = "issuer = " + this.issuer + ", thisUpdate = " + this.thisUpdate;
        if (this.nextUpdate != null) {
            s = s + ", nextUpdate = " + this.nextUpdate;
        }
        s = s + ", revokedCertificates = {";
        Enumeration e = this.serialNo.elements();
        while (e.hasMoreElements()) {
            RevokedCertificate r = (RevokedCertificate)this.revokedCertificates.get(e.nextElement());
            s = s + "(" + r + ")";
            if (!e.hasMoreElements()) continue;
            s = s + ", ";
        }
        s = s + "}";
        if (this.extensions != null && this.extensions.size() > 0) {
            s = s + ", extensions = " + this.extensions;
        }
        return s;
    }

    public byte[] getEncoded() {
        try {
            return Utils.toBytes((Streamable)this.toASN1Sequence());
        }
        catch (SignatureException ex) {
            throw new StreamableOutputException(ex.toString());
        }
    }

    public void writeExternal(ObjectOutput os) throws IOException {
        os.writeObject(Utils.toBytes((Streamable)this));
    }

    public void readExternal(ObjectInput is) throws IOException, ClassNotFoundException {
        byte[] data;
        try {
            data = (byte[])is.readObject();
        }
        catch (ClassCastException ex) {
            throw new InvalidInputException((Exception)ex);
        }
        this.input((InputStream)new UnsyncByteArrayInputStream(data));
    }
}

