/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.pki.internal;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import oracle.security.crypto.cert.CertificateRequest;
import oracle.security.crypto.util.Utils;

public final class OraclePKIX509CertReqHelper {
    private static final String a = "-----BEGIN NEW CERTIFICATE REQUEST-----";
    private static final String b = "-----END NEW CERTIFICATE REQUEST-----";

    public static final CertificateRequest readB64CertReqFrom(Reader reader) throws IOException {
        BufferedReader bufferedReader = new BufferedReader(reader);
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        boolean bl2 = false;
        String string = bufferedReader.readLine();
        while (string != null) {
            if (string.startsWith(a)) {
                bl = true;
                stringBuffer.append(string.substring(a.length()));
                break;
            }
            string = bufferedReader.readLine();
        }
        if (!bl) {
            throw new IOException();
        }
        string = bufferedReader.readLine();
        while (string != null) {
            if (string.indexOf(b) != -1) {
                bl2 = true;
                stringBuffer.append(string.substring(0, string.indexOf(b)));
                break;
            }
            stringBuffer.append(string);
            string = bufferedReader.readLine();
        }
        if (!bl2) {
            throw new IOException();
        }
        for (int i = 0; i < stringBuffer.length(); ++i) {
            if (stringBuffer.charAt(i) != ' ') continue;
            stringBuffer.deleteCharAt(i);
        }
        return new CertificateRequest((InputStream)new ByteArrayInputStream(Utils.fromBase64((String)stringBuffer.toString())));
    }

    public static final void writeB64X509CertReqTo(Writer writer, CertificateRequest certificateRequest) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        certificateRequest.output((OutputStream)byteArrayOutputStream);
        String string = "-----BEGIN NEW CERTIFICATE REQUEST-----\n" + Utils.toBase64((byte[])byteArrayOutputStream.toByteArray()) + b;
        writer.write(string);
        writer.flush();
    }

    public static final String addCertReqHeaderFooter(String string) throws IOException {
        String string2 = null;
        string2 = "-----BEGIN NEW CERTIFICATE REQUEST-----\n" + string + "\n" + b;
        return string2;
    }

    public static final String removeCertReqHeaderFooter(String string) throws IOException {
        String string2 = null;
        if (!string.startsWith(a) || !string.endsWith(b)) {
            throw new IOException("No header or footer in B64 cert");
        }
        string2 = string.substring(a.length(), string.length() - b.length());
        return string2;
    }
}

