/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.jdbc.oracle;

import java.lang.reflect.Executable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;
import oracle.jdbc.internal.NetStat;
import oracle.ucp.UniversalConnectionPoolException;
import oracle.ucp.logging.ClioSupport;
import oracle.ucp.logging.annotations.DefaultLogger;
import oracle.ucp.logging.annotations.Feature;
import oracle.ucp.logging.annotations.Supports;

@DefaultLogger(value="oracle.ucp.jdbc.oracle")
@Supports(value={Feature.HIGH_AVAILABILITY})
public class FailoverablePooledConnectionHelper {
    private static final Object[] NO_ARGS;
    private static final Map<Class<?>, InvocationVector> oracleConnCache;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;
    private static Executable $$$methodRef$$$15;
    private static Logger $$$loggerRef$$$15;
    private static Executable $$$methodRef$$$16;
    private static Logger $$$loggerRef$$$16;
    private static Executable $$$methodRef$$$17;
    private static Logger $$$loggerRef$$$17;
    private static Executable $$$methodRef$$$18;
    private static Logger $$$loggerRef$$$18;
    private static Executable $$$methodRef$$$19;
    private static Logger $$$loggerRef$$$19;
    private static Executable $$$methodRef$$$20;
    private static Logger $$$loggerRef$$$20;

    static boolean isUsableOnOracleConnection(Connection oconn) {
        boolean ret_value = false;
        try {
            Method method = FailoverablePooledConnectionHelper.getInvocationVector(oconn).getMethodIsUsable();
            if (null != method) {
                ret_value = (Boolean)method.invoke((Object)oconn, NO_ARGS);
            } else {
                ClioSupport.ilogFinest(null, null, null, null, "failed to invoke isUsable(): no such method");
                ret_value = !oconn.isClosed();
            }
        }
        catch (Exception e) {
            ClioSupport.ilogThrowing(null, null, null, null, e);
        }
        return ret_value;
    }

    static long getLastNetworkAccessTime(Connection oconn) {
        long ret_value = 0L;
        try {
            Method method = FailoverablePooledConnectionHelper.getInvocationVector(oconn).getMethodNetworkStat();
            if (null != method) {
                NetStat stat = (NetStat)method.invoke((Object)oconn, NO_ARGS);
                if (stat != null) {
                    ret_value = stat.getLastNetworkAccessTime();
                }
            } else {
                ClioSupport.ilogFinest(null, null, null, null, "failed to invoke getNetworkStat(): no such method");
            }
        }
        catch (Exception e) {
            ClioSupport.ilogThrowing(null, null, null, null, e);
        }
        return ret_value;
    }

    public static Properties getSessionInfoOnOracleConnection(Connection oconn) {
        Properties props = new Properties();
        try {
            Method method = FailoverablePooledConnectionHelper.getInvocationVector(oconn).getMethodGetServerSessionInfo();
            if (null != method) {
                props = (Properties)method.invoke((Object)oconn, NO_ARGS);
            } else {
                ClioSupport.ilogFinest(null, null, null, null, "failed to invoke getServerSessionInfo: method not found");
                props = FailoverablePooledConnectionHelper.getSessionInfoOnOracleConnectionHelper(oconn);
            }
        }
        catch (Exception e) {
            ClioSupport.ilogThrowing(null, null, null, null, e);
        }
        return props;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Properties getSessionInfoOnOracleConnectionHelper(Connection connection) throws SQLException {
        String query = "select sys_context('userenv', 'instance_name'),sys_context('userenv', 'server_host'),sys_context('userenv', 'service_name'),sys_context('userenv', 'db_unique_name') from dual";
        Properties props = new Properties();
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = connection.createStatement();
            rs = stmt.executeQuery(query);
            while (rs.next()) {
                String val = null;
                val = rs.getString(1);
                if (val != null) {
                    props.setProperty("INSTANCE_NAME", val);
                }
                if ((val = rs.getString(2)) != null) {
                    props.setProperty("SERVER_HOST", val);
                }
                if ((val = rs.getString(3)) != null) {
                    props.setProperty("SERVICE_NAME", val);
                }
                if ((val = rs.getString(4)) == null) continue;
                props.setProperty("DATABASE_NAME", val);
            }
        }
        catch (SQLException ea) {
            ClioSupport.ilogThrowing(null, null, null, null, ea);
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            if (stmt != null) {
                stmt.close();
            }
        }
        return props;
    }

    static void cancelOnOracleConnection(Connection oconn) throws SQLException {
        try {
            Method method = FailoverablePooledConnectionHelper.getInvocationVector(oconn).getMethodCancel();
            if (null != method) {
                method.invoke((Object)oconn, NO_ARGS);
                ClioSupport.ilogFinest(null, null, null, null, "conn cancelled successfully");
            } else {
                ClioSupport.ilogFinest(null, null, null, null, "failed to cancel a connection: method not found");
            }
        }
        catch (Exception exc) {
            ClioSupport.ilogThrowing(null, null, null, null, exc);
        }
    }

    static void enableStatementPooling(Connection oconn, int maxStatements) throws SQLException {
        block6: {
            try {
                if (null == oconn) {
                    ClioSupport.ilogFinest(null, null, null, null, "failed to get SQL conn");
                    return;
                }
                InvocationVector vector = FailoverablePooledConnectionHelper.getInvocationVector(oconn);
                Method method = vector.getMethodSetStatementCacheSize();
                if (null != method) {
                    method.invoke((Object)oconn, maxStatements);
                    ClioSupport.ilogFinest(null, null, null, null, "setStatementCacheSize invoked");
                }
                if (null != (method = vector.getMethodSetImplicitCachingEnabled())) {
                    method.invoke((Object)oconn, true);
                    ClioSupport.ilogFinest(null, null, null, null, "setImplicitCachingEnabled invoked");
                }
                if (null != (method = vector.getMethodSetExplicitCachingEnabled())) {
                    method.invoke((Object)oconn, true);
                    ClioSupport.ilogFinest(null, null, null, null, "setExplicitCachingEnabled invoked");
                }
            }
            catch (Exception e) {
                ClioSupport.ilogThrowing(null, null, null, null, e);
                if (!(e instanceof SQLException)) break block6;
                throw (SQLException)e;
            }
        }
    }

    static void disableStatementPooling(Connection oconn) throws SQLException {
        block6: {
            try {
                if (null == oconn) {
                    ClioSupport.ilogFinest(null, null, null, null, "failed to get SQL conn");
                    return;
                }
                InvocationVector vector = FailoverablePooledConnectionHelper.getInvocationVector(oconn);
                Method method = vector.getMethodSetStatementCacheSize();
                if (null != method) {
                    method.invoke((Object)oconn, 0);
                    ClioSupport.ilogFinest(null, null, null, null, "setStatementCacheSize invoked");
                }
                if (null != (method = vector.getMethodSetImplicitCachingEnabled())) {
                    method.invoke((Object)oconn, false);
                    ClioSupport.ilogFinest(null, null, null, null, "setImplicitCachingEnabled invoked");
                }
                if (null != (method = vector.getMethodSetExplicitCachingEnabled())) {
                    method.invoke((Object)oconn, false);
                    ClioSupport.ilogFinest(null, null, null, null, "setExplicitCachingEnabled invoked");
                }
            }
            catch (Exception e) {
                ClioSupport.ilogThrowing(null, null, null, null, e);
                if (!(e instanceof SQLException)) break block6;
                throw (SQLException)e;
            }
        }
    }

    static boolean pingDatabaseOnOracleConnection(Connection oconn) {
        Object[] arg;
        InvocationVector vector = FailoverablePooledConnectionHelper.getInvocationVector(oconn);
        Method method = vector.getMethodPingDatabase();
        if (null == method) {
            method = vector.getMethodPingDatabaseInt();
            arg = new Object[]{0};
        } else {
            arg = NO_ARGS;
        }
        try {
            return vector.getConnClass().getField("DATABASE_OK").getInt(null) == ((Integer)method.invoke((Object)oconn, arg)).intValue();
        }
        catch (Exception e) {
            ClioSupport.ilogThrowing(null, null, null, null, e);
            return true;
        }
    }

    public static void abortOracleConnection(final Connection oconn) {
        if (oconn == null) {
            return;
        }
        try {
            final Method method = FailoverablePooledConnectionHelper.getInvocationVector(oconn).getMethodAbort();
            if (null != method) {
                AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){
                    private static Executable $$$methodRef$$$0;
                    private static Logger $$$loggerRef$$$0;
                    private static Executable $$$methodRef$$$1;
                    private static Logger $$$loggerRef$$$1;
                    private static Executable $$$methodRef$$$2;
                    private static Logger $$$loggerRef$$$2;

                    @Override
                    public Void run() throws IllegalAccessException, InvocationTargetException {
                        method.invoke((Object)oconn, NO_ARGS);
                        return null;
                    }

                    static {
                        try {
                            $$$methodRef$$$2 = 1.class.getDeclaredConstructor(Method.class, Connection.class);
                        }
                        catch (Throwable throwable) {}
                        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                        try {
                            $$$methodRef$$$1 = 1.class.getDeclaredMethod("run", new Class[0]);
                        }
                        catch (Throwable throwable) {}
                        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                        try {
                            $$$methodRef$$$0 = 1.class.getDeclaredMethod("run", new Class[0]);
                        }
                        catch (Throwable throwable) {}
                        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                    }
                });
                ClioSupport.ilogFinest(null, null, null, null, "connection aborted");
            } else {
                ClioSupport.ilogFinest(null, null, null, null, "failed to abort connection: method not found");
            }
        }
        catch (Exception ex) {
            ClioSupport.ilogThrowing(null, null, null, null, ex);
        }
    }

    protected static InvocationVector getInvocationVector(Connection oracleConn) {
        Class<?> connClass = oracleConn.getClass();
        InvocationVector vector = oracleConnCache.get(connClass);
        if (null != vector) {
            return vector;
        }
        Class<?> c = null;
        try {
            c = Class.forName("oracle.jdbc.internal.OracleConnection", true, connClass.getClassLoader());
        }
        catch (Exception e) {
            ClioSupport.ilogThrowing(null, null, null, null, e);
        }
        final Class<?> cls = c;
        vector = new InvocationVector(){
            private final Method abort = this.getMethod("abort");
            private final Method cancel = this.getMethod("cancel");
            private final Method isUsable = this.getMethod("isUsable");
            private final Method setStatementCacheSize = this.getMethod("setStatementCacheSize", Integer.TYPE);
            private final Method setImplicitCachingEnabled = this.getMethod("setImplicitCachingEnabled", Boolean.TYPE);
            private final Method setExplicitCachingEnabled = this.getMethod("setExplicitCachingEnabled", Boolean.TYPE);
            private final Method getServerSessionInfo = this.getMethod("getServerSessionInfo");
            private final Method pingDatabase = this.getMethod("pingDatabase");
            private final Method pingDatabaseInt = this.getMethod("pingDatabase", Integer.TYPE);
            private final Method getVersionNumber = this.getMethod("getVersionNumber");
            private final Method attachServerConnection = this.getMethod("attachServerConnection");
            private final Method detachServerConnection = this.getMethod("detachServerConnection", String.class);
            private final Method isDRCPEnabled = this.getMethod("isDRCPEnabled");
            private final Method isDRCPMultitagEnabled = this.getMethod("isDRCPMultitagEnabled");
            private final Method getDRCPReturnTag = this.getMethod("getDRCPReturnTag");
            private final Method getDRCPPLSQLCallbackName = this.getMethod("getDRCPPLSQLCallbackName");
            private final Method getNetworkStat = this.getMethod("getNetworkStat");
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;
            private static Executable $$$methodRef$$$3;
            private static Logger $$$loggerRef$$$3;
            private static Executable $$$methodRef$$$4;
            private static Logger $$$loggerRef$$$4;
            private static Executable $$$methodRef$$$5;
            private static Logger $$$loggerRef$$$5;
            private static Executable $$$methodRef$$$6;
            private static Logger $$$loggerRef$$$6;
            private static Executable $$$methodRef$$$7;
            private static Logger $$$loggerRef$$$7;
            private static Executable $$$methodRef$$$8;
            private static Logger $$$loggerRef$$$8;
            private static Executable $$$methodRef$$$9;
            private static Logger $$$loggerRef$$$9;
            private static Executable $$$methodRef$$$10;
            private static Logger $$$loggerRef$$$10;
            private static Executable $$$methodRef$$$11;
            private static Logger $$$loggerRef$$$11;
            private static Executable $$$methodRef$$$12;
            private static Logger $$$loggerRef$$$12;
            private static Executable $$$methodRef$$$13;
            private static Logger $$$loggerRef$$$13;
            private static Executable $$$methodRef$$$14;
            private static Logger $$$loggerRef$$$14;
            private static Executable $$$methodRef$$$15;
            private static Logger $$$loggerRef$$$15;
            private static Executable $$$methodRef$$$16;
            private static Logger $$$loggerRef$$$16;
            private static Executable $$$methodRef$$$17;
            private static Logger $$$loggerRef$$$17;
            private static Executable $$$methodRef$$$18;
            private static Logger $$$loggerRef$$$18;
            private static Executable $$$methodRef$$$19;
            private static Logger $$$loggerRef$$$19;
            private static Executable $$$methodRef$$$20;
            private static Logger $$$loggerRef$$$20;

            private Method getMethod(String method, Class<?> type) {
                if (null != cls) {
                    try {
                        return cls.getMethod(method, type);
                    }
                    catch (NoSuchMethodException e) {
                        ClioSupport.ilogThrowing(null, null, null, null, e);
                        return null;
                    }
                }
                return null;
            }

            private Method getMethod(String method) {
                if (null != cls) {
                    try {
                        return cls.getMethod(method, new Class[0]);
                    }
                    catch (NoSuchMethodException e) {
                        ClioSupport.ilogThrowing(null, null, null, null, e);
                        return null;
                    }
                }
                return null;
            }

            @Override
            public Class<?> getConnClass() {
                return cls;
            }

            @Override
            public Method getMethodAbort() {
                return this.abort;
            }

            @Override
            public Method getMethodCancel() {
                return this.cancel;
            }

            @Override
            public Method getMethodIsUsable() {
                return this.isUsable;
            }

            @Override
            public Method getMethodNetworkStat() {
                return this.getNetworkStat;
            }

            @Override
            public Method getMethodSetStatementCacheSize() {
                return this.setStatementCacheSize;
            }

            @Override
            public Method getMethodSetImplicitCachingEnabled() {
                return this.setImplicitCachingEnabled;
            }

            @Override
            public Method getMethodSetExplicitCachingEnabled() {
                return this.setExplicitCachingEnabled;
            }

            @Override
            public Method getMethodGetServerSessionInfo() {
                return this.getServerSessionInfo;
            }

            @Override
            public Method getMethodPingDatabase() {
                return this.pingDatabase;
            }

            @Override
            public Method getMethodPingDatabaseInt() {
                return this.pingDatabaseInt;
            }

            @Override
            public Method getMethodGetVersionNumber() {
                return this.getVersionNumber;
            }

            @Override
            public Method getMethodAttachServerConnection() {
                return this.attachServerConnection;
            }

            @Override
            public Method getMethodIsDRCPEnabled() {
                return this.isDRCPEnabled;
            }

            @Override
            public Method getMethodDetachServerConnection() {
                return this.detachServerConnection;
            }

            @Override
            public Method getMethodIsDRCPMultitagEnabled() {
                return this.isDRCPMultitagEnabled;
            }

            @Override
            public Method getMethodGetDRCPReturnTag() {
                return this.getDRCPReturnTag;
            }

            @Override
            public Method getDRCPPLSQLCallbackName() {
                return this.getDRCPPLSQLCallbackName;
            }

            static {
                try {
                    $$$methodRef$$$20 = 2.class.getDeclaredConstructor(Class.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$20 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$19 = 2.class.getDeclaredMethod("getDRCPPLSQLCallbackName", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$19 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$18 = 2.class.getDeclaredMethod("getMethodGetDRCPReturnTag", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$18 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$17 = 2.class.getDeclaredMethod("getMethodIsDRCPMultitagEnabled", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$17 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$16 = 2.class.getDeclaredMethod("getMethodDetachServerConnection", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$16 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$15 = 2.class.getDeclaredMethod("getMethodIsDRCPEnabled", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$14 = 2.class.getDeclaredMethod("getMethodAttachServerConnection", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$13 = 2.class.getDeclaredMethod("getMethodGetVersionNumber", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$12 = 2.class.getDeclaredMethod("getMethodPingDatabaseInt", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$11 = 2.class.getDeclaredMethod("getMethodPingDatabase", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$10 = 2.class.getDeclaredMethod("getMethodGetServerSessionInfo", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$9 = 2.class.getDeclaredMethod("getMethodSetExplicitCachingEnabled", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$8 = 2.class.getDeclaredMethod("getMethodSetImplicitCachingEnabled", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$7 = 2.class.getDeclaredMethod("getMethodSetStatementCacheSize", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$6 = 2.class.getDeclaredMethod("getMethodNetworkStat", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$5 = 2.class.getDeclaredMethod("getMethodIsUsable", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$4 = 2.class.getDeclaredMethod("getMethodCancel", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$3 = 2.class.getDeclaredMethod("getMethodAbort", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$2 = 2.class.getDeclaredMethod("getConnClass", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$1 = 2.class.getDeclaredMethod("getMethod", String.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$0 = 2.class.getDeclaredMethod("getMethod", String.class, Class.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            }
        };
        oracleConnCache.put(connClass, vector);
        return vector;
    }

    public static int getDatabaseVersion(Connection oconn) throws UniversalConnectionPoolException {
        int dbVersion = 0;
        try {
            Method method = FailoverablePooledConnectionHelper.getInvocationVector(oconn).getMethodGetVersionNumber();
            if (null != method) {
                dbVersion = ((Short)method.invoke((Object)oconn, NO_ARGS)).intValue();
                ClioSupport.ilogFinest(null, null, null, null, "db version obtained successfully");
            } else {
                ClioSupport.ilogFinest(null, null, null, null, "failed to get db version: method not found");
            }
        }
        catch (Exception exc) {
            dbVersion = 0;
            ClioSupport.ilogThrowing(null, null, null, null, exc);
        }
        return dbVersion;
    }

    public static boolean attachServerConnection(Connection oconn) throws SQLException {
        boolean returnValue = true;
        try {
            Method method = FailoverablePooledConnectionHelper.getInvocationVector(oconn).getMethodAttachServerConnection();
            if (null != method) {
                returnValue = (Boolean)method.invoke((Object)oconn, NO_ARGS);
                ClioSupport.ilogFinest(null, null, null, null, "Invoked attachServerConnection Successfully");
            } else {
                ClioSupport.ilogFinest(null, null, null, null, "failed to invoke attachServerConnection");
            }
        }
        catch (InvocationTargetException targetException) {
            Throwable throwable = targetException.getCause();
            if (throwable != null && throwable instanceof SQLException) {
                throw (SQLException)throwable;
            }
            throw new SQLException(targetException);
        }
        catch (Throwable exc) {
            throw new SQLException(exc);
        }
        return returnValue;
    }

    public static void detachServerConnection(Connection oconn, String tag) throws SQLException {
        try {
            Method method = FailoverablePooledConnectionHelper.getInvocationVector(oconn).getMethodDetachServerConnection();
            if (null != method) {
                method.invoke((Object)oconn, tag);
                ClioSupport.ilogFinest(null, null, null, null, "Invoked detachServerConnection Successfully");
            } else {
                ClioSupport.ilogFinest(null, null, null, null, "failed to invoke detachServerConnection");
            }
        }
        catch (InvocationTargetException targetException) {
            Throwable throwable = targetException.getCause();
            if (throwable != null && throwable instanceof SQLException) {
                throw (SQLException)throwable;
            }
            throw new SQLException(targetException);
        }
        catch (Throwable exc) {
            throw new SQLException(exc);
        }
    }

    public static boolean isDRCPEnabled(Connection oconn) throws SQLException {
        Boolean returnValue = Boolean.FALSE;
        try {
            Method method = FailoverablePooledConnectionHelper.getInvocationVector(oconn).getMethodIsDRCPEnabled();
            if (null != method) {
                returnValue = (Boolean)method.invoke((Object)oconn, NO_ARGS);
                ClioSupport.ilogFinest(null, null, null, null, "Invoked isDRCPEnabled Successfully");
            } else {
                ClioSupport.ilogFinest(null, null, null, null, "failed to invoke isDRCPEnabled");
            }
        }
        catch (Exception exc) {
            ClioSupport.ilogThrowing(null, null, null, null, exc);
        }
        return returnValue;
    }

    static boolean isDRCPMultitagEnabled(Connection oconn) throws SQLException {
        try {
            Method method = FailoverablePooledConnectionHelper.getInvocationVector(oconn).getMethodIsDRCPMultitagEnabled();
            if (method != null) {
                return (Boolean)method.invoke((Object)oconn, NO_ARGS);
            }
            ClioSupport.ilogFinest(null, null, null, null, "failed to invoke isDRCPMultitagEnabled");
        }
        catch (Exception exc) {
            ClioSupport.ilogThrowing(null, null, null, null, exc);
        }
        return false;
    }

    static String getDRCPReturnTag(Connection oconn) throws SQLException {
        try {
            Method method = FailoverablePooledConnectionHelper.getInvocationVector(oconn).getMethodGetDRCPReturnTag();
            if (method != null) {
                return (String)method.invoke((Object)oconn, NO_ARGS);
            }
            ClioSupport.ilogFinest(null, null, null, null, "failed to invoke getDRCPReturnTag");
        }
        catch (Exception exc) {
            ClioSupport.ilogThrowing(null, null, null, null, exc);
        }
        return null;
    }

    static String getDRCPPLSQLCallbackName(Connection oconn) throws SQLException {
        try {
            Method method = FailoverablePooledConnectionHelper.getInvocationVector(oconn).getDRCPPLSQLCallbackName();
            if (method != null) {
                return (String)method.invoke((Object)oconn, NO_ARGS);
            }
            ClioSupport.ilogFinest(null, null, null, null, "failed to invoke getDRCPPLSQLCallbackName");
        }
        catch (Exception exc) {
            ClioSupport.ilogThrowing(null, null, null, null, exc);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getInstanceNumber(Connection connection) throws SQLException {
        Properties props = FailoverablePooledConnectionHelper.getSessionInfoOnOracleConnection(connection);
        String instIdStr = props.getProperty("AUTH_SC_INSTANCE_ID");
        if (instIdStr != null && !"".equals(instIdStr)) {
            return Integer.parseInt(instIdStr);
        }
        ClioSupport.ilogFinest(null, null, null, null, "Failed to obtain instance number without roundtrip, doing a query");
        String query = "select sys_context('userenv', 'instance') from dual";
        int instId = -1;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = connection.createStatement();
            rs = stmt.executeQuery(query);
            rs.next();
            instId = rs.getInt(1);
        }
        catch (SQLException ea) {
            ClioSupport.ilogThrowing(null, null, null, null, ea);
            instId = -1;
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            if (stmt != null) {
                stmt.close();
            }
        }
        return instId;
    }

    public static Date getInstanceStartTime(String timestampString) {
        if (timestampString == null) {
            return null;
        }
        StringBuffer instStartTimeString = new StringBuffer(timestampString);
        int nanosecStartIndex = instStartTimeString.indexOf(".", 18);
        instStartTimeString.delete(nanosecStartIndex, nanosecStartIndex + 10);
        instStartTimeString.insert(nanosecStartIndex + 1, "GMT");
        ClioSupport.ilogFinest(null, null, null, null, "instance start time string: " + instStartTimeString);
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss z");
        format.setLenient(false);
        Date ts = null;
        try {
            ts = format.parse(instStartTimeString.toString());
        }
        catch (ParseException pe) {
            ClioSupport.ilogFinest(null, null, null, null, "Invalid instance start time, return null: " + instStartTimeString);
            ts = null;
        }
        return ts;
    }

    static {
        try {
            $$$methodRef$$$20 = FailoverablePooledConnectionHelper.class.getDeclaredConstructor(new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$20 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$19 = FailoverablePooledConnectionHelper.class.getDeclaredMethod("access$000", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$19 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$18 = FailoverablePooledConnectionHelper.class.getDeclaredMethod("getInstanceStartTime", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$18 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$17 = FailoverablePooledConnectionHelper.class.getDeclaredMethod("getInstanceNumber", Connection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$17 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$16 = FailoverablePooledConnectionHelper.class.getDeclaredMethod("getDRCPPLSQLCallbackName", Connection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$16 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$15 = FailoverablePooledConnectionHelper.class.getDeclaredMethod("getDRCPReturnTag", Connection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$14 = FailoverablePooledConnectionHelper.class.getDeclaredMethod("isDRCPMultitagEnabled", Connection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$13 = FailoverablePooledConnectionHelper.class.getDeclaredMethod("isDRCPEnabled", Connection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$12 = FailoverablePooledConnectionHelper.class.getDeclaredMethod("detachServerConnection", Connection.class, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$11 = FailoverablePooledConnectionHelper.class.getDeclaredMethod("attachServerConnection", Connection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$10 = FailoverablePooledConnectionHelper.class.getDeclaredMethod("getDatabaseVersion", Connection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$9 = FailoverablePooledConnectionHelper.class.getDeclaredMethod("getInvocationVector", Connection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$8 = FailoverablePooledConnectionHelper.class.getDeclaredMethod("abortOracleConnection", Connection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$7 = FailoverablePooledConnectionHelper.class.getDeclaredMethod("pingDatabaseOnOracleConnection", Connection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$6 = FailoverablePooledConnectionHelper.class.getDeclaredMethod("disableStatementPooling", Connection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$5 = FailoverablePooledConnectionHelper.class.getDeclaredMethod("enableStatementPooling", Connection.class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$4 = FailoverablePooledConnectionHelper.class.getDeclaredMethod("cancelOnOracleConnection", Connection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$3 = FailoverablePooledConnectionHelper.class.getDeclaredMethod("getSessionInfoOnOracleConnectionHelper", Connection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$2 = FailoverablePooledConnectionHelper.class.getDeclaredMethod("getSessionInfoOnOracleConnection", Connection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$1 = FailoverablePooledConnectionHelper.class.getDeclaredMethod("getLastNetworkAccessTime", Connection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$0 = FailoverablePooledConnectionHelper.class.getDeclaredMethod("isUsableOnOracleConnection", Connection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        NO_ARGS = new Object[0];
        oracleConnCache = Collections.synchronizedMap(new HashMap());
    }

    static interface InvocationVector {
        public Class<?> getConnClass();

        public Method getMethodAbort();

        public Method getMethodCancel();

        public Method getMethodIsUsable();

        public Method getMethodSetStatementCacheSize();

        public Method getMethodSetImplicitCachingEnabled();

        public Method getMethodSetExplicitCachingEnabled();

        public Method getMethodGetServerSessionInfo();

        public Method getMethodPingDatabase();

        public Method getMethodPingDatabaseInt();

        public Method getMethodGetVersionNumber();

        public Method getMethodAttachServerConnection();

        public Method getMethodDetachServerConnection();

        public Method getMethodIsDRCPEnabled();

        public Method getMethodIsDRCPMultitagEnabled();

        public Method getMethodGetDRCPReturnTag();

        public Method getDRCPPLSQLCallbackName();

        public Method getMethodNetworkStat();
    }
}

