/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.jdbc.proxy;

import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLRecoverableException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Logger;
import oracle.jdbc.logging.annotations.DisableTrace;
import oracle.jdbc.replay.ReplayableConnection;
import oracle.ucp.UniversalConnectionPoolException;
import oracle.ucp.UniversalPooledConnectionStatus;
import oracle.ucp.common.Clock;
import oracle.ucp.jdbc.JDBCConnectionPool;
import oracle.ucp.jdbc.JDBCUniversalPooledConnection;
import oracle.ucp.jdbc.proxy.LogicalObject;
import oracle.ucp.jdbc.proxy.ResultSetProxyFactory;
import oracle.ucp.util.UCPErrorHandler;

@DisableTrace
public class StatementProxyFactory
implements InvocationHandler,
LogicalObject {
    protected static ConcurrentMap<Class, Constructor> constructorMap = new ConcurrentHashMap<Class, Constructor>();
    protected final Statement m_proxiedStatement;
    protected final Connection m_proxyConnection;
    protected final JDBCUniversalPooledConnection m_jdbcPooledConnection;
    protected final JDBCConnectionPool m_jdbcConnectionPool;
    protected boolean m_closed = false;
    protected boolean m_closed_on_completion = false;
    private boolean m_sqlWithQueryTimeoutInProgress = false;
    protected final long creationTS = Clock.clock();
    protected final boolean isReplayable;
    private static final int ORAERROR_INVALID_SHARDKEYS = 45582;
    private static final Map<String, SwitchTable> m_invokeSwitchTable = new HashMap<String, SwitchTable>();
    private static final Map<Class, Class[]> m_mapInterfaces;

    public static Object createStatementProxy(Object proxiedStatement, Object proxyConnection, JDBCConnectionPool jdbcConnectionPool, JDBCUniversalPooledConnection jdbcPooledConnection) throws UniversalConnectionPoolException {
        if (proxiedStatement == null) {
            return null;
        }
        Object stmtProxy = null;
        try {
            stmtProxy = StatementProxyFactory.createProxyHelper(proxyConnection.getClass().getClassLoader(), proxiedStatement, proxyConnection, jdbcConnectionPool, jdbcPooledConnection);
        }
        catch (Throwable e) {
            try {
                stmtProxy = StatementProxyFactory.createProxyHelper(StatementProxyFactory.class.getClassLoader(), proxiedStatement, proxyConnection, jdbcConnectionPool, jdbcPooledConnection);
            }
            catch (Throwable ee) {
                throw new UniversalConnectionPoolException(ee);
            }
        }
        return stmtProxy;
    }

    private static Object createProxyHelper(ClassLoader clsLoader, Object proxiedStatement, Object proxyConnection, JDBCConnectionPool jdbcConnectionPool, JDBCUniversalPooledConnection jdbcPooledConnection) throws Exception {
        Class<?> stmtClass = proxiedStatement.getClass();
        Constructor<?> constructor = (Constructor<?>)constructorMap.get(stmtClass);
        if (constructor == null) {
            Class<?> pxyClass = Proxy.getProxyClass(clsLoader, StatementProxyFactory.createInterfaces(proxiedStatement));
            constructor = pxyClass.getConstructor(InvocationHandler.class);
        }
        Object stmtProxy = constructor.newInstance(new StatementProxyFactory(proxiedStatement, proxyConnection, jdbcConnectionPool, jdbcPooledConnection));
        if (null == constructorMap.putIfAbsent(stmtClass, constructor)) {
        }
        return stmtProxy;
    }

    protected StatementProxyFactory(Object proxiedStatement, Object proxyConnection, JDBCConnectionPool jdbcConnectionPool, JDBCUniversalPooledConnection jdbcPooledConnection) throws UniversalConnectionPoolException {
        int errCode;
        if (jdbcPooledConnection == null) {
            errCode = 150;
        } else if (jdbcConnectionPool == null) {
            errCode = 54;
        } else if (!(proxyConnection instanceof Connection)) {
            errCode = 259;
        } else if (!(proxiedStatement instanceof Statement)) {
            errCode = 265;
        } else {
            this.m_proxiedStatement = (Statement)proxiedStatement;
            this.m_proxyConnection = (Connection)proxyConnection;
            this.m_jdbcConnectionPool = jdbcConnectionPool;
            this.m_jdbcPooledConnection = jdbcPooledConnection;
            this.isReplayable = this.m_proxyConnection instanceof ReplayableConnection;
            try {
                this.m_proxiedStatement.setQueryTimeout(this.m_jdbcConnectionPool.getQueryTimeout());
            }
            catch (SQLException e) {
                throw UCPErrorHandler.newUniversalConnectionPoolException(274, e);
            }
            return;
        }
        throw UCPErrorHandler.newUniversalConnectionPoolException(errCode);
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        this.m_jdbcPooledConnection.heartbeat();
        SwitchTable invokeSwitch = m_invokeSwitchTable.get(method.getName());
        if (null == invokeSwitch) {
            invokeSwitch = SwitchTable._ABSENT;
        }
        switch (invokeSwitch) {
            case OBJECT_EQUALS: {
                return new Boolean(proxy == args[0]);
            }
            case OBJECT_HASHCODE: {
                return new Integer(System.identityHashCode(proxy));
            }
            case OBJECT_TOSTRING: {
                return proxy.getClass().getName() + "@" + Integer.toHexString(proxy.hashCode());
            }
            case WRAPPER_UNWRAP: {
                return method.invoke((Object)this.m_proxiedStatement, args);
            }
        }
        if (!this.m_closed && SwitchTable.GETCONNECTION == invokeSwitch) {
            return this.m_proxyConnection;
        }
        UniversalPooledConnectionStatus status = this.m_jdbcPooledConnection.getStatus();
        Object result = null;
        try {
            if (Clock.isBefore(this.creationTS, this.m_jdbcPooledConnection.getAvailableStartTime()) || Clock.isBefore(this.creationTS, this.m_jdbcPooledConnection.getBorrowedStartTime())) {
                this.m_closed = true;
                this.m_proxyConnection.close();
            }
            if (SwitchTable.SETQUERYTIMEOUT == invokeSwitch) {
                assert (1 == args.length);
                assert (args[0] instanceof Integer);
                this.m_sqlWithQueryTimeoutInProgress = (Integer)args[0] > 0;
            } else if (SwitchTable.CLOSE == invokeSwitch) {
                if (this.m_closed) {
                    Object var7_7 = null;
                    return var7_7;
                }
                this.m_closed = true;
            } else if (SwitchTable.ISCLOSED == invokeSwitch) {
                if (this.m_closed || this.m_proxyConnection.isClosed()) {
                    Boolean bl = true;
                    return bl;
                }
                if (!this.m_closed_on_completion) {
                    Boolean bl = false;
                    return bl;
                }
            } else if (SwitchTable.CLOSEONCOMPLETION == invokeSwitch) {
                this.m_closed_on_completion = true;
            } else {
                if (SwitchTable.ISLOGICALLYCLOSED == invokeSwitch) {
                    Object object = method.invoke((Object)this, args);
                    return object;
                }
                if (this.m_closed) {
                    throw UCPErrorHandler.newSQLException(44);
                }
                if (((LogicalObject)((Object)this.m_proxyConnection)).isLogicallyClosed()) {
                    throw UCPErrorHandler.newSQLException(31);
                }
            }
            this.m_jdbcPooledConnection.setSqlWithQueryTimeoutInProgress(this.m_sqlWithQueryTimeoutInProgress);
            result = method.invoke((Object)this.m_proxiedStatement, args);
        }
        catch (InvocationTargetException e) {
            int errNo;
            Throwable t = e.getCause();
            if (t instanceof SQLRecoverableException) {
                this.m_jdbcPooledConnection.setStatus(UniversalPooledConnectionStatus.STATUS_BAD);
                this.m_jdbcConnectionPool.returnConnection(this.m_jdbcPooledConnection);
            }
            if (t instanceof SQLException && (errNo = ((SQLException)t).getErrorCode()) == 45582) {
                this.m_jdbcPooledConnection.getDelegator().invalidateChunkInfo();
            }
            throw t;
        }
        finally {
            this.m_jdbcPooledConnection.setSqlWithQueryTimeoutInProgress(false);
            this.m_jdbcPooledConnection.heartbeat();
        }
        this.m_jdbcPooledConnection.heartbeat();
        if (SwitchTable._REST == invokeSwitch) {
            return ResultSetProxyFactory.createResultSetProxy(result, proxy, this.m_jdbcConnectionPool, this.m_jdbcPooledConnection);
        }
        return result;
    }

    @Override
    public boolean isLogicallyClosed() {
        return this.m_closed;
    }

    protected static Class[] createInterfaces(Object object) {
        Class<?> objectClass = object.getClass();
        Class[] interfaces = m_mapInterfaces.get(objectClass);
        if (null != interfaces) {
            return interfaces;
        }
        HashSet<Class<LogicalObject>> interfacesSet = new HashSet<Class<LogicalObject>>();
        StatementProxyFactory.addInterfaces(interfacesSet, object.getClass());
        interfacesSet.add(LogicalObject.class);
        interfaces = interfacesSet.toArray(new Class[0]);
        m_mapInterfaces.put(objectClass, interfaces);
        return interfaces;
    }

    protected static void addInterfaces(HashSet interfaces, Class type) {
        if (type == null) {
            return;
        }
        Class<?>[] proxyInterfaces = type.getInterfaces();
        for (int i = 0; i < proxyInterfaces.length; ++i) {
            Class<?> proxyInterface = proxyInterfaces[i];
            if (!Modifier.isPublic(proxyInterface.getModifiers())) continue;
            interfaces.add(proxyInterface);
        }
        StatementProxyFactory.addInterfaces(interfaces, type.getSuperclass());
    }

    private void setStatementPooling(Object statementObj, boolean poolable) {
        if (statementObj != null) {
            try {
                Statement.class.getMethod("setPoolable", Boolean.TYPE).invoke(statementObj, poolable);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    static {
        m_invokeSwitchTable.put("close", SwitchTable.CLOSE);
        m_invokeSwitchTable.put("isClosed", SwitchTable.ISCLOSED);
        m_invokeSwitchTable.put("getConnection", SwitchTable.GETCONNECTION);
        m_invokeSwitchTable.put("executeQuery", SwitchTable._REST);
        m_invokeSwitchTable.put("getResultSet", SwitchTable._REST);
        m_invokeSwitchTable.put("getGeneratedKeys", SwitchTable._REST);
        m_invokeSwitchTable.put("isLogicallyClosed", SwitchTable.ISLOGICALLYCLOSED);
        m_invokeSwitchTable.put("equals", SwitchTable.OBJECT_EQUALS);
        m_invokeSwitchTable.put("hashCode", SwitchTable.OBJECT_HASHCODE);
        m_invokeSwitchTable.put("toString", SwitchTable.OBJECT_TOSTRING);
        m_invokeSwitchTable.put("setQueryTimeout", SwitchTable.SETQUERYTIMEOUT);
        m_invokeSwitchTable.put("closeOnCompletion", SwitchTable.CLOSEONCOMPLETION);
        m_invokeSwitchTable.put("unwrap", SwitchTable.WRAPPER_UNWRAP);
        m_mapInterfaces = new HashMap<Class, Class[]>();
    }

    private static final class SwitchTable
    extends Enum<SwitchTable> {
        public static final /* enum */ SwitchTable CLOSE;
        public static final /* enum */ SwitchTable GETCONNECTION;
        public static final /* enum */ SwitchTable _REST;
        public static final /* enum */ SwitchTable _ABSENT;
        public static final /* enum */ SwitchTable ISCLOSED;
        public static final /* enum */ SwitchTable ISLOGICALLYCLOSED;
        public static final /* enum */ SwitchTable OBJECT_EQUALS;
        public static final /* enum */ SwitchTable OBJECT_HASHCODE;
        public static final /* enum */ SwitchTable OBJECT_TOSTRING;
        public static final /* enum */ SwitchTable SETQUERYTIMEOUT;
        public static final /* enum */ SwitchTable CLOSEONCOMPLETION;
        public static final /* enum */ SwitchTable WRAPPER_UNWRAP;
        private static final /* synthetic */ SwitchTable[] $VALUES;
        private static Executable $$$methodRef$$$0;
        private static Logger $$$loggerRef$$$0;
        private static Executable $$$methodRef$$$1;
        private static Logger $$$loggerRef$$$1;
        private static Executable $$$methodRef$$$2;
        private static Logger $$$loggerRef$$$2;

        public static SwitchTable[] values() {
            return (SwitchTable[])$VALUES.clone();
        }

        public static SwitchTable valueOf(String name) {
            return Enum.valueOf(SwitchTable.class, name);
        }

        static {
            try {
                $$$methodRef$$$2 = SwitchTable.class.getDeclaredConstructor(String.class, Integer.TYPE);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            try {
                $$$methodRef$$$1 = SwitchTable.class.getDeclaredMethod("valueOf", String.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            try {
                $$$methodRef$$$0 = SwitchTable.class.getDeclaredMethod("values", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            CLOSE = new SwitchTable();
            GETCONNECTION = new SwitchTable();
            _REST = new SwitchTable();
            _ABSENT = new SwitchTable();
            ISCLOSED = new SwitchTable();
            ISLOGICALLYCLOSED = new SwitchTable();
            OBJECT_EQUALS = new SwitchTable();
            OBJECT_HASHCODE = new SwitchTable();
            OBJECT_TOSTRING = new SwitchTable();
            SETQUERYTIMEOUT = new SwitchTable();
            CLOSEONCOMPLETION = new SwitchTable();
            WRAPPER_UNWRAP = new SwitchTable();
            $VALUES = new SwitchTable[]{CLOSE, GETCONNECTION, _REST, _ABSENT, ISCLOSED, ISLOGICALLYCLOSED, OBJECT_EQUALS, OBJECT_HASHCODE, OBJECT_TOSTRING, SETQUERYTIMEOUT, CLOSEONCOMPLETION, WRAPPER_UNWRAP};
        }
    }
}

