/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.resolver;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Stack;
import java.util.Vector;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.net.ssl.SSLContext;
import oracle.jdbc.OracleHostnameResolver;
import oracle.jdbc.TraceEventListener;
import oracle.jdbc.diagnostics.Diagnosable;
import oracle.jdbc.diagnostics.SecurityLabel;
import oracle.jdbc.driver.DMSFactory;
import oracle.jdbc.driver.resource.DriverResources;
import oracle.jdbc.internal.CompletionStageUtil;
import oracle.jdbc.logging.annotations.Blind;
import oracle.jdbc.logging.annotations.PropertiesBlinder;
import oracle.net.jdbc.TNSAddress.SOException;
import oracle.net.jdbc.nl.NLException;
import oracle.net.jdbc.nl.NVFactory;
import oracle.net.jdbc.nl.NVNavigator;
import oracle.net.jdbc.nl.NVPair;
import oracle.net.jndi.JndiAttrs;
import oracle.net.ns.NetException;
import oracle.net.nt.AsyncOutboundTimeoutHandler;
import oracle.net.nt.ConnOption;
import oracle.net.nt.ConnStrategy;
import oracle.net.nt.ConnectDescription;
import oracle.net.resolver.EZConnectResolver;
import oracle.net.resolver.InetAddressResolver;
import oracle.net.resolver.NameResolver;
import oracle.net.resolver.NameResolverFactory;
import oracle.net.resolver.NavDescriptionList;
import oracle.net.resolver.NavSchemaObjectFactory;
import oracle.net.resolver.NavServiceAlias;

public class AddrResolution
implements Diagnosable {
    private static final String CLASS_NAME = AddrResolution.class.getName();
    static final String ADDRESS_FORMAT = "(ADDRESS=(PROTOCOL=%s)(HOST=%s)(PORT=%s))";
    static final String CID_FORMAT = "(CID=(PROGRAM=%s)(HOST=%s)(USER=%s))";
    static final String CONNECT_DATA_FORMAT = "(CONNECT_DATA=%s%s%s)";
    static final String DESCRIPTION_FORMAT = "(DESCRIPTION=%s%s)";
    static final String SERVERMODE_FORMAT = "(SERVER=%s)";
    static final String EMPTY_STRING = "";
    static final String SID_KEY = "(SID=%s)";
    static final String SERVICE_NAME_KEY = "(SERVICE_NAME=%s)";
    private ConnStrategy connStrategy = null;
    private Stack<ConnStrategy> connStrategyStack = new Stack();
    private static final int MAX_CONNECTION_STRATEGY_COUNT = 20;
    private Properties up;
    private static final String default_proxy_rules = "__jdbc__";
    private static final String service_alias_name = "ora-net-service-alias";
    private static final String service_attr_name = "orclnetdescstring";
    private static final int length_of_alias_prefix = 6;
    public static final int DEFAULT_DATABASE_PORT = 1521;
    public static final String DEFAULT_CONNECT_PROTOCOL = "TCP";
    static final List<String> SERVER_MODES = Arrays.asList("SHARED", "DEDICATED", "POOLED");
    private boolean newSyntax = true;
    public boolean connection_revised = false;
    public boolean connection_redirected = false;
    private String TNSAddress;
    private final SSLContext sslContext;
    private final OracleHostnameResolver hostnameResolver;
    private final Diagnosable diagnosable;
    private final TraceEventListener traceEventListener;
    private final List<ConnectDescription> resolvedDescriptions;
    private ConnectDescription connectedDescription;
    private static final Pattern HOST_INFO_PATTERN = Pattern.compile("(?<hostnames>([A-z0-9][A-z0-9._-]+,?)+)(:(?<port>\\d+))?");
    private static final Pattern EZ_URL_PATTERN = Pattern.compile("(.*)@(//)?(?<hostinfo>(" + HOST_INFO_PATTERN.pattern() + ")+)(/(?<servicename>[A-z][A-z0-9,-.]+))?(:(?<servermode>dedicated|shared|pooled))?(/(?<instance>[A-z][A-z0-9]+))?", 2);
    private static final Pattern TNS_NAME_URL_PATTERN = Pattern.compile("(.*)@(?<tnsalias>[A-z][A-z0-9,-.]+)");
    private DriverResources driverResources;
    private static final Pattern pattern = Pattern.compile("(?=ldaps?://)");

    public AddrResolution(String TNSdesc, @Blind(value=PropertiesBlinder.class) Properties _up) throws NetException {
        this(TNSdesc, _up, null, null, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AddrResolution(String TNSdesc, @Blind(value=PropertiesBlinder.class) Properties _up, SSLContext sslContext, OracleHostnameResolver hostnameResolver, Diagnosable diagnosable, TraceEventListener traceEventListener) throws NetException {
        String prop;
        this.up = _up;
        this.TNSAddress = TNSdesc;
        this.diagnosable = diagnosable;
        if (TNSdesc.startsWith("ldap:") || TNSdesc.startsWith("ldaps:")) {
            boolean isLdapUrlList = false;
            Vector<String> ldapUrlList = null;
            ldapUrlList = this.computeLdapList(TNSdesc);
            if (ldapUrlList.size() > 1) {
                isLdapUrlList = true;
            } else {
                int pos = TNSdesc.lastIndexOf(47);
                if (pos == -1) {
                    throw new NetException(17874);
                }
                this.up.put("java.naming.provider.url", TNSdesc.substring(0, pos));
                this.TNSAddress = TNSdesc.substring(pos + 1, TNSdesc.length());
            }
            if (!isLdapUrlList) {
                String[] attrname = new String[1];
                JndiAttrs ja = new JndiAttrs(this.up);
                attrname[0] = service_attr_name;
                Vector _service = null;
                try {
                    _service = ja.getAttrs(this.TNSAddress, attrname);
                    this.TNSAddress = (String)_service.firstElement();
                    this.connection_revised = true;
                }
                catch (NetException netException) {
                }
                finally {
                    try {
                        ja.close();
                    }
                    catch (NetException netException) {}
                }
            } else {
                this.processLdapFailoverLoadblance(ldapUrlList);
            }
        }
        if ((prop = this.up.getProperty("oracle.net.oldSyntax")) != null && (prop.equalsIgnoreCase("ON") || prop.equalsIgnoreCase("TRUE") || prop.equalsIgnoreCase("YES"))) {
            this.newSyntax = false;
        }
        this.sslContext = sslContext;
        this.hostnameResolver = hostnameResolver;
        this.traceEventListener = traceEventListener;
        this.initConnStrategy(this.connection_revised ? this.getTNSAddressInUpperCase() : this.TNSAddress);
        this.resolvedDescriptions = Collections.unmodifiableList(new ArrayList<ConnectDescription>(this.connStrategy.getAllDescriptions()));
    }

    private Vector<String> computeLdapList(String tnsDesc) {
        String[] ldapUrlS = pattern.split(tnsDesc);
        int nonEmptyLdapUrlsCount = 0;
        for (int i = 0; i < ldapUrlS.length; ++i) {
            ldapUrlS[i] = ldapUrlS[i].trim();
            if (ldapUrlS[i].length() == 0) continue;
            ++nonEmptyLdapUrlsCount;
        }
        Vector<String> ret = new Vector<String>(nonEmptyLdapUrlsCount);
        for (int i = 0; i < ldapUrlS.length; ++i) {
            if (ldapUrlS[i].length() == 0) continue;
            ret.add(ldapUrlS[i]);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processLdapFailoverLoadblance(Vector<String> urlList) throws NetException {
        boolean urlStart = false;
        if (urlList.size() <= 1) {
            throw new NetException(17874);
        }
        boolean ldapFailover = true;
        boolean ldapLoadbalance = true;
        String prop = this.up.getProperty("oracle.net.ldap_failover");
        if (prop != null && (prop.equalsIgnoreCase("OFF") || prop.equalsIgnoreCase("FALSE") || prop.equalsIgnoreCase("NO"))) {
            ldapFailover = false;
        }
        if ((prop = this.up.getProperty("oracle.net.ldap_loadbalance")) != null && (prop.equalsIgnoreCase("OFF") || prop.equalsIgnoreCase("FALSE") || prop.equalsIgnoreCase("NO"))) {
            ldapLoadbalance = false;
        }
        if (urlList.size() > 1) {
            urlList = NavDescriptionList.setActiveChildren(urlList, ldapFailover, ldapLoadbalance);
        }
        StringBuilder sbJndiUrlList = new StringBuilder();
        int listSize = urlList.size();
        Hashtable<String, String> tabMapUrlToTns = new Hashtable<String, String>(listSize);
        for (int i = 0; i < listSize; ++i) {
            String url = (String)urlList.elementAt(i);
            int pos = url.lastIndexOf(47);
            if (pos == -1) {
                throw new NetException(17874);
            }
            String jndiUrl = url.substring(0, pos);
            String tnsAddr = url.substring(pos + 1, url.length());
            sbJndiUrlList.append(jndiUrl);
            if (i < listSize - 1) {
                sbJndiUrlList.append(' ');
            }
            tabMapUrlToTns.put(jndiUrl.substring(jndiUrl.indexOf(47)), tnsAddr);
        }
        String jndiUrlList = new String(sbJndiUrlList);
        this.up.put("java.naming.provider.url", jndiUrlList);
        JndiAttrs ja = new JndiAttrs(this.up);
        String ldapUlrConnected = ja.getLdapUrlUsed();
        this.TNSAddress = (String)tabMapUrlToTns.get(ldapUlrConnected.substring(ldapUlrConnected.indexOf(47)));
        Vector serviceList = null;
        String[] attrNames = new String[]{service_attr_name};
        try {
            serviceList = ja.getAttrs(this.TNSAddress, attrNames);
        }
        finally {
            ja.close();
        }
        this.TNSAddress = (String)serviceList.firstElement();
        this.connection_revised = true;
    }

    public String getTNSAddressInUpperCase() {
        return this.TNSAddress.toUpperCase();
    }

    public String getTNSAddress() {
        return this.TNSAddress;
    }

    private void initConnStrategy(String TNSdesc) throws NetException {
        ConnStrategy orig_cs = this.connStrategy;
        this.connStrategy = new ConnStrategy(this.up, this.sslContext, this.hostnameResolver, this.diagnosable, this.traceEventListener);
        this.connStrategy.setDriverResources(this.driverResources);
        if (this.connection_redirected) {
            this.configureConnStrategyAfterRedirect(orig_cs);
        }
        if (orig_cs != null) {
            this.connStrategyStack.push(orig_cs);
            this.debug(Level.INFO, SecurityLabel.UNKNOWN, CLASS_NAME, "initConnStrategy", "Connection strategy {0} stored in stack, conn strategy updated to new conn strategy: {1}", (String)null, null, (Object)orig_cs.toString(), (Object)this.connStrategy.toString());
        }
        this.resolveTNSAddress(TNSdesc);
    }

    public ConnOption resolveAndExecute(String TNSdesc, DMSFactory.DMSNoun dmsParent) throws NetException, IOException, InterruptedIOException {
        return this.resolveAndExecute(TNSdesc, false, dmsParent);
    }

    public ConnOption resolveAndExecute(String descriptor, boolean startNewOCTOInterruptTask, DMSFactory.DMSNoun dmsParent) throws NetException, IOException, InterruptedIOException {
        if (descriptor != null && this.connStrategyStack.size() < 20) {
            this.initConnStrategy(descriptor);
        } else if (this.connStrategy == null) {
            return null;
        }
        ConnOption cOption = null;
        do {
            try {
                cOption = null;
                cOption = this.connStrategy.execute(startNewOCTOInterruptTask, dmsParent);
                this.updateConnectedDescription();
            }
            catch (NetException e) {
                if (this.connection_redirected && !this.connStrategyStack.empty()) {
                    this.debug(Level.INFO, SecurityLabel.UNKNOWN, CLASS_NAME, "resolveAndExecute", "Connection establishment with conn strategy: {0} failed, trying previous conn strategy from stack", (String)null, e, (Object)this.connStrategy.toString());
                    this.connStrategy = this.connStrategyStack.pop();
                    continue;
                }
                throw e;
            }
        } while (cOption == null);
        return cOption;
    }

    public final CompletionStage<ConnOption> resolveAndExecuteAsync(String TNSdesc, boolean startNewOCTOInterruptTask, DMSFactory.DMSNoun dmsParent, AsyncOutboundTimeoutHandler outboundTimeoutHandler, Executor asyncExecutor) {
        if (TNSdesc != null && this.connStrategyStack.size() < 20) {
            try {
                this.initConnStrategy(TNSdesc);
            }
            catch (NetException resolutionFailure) {
                return CompletionStageUtil.failedStage(resolutionFailure);
            }
        } else if (this.connStrategy == null) {
            return CompletionStageUtil.completedStage(null);
        }
        return this.executeStackAsync(startNewOCTOInterruptTask, dmsParent, outboundTimeoutHandler, asyncExecutor);
    }

    private final CompletionStage<ConnOption> executeStackAsync(boolean startNewOCTOInterruptTask, DMSFactory.DMSNoun dmsParent, AsyncOutboundTimeoutHandler outboundTimeoutHandler, Executor asyncExecutor) {
        return this.connStrategy.executeAsync(startNewOCTOInterruptTask, dmsParent, outboundTimeoutHandler, asyncExecutor).handle((cOption, throwable) -> {
            if ((throwable = CompletionStageUtil.unwrapCompletionException(throwable)) instanceof NetException && this.connection_redirected && !this.connStrategyStack.isEmpty()) {
                this.debug(Level.INFO, SecurityLabel.UNKNOWN, CLASS_NAME, "executeStackAsync", "Connection establishment with conn strategy: {0} failed, trying previous conn strategy from stack", (String)null, throwable, (Object)this.connStrategy.toString());
                this.connStrategy = this.connStrategyStack.pop();
                return this.executeStackAsync(startNewOCTOInterruptTask, dmsParent, outboundTimeoutHandler, asyncExecutor);
            }
            if (throwable != null) {
                return CompletionStageUtil.failedStage(throwable);
            }
            this.updateConnectedDescription();
            return CompletionStageUtil.completedStage(cOption);
        }).thenCompose(Function.identity());
    }

    private void updateConnectedDescription() {
        if (!this.connection_redirected) {
            this.connectedDescription = this.connStrategy.getConnectedDescription();
        }
    }

    private final void configureConnStrategyAfterRedirect(ConnStrategy redirectedConnStrategy) {
        this.connStrategy.sdu = redirectedConnStrategy.sdu;
        this.connStrategy.tdu = redirectedConnStrategy.tdu;
        this.connStrategy.retryCount = redirectedConnStrategy.retryCount;
        this.connStrategy.socketOptions = redirectedConnStrategy.socketOptions;
        this.connStrategy.reuseOpt = true;
    }

    private final void resolveTNSAddress(String TNSdesc) throws NetException {
        if ((TNSdesc = TNSdesc.trim()).indexOf(41) == -1 || TNSdesc.indexOf(40) != 0) {
            this.diagnosable.debug(Level.FINEST, SecurityLabel.UNKNOWN, this.getClass().getName(), "resolveTNSAddress", "TNSdesc = {0}", (String)null, null, (Object)TNSdesc);
            if (TNSdesc.startsWith("//") || TNSdesc.matches("[\\w[.+*?!/;%@a~#'$&:|^()<>\\-\\\\\\\"]]*") && !TNSdesc.matches("[[\\w-]\\.]*:[\\d]*:[+]?+[[\\w\\$\\#-]\\.]*(?i)(:[\\w]*)?(?-i)") || TNSdesc.matches("[\\[[\\w:]*\\]]") || TNSdesc.matches("[[\\w-]\\.]*:[\\d]*/[[\\w\\$\\#]\\.]*(?i)(:[\\w]*)?(?-i)")) {
                this.diagnosable.debug(Level.FINEST, SecurityLabel.UNKNOWN, this.getClass().getName(), "resolveTNSAddress", "resolveName() ...", null, null);
                String tnsAdmin = this.up.getProperty("oracle.net.tns_admin");
                NameResolver nr = NameResolverFactory.getNameResolver(tnsAdmin, this.connStrategy.getOSUsername(), this.connStrategy.getProgramName());
                TNSdesc = TNSdesc.replaceAll("#", "\\\\#");
                TNSdesc = TNSdesc.replaceAll("\\(", "\\\\(");
                TNSdesc = TNSdesc.replaceAll("\\)", "\\\\)");
                this.TNSAddress = nr.resolveName(TNSdesc);
                if (this.TNSAddress.indexOf(41) == -1 || this.TNSAddress.indexOf(40) != 0) {
                    EZConnectResolver resolver = EZConnectResolver.newInstance(this.TNSAddress);
                    this.TNSAddress = resolver.getResolvedUrl();
                }
            } else {
                this.diagnosable.debug(Level.FINEST, SecurityLabel.UNKNOWN, this.getClass().getName(), "resolveTNSAddress", "calling resolveSimple() ", null, null);
                this.TNSAddress = this.resolveSimple(TNSdesc);
            }
            this.TNSAddress = this.addConnectionProperties(this.TNSAddress);
            this.diagnosable.debug(Level.FINEST, SecurityLabel.UNKNOWN, this.getClass().getName(), "resolveTNSAddress", "TNSAddress = {0}", (String)null, null, (Object)this.TNSAddress);
            this.resolveAddrTree(this.TNSAddress);
        } else {
            TNSdesc = this.addConnectionProperties(TNSdesc);
            this.resolveAddrTree(TNSdesc);
        }
    }

    private String addConnectionProperties(String TNSdesc) {
        String isAllowReadOnly;
        String newTNSdesc = TNSdesc;
        if (this.up.containsKey("oracle.jdbc.targetInstanceName")) {
            newTNSdesc = this.appendInstanceName(TNSdesc, this.up.getProperty("oracle.jdbc.targetInstanceName"));
        }
        if (this.up.containsKey("oracle.jdbc.targetServiceName")) {
            newTNSdesc = AddrResolution.replaceServiceName(newTNSdesc, this.up.getProperty("oracle.jdbc.targetServiceName"));
        }
        if (this.up.containsKey("oracle.jdbc.targetShardingKey")) {
            String superShardingKey = null;
            if (this.up.containsKey("oracle.jdbc.targetSuperShardingKey")) {
                superShardingKey = this.up.getProperty("oracle.jdbc.targetSuperShardingKey");
            }
            newTNSdesc = this.appendShardKeys(newTNSdesc, this.up.getProperty("oracle.jdbc.targetShardingKey"), superShardingKey);
        }
        if (this.up.containsKey("oracle.jdbc.readOnlyInstanceAllowed") && "true".equalsIgnoreCase(isAllowReadOnly = this.up.getProperty("oracle.jdbc.readOnlyInstanceAllowed"))) {
            newTNSdesc = this.appendReadOnly(newTNSdesc);
        }
        return newTNSdesc;
    }

    private String resolveSimple(String TNSdesc) throws NetException {
        ConnOption co = new ConnOption();
        int fColon = 0;
        int sColon = 0;
        boolean tColon = false;
        int eColon = 0;
        int initialIndex = 0;
        boolean isIPV6Literal = false;
        boolean isServerModePresent = false;
        String serverMode = EMPTY_STRING;
        if (TNSdesc.startsWith("[")) {
            initialIndex = TNSdesc.indexOf(93);
            if (initialIndex == -1) {
                throw new NetException(17865);
            }
            isIPV6Literal = true;
        }
        if ((fColon = TNSdesc.indexOf(58, initialIndex)) == -1 || (sColon = TNSdesc.indexOf(58, fColon + 1)) == -1) {
            throw new NetException(17865);
        }
        eColon = TNSdesc.indexOf(58, sColon + 1);
        if (eColon != -1 && TNSdesc.length() > eColon + 6) {
            serverMode = TNSdesc.substring(eColon + 1);
            isServerModePresent = SERVER_MODES.contains(serverMode.toUpperCase());
            if (isServerModePresent) {
                co.sid = TNSdesc.substring(sColon + 1, eColon);
                eColon = TNSdesc.indexOf(58, eColon + 1);
            } else {
                co.sid = TNSdesc.substring(sColon + 1);
            }
        } else {
            co.sid = TNSdesc.substring(sColon + 1);
        }
        if (eColon != -1) {
            throw new NetException(17865);
        }
        try {
            co.host = isIPV6Literal ? TNSdesc.substring(1, fColon - 1) : TNSdesc.substring(0, fColon);
            co.port = Integer.parseInt(TNSdesc.substring(fColon + 1, sColon));
            co.addr = String.format(ADDRESS_FORMAT, DEFAULT_CONNECT_PROTOCOL, co.host, co.port);
            co.conn_data.append(String.format(DESCRIPTION_FORMAT, String.format(CONNECT_DATA_FORMAT, String.format(SID_KEY, co.sid), isServerModePresent ? String.format(SERVERMODE_FORMAT, serverMode) : EMPTY_STRING, String.format(CID_FORMAT, this.connStrategy.getProgramName(), this.connStrategy.getHostname(), this.connStrategy.getOSUsername())), co.addr));
            co.protocol = DEFAULT_CONNECT_PROTOCOL;
            ConnectDescription desc = this.connStrategy.newConnectDescription();
            this.connStrategy.currentDescription().addConnectOption(co);
            this.connStrategy.closeDescription();
            return String.format(DESCRIPTION_FORMAT, String.format(CONNECT_DATA_FORMAT, String.format(SID_KEY, co.sid), isServerModePresent ? String.format(SERVERMODE_FORMAT, serverMode) : EMPTY_STRING, EMPTY_STRING), co.addr);
        }
        catch (NumberFormatException nfe) {
            throw new NetException(17866);
        }
    }

    private void resolveAddrTree(String TNSdesc) throws NetException {
        NavSchemaObjectFactory fac = new NavSchemaObjectFactory();
        NavServiceAlias sa = (NavServiceAlias)fac.create(4);
        try {
            String alias = TNSdesc.startsWith("alias=") ? TNSdesc : "alias=" + TNSdesc;
            sa.initFromString(alias);
        }
        catch (NLException nle) {
            throw new NetException(18951, nle.getMessage());
        }
        catch (SOException soe) {
            throw new NetException(18952, soe.getMessage());
        }
        sa.navigate(this.connStrategy, null);
        boolean throwStashedException = true;
        Throwable stashedException = null;
        for (int i = 0; i < this.connStrategy.getAllDescriptions().size(); ++i) {
            ConnectDescription desc = this.connStrategy.getAllDescriptions().get(i);
            try {
                this.resolveConnOptions(desc.getConnectOptions());
                throwStashedException = false;
                continue;
            }
            catch (NetException e) {
                this.debug(Level.FINEST, SecurityLabel.INTERNAL, this.getClass().getName(), "resolveAddrTree", "Failed to create conn options for DESCRIPTION = {0}", (String)null, null, (Object)desc.toString());
                stashedException = e;
            }
        }
        if (throwStashedException && stashedException != null) {
            throw (NetException)stashedException.fillInStackTrace();
        }
    }

    private void resolveConnOptions(ArrayList<ConnOption> cOpts) throws NetException {
        int i;
        NetException stashedException = null;
        int initialSize = cOpts.size();
        for (i = 0; i < initialSize; ++i) {
            try {
                Iterator<InetSocketAddress> resolvedSocketAddresses = InetAddressResolver.resolveInetSocketAddresses(cOpts.get((int)i).host, cOpts.get((int)i).port, this.hostnameResolver, this.connStrategy.socketOptions, cOpts.get((int)i).protocol, cOpts.get((int)i).addr, cOpts.get((int)i).httpsProxy);
                while (resolvedSocketAddresses.hasNext()) {
                    ConnOption connOption = cOpts.get(i).clone();
                    connOption.host = connOption.host == null ? InetAddress.getLoopbackAddress().getHostName() : connOption.host;
                    connOption.inetSocketAddress = resolvedSocketAddresses.next();
                    connOption.formatConnectData();
                    this.debug(Level.FINEST, SecurityLabel.INTERNAL, this.getClass().getName(), "resolveConnOptions", "Connect data after formatting: {0}", (String)null, null, (Object)connOption.conn_data);
                    if (connOption.protocol.equalsIgnoreCase("beq")) {
                        this.debug(Level.FINEST, SecurityLabel.INTERNAL, this.getClass().getName(), "resolveConnOptions", "New conn option created with bequeath protocol", null, null);
                    } else if (connOption.inetSocketAddress.getAddress() != null) {
                        this.debug(Level.FINEST, SecurityLabel.INTERNAL, this.getClass().getName(), "resolveConnOptions", "New conn option created using IP={0} from host={1} after hostname resolution", (String)null, null, (Object)connOption.inetSocketAddress.getAddress().getHostAddress(), (Object)connOption.host);
                    } else {
                        this.debug(Level.FINEST, SecurityLabel.INTERNAL, this.getClass().getName(), "resolveConnOptions", "New conn option created with host={0}", (String)null, null, (Object)connOption.host);
                    }
                    cOpts.add(connOption);
                }
                continue;
            }
            catch (UnknownHostException e) {
                stashedException = new NetException(17868, e.getMessage());
                this.debug(Level.FINEST, SecurityLabel.INTERNAL, this.getClass().getName(), "resolveConnOptions", "Hostname resolution for ADDRESS with host={0} failed with error={1}", (String)null, null, (Object)cOpts.get((int)i).host, (Object)e);
                continue;
            }
            catch (NetException e) {
                stashedException = e;
                this.debug(Level.FINEST, SecurityLabel.INTERNAL, this.getClass().getName(), "resolveConnOptions", "Hostname resolution for ADDRESS with host={0} failed with error={1}", (String)null, null, (Object)cOpts.get((int)i).host, (Object)e);
            }
        }
        if (cOpts.size() == initialSize && stashedException != null) {
            throw stashedException;
        }
        for (i = 0; i < initialSize; ++i) {
            cOpts.remove(0);
        }
    }

    private StringBuilder insertCID(String TNSaddr) throws NetException {
        NVFactory nvf = new NVFactory();
        NVNavigator nvn = new NVNavigator();
        StringBuilder tns = new StringBuilder(2048);
        NVPair desc = null;
        NVPair addrl = null;
        NVPair addr = null;
        NVPair cdata = null;
        NVPair sroute = null;
        try {
            desc = nvn.findNVPairRecurse(nvf.createNVPair(TNSaddr), "description");
            addrl = nvn.findNVPairRecurse(nvf.createNVPair(TNSaddr), "address_list");
            addr = nvn.findNVPairRecurse(nvf.createNVPair(TNSaddr), "address");
            cdata = nvn.findNVPairRecurse(nvf.createNVPair(TNSaddr), "connect_data");
            sroute = nvn.findNVPairRecurse(nvf.createNVPair(TNSaddr), "source_route");
        }
        catch (NLException exp) {
            NetException ne = new NetException(17851);
            ne.initCause(exp);
            throw ne;
        }
        NVPair sid = null;
        NVPair cid = null;
        NVPair sn = null;
        NVPair server = null;
        if (cdata == null) {
            throw new NetException(17855);
        }
        sid = nvn.findNVPair(cdata, "SID");
        cid = nvn.findNVPair(cdata, "CID");
        sn = nvn.findNVPair(cdata, "SERVICE_NAME");
        server = nvn.findNVPair(cdata, "SERVER");
        if (sid == null && sn == null) {
            throw new NetException(17856);
        }
        tns.append("(DESCRIPTION=");
        if (addrl != null && addrl.getListSize() > 0) {
            for (int i = 0; i < addrl.getListSize(); ++i) {
                NVPair nvp = addrl.getListElement(i);
                tns.append(nvp.toString());
            }
        } else if (addr != null) {
            tns.append(addr.toString());
        } else {
            throw new NetException(17857);
        }
        tns.append(String.format(CONNECT_DATA_FORMAT, (sn != null ? sn : sid).toString(), server != null ? server.toString() : EMPTY_STRING, String.format(CID_FORMAT, this.connStrategy.getProgramName(), this.connStrategy.getHostname(), this.connStrategy.getOSUsername())));
        if (sroute != null) {
            tns.append(sroute.toString());
        }
        tns.append(")");
        return tns;
    }

    @Blind(value=PropertiesBlinder.class)
    public Properties getUp() {
        return this.up;
    }

    @Blind(value=PropertiesBlinder.class)
    public Properties getSocketOptions() {
        return this.connStrategy.socketOptions;
    }

    public boolean isConnectionSocketKeepAlive() throws SocketException {
        return this.connStrategy.isConnectionSocketKeepAlive();
    }

    private String appendInstanceName(String TNSDesc, String instanceName) {
        Pattern pattern = Pattern.compile("CONNECT_DATA[\\s]*=([^)]+)\\)", 2);
        Matcher matcher = pattern.matcher(TNSDesc);
        StringBuffer sb = new StringBuffer();
        boolean result = matcher.find();
        while (result) {
            matcher.appendReplacement(sb, Matcher.quoteReplacement(matcher.group() + "(INSTANCE_NAME=" + instanceName + ")"));
            result = matcher.find();
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    private static String replaceServiceName(String TNSDesc, String newServiceName) {
        Pattern pattern = Pattern.compile("\\([\\s]*SERVICE_NAME[\\s]*=([^)]+)\\)", 2);
        Matcher matcher = pattern.matcher(TNSDesc);
        StringBuffer sb = new StringBuffer();
        boolean result = matcher.find();
        while (result) {
            matcher.appendReplacement(sb, Matcher.quoteReplacement("(SERVICE_NAME=" + newServiceName + ")"));
            result = matcher.find();
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    public static String replaceServiceNameInUrl(String url, String gsmServiceName, String catalogServiceName) {
        if (url.toUpperCase().contains("DESCRIPTION")) {
            return AddrResolution.replaceServiceName(url, catalogServiceName);
        }
        String urlWithoutWhiteSpaces = url.replaceAll("\\s+", EMPTY_STRING);
        Matcher matcher = EZ_URL_PATTERN.matcher(urlWithoutWhiteSpaces);
        if (matcher.find()) {
            StringBuffer sb = new StringBuffer();
            int startIndex = matcher.start("servicename");
            int endIndex = matcher.end("servicename");
            sb.append(url.substring(0, startIndex));
            sb.append(catalogServiceName);
            if (endIndex != -1) {
                sb.append(url.substring(endIndex));
            }
            return sb.toString();
        }
        return url;
    }

    public static String getServiceName(String url) {
        if (url.toUpperCase().contains("DESCRIPTION")) {
            Pattern pattern = Pattern.compile("(.*)\\([\\s]*SERVICE_NAME[\\s]*=([^)]+)\\)", 2);
            Matcher matcher = pattern.matcher(url);
            boolean result = matcher.find();
            return result ? matcher.group(2) : null;
        }
        String urlWithoutWhiteSpaces = url.replaceAll("\\s+", EMPTY_STRING);
        Matcher matcher = EZ_URL_PATTERN.matcher(urlWithoutWhiteSpaces);
        return matcher.matches() ? matcher.group("servicename") : null;
    }

    public static String resolveTNSAlias(String url, @Blind(value=PropertiesBlinder.class) Properties up, String tnsAdmin) {
        String aliasName;
        String urlWithoutWhiteSpaces = url.replaceAll("\\s+", EMPTY_STRING);
        String newUrl = null;
        Matcher matcher = TNS_NAME_URL_PATTERN.matcher(urlWithoutWhiteSpaces);
        if (matcher.matches() && (aliasName = matcher.group("tnsalias")) != null && tnsAdmin != null) {
            try {
                String osuser = up.getProperty("oracle.jdbc.v$session.osuser");
                String programName = up.getProperty("oracle.jdbc.v$session.program");
                NameResolver nr = NameResolverFactory.getNameResolver(tnsAdmin, osuser, programName);
                aliasName = aliasName.trim();
                String aliasVal = nr.resolveName(aliasName);
                int startIndex = matcher.start("tnsalias");
                if (startIndex != -1) {
                    StringBuffer sb = new StringBuffer();
                    sb.append(url.substring(0, startIndex));
                    sb.append(aliasVal);
                    newUrl = sb.toString();
                }
            }
            catch (NetException netException) {
                // empty catch block
            }
        }
        return newUrl;
    }

    private String appendShardKeys(String TNSDesc, String shardingKey, String superShardingKey) {
        Pattern pattern = Pattern.compile("CONNECT_DATA[\\s]*=([^)]+)\\)", 2);
        String shardingKeyStr = (shardingKey != null ? "(SHARDING_KEY_B64=" + shardingKey + ")" : EMPTY_STRING) + (superShardingKey != null ? "(SUPER_SHARDING_KEY_B64=" + superShardingKey + ")" : EMPTY_STRING);
        Matcher matcher = pattern.matcher(TNSDesc);
        StringBuffer sb = new StringBuffer();
        boolean result = matcher.find();
        while (result) {
            matcher.appendReplacement(sb, Matcher.quoteReplacement(matcher.group() + shardingKeyStr));
            result = matcher.find();
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    private String appendReadOnly(String TNSDesc) {
        Pattern pattern = Pattern.compile("CONNECT_DATA[\\s]*=([^)]+)\\)", 2);
        String readonlyTag = "(READONLY_OK=true)";
        Matcher matcher = pattern.matcher(TNSDesc);
        StringBuffer sb = new StringBuffer();
        boolean result = matcher.find();
        while (result) {
            matcher.appendReplacement(sb, Matcher.quoteReplacement(matcher.group() + "(READONLY_OK=true)"));
            result = matcher.find();
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    public ConnStrategy getConnStrategy() {
        return this.connStrategy;
    }

    public boolean isUsingCustomHostnameResolver() {
        return this.connStrategy.isUsingCustomHostnameResolver();
    }

    public void clearConnStrategyStack() {
        this.connStrategyStack.clear();
    }

    @Override
    public Diagnosable getDiagnosable() {
        return this.diagnosable;
    }

    public List<ConnectDescription> getResolvedDescriptions() {
        return this.resolvedDescriptions;
    }

    public ConnectDescription getConnectedDescription() {
        return this.connectedDescription;
    }

    public void setDriverResources(DriverResources driverResources) {
        this.driverResources = driverResources;
        if (this.connStrategy != null) {
            this.connStrategy.setDriverResources(driverResources);
        }
    }
}

