/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.InputStream;
import java.sql.SQLException;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import oracle.jdbc.spi.OracleConfigurationJsonSecretProvider;
import oracle.jdbc.spi.OracleConfigurationProvider;
import oracle.jdbc.util.OracleConfigurationCache;
import oracle.jdbc.util.OracleConfigurationProviderNetworkError;
import oracle.sql.json.OracleJsonFactory;
import oracle.sql.json.OracleJsonObject;
import oracle.sql.json.OracleJsonValue;

public abstract class OracleConfigurationJsonProvider
implements OracleConfigurationProvider {
    private static final OracleJsonFactory JSON_FACTORY = new OracleJsonFactory();
    private static final Map<String, OracleConfigurationJsonSecretProvider> secretProviders = new HashMap<String, OracleConfigurationJsonSecretProvider>();
    private static final String WALLET_LOCATION_JSON_OBJECT_NAME = "wallet_location";
    private static final String CONFIG_TTL_JSON_OBJECT_NAME = "config_time_to_live";
    private final long msTimeout = 60000L;
    private final long msRefreshInterval = 60000L;
    protected static final OracleConfigurationCache CACHE = OracleConfigurationCache.create(100);
    protected Map<String, String> options;

    public abstract InputStream getJson(String var1) throws SQLException;

    @Override
    public Properties getConnectionProperties(String location) throws SQLException {
        Properties cachedProp = CACHE.get(location);
        if (Objects.nonNull(cachedProp)) {
            return cachedProp;
        }
        Properties properties = this.retrieveProperties(location);
        if (properties.containsKey(CONFIG_TTL_JSON_OBJECT_NAME)) {
            long configTimeToLive = Long.parseLong(properties.getProperty(CONFIG_TTL_JSON_OBJECT_NAME));
            properties.remove(CONFIG_TTL_JSON_OBJECT_NAME);
            CACHE.put(location, properties, configTimeToLive, () -> this.refreshProperties(location), 60000L, 60000L);
        } else {
            CACHE.put(location, properties, () -> this.refreshProperties(location), 60000L, 60000L);
        }
        return properties;
    }

    private Properties retrieveProperties(String location) throws SQLException {
        OracleConfigurationJsonSecretProvider provider;
        String secretType;
        String[] params = location.split("\\?");
        location = params[0];
        this.options = params.length > 1 ? OracleConfigurationProvider.mapOptions(params[1]) : Collections.emptyMap();
        OracleJsonObject json = JSON_FACTORY.createJsonTextValue(this.getJson(location)).asJsonObject();
        if (this.options.containsKey("key")) {
            String key2 = this.options.get("key");
            if (!json.containsKey(key2)) {
                throw new IllegalArgumentException(key2 + " key appears in URL but is missing in JSON.");
            }
            json = ((OracleJsonValue)json.get(key2)).asJsonObject();
        }
        Properties properties = new Properties();
        if (json.containsKey("user")) {
            properties.setProperty("user", json.getString("user"));
        }
        if (!json.containsKey("connect_descriptor")) {
            throw new SQLException("'connect_descriptor' attribute missing in JSON.");
        }
        properties.setProperty("URL", "jdbc:oracle:thin:@" + json.getString("connect_descriptor"));
        if (json.containsKey("jdbc")) {
            OracleJsonObject jdbc = ((OracleJsonValue)json.get("jdbc")).asJsonObject();
            jdbc.forEach((key, value) -> {
                if (value.getOracleJsonType().equals((Object)OracleJsonValue.OracleJsonType.STRING)) {
                    properties.setProperty((String)key, value.asJsonString().getString());
                } else {
                    properties.setProperty((String)key, value.toString());
                }
            });
        }
        if (json.containsKey("password")) {
            OracleJsonObject password = ((OracleJsonValue)json.get("password")).asJsonObject();
            secretType = password.getString("type");
            provider = null;
            if (secretProviders.containsKey(secretType)) {
                provider = secretProviders.get(secretType);
            } else {
                provider = OracleConfigurationJsonSecretProvider.find(secretType);
                secretProviders.put(secretType, provider);
            }
            properties.setProperty("password", new String(Base64.getDecoder().decode(new String(provider.getSecret(password)))));
        }
        if (json.containsKey(WALLET_LOCATION_JSON_OBJECT_NAME)) {
            OracleJsonObject wallet = ((OracleJsonValue)json.get(WALLET_LOCATION_JSON_OBJECT_NAME)).asJsonObject();
            secretType = wallet.getString("type");
            provider = null;
            if (secretProviders.containsKey(secretType)) {
                provider = secretProviders.get(secretType);
            } else {
                provider = OracleConfigurationJsonSecretProvider.find(secretType);
                secretProviders.put(secretType, provider);
            }
            properties.setProperty("oracle.net.wallet_location", "data:;base64," + new String(provider.getSecret(wallet)));
        }
        if (json.containsKey(CONFIG_TTL_JSON_OBJECT_NAME)) {
            properties.setProperty(CONFIG_TTL_JSON_OBJECT_NAME, String.valueOf(json.getLong(CONFIG_TTL_JSON_OBJECT_NAME)));
        }
        return properties;
    }

    private Properties refreshProperties(String location) throws OracleConfigurationProviderNetworkError {
        try {
            return this.retrieveProperties(location);
        }
        catch (SQLException e) {
            throw new OracleConfigurationProviderNetworkError(e);
        }
    }

    static {
        secretProviders.put("base64", new OracleConfigurationJsonSecretProvider(){

            @Override
            public String getSecretType() {
                return "base64";
            }

            @Override
            public char[] getSecret(OracleJsonObject secret) {
                return secret.getString("value").toCharArray();
            }
        });
    }
}

