/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver.json.parser;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import oracle.jdbc.driver.json.OracleJsonExceptions;

class UnicodeDetectingInputStream
extends FilterInputStream {
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    private static final Charset UTF_16BE = Charset.forName("UTF-16BE");
    private static final Charset UTF_16LE = Charset.forName("UTF-16LE");
    private static final Charset UTF_32LE = Charset.forName("UTF-32LE");
    private static final Charset UTF_32BE = Charset.forName("UTF-32BE");
    private static final byte FF = -1;
    private static final byte FE = -2;
    private static final byte EF = -17;
    private static final byte BB = -69;
    private static final byte BF = -65;
    private static final byte NUL = 0;
    private final byte[] buf = new byte[4];
    private int bufLen;
    private int curIndex;
    private final Charset charset = this.detectEncoding();

    UnicodeDetectingInputStream(InputStream inputStream) {
        super(inputStream);
    }

    Charset getCharset() {
        return this.charset;
    }

    private OracleJsonExceptions.ExceptionFactory factory() {
        return OracleJsonExceptions.ORACLE_FACTORY;
    }

    private void fillBuf() {
        try {
            int n2 = this.in.read();
            if (n2 == -1) {
                return;
            }
            int n3 = this.in.read();
            if (n3 == -1) {
                this.bufLen = 1;
                this.buf[0] = (byte)n2;
                return;
            }
            int n4 = this.in.read();
            if (n4 == -1) {
                this.bufLen = 2;
                this.buf[0] = (byte)n2;
                this.buf[1] = (byte)n3;
                return;
            }
            int n5 = this.in.read();
            if (n5 == -1) {
                this.bufLen = 3;
                this.buf[0] = (byte)n2;
                this.buf[1] = (byte)n3;
                this.buf[2] = (byte)n4;
                return;
            }
            this.bufLen = 4;
            this.buf[0] = (byte)n2;
            this.buf[1] = (byte)n3;
            this.buf[2] = (byte)n4;
            this.buf[3] = (byte)n5;
        }
        catch (IOException iOException) {
            throw OracleJsonExceptions.IO.create(this.factory(), new Object[0]);
        }
    }

    private Charset detectEncoding() {
        this.fillBuf();
        if (this.bufLen < 2) {
            throw OracleJsonExceptions.PARSER_ENC_DETECT_FAIL.create(this.factory(), new Object[0]);
        }
        if (this.bufLen == 4) {
            if (this.buf[0] == 0 && this.buf[1] == 0 && this.buf[2] == -2 && this.buf[3] == -1) {
                this.curIndex = 4;
                return UTF_32BE;
            }
            if (this.buf[0] == -1 && this.buf[1] == -2 && this.buf[2] == 0 && this.buf[3] == 0) {
                this.curIndex = 4;
                return UTF_32LE;
            }
            if (this.buf[0] == -2 && this.buf[1] == -1) {
                this.curIndex = 2;
                return UTF_16BE;
            }
            if (this.buf[0] == -1 && this.buf[1] == -2) {
                this.curIndex = 2;
                return UTF_16LE;
            }
            if (this.buf[0] == -17 && this.buf[1] == -69 && this.buf[2] == -65) {
                this.curIndex = 3;
                return UTF_8;
            }
            if (this.buf[0] == 0 && this.buf[1] == 0 && this.buf[2] == 0) {
                return UTF_32BE;
            }
            if (this.buf[0] == 0 && this.buf[2] == 0) {
                return UTF_16BE;
            }
            if (this.buf[1] == 0 && this.buf[2] == 0 && this.buf[3] == 0) {
                return UTF_32LE;
            }
            if (this.buf[1] == 0 && this.buf[3] == 0) {
                return UTF_16LE;
            }
        }
        return UTF_8;
    }

    @Override
    public int read() throws IOException {
        if (this.curIndex < this.bufLen) {
            return this.buf[this.curIndex++];
        }
        return this.in.read();
    }

    @Override
    public int read(byte[] byArray, int n2, int n3) throws IOException {
        if (this.curIndex < this.bufLen) {
            if (n3 == 0) {
                return 0;
            }
            if (n2 < 0 || n3 < 0 || n3 > byArray.length - n2) {
                throw new IndexOutOfBoundsException();
            }
            int n4 = Math.min(this.bufLen - this.curIndex, n3);
            System.arraycopy(this.buf, this.curIndex, byArray, n2, n4);
            this.curIndex += n4;
            return n4;
        }
        return this.in.read(byArray, n2, n3);
    }
}

