/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.sql.SQLException;
import oracle.jdbc.NotificationRegistration;
import oracle.jdbc.driver.NTFJMSRegistration;
import oracle.jdbc.driver.NTFRegistration;
import oracle.jdbc.driver.PhysicalConnection;
import oracle.jdbc.driver.T4CConnection;
import oracle.jdbc.driver.T4CMAREngine;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.THIN_INTERNAL})
class T4CTTIkpdnrnf {
    int messageType;
    int errorCode;
    long registrationId;
    byte[] notificationQueue = null;
    byte[] consumerName = null;
    String consumerNameString = null;
    T4CConnection connection = null;
    T4CMAREngine mar;
    static final int STOP_TFN_KPDNRNF = 4;
    static final int CONS_CLOSE_ERR = 24035;
    static final int DEST_CLOSE_ERR = 24010;

    T4CTTIkpdnrnf(T4CConnection t4CConnection) {
        this.mar = t4CConnection.mare;
    }

    public void receive() throws SQLException, IOException {
        int n2;
        Object object;
        Object object2;
        this.messageType = (int)this.mar.unmarshalUB4();
        this.errorCode = (int)this.mar.unmarshalUB4();
        this.registrationId = this.mar.unmarshalUB4();
        if (this.messageType == 4) {
            object2 = PhysicalConnection.ntfManager.getJDBCRegId(this.registrationId);
            object = (NTFJMSRegistration)PhysicalConnection.ntfManager.getRegistration((int)object2);
            ((NTFRegistration)object).setState(NotificationRegistration.RegistrationState.DISABLED);
        }
        if ((object2 = (int)this.mar.unmarshalUB4()) > 0) {
            this.notificationQueue = new byte[object2];
            object = new int[1];
            this.mar.unmarshalCLR(this.notificationQueue, 0, (int[])object, this.notificationQueue.length);
            object2 = object[0];
        }
        if ((n2 = (int)this.mar.unmarshalUB4()) > 0) {
            this.consumerName = new byte[n2];
            int[] nArray = new int[1];
            this.mar.unmarshalCLR(this.consumerName, 0, nArray, this.consumerName.length);
            n2 = nArray[0];
        }
    }

    public String getNotificationQueue() throws SQLException {
        return this.mar.conv.CharBytesToString(this.notificationQueue, this.notificationQueue.length);
    }

    public long getRegistrationId() {
        return this.registrationId;
    }

    public String getConsumerName() throws SQLException {
        if (this.consumerName == null) {
            return null;
        }
        return this.mar.conv.CharBytesToString(this.consumerName, this.consumerName.length);
    }
}

