/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.sql.SQLException;
import oracle.jdbc.OracleResultSetMetaData;
import oracle.jdbc.driver.ByteArray;
import oracle.jdbc.driver.CRC64;
import oracle.jdbc.driver.DynamicByteArray;
import oracle.jdbc.driver.LongRawAccessor;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.T4CAccessor;
import oracle.jdbc.driver.T4CConnection;
import oracle.jdbc.driver.T4CMAREngine;
import oracle.jdbc.driver.T4CMarshaller;
import oracle.jdbc.driver.T4CTTIoer11;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.THIN_INTERNAL})
class T4CLongRawAccessor
extends LongRawAccessor
implements T4CAccessor {
    T4CMAREngine mare;
    byte[][] data = null;
    int[] nbBytesRead = null;
    int[] bytesReadSoFar = null;
    private T4CMarshaller marshaller = null;

    T4CLongRawAccessor(OracleStatement oracleStatement, int n2, int n3, short s2, int n4, T4CMAREngine t4CMAREngine) throws SQLException {
        super(oracleStatement, n2, n3, s2, n4);
        this.mare = t4CMAREngine;
        if (oracleStatement.isFetchStreams) {
            this.data = new byte[oracleStatement.rowPrefetch][];
            for (int i2 = 0; i2 < oracleStatement.rowPrefetch; ++i2) {
                this.data[i2] = new byte[4080];
            }
            this.nbBytesRead = new int[oracleStatement.rowPrefetch];
            this.bytesReadSoFar = new int[oracleStatement.rowPrefetch];
        }
    }

    T4CLongRawAccessor(OracleStatement oracleStatement, int n2, int n3, boolean bl, int n4, int n5, int n6, long l2, int n7, short s2, int n8, int n9, T4CMAREngine t4CMAREngine) throws SQLException {
        super(oracleStatement, n2, n3, bl, n4, n5, n6, l2, n7, s2);
        this.mare = t4CMAREngine;
        if (oracleStatement != null && oracleStatement.implicitDefineForLobPrefetchDone) {
            this.definedColumnType = 0;
            this.definedColumnSize = 0;
        } else {
            this.definedColumnType = n8;
            this.definedColumnSize = n9;
        }
        if (oracleStatement.isFetchStreams) {
            this.data = new byte[oracleStatement.rowPrefetch][];
            for (int i2 = 0; i2 < oracleStatement.rowPrefetch; ++i2) {
                this.data[i2] = new byte[4080];
            }
            this.nbBytesRead = new int[oracleStatement.rowPrefetch];
            this.bytesReadSoFar = new int[oracleStatement.rowPrefetch];
        }
    }

    @Override
    public T4CMAREngine getMAREngine() {
        return this.mare;
    }

    @Override
    public void unmarshalColumnMetadata() throws SQLException, IOException {
        if (this.statement.statementType != 2 && !this.statement.sqlKind.isPlsqlOrCall() && this.securityAttribute == OracleResultSetMetaData.SecurityAttribute.ENABLED) {
            this.setRowMetadata(this.lastRowProcessed, (byte)this.mare.unmarshalUB1());
        }
    }

    @Override
    public void processIndicator(int n2) throws IOException, SQLException {
        if (this.internalType == 1 && this.describeType == 112 || this.internalType == 23 && this.describeType == 113) {
            this.mare.unmarshalSB2();
            this.mare.unmarshalUB2();
        } else if (this.statement.connection.versionNumber < 9200) {
            this.mare.unmarshalSB2();
            if (!this.statement.sqlKind.isPlsqlOrCall()) {
                this.mare.unmarshalSB2();
            }
        } else if (this.statement.sqlKind.isPlsqlOrCall() || this.isDMLReturnedParam) {
            this.mare.processIndicator(n2 <= 0, n2);
        }
    }

    @Override
    int getPreviousRowProcessed() {
        if (this.previousRowProcessed == -1) {
            this.previousRowProcessed = this.statement.rowPrefetchInLastFetch - 1;
        }
        return this.previousRowProcessed;
    }

    @Override
    void reinitForResultSetCache(ByteArray byteArray, OracleStatement oracleStatement) throws SQLException {
        this.rowData = byteArray;
        this.mare = ((T4CConnection)oracleStatement.connection).mare;
        this.rowNull = null;
        this.setCapacity(oracleStatement.getFetchSize());
    }

    @Override
    boolean unmarshalOneRow() throws SQLException, IOException {
        return this.getMarshaller().unmarshalOneRow(this);
    }

    int readStreamFromWire(byte[] byArray, int n2, int n3, int[] nArray, boolean[] blArray, boolean[] blArray2, T4CMAREngine t4CMAREngine, T4CTTIoer11 t4CTTIoer11) throws SQLException, IOException {
        return this.getMarshaller().readStreamFromWire(byArray, n2, n3, nArray, blArray, blArray2, t4CMAREngine, t4CTTIoer11);
    }

    @Override
    void fetchNextColumns() throws SQLException {
        this.statement.continueReadRow(this.columnPosition);
    }

    @Override
    int readStream(byte[] byArray, int n2) throws SQLException, IOException {
        int n3 = this.lastRowProcessed;
        if (this.statement.isFetchStreams) {
            int n4 = this.bytesReadSoFar[n3];
            int n5 = this.getLength(n3);
            if (n4 == n5) {
                return -1;
            }
            int n6 = 0;
            n6 = n2 <= n5 - n4 ? n2 : n5 - n4;
            this.rowData.setPosition(this.getOffset(n3) + (long)n4);
            this.rowData.getBytes(byArray, 0, n6);
            int n7 = n3;
            this.bytesReadSoFar[n7] = this.bytesReadSoFar[n7] + n6;
            return n6;
        }
        int n8 = this.readStreamFromWire(byArray, 0, n2, this.escapeSequenceArr, this.readHeaderArr, this.readAsNonStreamArr, this.mare, ((T4CConnection)this.statement.connection).oer);
        if (this.statement.connection.checksumMode.needToCalculateFetchChecksum() && n8 != -1) {
            long l2;
            this.statement.checkSum = l2 = CRC64.updateChecksum(this.statement.checkSum, byArray, 0, n8);
        }
        return n8;
    }

    @Override
    void copyRow() throws SQLException, IOException {
        if (this.isNullByDescribe || this.previousRowProcessed == -1) {
            this.setNull(this.lastRowProcessed, true);
            this.previousRowProcessed = this.statement.rowPrefetchInLastFetch - 1;
        } else if (this.lastRowProcessed == 0) {
            if (this.previousRowProcessed == -1) {
                this.previousRowProcessed = this.statement.rowPrefetchInLastFetch - 1;
            }
            long l2 = this.getOffset(this.previousRowProcessed);
            this.setNull(this.lastRowProcessed, this.isNull(this.previousRowProcessed));
            this.rowMetadata[this.lastRowProcessed] = this.rowMetadata[this.previousRowProcessed];
            if (!this.isNull(this.previousRowProcessed)) {
                this.setOffset(this.lastRowProcessed);
                ((DynamicByteArray)this.rowData).copyLeft(l2, this.getLength(this.previousRowProcessed));
                this.setLength(this.lastRowProcessed, this.getLength(this.previousRowProcessed));
            }
        } else if (this.lastCopyRow == this.previousRowProcessed) {
            this.setNull(this.lastRowProcessed, this.lastCopyRowIsNull);
            this.rowMetadata[this.lastRowProcessed] = this.lastCopyRowMetaData;
            this.setOffset(this.lastRowProcessed, this.lastCopyRowOffset);
            this.setLength(this.lastRowProcessed, this.lastCopyRowLength);
        } else {
            this.setNull(this.lastRowProcessed, this.isNull(this.previousRowProcessed));
            this.rowMetadata[this.lastRowProcessed] = this.rowMetadata[this.previousRowProcessed];
            this.setOffset(this.lastRowProcessed, this.getOffset(this.previousRowProcessed));
            this.setLength(this.lastRowProcessed, this.getLength(this.previousRowProcessed));
        }
        this.previousRowProcessed = this.lastRowProcessed++;
    }

    private final T4CMarshaller getMarshaller() {
        if (this.marshaller == null) {
            this.marshaller = this.describeType == 23 ? T4CMarshaller.RAW : T4CMarshaller.LONG_RAW;
        }
        return this.marshaller;
    }

    @Override
    boolean isNullByDescribe() {
        return false;
    }

    @Override
    String getString(int n2) throws SQLException {
        String string = super.getString(n2);
        if (string != null && this.definedColumnSize > 0 && string.length() > this.definedColumnSize * 2) {
            string = string.substring(0, this.definedColumnSize * 2);
        }
        return string;
    }

    @Override
    long updateChecksum(long l2, int n2) throws SQLException {
        if (this.isNull(n2)) {
            l2 = CRC64.updateChecksum(l2, NULL_DATA_BYTES, 0, NULL_DATA_BYTES.length);
        }
        return l2;
    }
}

