/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Properties;
import oracle.jdbc.driver.Accessor;
import oracle.jdbc.driver.Binder;
import oracle.jdbc.driver.ByteArray;
import oracle.jdbc.driver.ByteCopyingBinder;
import oracle.jdbc.driver.CRC64;
import oracle.jdbc.driver.DBConversion;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.DirectPathBufferMarshaler;
import oracle.jdbc.driver.OraclePreparedStatement;
import oracle.jdbc.driver.PhysicalConnection;
import oracle.jdbc.driver.T4CConnection;
import oracle.jdbc.driver.T4CPreparedStatement;
import oracle.jdbc.driver.T4CRowidAccessor;
import oracle.jdbc.internal.Monitor;
import oracle.jdbc.logging.annotations.Blind;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.PropertiesBlinder;
import oracle.jdbc.logging.annotations.Supports;
import oracle.sql.CharacterSet;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.THIN_INTERNAL})
class T4CDirectPathPreparedStatement
extends T4CPreparedStatement {
    private int directPathCursor;
    static final int DPPSTMT_STATUS_UNKNOWN = 0;
    static final int DPPSTMT_STATUS_PREPARED = 1;
    static final int DPPSTMT_STATUS_LOAD_STREAM = 2;
    static final int DPPSTMT_STATUS_FINISH = 3;
    static final int DPPSTMT_STATUS_ABORT = 4;
    static final int DPPSTMT_STATUS_CLOSED = 5;
    private int directPathStatus;
    private final String schemaName;
    private final String tableName;
    private final String[] colNames;
    private final String partitionName;
    Properties dpStmtProps;
    private int rowInError;
    private boolean codePointCountingEnabled;
    private int[] maxCodePointCounts;
    private static final int DTYBRI_SIZE = 10;
    private static final String IS_DTYBRI_QUERY = "SELECT COUNT(*) FROM SYS.ALL_TAB_COLUMNS WHERE OWNER = ? AND TABLE_NAME = ? AND COLUMN_NAME = ? AND DATA_TYPE='ROWID'";
    private static final int QUERY_BIND_POS_SCHEMA = 1;
    private static final int QUERY_BIND_POS_TABLE = 2;
    private static final int QUERY_BIND_POS_COLUMN = 3;
    private int sdbaOfBits;
    private int sdbaBits;
    private int dbabBits;

    T4CDirectPathPreparedStatement(PhysicalConnection physicalConnection, String string, String string2, String[] stringArray, String string3, @Blind(value=PropertiesBlinder.class) Properties properties, @Blind(value=PropertiesBlinder.class) Properties properties2, String string4) throws SQLException {
        super(physicalConnection, string4, properties);
        if (!this.bindUseDBA) {
            throw new IllegalStateException("Dynamic byte array storage of bind values must be enabled for direct path loads. (The oracle.jdbc.bindUseDBA connection property cannot be false)");
        }
        this.schemaName = string;
        this.tableName = string2;
        this.colNames = stringArray;
        this.partitionName = string3;
        this.dpStmtProps = properties2;
        this.directPathStatus = 0;
        this.rowInError = 0;
    }

    @Override
    public String getOriginalSql() throws SQLException {
        throw (SQLException)DatabaseError.createUnsupportedFeatureSqlException().fillInStackTrace();
    }

    @Override
    public void registerReturnParameter(int n2, int n3) throws SQLException {
        throw (SQLException)DatabaseError.createUnsupportedFeatureSqlException().fillInStackTrace();
    }

    @Override
    public void registerReturnParameter(int n2, int n3, int n4) throws SQLException {
        throw (SQLException)DatabaseError.createUnsupportedFeatureSqlException().fillInStackTrace();
    }

    @Override
    public void registerReturnParameter(int n2, int n3, String string) throws SQLException {
        throw (SQLException)DatabaseError.createUnsupportedFeatureSqlException().fillInStackTrace();
    }

    @Override
    public ResultSet getReturnResultSet() throws SQLException {
        throw (SQLException)DatabaseError.createUnsupportedFeatureSqlException().fillInStackTrace();
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        throw (SQLException)DatabaseError.createUnsupportedFeatureSqlException().fillInStackTrace();
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        throw (SQLException)DatabaseError.createUnsupportedFeatureSqlException().fillInStackTrace();
    }

    @Override
    public int executeUpdate(String string) throws SQLException {
        throw (SQLException)DatabaseError.createUnsupportedFeatureSqlException().fillInStackTrace();
    }

    @Override
    public boolean execute(String string) throws SQLException {
        throw (SQLException)DatabaseError.createUnsupportedFeatureSqlException().fillInStackTrace();
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        throw (SQLException)DatabaseError.createUnsupportedFeatureSqlException().fillInStackTrace();
    }

    @Override
    public int executeUpdate(String string, int n2) throws SQLException {
        throw (SQLException)DatabaseError.createUnsupportedFeatureSqlException().fillInStackTrace();
    }

    @Override
    public int executeUpdate(String string, int[] nArray) throws SQLException {
        throw (SQLException)DatabaseError.createUnsupportedFeatureSqlException().fillInStackTrace();
    }

    @Override
    public int executeUpdate(String string, String[] stringArray) throws SQLException {
        throw (SQLException)DatabaseError.createUnsupportedFeatureSqlException().fillInStackTrace();
    }

    @Override
    public boolean execute(String string, int n2) throws SQLException {
        throw (SQLException)DatabaseError.createUnsupportedFeatureSqlException().fillInStackTrace();
    }

    @Override
    public boolean execute(String string, int[] nArray) throws SQLException {
        throw (SQLException)DatabaseError.createUnsupportedFeatureSqlException().fillInStackTrace();
    }

    @Override
    public boolean execute(String string, String[] stringArray) throws SQLException {
        throw (SQLException)DatabaseError.createUnsupportedFeatureSqlException().fillInStackTrace();
    }

    static String getSQLStatement(String string, String string2, String[] stringArray, String string3, PhysicalConnection physicalConnection) throws SQLException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("INSERT INTO ");
        if (string != null && string.length() != 0) {
            stringBuffer.append(physicalConnection.enquoteIdentifier(string, true));
            stringBuffer.append(".");
        }
        stringBuffer.append(physicalConnection.enquoteIdentifier(string2, true));
        stringBuffer.append("(");
        boolean bl = true;
        for (String string4 : stringArray) {
            if (!bl) {
                stringBuffer.append(",");
            } else {
                bl = false;
            }
            stringBuffer.append(physicalConnection.enquoteIdentifier(string4, true));
        }
        stringBuffer.append(")");
        stringBuffer.append(" VALUES ");
        stringBuffer.append("(");
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            if (i2 != 0) {
                stringBuffer.append(",");
            }
            stringBuffer.append("?");
        }
        stringBuffer.append(")");
        if (string3 != null) {
            stringBuffer.append("/* Partition Name:");
            stringBuffer.append(string3);
            stringBuffer.append(" */");
        }
        return stringBuffer.toString();
    }

    @Override
    public boolean execute() throws SQLException {
        try (Monitor.CloseableLock closeableLock = this.connection.acquireCloseableLock();){
            this.checkForDirectPathReprepare();
            boolean bl = super.execute();
            return bl;
        }
    }

    @Override
    public int executeUpdate() throws SQLException {
        try (Monitor.CloseableLock closeableLock = this.connection.acquireCloseableLock();){
            this.checkForDirectPathReprepare();
            int n2 = super.executeUpdate();
            return n2;
        }
    }

    @Override
    public int[] executeBatch() throws SQLException {
        try (Monitor.CloseableLock closeableLock = this.connection.acquireCloseableLock();){
            this.checkForDirectPathReprepare();
            int[] nArray = super.executeBatch();
            return nArray;
        }
    }

    @Override
    public long[] executeLargeBatch() throws SQLException {
        try (Monitor.CloseableLock closeableLock = this.connection.acquireCloseableLock();){
            this.checkForDirectPathReprepare();
            long[] lArray = super.executeLargeBatch();
            return lArray;
        }
    }

    @Override
    void doOall8(boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, int n2) throws SQLException, IOException {
        int n3 = 0;
        int n4 = 0;
        int[] nArray = new int[2];
        if (this.bindIndicators != null) {
            n3 = ((this.bindIndicators[this.bindIndicatorSubRange + 3] & 0xFFFF) << 16) + (this.bindIndicators[this.bindIndicatorSubRange + 4] & 0xFFFF);
            n4 = this.bindIndicators[this.bindIndicatorSubRange + 0] & 0xFFFF;
        }
        this.rowInError = 0;
        this.validateBindLengths();
        DirectPathBufferMarshaler.BufferPlanner bufferPlanner = DirectPathBufferMarshaler.createBufferPlanner(n3, n4, this.bindData, this.bindDataOffsets, this.bindDataLengths, this.parameterStream, this.accessors, this.t4Connection);
        try {
            this.t4Connection.directPathLoadStream(bufferPlanner, this.directPathCursor, nArray);
        }
        catch (SQLException sQLException) {
            this.rowInError = bufferPlanner.getRowByOffset(nArray[0], nArray[1]);
            throw sQLException;
        }
        this.setDirectPathStatus(2);
    }

    @Override
    public void close() throws SQLException {
        try (Monitor.CloseableLock closeableLock = this.connection.acquireCloseableLock();){
            if (this.isDirectPathUncommitted()) {
                this.t4Connection.directPathAbort();
            }
            super.close();
            this.setDirectPathStatus(5);
            this.t4Connection.clearDirectPathState();
        }
    }

    @Override
    public void closeWithKey(String string) throws SQLException {
        try (Monitor.CloseableLock closeableLock = this.connection.acquireCloseableLock();){
            if (this.isDirectPathUncommitted()) {
                this.t4Connection.directPathAbort();
            }
            super.closeWithKey(string);
            this.setDirectPathStatus(5);
            this.t4Connection.clearDirectPathState();
        }
    }

    void setDirectPathCursor(int n2) {
        this.directPathCursor = n2;
    }

    int getDirectPathCursor() {
        return this.directPathCursor;
    }

    int getDirectPathStatus() {
        return this.directPathStatus;
    }

    boolean isDirectPathUncommitted() {
        return this.directPathStatus == 1 || this.directPathStatus == 2;
    }

    boolean isDirectPathCommitted() {
        return this.directPathStatus == 3 || this.directPathStatus == 4;
    }

    boolean isDirectPathClosed() {
        return this.directPathStatus == 5;
    }

    void setDirectPathStatus(int n2) {
        this.directPathStatus = n2;
    }

    void checkForDirectPathReprepare() throws SQLException {
        try {
            if (this.isDirectPathCommitted()) {
                this.t4Connection.odpp.doODPP(this.schemaName, this.tableName, this.colNames, this.partitionName, this.dpStmtProps);
                int n2 = (int)this.t4Connection.odpp.getO4Value(3);
                this.setDirectPathCursor(n2);
                this.setDirectPathStatus(1);
            }
        }
        catch (IOException iOException) {
            ((T4CConnection)this.connection).handleIOException(iOException);
            throw (SQLException)DatabaseError.createSqlException(iOException).fillInStackTrace();
        }
    }

    int getErrorRowNumber() {
        return this.rowInError;
    }

    @Override
    void setupBindBuffers(int n2, int n3) throws SQLException {
        this.updateCodePointCounts(n2, n3);
        super.setupBindBuffers(n2, n3);
    }

    @Override
    int getConversionCodeForAsciiStream(int n2) {
        return this.bindRequiresUTF16(n2) ? 13 : 15;
    }

    @Override
    final int getConversionCodeForCharacterStream(int n2) {
        return this.bindRequiresUTF16(n2) ? 14 : 16;
    }

    @Override
    void adjustCharLensForSetCHAR(int n2, byte[] byArray) {
        this.currentRowCharLens[n2] = 0;
        this.currentRowByteLens[n2] = byArray.length;
    }

    void updateAccessors(Accessor[] accessorArray) throws SQLException {
        assert (accessorArray != null) : "describedAccessors is null";
        assert (this.numberOfBindPositions == accessorArray.length) : "numberOfBindPositions: " + this.numberOfBindPositions + "describedAccessors.length" + accessorArray.length;
        this.accessors = accessorArray;
        this.initCodePointCounting();
        this.initRowIDAccessors();
    }

    @Override
    final CharacterSet getCharacterSetForBind(int n2, short s2) {
        DBConversion dBConversion = this.connection.conversion;
        return this.bindRequiresUTF16(n2) ? CharacterSet.make(2000) : (2 == this.accessors[n2].describeFormOfUse ? dBConversion.serverNCharSet : dBConversion.serverCharSet);
    }

    @Override
    protected Binder createRowidBinder(byte[] byArray) throws SQLException {
        if (byArray == null || byArray.length == 0) {
            return this.createRowidNullBinder();
        }
        return new DirectPathRowIDBinder(byArray);
    }

    private boolean bindRequiresUTF16(int n2) {
        Accessor accessor = this.accessors[n2];
        DBConversion dBConversion = this.connection.conversion;
        if (112 != accessor.describeType) {
            return false;
        }
        if (2 == accessor.describeFormOfUse) {
            return !dBConversion.isServerNCharSetFixedWidth;
        }
        return dBConversion.isServerCSMultiByte && !dBConversion.isServerCharSetFixedWidth;
    }

    private boolean isCharacterSetFixedWidth(int n2) {
        Accessor accessor = this.accessors[n2];
        DBConversion dBConversion = this.connection.conversion;
        if (this.bindRequiresUTF16(n2)) {
            return true;
        }
        if (2 == accessor.describeFormOfUse) {
            return dBConversion.isServerNCharSetFixedWidth;
        }
        return !dBConversion.isServerCSMultiByte || dBConversion.isServerCharSetFixedWidth;
    }

    private final void initCodePointCounting() {
        this.codePointCountingEnabled = false;
        for (int i2 = 0; i2 < this.accessors.length; ++i2) {
            if (!this.accessors[i2].isLengthSemanticChar() || this.isCharacterSetFixedWidth(i2)) continue;
            this.codePointCountingEnabled = true;
            break;
        }
        this.maxCodePointCounts = (int[])(this.codePointCountingEnabled ? new int[this.numberOfBindPositions] : null);
    }

    private void updateCodePointCounts(int n2, int n3) {
        if (!this.codePointCountingEnabled) {
            return;
        }
        int n4 = n2 + n3;
        for (int i2 = 0; i2 < this.numberOfBindPositions; ++i2) {
            int n5 = 0;
            for (int i3 = n2; i3 < n4; ++i3) {
                String string = this.getStringBinderVal(i3, i2);
                if (string == null) {
                    n5 = Integer.MAX_VALUE;
                    break;
                }
                int n6 = string.codePointCount(0, string.length());
                if (n6 <= n5) continue;
                n5 = n6;
            }
            this.maxCodePointCounts[i2] = n5;
        }
    }

    private int getMaxCodePointCount(int n2) {
        return this.codePointCountingEnabled ? this.maxCodePointCounts[n2] : Integer.MAX_VALUE;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void validateBindLengths() throws SQLException {
        int n2 = 0;
        while (true) {
            block13: {
                if (n2 >= this.numberOfBindPositions) {
                    return;
                }
                Accessor accessor = this.accessors[n2];
                switch (accessor.describeType) {
                    case 8: {
                        if (this.maxRawBytesSql > Integer.MAX_VALUE) {
                            break;
                        }
                        break block13;
                    }
                    case 24: {
                        if (this.maxRawBytesSql > Integer.MAX_VALUE) {
                            break;
                        }
                        break block13;
                    }
                    case 112: 
                    case 113: {
                        break block13;
                    }
                }
                int n3 = accessor.describeMaxLength;
                if (!accessor.isLengthSemanticChar() || this.isCharacterSetFixedWidth(n2)) {
                    this.validateByteLengths(n2, n3);
                } else {
                    int n4 = accessor.describeMaxLengthChars;
                    if (n4 >= this.getMaxCodePointCount(n2)) {
                        this.validateByteLengths(n2, n3);
                    } else {
                        this.validateByteAndCodePointLengths(n2, n3, n4, this.getCharacterSetForBind(n2, (short)0));
                    }
                }
            }
            ++n2;
        }
    }

    private void validateByteLengths(int n2, int n3) throws SQLException {
        int n4 = this.numberOfBindPositions * this.numberOfBoundRows;
        for (int i2 = n2; i2 < n4; i2 += this.numberOfBindPositions) {
            int n5 = this.bindDataLengths[i2];
            if (n5 <= n3) continue;
            throw T4CDirectPathPreparedStatement.newBindLengthException(i2 / this.numberOfBindPositions + 1, i2 % this.numberOfBindPositions + 1, n5, n3, "BYTE");
        }
    }

    private void validateByteAndCodePointLengths(int n2, int n3, int n4, CharacterSet characterSet) throws SQLException {
        int n5 = this.numberOfBindPositions * this.numberOfBoundRows;
        for (int i2 = n2; i2 < n5; i2 += this.numberOfBindPositions) {
            long l2;
            int n6;
            int n7 = this.bindDataLengths[i2];
            if (n7 > n3) {
                throw T4CDirectPathPreparedStatement.newBindLengthException(i2 / this.numberOfBindPositions + 1, i2 % this.numberOfBindPositions + 1, n7, n3, "BYTE");
            }
            if (n7 <= n4 || (n6 = this.getCodePointCount(l2 = this.bindDataOffsets[i2], n7, characterSet)) <= n4) continue;
            throw T4CDirectPathPreparedStatement.newBindLengthException(i2 / this.numberOfBindPositions + 1, i2 % this.numberOfBindPositions + 1, n6, n4, "CHAR");
        }
    }

    private int getCodePointCount(long l2, int n2, CharacterSet characterSet) {
        String string;
        switch (characterSet.getOracleId()) {
            case 873: {
                return this.getAL32UTF8CodePointCount(l2, n2);
            }
            case 871: {
                return this.getUTF8CodePointCount(l2, n2);
            }
        }
        try {
            string = this.bindData.getString(l2, n2, characterSet);
        }
        catch (SQLException sQLException) {
            byte[] byArray = this.bindData.get(l2, n2);
            string = characterSet.toStringWithReplacement(byArray, 0, byArray.length);
        }
        return string.codePointCount(0, string.length());
    }

    private int getAL32UTF8CodePointCount(long l2, int n2) {
        byte[] byArray = this.connection.getByteBuffer(n2);
        this.bindData.get(l2, byArray, 0, n2);
        int n3 = 0;
        for (int i2 = 0; i2 < n2; ++i2) {
            ++n3;
            byte by = byArray[i2];
            if (0 == (0x80 & by)) continue;
            if (192 == (0xE0 & by)) {
                ++i2;
                continue;
            }
            if (224 == (0xF0 & by)) {
                i2 += 2;
                continue;
            }
            if (240 == (0xF8 & by)) {
                i2 += 3;
                continue;
            }
            assert (false) : "Detected invalid AL32UTF8 code point at buffer position " + (l2 + (long)i2) + " with a leading byte of: 0x" + Integer.toHexString(Byte.toUnsignedInt(by));
        }
        this.connection.cacheBuffer(byArray);
        return n3;
    }

    private int getUTF8CodePointCount(long l2, int n2) {
        byte[] byArray = this.connection.getByteBuffer(n2);
        this.bindData.get(l2, byArray, 0, n2);
        int n3 = 0;
        for (int i2 = 0; i2 < n2; ++i2) {
            ++n3;
            byte by = byArray[i2];
            if (0 == (0x80 & by)) continue;
            if (192 == (0xE0 & by)) {
                ++i2;
                continue;
            }
            if (237 == (0xFF & by)) {
                if (i2 + 1 >= n2) continue;
                int n4 = 0xF & byArray[i2 + 1] >> 2;
                if (8 == n4) {
                    --n3;
                }
                i2 += 2;
                continue;
            }
            if (224 == (0xF0 & by)) {
                i2 += 2;
                continue;
            }
            assert (false) : "Detected invalid UTF8 code point at buffer position " + (l2 + (long)i2) + " with a leading byte of: 0x" + Integer.toHexString(Byte.toUnsignedInt(by));
        }
        this.connection.cacheBuffer(byArray);
        return n3;
    }

    private static SQLException newBindLengthException(int n2, int n3, int n4, int n5, String string) {
        String string2 = "Maximum Length: " + n5 + " " + string + ". Bind at row " + n2 + ", position " + n3 + ": " + n4 + " " + string;
        return DatabaseError.createSqlException(72, string2);
    }

    void setSDBAOfBits(int n2) {
        this.sdbaOfBits = n2;
    }

    void setSDBABits(int n2) {
        this.sdbaBits = n2;
    }

    void setDBABBits(int n2) {
        this.dbabBits = n2;
    }

    private void initRowIDAccessors() throws SQLException {
        for (Accessor accessor : this.accessors) {
            if (accessor.describeType != 208 || accessor.describeMaxLength != 10 || !this.columnIsRowID(accessor.columnName)) continue;
            accessor.describeType = 104;
        }
    }

    private boolean columnIsRowID(String string) throws SQLException {
        try (PreparedStatement preparedStatement = this.t4Connection.prepareStatement(IS_DTYBRI_QUERY);){
            preparedStatement.setString(1, this.schemaName.toUpperCase());
            preparedStatement.setString(2, this.tableName.toUpperCase());
            preparedStatement.setString(3, string.toUpperCase());
            ResultSet resultSet = preparedStatement.executeQuery();
            resultSet.next();
            boolean bl = 0 != resultSet.getInt(1);
            return bl;
        }
    }

    private class DirectPathRowIDBinder
    extends Binder {
        private Binder copyingBinder;
        private final long[] riddef;

        private DirectPathRowIDBinder(byte[] byArray) throws SQLException {
            this.riddef = T4CRowidAccessor.isRestricted(byArray) ? T4CRowidAccessor.rcToRowid(byArray, 0, byArray.length) : T4CRowidAccessor.stringToRowid(byArray, 0, byArray.length);
            this.type = (short)104;
            this.bytelen = 10;
        }

        @Override
        Binder copyingBinder() {
            if (this.copyingBinder == null) {
                this.copyingBinder = new ByteCopyingBinder(){};
                this.copyingBinder.type = this.type;
                this.copyingBinder.bytelen = this.bytelen;
            }
            return this.copyingBinder;
        }

        @Override
        long bind(OraclePreparedStatement oraclePreparedStatement, int n2, int n3, int n4, byte[] byArray, char[] cArray, short[] sArray, int n5, int n6, int n7, int n8, int n9, int n10, boolean bl, long l2, ByteArray byteArray, long[] lArray, int[] nArray, int n11, boolean bl2, int n12) throws SQLException {
            int n13;
            long l3;
            assert (bl2) : "bindUseDBA is false";
            lArray[n11] = l3 = byteArray.getPosition();
            oraclePreparedStatement.lastBoundDataOffsets[n2] = l3;
            byte[] byArray2 = 104 == T4CDirectPathPreparedStatement.this.accessors[n2].describeType ? T4CRowidAccessor.rowidToDTYBRI(this.riddef, T4CDirectPathPreparedStatement.this.sdbaOfBits, T4CDirectPathPreparedStatement.this.sdbaBits, T4CDirectPathPreparedStatement.this.dbabBits) : T4CRowidAccessor.rowidToDTYBURI(this.riddef);
            T4CDirectPathPreparedStatement.this.rowData.put(byArray2);
            nArray[n11] = n13 = byArray2.length;
            oraclePreparedStatement.lastBoundDataLengths[n2] = n13;
            sArray[n9] = (short)n13;
            if (oraclePreparedStatement.connection.checksumMode.needToCalculateBindChecksum()) {
                if (sArray[n10] == -1) {
                    return CRC64.updateChecksum(l2, Accessor.NULL_DATA_BYTES, 0, Accessor.NULL_DATA_BYTES.length);
                }
                return CRC64.updateChecksum(l2, byArray2, 0, n13);
            }
            return l2;
        }
    }
}

