/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.o3logon;

import java.security.SecureRandom;
import oracle.security.o3logon.CryptDES;
import oracle.security.o3logon.WorkBench;

public final class O3LoginProtocolHelper {
    private final byte[] encryptedPassword;
    private final byte[] sessionKey = new byte[8];
    private static long stamp = System.currentTimeMillis();
    private static int failures = 0;
    private static final boolean DEBUG = false;
    private static WorkBench converer;
    private final boolean useJCE;

    public O3LoginProtocolHelper(boolean useJCE) {
        this.encryptedPassword = null;
        this.useJCE = useJCE;
    }

    public O3LoginProtocolHelper(byte[] encryptedPassword, boolean useJCE) {
        this.encryptedPassword = encryptedPassword;
        this.useJCE = useJCE;
    }

    public byte[] getVerifier(String username, String password) {
        return this.getVerifier(username, password, true);
    }

    public byte[] getVerifier(String username, String password, Boolean svrCSMultibyte) {
        if (converer == null) {
            converer = new WorkBench(this.useJCE);
        }
        return converer.normO(username, password, svrCSMultibyte);
    }

    public boolean authenticate(String username, String passphrase) {
        byte[] epw;
        try {
            Thread.sleep(failures * 1000);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (converer == null) {
            converer = new WorkBench(this.useJCE);
        }
        if (this.encryptedPassword.length != (epw = converer.normO(username, passphrase)).length) {
            ++failures;
            return false;
        }
        for (int i = 0; i < epw.length; ++i) {
            if (epw[i] == this.encryptedPassword[i]) continue;
            ++failures;
            return false;
        }
        return true;
    }

    public byte[] getChallenge(byte[] seed) {
        SecureRandom rnd = null;
        rnd = new SecureRandom(seed);
        rnd.setSeed(stamp += System.currentTimeMillis());
        rnd.setSeed(this.encryptedPassword);
        rnd.nextBytes(this.sessionKey);
        CryptDES engine = new CryptDES(this.useJCE);
        byte[] cipherText = engine.encrypt(this.encryptedPassword, this.sessionKey, this.sessionKey.length);
        return cipherText;
    }

    public String getPassword(byte[] response) {
        int error = -1;
        CryptDES engine = new CryptDES(this.useJCE);
        byte padding = response[response.length - 1];
        byte[] temp = new byte[response.length - 1];
        System.arraycopy(response, 0, temp, 0, temp.length);
        byte[] buffer = null;
        try {
            buffer = engine.decrypt(this.sessionKey, temp);
        }
        catch (Exception e) {
            return null;
        }
        byte[] pwBytes = new byte[buffer.length - padding];
        System.arraycopy(buffer, 0, pwBytes, 0, pwBytes.length);
        String password = new String(pwBytes).toUpperCase();
        return password;
    }

    public static byte[] getResponse(String username, String password, byte[] challenge, boolean useJCE) {
        if (converer == null) {
            converer = new WorkBench(useJCE);
        }
        byte[] ePwdOneWay = converer.normO(username, password);
        CryptDES engine = new CryptDES(useJCE);
        byte[] sessionKey = engine.decrypt(ePwdOneWay, challenge);
        byte[] pw = password.getBytes();
        int pwdPadLen = pw.length % 8 > 0 ? (int)((byte)(8 - pw.length % 8)) : 0;
        byte[] paddedPwd = new byte[pw.length + pwdPadLen];
        System.arraycopy(pw, 0, paddedPwd, 0, pw.length);
        byte[] ePwdOnSessKey = engine.encrypt(sessionKey, paddedPwd, paddedPwd.length);
        byte[] response = new byte[ePwdOnSessKey.length + 1];
        System.arraycopy(ePwdOnSessKey, 0, response, 0, ePwdOnSessKey.length);
        response[response.length - 1] = pwdPadLen;
        return response;
    }
}

