/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.ano;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.logging.Level;
import oracle.jdbc.clio.annotations.Format;
import oracle.jdbc.diagnostics.Parameter;
import oracle.jdbc.diagnostics.SecurityLabel;
import oracle.net.ano.Ano;
import oracle.net.aso.DataIntegrityAlgorithm;
import oracle.net.aso.EncryptionAlgorithm;
import oracle.net.ns.BreakNetException;
import oracle.net.ns.NIONSDataChannel;
import oracle.net.ns.NetException;
import oracle.net.ns.SQLnetDef;
import oracle.net.ns.SessionAtts;

class CryptoNIONSDataChannel
extends NIONSDataChannel
implements SQLnetDef {
    private static final String CLASS_NAME = CryptoNIONSDataChannel.class.getName();
    private EncryptionAlgorithm encryptionAlg = null;
    private DataIntegrityAlgorithm dataIntegrityAlg = null;
    private byte foldinByte = 0;
    private int dataExpansionBytes = 0;
    private Ano ano = null;

    public CryptoNIONSDataChannel(SessionAtts sAtts) {
        super(sAtts);
        this.ano = sAtts.ano;
        if (sAtts.ano.encryptionAlg != null) {
            this.encryptionAlg = sAtts.ano.encryptionAlg;
            this.dataExpansionBytes += this.encryptionAlg.maxDelta();
        }
        if (sAtts.ano.dataIntegrityAlg != null) {
            this.dataIntegrityAlg = sAtts.ano.dataIntegrityAlg;
            this.dataExpansionBytes += this.dataIntegrityAlg.size();
        }
        ++this.dataExpansionBytes;
        if (sAtts.isNetworkCompressionEnabled()) {
            this.initializeNetworkCompressionBuffers();
        }
    }

    @Override
    public void readDataFromSocketChannel() throws IOException {
        super.readDataFromSocketChannel();
        this.ano = this.session.ano;
        this.dataExpansionBytes = 0;
        if (this.ano.encryptionAlg != null) {
            this.encryptionAlg = this.ano.encryptionAlg;
            this.dataExpansionBytes += this.encryptionAlg.maxDelta();
            if (this.ano.getRenewKey()) {
                this.encryptionAlg.setSessionKey(null, null);
            }
        }
        if (this.ano.dataIntegrityAlg != null) {
            this.dataIntegrityAlg = this.ano.dataIntegrityAlg;
            this.dataExpansionBytes += this.dataIntegrityAlg.size();
            if (this.ano.getRenewKey()) {
                this.dataIntegrityAlg.renew();
            }
        }
        ++this.dataExpansionBytes;
        this.ano.setRenewKey(false);
        try {
            this.decryptAndChecksum();
        }
        catch (Exception e) {
            this.ano.checkForAnoNegotiationFailure();
            throw e;
        }
    }

    @Override
    public void writeDataToSocketChannel(int dataFlags) throws IOException {
        if (this.foldinByte == 0) {
            this.foldinByte = this.ano.foldinKey();
        }
        this.checksumAndEncrypt();
        super.writeDataToSocketChannel(dataFlags);
    }

    @Override
    public int getDataExpansionByteSize() {
        return this.dataExpansionBytes;
    }

    @Override
    protected void processMarker() throws IOException, NetException, BreakNetException {
        this.session.ano.setRenewKey(true);
    }

    protected void checksumAndEncrypt() throws IOException {
        int dataOff = 0;
        int initialPosition = this.session.payloadDataBufferForWrite.position();
        byte[] clearBuffer = new byte[this.session.payloadDataBufferForWrite.position() - dataOff];
        this.session.payloadDataBufferForWrite.limit(this.session.payloadDataBufferForWrite.position());
        this.session.payloadDataBufferForWrite.position(dataOff);
        this.session.payloadDataBufferForWrite.get(clearBuffer);
        this.session.payloadDataBufferForWrite.position(dataOff);
        this.session.payloadDataBufferForWrite.limit(this.session.payloadDataBufferForWrite.capacity());
        this.tracep(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "checksumAndEncrypt", "Packet size before encryption {0}.", "Packet size before encryption {0}. Packet Dump : \n{1}", null, () -> {
            if (this.isSensitiveEnabled()) {
                return new Object[]{clearBuffer.length, Parameter.arg(Format.Style.PACKET_DUMP, ByteBuffer.wrap(clearBuffer), 0L, clearBuffer.length)};
            }
            return new Object[]{clearBuffer.length};
        });
        byte[] checksum = null;
        int dataLen = initialPosition - dataOff;
        if (this.dataIntegrityAlg != null && (checksum = this.dataIntegrityAlg.compute(clearBuffer, clearBuffer.length)) != null) {
            dataLen += checksum.length;
        }
        byte[] bufferToEncrypt = new byte[dataLen];
        System.arraycopy(clearBuffer, 0, bufferToEncrypt, 0, clearBuffer.length);
        if (checksum != null) {
            System.arraycopy(checksum, 0, bufferToEncrypt, clearBuffer.length, checksum.length);
        }
        if (this.encryptionAlg != null) {
            byte[] encryptedBuffer = this.encryptionAlg.encrypt(bufferToEncrypt);
            if (encryptedBuffer == null) {
                throw new IOException("Fail to encrypt buffer");
            }
            dataLen = encryptedBuffer.length;
            this.session.payloadDataBufferForWrite.put(encryptedBuffer);
        } else if (this.dataIntegrityAlg != null) {
            this.session.payloadDataBufferForWrite.put(bufferToEncrypt);
        }
        if (dataLen > 0) {
            this.session.payloadDataBufferForWrite.put(this.foldinByte);
        }
    }

    protected void decryptAndChecksum() throws IOException {
        int initialPosition = this.session.payloadDataBufferForRead.position();
        ByteOrder originalOrder = this.session.payloadDataBufferForRead.order();
        this.session.payloadDataBufferForRead.order(ByteOrder.BIG_ENDIAN);
        int dataLen = this.session.payloadDataBufferForRead.limit();
        if (dataLen > 0) {
            this.session.payloadDataBufferForRead.position(dataLen - 1);
            byte foldin = this.session.payloadDataBufferForRead.get();
            this.session.payloadDataBufferForRead.position(initialPosition);
            this.session.payloadDataBufferForRead.order(originalOrder);
            --dataLen;
        }
        byte[] dataBuffer = new byte[dataLen];
        int initialLimit = this.session.payloadDataBufferForRead.limit();
        this.session.payloadDataBufferForRead.get(dataBuffer);
        this.session.payloadDataBufferForRead.position(initialPosition);
        this.session.payloadDataBufferForRead.limit(initialLimit);
        byte[] clearBuffer = this.encryptionAlg != null && dataLen > 0 ? this.encryptionAlg.decrypt(dataBuffer) : dataBuffer;
        if (clearBuffer == null) {
            throw new IOException("Bad buffer - Fail to decrypt buffer");
        }
        dataLen = clearBuffer.length;
        if (this.dataIntegrityAlg != null && dataLen > 0) {
            byte[] checksum = new byte[this.dataIntegrityAlg.size()];
            System.arraycopy(clearBuffer, dataLen -= this.dataIntegrityAlg.size(), checksum, 0, this.dataIntegrityAlg.size());
            byte[] xsumBuff = new byte[dataLen];
            System.arraycopy(clearBuffer, 0, xsumBuff, 0, dataLen);
            if (this.dataIntegrityAlg.compare(xsumBuff, checksum)) {
                throw new IOException("Checksum fail");
            }
            this.session.payloadDataBufferForRead = ByteBuffer.wrap(xsumBuff, 0, dataLen);
            this.session.payloadDataBufferForRead.limit(dataLen);
            this.session.payloadDataBufferForRead.order(originalOrder);
        } else {
            this.session.payloadDataBufferForRead = ByteBuffer.wrap(clearBuffer, 0, dataLen);
            this.session.payloadDataBufferForRead.limit(dataLen);
            this.session.payloadDataBufferForRead.order(originalOrder);
        }
        this.session.payloadDataBufferForRead.position(initialPosition);
        this.tracep(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "decryptAndChecksum", "Packet size after decryption {0}.", "Packet size after decryption {0}. Packet Dump : \n{1}", null, () -> {
            if (this.isSensitiveEnabled()) {
                return new Object[]{clearBuffer.length, Parameter.arg(Format.Style.PACKET_DUMP, ByteBuffer.wrap(clearBuffer), 0L, clearBuffer.length)};
            }
            return new Object[]{clearBuffer.length};
        });
    }
}

