/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.logging.Level;
import oracle.jdbc.OracleCallableStatement;
import oracle.jdbc.diagnostics.CommonDiagnosable;
import oracle.jdbc.diagnostics.SecurityLabel;
import oracle.jdbc.internal.OracleBfile;
import oracle.jdbc.internal.OracleBlob;
import oracle.jdbc.internal.OracleClob;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.internal.OracleDatumWithConnection;
import oracle.sql.BFILE;
import oracle.sql.BLOB;
import oracle.sql.CLOB;
import oracle.sql.Datum;

public class LobPlsqlUtil {
    static boolean PLSQL_DEBUG = false;
    static final int MAX_PLSQL_SIZE = 32512;
    static final int MAX_PLSQL_INSTR_SIZE = 32512;
    static final int MAX_CHUNK_SIZE = 32512;
    private static final String CLASS_NAME = LobPlsqlUtil.class.getName();

    public static long hasPattern(BLOB blob, byte[] pattern, long startPos) throws SQLException {
        return LobPlsqlUtil.hasPattern(blob, (Datum)blob, pattern, startPos);
    }

    public static long hasPattern(OracleBlob blob, Datum lob, byte[] pattern, long startPos) throws SQLException {
        return LobPlsqlUtil.hasPattern(blob.getInternalConnection(), lob, 2004, pattern, startPos);
    }

    public static long isSubLob(BLOB blob, BLOB subLob, long startPos) throws SQLException {
        return LobPlsqlUtil.isSubLob(blob, (Datum)blob, (Datum)subLob, startPos);
    }

    public static long isSubLob(OracleBlob blob, Datum lob, Datum subLob, long startPos) throws SQLException {
        return LobPlsqlUtil.isSubLob(blob.getInternalConnection(), lob, 2004, subLob, startPos);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long hasPattern(OracleClob clob, char[] pattern, long startPos) throws SQLException {
        if (pattern == null || startPos <= 0L) {
            return 0L;
        }
        OracleConnection conn = clob.getInternalConnection();
        long patternLen = pattern.length;
        long lobLen = LobPlsqlUtil.length(conn, clob, 2005, clob.isNCLOB());
        if (patternLen == 0L || patternLen > lobLen - startPos + 1L || startPos > lobLen) {
            return 0L;
        }
        if (patternLen <= (long)LobPlsqlUtil.getPlsqlMaxInstrSize(conn)) {
            Statement cstmt = null;
            try {
                cstmt = (OracleCallableStatement)conn.prepareCall("begin :1 := sys.dbms_lob.instr(:2, :3, :4); end;");
                cstmt.registerOutParameter(1, 2);
                if (clob.isNCLOB()) {
                    cstmt.setFormOfUse(2, (short)2);
                    cstmt.setFormOfUse(3, (short)2);
                }
                cstmt.setClob(2, clob);
                cstmt.setString(3, new String(pattern));
                cstmt.setLong(4, startPos);
                cstmt.execute();
                long l = cstmt.getLong(1);
                return l;
            }
            finally {
                cstmt.close();
                cstmt = null;
            }
        }
        int matchedLen = 0;
        long subStartPos = startPos;
        boolean done = false;
        long matchedPos = 0L;
        while (!done) {
            if (patternLen > lobLen - subStartPos + 1L) {
                return 0L;
            }
            matchedLen = 0;
            int subPatternLen = (int)Math.min((long)LobPlsqlUtil.getPlsqlMaxInstrSize(conn), patternLen - (long)matchedLen);
            char[] subPattern = new char[subPatternLen];
            System.arraycopy(pattern, matchedLen, subPattern, 0, subPatternLen);
            long subMatchedPos = LobPlsqlUtil.hasPattern(clob, subPattern, subStartPos);
            if (subMatchedPos == 0L) {
                return 0L;
            }
            matchedPos = subMatchedPos;
            matchedLen += subPatternLen;
            subStartPos = subMatchedPos + (long)subPatternLen;
            boolean moreChunks = true;
            while (moreChunks) {
                subPatternLen = (int)Math.min((long)LobPlsqlUtil.getPlsqlMaxInstrSize(conn), patternLen - (long)matchedLen);
                subPattern = new char[subPatternLen];
                System.arraycopy(pattern, matchedLen, subPattern, 0, subPatternLen);
                subMatchedPos = LobPlsqlUtil.hasPattern(clob, subPattern, subStartPos);
                if (subMatchedPos == subStartPos) {
                    subStartPos += (long)subPatternLen;
                    if ((long)(matchedLen += subPatternLen) != patternLen) continue;
                    moreChunks = false;
                    done = true;
                    continue;
                }
                if (subMatchedPos == 0L) {
                    return 0L;
                }
                subStartPos = subMatchedPos - (long)matchedLen;
                moreChunks = false;
            }
        }
        return matchedPos;
    }

    public static long isSubLob(OracleClob clob, OracleClob subLob, long startPos) throws SQLException {
        if (subLob == null || startPos <= 0L) {
            return 0L;
        }
        OracleConnection conn = clob.getInternalConnection();
        long patternLen = LobPlsqlUtil.length(conn, subLob, 2005, subLob.isNCLOB());
        long lobLen = LobPlsqlUtil.length(conn, clob, 2005, clob.isNCLOB());
        if (patternLen == 0L || patternLen > lobLen - startPos + 1L || startPos > lobLen) {
            return 0L;
        }
        if (patternLen <= (long)LobPlsqlUtil.getPlsqlMaxInstrSize(conn)) {
            char[] pattern = new char[(int)patternLen];
            subLob.getChars(1L, (int)patternLen, pattern);
            return LobPlsqlUtil.hasPattern(clob, pattern, startPos);
        }
        int matchedLen = 0;
        long subStartPos = startPos;
        boolean done = false;
        long matchedPos = 0L;
        while (!done) {
            if (patternLen > lobLen - subStartPos + 1L) {
                return 0L;
            }
            matchedLen = 0;
            int subPatternLen = (int)Math.min((long)LobPlsqlUtil.getPlsqlMaxInstrSize(conn), patternLen - (long)matchedLen);
            char[] subPattern = new char[subPatternLen];
            subLob.getChars(matchedLen + 1, subPatternLen, subPattern);
            long subMatchedPos = LobPlsqlUtil.hasPattern(clob, subPattern, subStartPos);
            if (subMatchedPos == 0L) {
                return 0L;
            }
            matchedPos = subMatchedPos;
            matchedLen += subPatternLen;
            subStartPos = subMatchedPos + (long)subPatternLen;
            boolean moreChunks = true;
            while (moreChunks) {
                subPatternLen = (int)Math.min((long)LobPlsqlUtil.getPlsqlMaxInstrSize(conn), patternLen - (long)matchedLen);
                subPattern = new char[subPatternLen];
                subLob.getChars(matchedLen + 1, subPatternLen, subPattern);
                subMatchedPos = LobPlsqlUtil.hasPattern(clob, subPattern, subStartPos);
                if (subMatchedPos == subStartPos) {
                    subStartPos += (long)subPatternLen;
                    if ((long)(matchedLen += subPatternLen) != patternLen) continue;
                    moreChunks = false;
                    done = true;
                    continue;
                }
                if (subMatchedPos == 0L) {
                    return 0L;
                }
                subStartPos = subMatchedPos - (long)matchedLen;
                moreChunks = false;
            }
        }
        return matchedPos;
    }

    public static long hasPattern(BFILE bfile, byte[] pattern, long startPos) throws SQLException {
        return LobPlsqlUtil.hasPattern(bfile, (Datum)bfile, pattern, startPos);
    }

    public static long hasPattern(OracleBfile bfile, Datum lob, byte[] pattern, long startPos) throws SQLException {
        return LobPlsqlUtil.hasPattern(bfile.getInternalConnection(), lob, -13, pattern, startPos);
    }

    public static long isSubLob(BFILE bfile, BFILE subLob, long startPos) throws SQLException {
        return LobPlsqlUtil.isSubLob(bfile, (Datum)bfile, (Datum)subLob, startPos);
    }

    public static long isSubLob(OracleBfile bfile, Datum lob, Datum subLob, long startPos) throws SQLException {
        return LobPlsqlUtil.isSubLob(bfile.getInternalConnection(), lob, -13, subLob, startPos);
    }

    public static String fileGetName(OracleBfile bfile) throws SQLException {
        OracleCallableStatement cstmt = null;
        String ret = null;
        try {
            cstmt = (OracleCallableStatement)bfile.getInternalConnection().prepareCall("begin sys.dbms_lob.fileGetName(:1, :2, :3); end; ");
            cstmt.setObject(1, (Object)bfile);
            cstmt.registerOutParameter(2, 12);
            cstmt.registerOutParameter(3, 12);
            cstmt.execute();
            ret = cstmt.getString(3);
        }
        finally {
            if (cstmt != null) {
                cstmt.close();
                cstmt = null;
            }
        }
        return ret;
    }

    public static String fileGetDirAlias(OracleBfile bfile) throws SQLException {
        OracleCallableStatement cstmt = null;
        String ret = null;
        try {
            cstmt = (OracleCallableStatement)bfile.getInternalConnection().prepareCall("begin sys.dbms_lob.fileGetName(:1, :2, :3); end; ");
            cstmt.setObject(1, (Object)bfile);
            cstmt.registerOutParameter(2, 12);
            cstmt.registerOutParameter(3, 12);
            cstmt.execute();
            ret = cstmt.getString(2);
        }
        finally {
            if (cstmt != null) {
                cstmt.close();
                cstmt = null;
            }
        }
        return ret;
    }

    private static int getPlsqlMaxInstrSize(OracleConnection conn) throws SQLException {
        boolean isCharSetMultibyte = conn.isCharSetMultibyte(conn.getDriverCharSet());
        int maxCharbyteSize = conn.getMaxCharbyteSize();
        int ret = 32512;
        if (isCharSetMultibyte) {
            ret = 32512 / (conn.getC2SNlsRatio() * maxCharbyteSize);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long read(OracleConnection conn, Datum lob, int type, long pos, long length, byte[] bytes_read) throws SQLException {
        OracleCallableStatement cstmt = null;
        int totalSizeRead = 0;
        try {
            cstmt = (OracleCallableStatement)conn.prepareCall("begin sys.dbms_lob.read (:1, :2, :3, :4); end;");
            int readThisTime = 0;
            int chunkSize = 0;
            if (LobPlsqlUtil.isNCLOB(lob)) {
                cstmt.setFormOfUse(1, (short)2);
                cstmt.setFormOfUse(4, (short)2);
            }
            cstmt.setObject(1, (Object)lob, type);
            cstmt.registerOutParameter(2, 2);
            cstmt.registerOutParameter(4, -3);
            while ((long)totalSizeRead < length) {
                chunkSize = Math.min((int)length, 32512);
                CommonDiagnosable.getInstance().debug(Level.FINER, SecurityLabel.UNKNOWN, CLASS_NAME, "read", "chunkSize={0}", (String)null, (Throwable)null, (Object)chunkSize);
                cstmt.setInt(2, chunkSize);
                cstmt.setInt(3, (int)pos + totalSizeRead);
                cstmt.execute();
                readThisTime = cstmt.getInt(2);
                byte[] bytesThisTime = cstmt.getBytes(4);
                readThisTime = Math.min(readThisTime, bytesThisTime.length);
                System.arraycopy(bytesThisTime, 0, bytes_read, totalSizeRead, readThisTime);
                CommonDiagnosable.getInstance().debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "read", "sizeRead={0}", (String)null, (Throwable)null, (Object)readThisTime);
                totalSizeRead += readThisTime;
                length -= (long)readThisTime;
            }
        }
        catch (SQLException e) {
            if (e.getErrorCode() != 1403) {
                CommonDiagnosable.getInstance().debug(Level.FINER, SecurityLabel.UNKNOWN, CLASS_NAME, "read", "Exception caught and thrown : {0} ", (String)null, e, (Object)e.getMessage());
                throw e;
            }
            CommonDiagnosable.getInstance().debug(Level.FINER, SecurityLabel.UNKNOWN, CLASS_NAME, "read", "ORA-1403 No data found end of file : {0}", (String)null, e, (Object)e.getMessage());
        }
        finally {
            if (cstmt != null) {
                cstmt.close();
                cstmt = null;
            }
        }
        return totalSizeRead;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long length(OracleConnection conn, OracleDatumWithConnection lob, int type, boolean isNclob) throws SQLException {
        long lob_length = 0L;
        OracleCallableStatement cstmt = null;
        try {
            cstmt = (OracleCallableStatement)conn.prepareCall("begin :1 := sys.dbms_lob.getLength (:2); end;");
            if (isNclob) {
                cstmt.setFormOfUse(2, (short)2);
            }
            cstmt.setObject(2, (Object)lob, type);
            cstmt.registerOutParameter(1, 2);
            cstmt.execute();
            lob_length = cstmt.getLong(1);
        }
        finally {
            if (cstmt != null) {
                cstmt.close();
                cstmt = null;
            }
        }
        return lob_length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long length(OracleConnection conn, Datum lob, int type) throws SQLException {
        long lob_length = 0L;
        OracleCallableStatement cstmt = null;
        try {
            cstmt = (OracleCallableStatement)conn.prepareCall("begin :1 := sys.dbms_lob.getLength (:2); end;");
            if (LobPlsqlUtil.isNCLOB(lob)) {
                cstmt.setFormOfUse(2, (short)2);
            }
            cstmt.setObject(2, (Object)lob, type);
            cstmt.registerOutParameter(1, 2);
            cstmt.execute();
            lob_length = cstmt.getLong(1);
        }
        finally {
            if (cstmt != null) {
                cstmt.close();
                cstmt = null;
            }
        }
        return lob_length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long hasPattern(OracleConnection conn, Datum lob, int type, byte[] pattern, long startPos) throws SQLException {
        if (pattern == null || startPos <= 0L) {
            return 0L;
        }
        long patternLen = pattern.length;
        long lobLen = LobPlsqlUtil.length(conn, lob, type);
        if (patternLen == 0L || patternLen > lobLen - startPos + 1L || startPos > lobLen) {
            return 0L;
        }
        if (patternLen <= 32512L) {
            Statement cstmt = null;
            try {
                cstmt = (OracleCallableStatement)conn.prepareCall("begin :1 := sys.dbms_lob.instr(:2, :3, :4); end;");
                cstmt.registerOutParameter(1, 2);
                cstmt.setObject(2, lob, type);
                cstmt.setBytes(3, pattern);
                cstmt.setLong(4, startPos);
                cstmt.execute();
                long l = cstmt.getLong(1);
                return l;
            }
            finally {
                cstmt.close();
                cstmt = null;
            }
        }
        int matchedLen = 0;
        long subStartPos = startPos;
        boolean done = false;
        long matchedPos = 0L;
        while (!done) {
            if (patternLen > lobLen - subStartPos + 1L) {
                return 0L;
            }
            matchedLen = 0;
            int subPatternLen = (int)Math.min(32512L, patternLen - (long)matchedLen);
            byte[] subPattern = new byte[subPatternLen];
            System.arraycopy(pattern, matchedLen, subPattern, 0, subPatternLen);
            long subMatchedPos = LobPlsqlUtil.hasPattern(conn, lob, type, subPattern, subStartPos);
            if (subMatchedPos == 0L) {
                return 0L;
            }
            matchedPos = subMatchedPos;
            matchedLen += subPatternLen;
            subStartPos = subMatchedPos + (long)subPatternLen;
            boolean moreChunks = true;
            while (moreChunks) {
                subPatternLen = (int)Math.min(32512L, patternLen - (long)matchedLen);
                subPattern = new byte[subPatternLen];
                System.arraycopy(pattern, matchedLen, subPattern, 0, subPatternLen);
                subMatchedPos = LobPlsqlUtil.hasPattern(conn, lob, type, subPattern, subStartPos);
                if (subMatchedPos == subStartPos) {
                    subStartPos += (long)subPatternLen;
                    if ((long)(matchedLen += subPatternLen) != patternLen) continue;
                    moreChunks = false;
                    done = true;
                    continue;
                }
                if (subMatchedPos == 0L) {
                    return 0L;
                }
                subStartPos = subMatchedPos - (long)matchedLen;
                moreChunks = false;
            }
        }
        return matchedPos;
    }

    public static long isSubLob(OracleConnection conn, Datum lob, int type, Datum subLob, long startPos) throws SQLException {
        if (subLob == null || startPos <= 0L) {
            return 0L;
        }
        long patternLen = LobPlsqlUtil.length(conn, subLob, type);
        long lobLen = LobPlsqlUtil.length(conn, lob, type);
        if (patternLen == 0L || patternLen > lobLen - startPos + 1L || startPos > lobLen) {
            return 0L;
        }
        if (patternLen <= 32512L) {
            byte[] pattern = new byte[(int)patternLen];
            LobPlsqlUtil.read(conn, subLob, type, 1L, patternLen, pattern);
            return LobPlsqlUtil.hasPattern(conn, lob, type, pattern, startPos);
        }
        int matchedLen = 0;
        long subStartPos = startPos;
        boolean done = false;
        long matchedPos = 0L;
        while (!done) {
            if (patternLen > lobLen - subStartPos + 1L) {
                return 0L;
            }
            matchedLen = 0;
            int subPatternLen = (int)Math.min(32512L, patternLen - (long)matchedLen);
            byte[] subPattern = new byte[subPatternLen];
            LobPlsqlUtil.read(conn, subLob, type, matchedLen + 1, subPatternLen, subPattern);
            long subMatchedPos = LobPlsqlUtil.hasPattern(conn, lob, type, subPattern, subStartPos);
            if (subMatchedPos == 0L) {
                return 0L;
            }
            matchedPos = subMatchedPos;
            matchedLen += subPatternLen;
            subStartPos = subMatchedPos + (long)subPatternLen;
            boolean moreChunks = true;
            while (moreChunks) {
                subPatternLen = (int)Math.min(32512L, patternLen - (long)matchedLen);
                subPattern = new byte[subPatternLen];
                LobPlsqlUtil.read(conn, subLob, type, matchedLen + 1, subPatternLen, subPattern);
                subMatchedPos = LobPlsqlUtil.hasPattern(conn, lob, type, subPattern, subStartPos);
                if (subMatchedPos == subStartPos) {
                    subStartPos += (long)subPatternLen;
                    if ((long)(matchedLen += subPatternLen) != patternLen) continue;
                    moreChunks = false;
                    done = true;
                    continue;
                }
                if (subMatchedPos == 0L) {
                    return 0L;
                }
                subStartPos = subMatchedPos - (long)matchedLen;
                moreChunks = false;
            }
        }
        return matchedPos;
    }

    private static boolean isNCLOB(Datum lob) {
        Class<?> cl = null;
        try {
            cl = Class.forName("oracle.sql.CLOB");
        }
        catch (ClassNotFoundException exp) {
            CommonDiagnosable.getInstance().debug(Level.FINE, SecurityLabel.UNKNOWN, CLASS_NAME, "isNCLOB", "Could not find class oracle.sql.CLOB : {0}", (String)null, exp, (Object)exp.getMessage());
            return false;
        }
        if (!cl.isInstance(lob)) {
            return false;
        }
        CLOB clob = (CLOB)lob;
        return clob.isNCLOB();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Datum createTemporaryLob(Connection conn, boolean cache, int duration, int type, short form_of_use) throws SQLException {
        Statement cstmt = null;
        Datum ret = null;
        try {
            cstmt = (OracleCallableStatement)conn.prepareCall("begin sys.dbms_lob.createTemporary (:1," + (cache ? "TRUE" : "FALSE") + ", :2); end;");
            cstmt.registerOutParameter(1, type);
            cstmt.setFormOfUse(1, form_of_use);
            cstmt.setInt(2, duration);
            cstmt.execute();
            ret = cstmt.getOracleObject(1);
        }
        finally {
            if (cstmt != null) {
                cstmt.close();
                cstmt = null;
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void freeTemporaryLob(Connection conn, Datum temp_lob, int type) throws SQLException {
        OracleCallableStatement cstmt = null;
        try {
            cstmt = (OracleCallableStatement)conn.prepareCall("begin sys.dbms_lob.freeTemporary (:1); end;");
            cstmt.registerOutParameter(1, type);
            if (LobPlsqlUtil.isNCLOB(temp_lob)) {
                cstmt.setFormOfUse(1, (short)2);
            }
            cstmt.setOracleObject(1, temp_lob);
            cstmt.execute();
            Datum ret = cstmt.getOracleObject(1);
            byte[] locator = ret.shareBytes();
            temp_lob.setShareBytes(locator);
        }
        finally {
            if (cstmt != null) {
                cstmt.close();
                cstmt = null;
            }
        }
    }
}

