/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.sql.SQLException;
import oracle.jdbc.aq.AQDequeueOptions;
import oracle.jdbc.aq.AQEnqueueOptions;
import oracle.jdbc.aq.AQMessage;
import oracle.jdbc.driver.AQMessageI;
import oracle.jdbc.driver.AQMessagePropertiesI;
import oracle.jdbc.driver.JMSMessagePropertiesI;
import oracle.jdbc.driver.T4CConnection;
import oracle.jdbc.driver.T4CTTIaqi;
import oracle.jdbc.driver.T4CTTIaqo;
import oracle.jdbc.driver.T4CTTIfun;
import oracle.jdbc.internal.JMSDequeueOptions;
import oracle.jdbc.internal.JMSEnqueueOptions;
import oracle.jdbc.internal.JMSFactory;
import oracle.jdbc.internal.JMSMessage;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.THIN_INTERNAL})
class T4CTTCaqa
extends T4CTTIfun {
    static final int AQXDEF_ENQ = 1;
    static final int AQXDEF_DEQ = 2;
    static final int AQXDEF_ARR = 3;
    static final int AQXDEF_RETMID = 1;
    static final int AQXDEF_DYNDAT = 2;
    static final int AQXDEF_ORGMID = 4;
    T4CConnection connection;
    T4CTTIaqi[] aqiArray;
    T4CTTIaqo[] aqoArray;
    private long aqxrflg = 0L;
    private int aqxaqopt = 0;
    private long aqxiters = 0L;
    private JMSEnqueueOptions jmsEnqueueOptions;
    private AQMessagePropertiesI[] messageProperties;
    private JMSMessage[] jmsMesgs;
    private boolean isAQMsgs = false;
    private AQMessage[] aqMesgs;
    private AQEnqueueOptions aqEnqueueOptions;
    private JMSDequeueOptions jmsDequeueOptions = null;
    private AQDequeueOptions aqDequeueOptions = null;

    T4CTTCaqa(T4CConnection t4CConnection) throws IOException, SQLException {
        super(t4CConnection, (byte)3);
        this.setFunCode((short)145);
        this.connection = t4CConnection;
    }

    int doJMSEnq(String string, JMSEnqueueOptions jMSEnqueueOptions, JMSMessage[] jMSMessageArray, AQMessagePropertiesI[] aQMessagePropertiesIArray) throws SQLException, IOException {
        this.jmsEnqueueOptions = jMSEnqueueOptions;
        this.messageProperties = aQMessagePropertiesIArray;
        this.jmsMesgs = jMSMessageArray;
        this.aqxaqopt = 1;
        this.isAQMsgs = false;
        this.aqxiters = jMSMessageArray.length;
        this.aqEnqueueOptions = null;
        this.aqMesgs = null;
        this.aqiArray = new T4CTTIaqi[(int)this.aqxiters];
        int n2 = 0;
        while ((long)n2 < this.aqxiters) {
            this.aqiArray[n2] = new T4CTTIaqi(this.connection, this.aqxaqopt, string, jMSEnqueueOptions, jMSMessageArray[n2], aQMessagePropertiesIArray[n2], jMSMessageArray[n2].getJMSMessageProperties(), null);
            ++n2;
        }
        this.setFlag();
        this.doRPC();
        return (int)this.aqxiters;
    }

    JMSMessage[] doJMSDeq(String string, JMSDequeueOptions jMSDequeueOptions, int n2, AQMessagePropertiesI[] aQMessagePropertiesIArray, JMSMessagePropertiesI jMSMessagePropertiesI) throws SQLException, IOException {
        this.jmsEnqueueOptions = null;
        this.messageProperties = aQMessagePropertiesIArray;
        JMSMessage[] jMSMessageArray = null;
        this.aqxaqopt = 2;
        this.isAQMsgs = false;
        this.aqxiters = n2;
        this.jmsDequeueOptions = jMSDequeueOptions;
        this.aqEnqueueOptions = null;
        this.aqMesgs = null;
        this.aqDequeueOptions = null;
        this.aqiArray = new T4CTTIaqi[(int)this.aqxiters];
        int n3 = 0;
        while ((long)n3 < this.aqxiters) {
            this.aqiArray[n3] = new T4CTTIaqi(this.connection, this.aqxaqopt, string, null, null, aQMessagePropertiesIArray[n3], jMSMessagePropertiesI, jMSDequeueOptions);
            ++n3;
        }
        this.setFlag();
        this.doRPC();
        if (this.aqoArray != null && this.aqoArray.length > 0) {
            jMSMessageArray = new JMSMessage[this.aqoArray.length];
            for (n3 = 0; n3 < this.aqoArray.length; ++n3) {
                JMSMessage jMSMessage = JMSFactory.createJMSMessage(jMSMessagePropertiesI);
                jMSMessage.setPayload(this.aqoArray[n3].getPayload());
                jMSMessage.setMessageId(this.aqoArray[n3].getMsgId());
                jMSMessage.setJMSMessageProperties(jMSMessagePropertiesI);
                jMSMessage.setAQMessageProperties(aQMessagePropertiesIArray[n3]);
                jMSMessageArray[n3] = jMSMessage;
            }
        }
        return jMSMessageArray;
    }

    int doAQEnq(String string, AQEnqueueOptions aQEnqueueOptions, AQMessage[] aQMessageArray) throws SQLException, IOException {
        this.aqEnqueueOptions = aQEnqueueOptions;
        this.aqMesgs = aQMessageArray;
        this.aqxaqopt = 1;
        this.isAQMsgs = true;
        this.aqxiters = aQMessageArray.length;
        this.jmsEnqueueOptions = null;
        this.jmsMesgs = null;
        this.aqDequeueOptions = null;
        this.jmsDequeueOptions = null;
        this.aqiArray = new T4CTTIaqi[(int)this.aqxiters];
        this.messageProperties = new AQMessagePropertiesI[(int)this.aqxiters];
        int n2 = 0;
        while ((long)n2 < this.aqxiters) {
            AQMessageI aQMessageI = (AQMessageI)aQMessageArray[n2];
            this.messageProperties[n2] = aQMessageI.getMessagePropertiesI();
            this.aqiArray[n2] = new T4CTTIaqi(this.connection, this.aqxaqopt, string, aQEnqueueOptions, aQMessageArray[n2], aQMessageI.getMessagePropertiesI(), null, null, 0);
            ++n2;
        }
        this.setFlag();
        this.doRPC();
        return (int)this.aqxiters;
    }

    AQMessage[] doAQDeq(String string, AQDequeueOptions aQDequeueOptions, byte[] byArray, int n2, int n3, AQMessagePropertiesI[] aQMessagePropertiesIArray) throws SQLException, IOException {
        AQMessageI[] aQMessageIArray = null;
        this.aqEnqueueOptions = null;
        this.messageProperties = aQMessagePropertiesIArray;
        this.aqxaqopt = 2;
        this.isAQMsgs = true;
        this.aqxiters = n3;
        this.aqDequeueOptions = aQDequeueOptions;
        this.jmsEnqueueOptions = null;
        this.jmsMesgs = null;
        this.jmsDequeueOptions = null;
        this.aqiArray = new T4CTTIaqi[(int)this.aqxiters];
        int n4 = 0;
        while ((long)n4 < this.aqxiters) {
            this.aqiArray[n4] = new T4CTTIaqi(this.connection, this.aqxaqopt, string, null, null, aQMessagePropertiesIArray[n4], aQDequeueOptions, byArray, n2);
            ++n4;
        }
        this.setFlag();
        this.doRPC();
        if (this.aqoArray != null && this.aqoArray.length > 0) {
            aQMessageIArray = new AQMessageI[this.aqoArray.length];
            for (n4 = 0; n4 < this.aqoArray.length; ++n4) {
                AQMessageI aQMessageI = new AQMessageI(aQMessagePropertiesIArray[n4], this.connection);
                aQMessageI.setPayload(this.aqoArray[n4].getPayload(), byArray);
                aQMessageI.setMessageId(this.aqoArray[n4].getMsgId());
                aQMessageIArray[n4] = aQMessageI;
            }
        }
        return aQMessageIArray;
    }

    void setFlag() {
        boolean bl;
        if (this.aqxaqopt == 1) {
            bl = !this.isAQMsgs && this.jmsEnqueueOptions.isRetrieveMessageId() || this.isAQMsgs && this.aqEnqueueOptions.getRetrieveMessageId();
        } else {
            boolean bl2 = bl = !this.isAQMsgs && this.jmsDequeueOptions.isRetrieveMessageId() || this.isAQMsgs && this.aqDequeueOptions.getRetrieveMessageId();
        }
        if (bl) {
            this.aqxrflg |= 1L;
        }
    }

    @Override
    void marshal() throws IOException {
        if (this.aqxaqopt == 1) {
            this.meg.marshalNULLPTR();
            this.meg.marshalSWORD(0);
        } else if (this.aqiArray != null && this.aqiArray.length != 0) {
            this.meg.marshalPTR();
            this.meg.marshalSWORD(this.aqiArray.length);
        } else {
            this.meg.marshalNULLPTR();
            this.meg.marshalSWORD(0);
        }
        this.meg.marshalUB4(this.aqxrflg);
        if (this.aqxaqopt == 1) {
            this.meg.marshalPTR();
            this.meg.marshalUB4(0L);
        } else {
            this.meg.marshalPTR();
            this.meg.marshalPTR();
        }
        if (this.isAQMsgs) {
            this.meg.marshalSB4(this.aqxaqopt);
        } else if (this.aqxaqopt == 1) {
            this.meg.marshalSB4(3);
        } else {
            this.meg.marshalSB4(this.aqxaqopt);
        }
        if (this.aqxaqopt == 1) {
            this.meg.marshalPTR();
            this.meg.marshalUB4(this.aqxiters);
        } else {
            this.meg.marshalNULLPTR();
        }
        if (this.aqiArray != null && this.aqiArray.length != 0) {
            if (this.aqxaqopt == 1) {
                this.aqiArray[0].marshalPropagation();
                this.aqiArray[0].marshalHeader();
                for (int i2 = 0; i2 < this.aqiArray.length; ++i2) {
                    if (this.isAQMsgs) {
                        this.aqiArray[i2].marshalData();
                        continue;
                    }
                    this.aqiArray[i2].marshalJmsData();
                }
                this.aqiArray[0].marshalDone();
            } else {
                for (int i3 = 0; i3 < this.aqiArray.length; ++i3) {
                    this.aqiArray[i3].marshal();
                }
            }
        }
    }

    @Override
    void readRPA() throws SQLException, IOException {
        this.unmarshal();
    }

    void unmarshal() throws SQLException, IOException {
        int n2 = (int)this.meg.unmarshalUB4();
        if (n2 > 0) {
            int n3;
            this.aqoArray = new T4CTTIaqo[n2];
            for (n3 = 0; n3 < n2; ++n3) {
                this.aqoArray[n3] = this.isAQMsgs ? new T4CTTIaqo(this.connection, this.aqxaqopt, this.aqEnqueueOptions, this.messageProperties[n3], this.aqDequeueOptions, this.aqiArray[n3].isRawQueue()) : new T4CTTIaqo(this.connection, this.aqxaqopt, this.jmsEnqueueOptions, this.messageProperties[n3], this.jmsDequeueOptions, this.aqiArray[n3].isRawQueue());
                this.aqoArray[n3].unmarshal();
            }
            if (this.aqxaqopt == 1) {
                byte[] byArray;
                int n4 = n3 = !this.isAQMsgs && this.jmsEnqueueOptions.isRetrieveMessageId() || this.isAQMsgs && this.aqEnqueueOptions.getRetrieveMessageId() ? 1 : 0;
                if (n3 != 0 && (byArray = this.aqoArray[0].getMsgId()) != null && this.aqxiters * 16L == (long)byArray.length) {
                    int n5 = 0;
                    while ((long)n5 < this.aqxiters) {
                        byte[] byArray2 = new byte[16];
                        System.arraycopy(byArray, n5 * 16, byArray2, 0, 16);
                        if (this.isAQMsgs) {
                            ((AQMessageI)this.aqMesgs[n5]).setMessageId(byArray2);
                        } else {
                            this.jmsMesgs[n5].setMessageId(byArray2);
                        }
                        ++n5;
                    }
                }
            }
        } else {
            this.aqoArray = null;
        }
        this.aqxiters = this.aqxaqopt == 1 ? this.meg.unmarshalUB4() : (long)n2;
    }
}

