/*
 * Decompiled with CFR 0.152.
 */
package oracle.ons;

import java.io.IOException;
import oracle.ons.Connection;
import oracle.ons.InputBuffer;
import oracle.ons.NotificationProperty;
import oracle.ons.ONS;
import oracle.ons.OutputBuffer;
import oracle.ons.PropertyList;

public class Notification {
    protected static byte[] eventmessageline;
    protected static byte[] poststring;
    protected static byte[] headerseparator;
    protected static byte[] crlf;
    protected static byte[] versionheader;
    protected static byte[] versionheaderid;
    protected static byte[] typeheader;
    protected static byte[] affectedcomponentsheader;
    protected static byte[] affectednodesheader;
    protected static byte[] generatingcomponentheader;
    protected static byte[] generatingnodeheader;
    protected static byte[] generatingprocessheader;
    protected static byte[] idheader;
    protected static byte[] clusteridheader;
    protected static byte[] clusternameheader;
    protected static byte[] instanceidheader;
    protected static byte[] instancenameheader;
    protected static byte[] creationtimeheader;
    protected static byte[] contentlengthheader;
    protected static byte[] numpropertiesheader;
    protected static byte[] localonlyheader;
    protected static byte[] stampheader;
    protected static byte[] hostname;
    protected static byte[] truestring;
    protected static byte[] falsestring;
    protected static byte[] versionheaderid3;
    protected static byte[] clusteronlyheader;
    private String type;
    private String affectedComponents;
    private String affectedNodes;
    private byte[] body;
    protected boolean localonly;
    protected long deliveryTime;
    protected String generatingComponent;
    protected String generatingNode;
    protected String generatingProcess;
    protected String id;
    protected long creationTime;
    protected String clusterId;
    protected String clusterName;
    protected String instanceId;
    protected String instanceName;
    protected ONS oems;
    private boolean readonly;
    private PropertyList properties;
    protected int[] recipients;

    public Notification(String t, String c, String n, byte[] b) {
        this.type = t;
        this.affectedComponents = c;
        this.affectedNodes = n;
        this.body = b;
        this.generatingComponent = null;
        this.generatingProcess = null;
        this.id = null;
        this.creationTime = -1L;
        this.deliveryTime = -1L;
        this.properties = null;
        this.readonly = false;
        this.localonly = false;
        this.recipients = null;
        this.clusterId = null;
        this.clusterName = null;
        this.instanceId = null;
        this.instanceName = null;
        this.oems = ONS.getONS();
    }

    protected Notification(InputBuffer ibuf) throws IOException {
        int contentlength = 0;
        int numproperties = 0;
        boolean newFmt = false;
        String tmpstr = ibuf.getNextString();
        if (tmpstr.charAt(0) == 'o') {
            newFmt = true;
            tmpstr = ibuf.getNextString();
            tmpstr = ibuf.getNextString();
        }
        ibuf.skipBytes(typeheader.length);
        this.type = ibuf.getNextString();
        ibuf.skipBytes(affectedcomponentsheader.length);
        this.affectedComponents = ibuf.getNextString();
        ibuf.skipBytes(affectednodesheader.length);
        this.affectedNodes = ibuf.getNextString();
        ibuf.skipBytes(generatingcomponentheader.length);
        this.generatingComponent = ibuf.getNextString();
        ibuf.skipBytes(generatingprocessheader.length);
        this.generatingProcess = ibuf.getNextString();
        ibuf.skipBytes(generatingnodeheader.length);
        this.generatingNode = ibuf.getNextString();
        ibuf.skipBytes(idheader.length);
        this.id = ibuf.getNextString();
        ibuf.skipBytes(creationtimeheader.length);
        tmpstr = ibuf.getNextString();
        if (tmpstr != null) {
            try {
                this.creationTime = new Long(tmpstr);
            }
            catch (NumberFormatException nfe) {
                if (ONS.debug) {
                    ONS.errstream.println("Caught NumberFormatException trying to convert creationTime string " + tmpstr + " to long value");
                }
                throw new IOException();
            }
        } else {
            this.creationTime = -1L;
        }
        ibuf.skipBytes(clusteridheader.length);
        this.clusterId = ibuf.getNextString();
        ibuf.skipBytes(clusternameheader.length);
        this.clusterName = ibuf.getNextString();
        ibuf.skipBytes(instanceidheader.length);
        this.instanceId = ibuf.getNextString();
        ibuf.skipBytes(instancenameheader.length);
        this.instanceName = ibuf.getNextString();
        ibuf.skipBytes(localonlyheader.length);
        tmpstr = ibuf.getNextString();
        this.localonly = tmpstr != null ? tmpstr.equalsIgnoreCase("true") : false;
        if (!newFmt) {
            ibuf.getNextString();
        }
        ibuf.skipBytes(numpropertiesheader.length);
        tmpstr = ibuf.getNextString();
        if (tmpstr != null) {
            try {
                numproperties = new Integer(tmpstr);
            }
            catch (NumberFormatException nfe) {
                if (ONS.debug) {
                    ONS.errstream.println("Caught NumberFormatException trying to convert numproperties string " + tmpstr + " to int value");
                }
                throw new IOException();
            }
        } else {
            numproperties = 0;
        }
        this.properties = numproperties > 0 ? new PropertyList(numproperties, ibuf) : null;
        ibuf.skipBytes(contentlengthheader.length);
        tmpstr = ibuf.getNextString();
        if (tmpstr != null) {
            try {
                contentlength = new Integer(tmpstr);
            }
            catch (NumberFormatException nfe) {
                if (ONS.debug) {
                    ONS.errstream.println("Caught NumberFormatException trying to convert contentlength string " + tmpstr + " to int value");
                }
                throw new IOException();
            }
        } else {
            contentlength = 0;
        }
        ibuf.skipBytes(14);
        tmpstr = ibuf.getNextString();
        if (tmpstr != null) {
            int nextsemicolon;
            int numentries = 1;
            int curpos = 0;
            while ((nextsemicolon = tmpstr.indexOf(59, curpos)) != -1) {
                ++numentries;
                curpos = nextsemicolon + 1;
            }
            this.recipients = new int[numentries];
            curpos = 0;
            for (int i = 0; i < numentries; ++i) {
                nextsemicolon = tmpstr.indexOf(59, curpos);
                String s = nextsemicolon == -1 ? tmpstr.substring(curpos) : tmpstr.substring(curpos, nextsemicolon);
                try {
                    this.recipients[i] = Integer.parseInt(s);
                }
                catch (NumberFormatException e) {
                    this.recipients[i] = -1;
                }
                curpos = nextsemicolon + 1;
            }
        } else {
            this.recipients = null;
        }
        ibuf.skipBytes(2);
        if (contentlength > 0) {
            this.body = new byte[contentlength];
            ibuf.getBytes(this.body, contentlength);
        } else {
            this.body = null;
        }
        this.deliveryTime = System.currentTimeMillis();
    }

    protected void send(OutputBuffer obuf, Connection connection) throws IOException {
        if (ONS.debug) {
            ONS.outstream.println("Notification::send ==> obuf=" + obuf);
        }
        obuf.putBytes(eventmessageline, eventmessageline.length);
        obuf.putBytes(versionheader, versionheader.length);
        if (connection.getServerVersion() == 3) {
            obuf.putBytes(versionheaderid3, versionheaderid.length);
        } else {
            obuf.putBytes(versionheaderid, versionheaderid.length);
        }
        obuf.putBytes(crlf, 2);
        obuf.putBytes(typeheader, typeheader.length);
        if (this.type != null) {
            obuf.putString(this.type);
        }
        obuf.putBytes(crlf, 2);
        obuf.putBytes(affectedcomponentsheader, affectedcomponentsheader.length);
        if (this.affectedComponents != null) {
            obuf.putString(this.affectedComponents);
        }
        obuf.putBytes(crlf, 2);
        obuf.putBytes(affectednodesheader, affectednodesheader.length);
        if (this.affectedNodes != null) {
            obuf.putString(this.affectedNodes);
        }
        obuf.putBytes(crlf, 2);
        obuf.putBytes(generatingcomponentheader, generatingcomponentheader.length);
        if (this.generatingComponent != null) {
            obuf.putString(this.generatingComponent);
        }
        obuf.putBytes(crlf, 2);
        obuf.putBytes(generatingprocessheader, generatingprocessheader.length);
        if (this.generatingProcess != null) {
            obuf.putString(this.generatingProcess);
        }
        obuf.putBytes(crlf, 2);
        obuf.putBytes(generatingnodeheader, generatingnodeheader.length);
        if (this.generatingNode != null) {
            obuf.putString(this.generatingNode);
        }
        obuf.putBytes(crlf, 2);
        obuf.putBytes(idheader, idheader.length);
        if (this.id != null) {
            obuf.putString(this.id);
        }
        obuf.putBytes(crlf, 2);
        obuf.putBytes(creationtimeheader, creationtimeheader.length);
        byte[] b1 = new Long(this.creationTime).toString().getBytes();
        obuf.putBytes(b1, b1.length);
        obuf.putBytes(crlf, 2);
        obuf.putBytes(clusteridheader, clusteridheader.length);
        if (this.oems.clusterid != null) {
            obuf.putString(this.oems.clusterid);
        }
        obuf.putBytes(crlf, 2);
        obuf.putBytes(clusternameheader, clusternameheader.length);
        if (this.oems.clustername != null) {
            obuf.putString(this.oems.clustername);
        }
        obuf.putBytes(crlf, 2);
        obuf.putBytes(instanceidheader, instanceidheader.length);
        if (this.oems.instanceid != null) {
            obuf.putString(this.oems.instanceid);
        }
        obuf.putBytes(crlf, 2);
        obuf.putBytes(instancenameheader, instancenameheader.length);
        if (this.oems.instancename != null) {
            obuf.putString(this.oems.instancename);
        }
        obuf.putBytes(crlf, 2);
        obuf.putBytes(localonlyheader, localonlyheader.length);
        if (this.localonly) {
            obuf.putBytes(truestring, truestring.length);
        } else {
            obuf.putBytes(falsestring, falsestring.length);
        }
        obuf.putBytes(crlf, 2);
        if (connection.getServerVersion() == 3) {
            obuf.putBytes(clusteronlyheader, clusteronlyheader.length);
            obuf.putBytes(falsestring, falsestring.length);
            obuf.putBytes(crlf, 2);
        }
        obuf.putBytes(numpropertiesheader, numpropertiesheader.length);
        if (this.properties != null) {
            b1 = new Integer(this.properties.num()).toString().getBytes();
            obuf.putBytes(b1, b1.length);
            obuf.putBytes(crlf, 2);
            this.properties.write(obuf);
        } else {
            obuf.putByte((byte)48);
            obuf.putBytes(crlf, 2);
        }
        if (this.body != null) {
            obuf.putBytes(contentlengthheader, contentlengthheader.length);
            b1 = new Integer(this.body.length).toString().getBytes();
            obuf.putBytes(b1, b1.length);
            obuf.putBytes(crlf, 2);
        } else {
            obuf.putBytes(contentlengthheader, contentlengthheader.length);
            obuf.putByte((byte)48);
            obuf.putBytes(crlf, 2);
        }
        obuf.putBytes(crlf, 2);
        if (this.body != null) {
            obuf.putBytes(this.body, this.body.length);
        }
        obuf.flush();
    }

    public String type() {
        return this.type;
    }

    public String affectedComponents() {
        return this.affectedComponents;
    }

    public String affectedNodes() {
        return this.affectedNodes;
    }

    public String generatingComponent() {
        return this.generatingComponent;
    }

    public String generatingNode() {
        return this.generatingNode;
    }

    public String generatingProcess() {
        return this.generatingProcess;
    }

    public String clusterId() {
        return this.clusterId;
    }

    public String clusterName() {
        return this.clusterName;
    }

    public String instanceId() {
        return this.instanceId;
    }

    public String instanceName() {
        return this.instanceName;
    }

    public String id() {
        return this.id;
    }

    public long creationTime() {
        return this.creationTime;
    }

    public long deliveryTime() {
        return this.deliveryTime;
    }

    public void setProperty(String name, String value) {
        if (!this.readonly) {
            if (this.properties == null) {
                this.properties = new PropertyList();
            }
            if (this.hasInvalidNameCharacters(name)) {
                throw new IllegalArgumentException("name has invalid characters, ':', '\\r' and '\\n' are not allowed.");
            }
            if (this.hasInvalidValueCharacters(value)) {
                throw new IllegalArgumentException("value has invalid characters, '\\r' and '\\n' are not allowed.");
            }
            this.properties.put(name, value);
        }
    }

    private boolean hasInvalidNameCharacters(String value) {
        boolean retVal = false;
        if (value != null) {
            for (int i = 0; i < value.length(); ++i) {
                char c = value.charAt(i);
                if (c != ':' && c != '\r' && c != '\n') continue;
                retVal = true;
                break;
            }
        }
        return retVal;
    }

    private boolean hasInvalidValueCharacters(String value) {
        boolean retVal = false;
        if (value != null) {
            for (int i = 0; i < value.length(); ++i) {
                char c = value.charAt(i);
                if (c != '\r' && c != '\n') continue;
                retVal = true;
                break;
            }
        }
        return retVal;
    }

    public String getProperty(String name) {
        String ret = null;
        if (this.properties != null) {
            ret = this.properties.get(name);
        }
        return ret;
    }

    public NotificationProperty[] getAllProperties() {
        if (this.properties != null) {
            return this.properties.getAll();
        }
        return null;
    }

    public byte[] body() {
        return this.body;
    }

    public void setLocalOnly() {
        this.localonly = true;
    }

    public boolean getLocalOnly() {
        return this.localonly;
    }

    public void print() {
        ONS.outstream.println("Notification Type:         " + this.type);
        ONS.outstream.println("Affected Components:       " + this.affectedComponents);
        ONS.outstream.println("Affected Nodes:            " + this.affectedNodes);
        ONS.outstream.println("Delivery Time:             " + this.deliveryTime);
        ONS.outstream.println("Generating Component:      " + this.generatingComponent);
        ONS.outstream.println("Generating Node:           " + this.generatingNode);
        ONS.outstream.println("Generating Process:        " + this.generatingProcess);
        ONS.outstream.println("Notification ID:           " + this.id);
        ONS.outstream.println("Notification Creation Time:" + this.creationTime);
        ONS.outstream.println("Cluster ID:                " + this.clusterId);
        ONS.outstream.println("Cluster Name:              " + this.clusterName);
        ONS.outstream.println("Instance ID:               " + this.instanceId);
        ONS.outstream.println("Instance Name:             " + this.instanceName);
        if (this.localonly) {
            ONS.outstream.println("Local Only Flag:           TRUE");
        } else {
            ONS.outstream.println("Local Only Flag:           FALSE");
        }
        if (this.properties != null) {
            this.properties.print();
        }
        ONS.outstream.println("Body:                      " + this.body);
    }

    static {
        crlf = new byte[2];
        Notification.crlf[0] = 13;
        Notification.crlf[1] = 10;
        eventmessageline = new byte[22];
        System.arraycopy(new String("POST /event HTTP/1.1").getBytes(), 0, eventmessageline, 0, 20);
        System.arraycopy(crlf, 0, eventmessageline, 20, 2);
        poststring = new String("POST ").getBytes();
        headerseparator = new String(": ").getBytes();
        versionheader = new String("Version: ").getBytes();
        versionheaderid = new String(Integer.toString(4)).getBytes();
        typeheader = new String("eventType: ").getBytes();
        affectedcomponentsheader = new String("affectedComponents: ").getBytes();
        affectednodesheader = new String("affectedNodes: ").getBytes();
        generatingcomponentheader = new String("generatingComponent: ").getBytes();
        generatingnodeheader = new String("generatingNode: ").getBytes();
        generatingprocessheader = new String("generatingProcess: ").getBytes();
        idheader = new String("eventId: ").getBytes();
        clusteridheader = new String("clusterId: ").getBytes();
        clusternameheader = new String("clusterName: ").getBytes();
        instanceidheader = new String("instanceId: ").getBytes();
        instancenameheader = new String("instanceName: ").getBytes();
        creationtimeheader = new String("creationTime: ").getBytes();
        contentlengthheader = new String("Content-Length: ").getBytes();
        numpropertiesheader = new String("numberOfProperties: ").getBytes();
        localonlyheader = new String("LocalOnly: ").getBytes();
        stampheader = new String("stamp: ").getBytes();
        hostname = new String("hostName: ").getBytes();
        truestring = new String("true").getBytes();
        falsestring = new String("false").getBytes();
        versionheaderid3 = new String("3").getBytes();
        clusteronlyheader = new String("ClusterOnly: ").getBytes();
    }
}

