/*
 * Decompiled with CFR 0.152.
 */
package com.openhtmltopdf.bidi.support;

import com.ibm.icu.lang.UCharacter;
import com.openhtmltopdf.extend.FSTextTransformer;
import java.util.Locale;

public class ICUTransformers {
    private ICUTransformers() {
    }

    public static class ICUToTitleTransformer
    implements FSTextTransformer {
        private final Locale lc;

        public ICUToTitleTransformer(Locale lc) {
            this.lc = lc;
        }

        public String transform(String in) {
            return UCharacter.toTitleCase((Locale)this.lc, (String)in, null, (int)256);
        }
    }

    public static class ICUToUpperTransformer
    implements FSTextTransformer {
        private final Locale lc;

        public ICUToUpperTransformer(Locale lc) {
            this.lc = lc;
        }

        public String transform(String in) {
            return UCharacter.toUpperCase((Locale)this.lc, (String)in);
        }
    }

    public static class ICUToLowerTransformer
    implements FSTextTransformer {
        private final Locale lc;

        public ICUToLowerTransformer(Locale lc) {
            this.lc = lc;
        }

        public String transform(String in) {
            return UCharacter.toLowerCase((Locale)this.lc, (String)in);
        }
    }
}

