/*
 * Decompiled with CFR 0.152.
 */
package com.openhtmltopdf.pdfboxout;

import com.openhtmltopdf.bidi.BidiReorderer;
import com.openhtmltopdf.extend.FSGlyphVector;
import com.openhtmltopdf.extend.FontContext;
import com.openhtmltopdf.extend.OutputDevice;
import com.openhtmltopdf.extend.TextRenderer;
import com.openhtmltopdf.pdfboxout.PdfBoxFSFont;
import com.openhtmltopdf.pdfboxout.PdfBoxFSFontMetrics;
import com.openhtmltopdf.pdfboxout.PdfBoxFontResolver;
import com.openhtmltopdf.pdfboxout.PdfBoxOutputDevice;
import com.openhtmltopdf.pdfboxout.PdfBoxRawPDFontMetrics;
import com.openhtmltopdf.pdfboxout.PdfBoxSlowOutputDevice;
import com.openhtmltopdf.pdfboxout.PdfContentStreamAdapter;
import com.openhtmltopdf.render.FSFont;
import com.openhtmltopdf.render.FSFontMetrics;
import com.openhtmltopdf.render.JustificationInfo;
import com.openhtmltopdf.util.OpenUtil;
import com.openhtmltopdf.util.ThreadCtx;
import com.openhtmltopdf.util.XRLog;
import java.awt.Rectangle;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;

public class PdfBoxTextRenderer
implements TextRenderer {
    private static float TEXT_MEASURING_DELTA = 0.01f;
    private BidiReorderer _reorderer;

    public void setup(FontContext context, BidiReorderer reorderer) {
        this._reorderer = reorderer;
    }

    public void drawString(OutputDevice outputDevice, String string, float x, float y) {
        ((PdfBoxOutputDevice)outputDevice).drawString(string, x, y, null);
    }

    public void drawString(OutputDevice outputDevice, String string, float x, float y, JustificationInfo info) {
        ((PdfBoxOutputDevice)outputDevice).drawString(string, x, y, info);
    }

    public FSFontMetrics getFSFontMetrics(FontContext context, FSFont font, String string) {
        List<PdfBoxFontResolver.FontDescription> descrs = ((PdfBoxFSFont)font).getFontDescription();
        float size = font.getSize2D();
        PdfBoxFSFontMetrics result = new PdfBoxFSFontMetrics();
        float largestAscent = -3.4028235E38f;
        float largestDescent = -3.4028235E38f;
        float largestStrikethroughOffset = -3.4028235E38f;
        float largestStrikethroughThickness = -3.4028235E38f;
        float largestUnderlinePosition = -3.4028235E38f;
        float largestUnderlineThickness = -3.4028235E38f;
        for (PdfBoxFontResolver.FontDescription des : descrs) {
            PdfBoxRawPDFontMetrics metrics = des.getFontMetrics();
            if (metrics == null) {
                XRLog.exception((String)"Font metrics not available. Probably a bug.");
                continue;
            }
            float loopAscent = metrics._ascent;
            float loopDescent = metrics._descent;
            float loopStrikethroughOffset = metrics._strikethroughOffset;
            float loopStrikethroughThickness = metrics._strikethroughThickness;
            float loopUnderlinePosition = metrics._underlinePosition;
            float loopUnderlineThickness = metrics._underlineThickness;
            if (loopAscent > largestAscent) {
                largestAscent = loopAscent;
            }
            if (loopDescent > largestDescent) {
                largestDescent = loopDescent;
            }
            if (loopStrikethroughOffset > largestStrikethroughOffset) {
                largestStrikethroughOffset = loopStrikethroughOffset;
            }
            if (loopStrikethroughThickness > largestStrikethroughThickness) {
                largestStrikethroughThickness = loopStrikethroughThickness;
            }
            if (loopUnderlinePosition > largestUnderlinePosition) {
                largestUnderlinePosition = loopUnderlinePosition;
            }
            if (!(loopUnderlineThickness > largestUnderlineThickness)) continue;
            largestUnderlineThickness = loopUnderlineThickness;
        }
        result.setAscent(largestAscent / 1000.0f * size);
        result.setDescent(largestDescent / 1000.0f * size);
        result.setStrikethroughOffset(largestStrikethroughOffset / 1000.0f * size);
        if (largestStrikethroughThickness > 0.0f) {
            result.setStrikethroughThickness(largestStrikethroughThickness / 1000.0f * size);
        } else {
            result.setStrikethroughThickness(size / 12.0f);
        }
        result.setUnderlineOffset(largestUnderlinePosition / 1000.0f * size);
        result.setUnderlineThickness(largestUnderlineThickness / 1000.0f * size);
        return result;
    }

    public static boolean isJustificationSpace(int c) {
        return c == 32 || c == 160 || c == 12288;
    }

    private static ReplacementChar getReplacementChar(FSFont font) {
        String replaceStr = ThreadCtx.get().sharedContext().getReplacementText();
        List<PdfBoxFontResolver.FontDescription> descriptions = ((PdfBoxFSFont)font).getFontDescription();
        for (PdfBoxFontResolver.FontDescription des : descriptions) {
            try {
                des.getFont().getStringWidth(replaceStr);
                ReplacementChar replace = new ReplacementChar();
                replace.replacement = replaceStr;
                replace.fontDescription = des;
                return replace;
            }
            catch (Exception replace) {
            }
        }
        replaceStr = " ";
        for (PdfBoxFontResolver.FontDescription des : descriptions) {
            try {
                des.getFont().getStringWidth(replaceStr);
                ReplacementChar replace = new ReplacementChar();
                replace.replacement = " ";
                replace.fontDescription = des;
                return replace;
            }
            catch (Exception exception) {
            }
        }
        XRLog.general((String)"Specified fonts don't contain a space character!");
        ReplacementChar replace = new ReplacementChar();
        replace.replacement = "";
        replace.fontDescription = descriptions.get(0);
        return replace;
    }

    public static List<PdfBoxSlowOutputDevice.FontRun> divideIntoFontRuns(FSFont font, String str, BidiReorderer reorderer) {
        StringBuilder sb = new StringBuilder();
        ReplacementChar replace = PdfBoxTextRenderer.getReplacementChar(font);
        List<PdfBoxFontResolver.FontDescription> fonts = ((PdfBoxFSFont)font).getFontDescription();
        ArrayList<PdfBoxSlowOutputDevice.FontRun> runs = new ArrayList<PdfBoxSlowOutputDevice.FontRun>();
        PdfBoxSlowOutputDevice.FontRun current = new PdfBoxSlowOutputDevice.FontRun();
        int i = 0;
        while (i < str.length()) {
            int unicode = str.codePointAt(i);
            i += Character.charCount(unicode);
            String ch = String.valueOf(Character.toChars(unicode));
            boolean gotChar = false;
            for (PdfBoxFontResolver.FontDescription des : fonts) {
                try {
                    des.getFont().getStringWidth(ch);
                    if (current.des == null) {
                        current.des = des;
                    } else if (des != current.des) {
                        current.str = sb.toString();
                        runs.add(current);
                        current = new PdfBoxSlowOutputDevice.FontRun();
                        current.des = des;
                        sb = new StringBuilder();
                    }
                    if (PdfBoxTextRenderer.isJustificationSpace(unicode)) {
                        ++current.spaceCharacterCount;
                    } else {
                        ++current.otherCharacterCount;
                    }
                    sb.append(ch);
                    gotChar = true;
                    break;
                }
                catch (Exception e1) {
                    if (!reorderer.isLiveImplementation()) continue;
                    String deshaped = reorderer.deshapeText(ch);
                    try {
                        des.getFont().getStringWidth(deshaped);
                        if (current.des == null) {
                            current.des = des;
                        } else if (des != current.des) {
                            current.str = sb.toString();
                            runs.add(current);
                            current = new PdfBoxSlowOutputDevice.FontRun();
                            current.des = des;
                            sb = new StringBuilder();
                        }
                        if (PdfBoxTextRenderer.isJustificationSpace(unicode)) {
                            ++current.spaceCharacterCount;
                        } else {
                            ++current.otherCharacterCount;
                        }
                        sb.append(deshaped);
                        gotChar = true;
                        break;
                    }
                    catch (Exception exception) {
                    }
                }
            }
            if (gotChar) continue;
            if (current.des == null) {
                current.des = replace.fontDescription;
            } else if (replace.fontDescription != current.des) {
                current.str = sb.toString();
                runs.add(current);
                current = new PdfBoxSlowOutputDevice.FontRun();
                current.des = replace.fontDescription;
                sb = new StringBuilder();
            }
            if (Character.isSpaceChar(unicode) || Character.isWhitespace(unicode)) {
                ++current.spaceCharacterCount;
                sb.append(' ');
                continue;
            }
            if (!OpenUtil.isCodePointPrintable((int)unicode)) continue;
            ++current.otherCharacterCount;
            sb.append(replace.replacement);
        }
        if (sb.length() > 0) {
            current.str = sb.toString();
            runs.add(current);
        }
        return runs;
    }

    private float getStringWidthSlow(FSFont bf, String str) {
        List<PdfBoxSlowOutputDevice.FontRun> runs = PdfBoxTextRenderer.divideIntoFontRuns(bf, str, this._reorderer);
        float strWidth = 0.0f;
        for (PdfBoxSlowOutputDevice.FontRun run : runs) {
            try {
                strWidth += run.des.getFont().getStringWidth(run.str);
            }
            catch (Exception e) {
                XRLog.render((Level)Level.WARNING, (String)"BUG. Font didn't contain expected character.", (Throwable)e);
            }
        }
        return strWidth;
    }

    public int getWidth(FontContext context, FSFont font, String string) {
        float result;
        block7: {
            result = 0.0f;
            try {
                if (((PdfBoxFSFont)font).getFontDescription() == null || ((PdfBoxFSFont)font).getFontDescription().isEmpty()) {
                    XRLog.render((Level)Level.WARNING, (String)"Font list is empty.");
                    break block7;
                }
                for (PdfBoxFontResolver.FontDescription fd : ((PdfBoxFSFont)font).getFontDescription()) {
                    if (fd.getFont() != null) {
                        result = fd.getFont().getStringWidth(string) / 1000.0f * font.getSize2D();
                        break;
                    }
                    XRLog.render((Level)Level.WARNING, (String)"Font is null.");
                }
            }
            catch (IllegalArgumentException e2) {
                result = this.getStringWidthSlow(font, string) / 1000.0f * font.getSize2D();
            }
            catch (IOException e) {
                throw new PdfContentStreamAdapter.PdfException("getWidth", e);
            }
        }
        if ((double)result - Math.floor(result) < (double)TEXT_MEASURING_DELTA) {
            return (int)result;
        }
        return (int)Math.ceil(result);
    }

    public void setFontScale(float scale) {
        throw new UnsupportedOperationException();
    }

    public float getFontScale() {
        return 1.0f;
    }

    public void setSmoothingThreshold(float fontsize) {
    }

    public int getSmoothingLevel() {
        return 0;
    }

    public void setSmoothingLevel(int level) {
    }

    public Rectangle getGlyphBounds(OutputDevice outputDevice, FSFont font, FSGlyphVector fsGlyphVector, int index, float x, float y) {
        throw new UnsupportedOperationException();
    }

    public float[] getGlyphPositions(OutputDevice outputDevice, FSFont font, FSGlyphVector fsGlyphVector) {
        throw new UnsupportedOperationException();
    }

    public FSGlyphVector getGlyphVector(OutputDevice outputDevice, FSFont font, String string) {
        throw new UnsupportedOperationException();
    }

    public void drawGlyphVector(OutputDevice outputDevice, FSGlyphVector vector, float x, float y) {
        throw new UnsupportedOperationException();
    }

    public void setup(FontContext context) {
    }

    private static class ReplacementChar {
        String replacement;
        PdfBoxFontResolver.FontDescription fontDescription;

        private ReplacementChar() {
        }
    }
}

