/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.jdbc.internal.com.read.resultset;

import com.oceanbase.jdbc.internal.com.read.dao.Results;
import com.oceanbase.jdbc.internal.com.read.resultset.ColumnDefinition;
import com.oceanbase.jdbc.internal.com.read.resultset.CursorResultSet;
import com.oceanbase.jdbc.internal.protocol.Protocol;
import java.io.IOException;
import java.sql.SQLException;

public class SensitiveCursorResultSet
extends CursorResultSet {
    private int lastRefetchBeginIndex;
    private int lastRefetchEndIndex;

    public SensitiveCursorResultSet(ColumnDefinition[] columnsInformation, Results results, Protocol protocol, boolean callableResult, boolean eofDeprecated, boolean isPsOutParamter) throws IOException, SQLException {
        super(columnsInformation, results, protocol, callableResult, eofDeprecated, isPsOutParamter);
        if (this.protocol.supportStmtPrepareExecute()) {
            this.lastRefetchBeginIndex = 0;
            this.lastRefetchEndIndex = this.fetchSize - 1;
        } else {
            this.lastRefetchBeginIndex = -1;
            this.lastRefetchEndIndex = -1;
        }
    }

    @Override
    public boolean next() throws SQLException {
        if (super.next()) {
            this.needRefetch();
            return true;
        }
        return false;
    }

    @Override
    public boolean previous() throws SQLException {
        if (super.previous()) {
            this.needRefetch();
            return true;
        }
        return false;
    }

    @Override
    public boolean first() throws SQLException {
        if (super.first()) {
            this.needRefetch();
            return true;
        }
        return false;
    }

    @Override
    public boolean last() throws SQLException {
        if (super.last()) {
            this.needRefetch();
            return true;
        }
        return false;
    }

    @Override
    public boolean absolute(int row) throws SQLException {
        if (super.absolute(row)) {
            this.needRefetch();
            return true;
        }
        return false;
    }

    @Override
    public boolean relative(int row) throws SQLException {
        if (super.relative(row)) {
            this.needRefetch();
            return true;
        }
        return false;
    }

    private boolean needRefetch() throws SQLException {
        if (this.rowPointer < this.lastRefetchBeginIndex && this.rowPointer < this.lastRefetchEndIndex || this.rowPointer > this.lastRefetchEndIndex && this.rowPointer > this.lastRefetchBeginIndex) {
            this.refreshRow();
            return true;
        }
        return false;
    }

    @Override
    public void refreshRow() throws SQLException {
        if (!this.checkRefreshable()) {
            return;
        }
        int refetchSize = this.refreshRowInternalOracle(this.fetchSize);
        this.lastRefetchBeginIndex = this.rowPointer;
        this.lastRefetchEndIndex = this.rowPointer + refetchSize - 1;
    }
}

