/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.jdbc.internal.com.read.resultset;

import com.oceanbase.jdbc.ServerSidePreparedStatement;
import com.oceanbase.jdbc.extend.datatype.RowObCursorData;
import com.oceanbase.jdbc.internal.com.read.dao.ColumnLabelIndexer;
import com.oceanbase.jdbc.internal.com.read.dao.Results;
import com.oceanbase.jdbc.internal.com.read.resultset.ColumnDefinition;
import com.oceanbase.jdbc.internal.com.read.resultset.CursorResultSet;
import com.oceanbase.jdbc.internal.com.read.resultset.rowprotocol.BinaryRowProtocol;
import com.oceanbase.jdbc.internal.protocol.Protocol;
import java.io.IOException;
import java.sql.SQLException;

public class RefCursor
extends CursorResultSet {
    private RowObCursorData rowObCursorData;

    public RefCursor(ColumnDefinition[] columnsInformation, Results results, Protocol protocol, boolean callableResult, boolean eofDeprecated, boolean isPsOutParamter, RowObCursorData rowObCursorData) throws IOException, SQLException {
        super(columnsInformation, results, protocol, callableResult, eofDeprecated, isPsOutParamter);
        this.resultSetScrollType = 1003;
        this.resultSetConcurType = 1007;
        this.rowObCursorData = rowObCursorData;
        try {
            this.cursorFetchInternal(1);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    protected boolean cursorFetch() throws SQLException {
        return this.cursorFetchInternal(this.fetchSize);
    }

    private boolean cursorFetchInternal(int tmpFetchSize) throws SQLException {
        if (this.protocol != null) {
            this.protocol.startCallInterface();
        }
        this.lock.lock();
        try {
            lockLogger.debug("RefCursor.cursorFetchInternal locked");
            if (this.isLastRowSent) {
                boolean bl = false;
                return bl;
            }
            if (this.rowObCursorData == null) {
                this.isLastRowSent = true;
                boolean bl = false;
                return bl;
            }
            ColumnDefinition[] ci = ((ServerSidePreparedStatement)this.getStatement()).cursorFetch(this.rowObCursorData.getCursorId(), tmpFetchSize);
            if (ci != null) {
                this.columnsInformation = ci;
                this.columnInformationLength = ci.length;
                this.row = new BinaryRowProtocol(this.columnsInformation, this.columnInformationLength, this.getStatement().getMaxFieldSize(), this.options);
                this.columnLabelIndexer = new ColumnLabelIndexer(this.columnsInformation);
                this.row.setProtocol(this.getProtocol());
            }
            this.getCursorFetchData(tmpFetchSize);
            boolean bl = true;
            return bl;
        }
        catch (SQLException e) {
            if ("ORA-01002: fetch out of sequence".equals(e.getMessage())) {
                this.isLastRowSent = true;
            }
            throw e;
        }
        finally {
            this.lock.unlock();
            lockLogger.debug("RefCursor.cursorFetchInternal unlocked");
            if (this.protocol != null) {
                this.protocol.endCallInterface("RefCursor.cursorFetch");
            }
        }
    }

    @Override
    public void close() throws SQLException {
        if (this.rowObCursorData != null) {
            ((ServerSidePreparedStatement)this.getStatement()).closeCursor(this.rowObCursorData.getCursorId());
            this.rowObCursorData.setOpen(false);
        }
        super.close();
    }
}

