/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.jdbc.internal.protocol;

import com.oceanbase.jdbc.LocalInfileInterceptor;
import com.oceanbase.jdbc.OceanBaseConnection;
import com.oceanbase.jdbc.OceanBaseStatement;
import com.oceanbase.jdbc.UrlParser;
import com.oceanbase.jdbc.credential.Credential;
import com.oceanbase.jdbc.internal.ColumnType;
import com.oceanbase.jdbc.internal.com.read.Buffer;
import com.oceanbase.jdbc.internal.com.read.ErrorPacket;
import com.oceanbase.jdbc.internal.com.read.dao.Results;
import com.oceanbase.jdbc.internal.com.read.resultset.ColumnDefinition;
import com.oceanbase.jdbc.internal.com.read.resultset.CursorResultSet;
import com.oceanbase.jdbc.internal.com.read.resultset.SelectResultSet;
import com.oceanbase.jdbc.internal.com.read.resultset.SensitiveCursorResultSet;
import com.oceanbase.jdbc.internal.com.send.ComQuery;
import com.oceanbase.jdbc.internal.com.send.ComStmtExecute;
import com.oceanbase.jdbc.internal.com.send.ComStmtPrepare;
import com.oceanbase.jdbc.internal.com.send.ComStmtPrepareExecute;
import com.oceanbase.jdbc.internal.com.send.SendChangeDbPacket;
import com.oceanbase.jdbc.internal.com.send.SendHandshakeResponsePacket;
import com.oceanbase.jdbc.internal.com.send.parameters.LongDataParameterHolder;
import com.oceanbase.jdbc.internal.com.send.parameters.ParameterHolder;
import com.oceanbase.jdbc.internal.io.LruTraceCache;
import com.oceanbase.jdbc.internal.io.output.PacketOutputStream;
import com.oceanbase.jdbc.internal.logging.Logger;
import com.oceanbase.jdbc.internal.logging.LoggerFactory;
import com.oceanbase.jdbc.internal.protocol.AbstractConnectProtocol;
import com.oceanbase.jdbc.internal.protocol.AbstractMultiSend;
import com.oceanbase.jdbc.internal.protocol.MasterProtocol;
import com.oceanbase.jdbc.internal.protocol.Protocol;
import com.oceanbase.jdbc.internal.protocol.flt.FullLinkTrace;
import com.oceanbase.jdbc.internal.util.BulkStatus;
import com.oceanbase.jdbc.internal.util.LogQueryTool;
import com.oceanbase.jdbc.internal.util.SqlStates;
import com.oceanbase.jdbc.internal.util.Utils;
import com.oceanbase.jdbc.internal.util.constant.Version;
import com.oceanbase.jdbc.internal.util.dao.ClientPrepareResult;
import com.oceanbase.jdbc.internal.util.dao.PrepareResult;
import com.oceanbase.jdbc.internal.util.dao.ServerPrepareResult;
import com.oceanbase.jdbc.internal.util.exceptions.ExceptionFactory;
import com.oceanbase.jdbc.internal.util.exceptions.MaxAllowedPacketException;
import com.oceanbase.jdbc.internal.util.exceptions.OceanBaseSqlException;
import com.oceanbase.jdbc.internal.util.pool.GlobalStateInfo;
import com.oceanbase.jdbc.internal.util.scheduler.SchedulerServiceProviderHolder;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.sql.SQLException;
import java.sql.SQLNonTransientConnectionException;
import java.sql.SQLTimeoutException;
import java.sql.SQLTransientConnectionException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.locks.ReentrantLock;

public class AbstractQueryProtocol
extends AbstractConnectProtocol
implements Protocol {
    private static final Logger logger = LoggerFactory.getLogger(AbstractQueryProtocol.class);
    private static final Set<Integer> LOCK_DEADLOCK_ERROR_CODES = new HashSet<Integer>(Arrays.asList(1205, 1213, 1614));
    private ThreadPoolExecutor readScheduler = null;
    private InputStream localInfileInputStream;
    private long maxRows;
    private FutureTask activeFutureTask = null;
    private boolean interrupted;
    private long checksum = 1L;
    private int iterationCount;
    private int executeMode;
    private boolean enableNetworkStatistics = false;
    protected static final Logger lockLogger = LoggerFactory.getLogger("JDBC-COST-LOGGER");

    AbstractQueryProtocol(UrlParser urlParser, GlobalStateInfo globalInfo, ReentrantLock lock, LruTraceCache traceCache) {
        super(urlParser, globalInfo, lock, traceCache);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void reset() throws SQLException {
        this.cmdPrologue();
        UUID spanId = null;
        this.lock.lock();
        try {
            lockLogger.debug("AbstractQueryProtocol.reset locked");
            spanId = this.ob20BeginTraceAndSpan("reset connection");
            this.writer.startPacket(0);
            this.writer.write(31);
            this.writer.flush();
            this.getResult(new Results());
            if (this.options.cachePrepStmts && this.options.useServerPrepStmts) {
                this.serverPrepareStatementCache.clear();
            }
            this.ob20EndSpanAndTrace(spanId);
            this.lock.unlock();
            lockLogger.debug("AbstractQueryProtocol.reset unlocked");
            return;
        }
        catch (SQLException sqlException) {
            try {
                throw this.exceptionWithQuery("COM_RESET_CONNECTION failed.", sqlException, this.explicitClosed);
                catch (IOException e) {
                    throw this.exceptionWithQuery("COM_RESET_CONNECTION failed.", this.handleIoException(e), this.explicitClosed);
                }
            }
            catch (Throwable throwable) {
                this.ob20EndSpanAndTrace(spanId);
                this.lock.unlock();
                lockLogger.debug("AbstractQueryProtocol.reset unlocked");
                throw throwable;
            }
        }
    }

    private OceanBaseSqlException exceptionWithQuery(ParameterHolder[] parameters, PrepareResult serverPrepareResult, SQLException sqlException, boolean explicitClosed) {
        return this.exceptionWithQuery(LogQueryTool.queryWithParams(serverPrepareResult, parameters, this.options), sqlException, explicitClosed);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OceanBaseSqlException exceptionWithQuery(String sql, SQLException sqlException, boolean explicitClosed) {
        OceanBaseSqlException ex = explicitClosed ? new OceanBaseSqlException("Connection has explicitly been closed/aborted.", sql, sqlException) : (sqlException.getCause() instanceof SocketTimeoutException ? new OceanBaseSqlException("Connection timed out", sql, "08000", (Throwable)sqlException) : OceanBaseSqlException.of(sqlException, sql));
        if (this.options.includeThreadDumpInDeadlockExceptions || sqlException.getErrorCode() == 1064) {
            ex.withThreadName(Thread.currentThread().getName());
        }
        if (this.options.includeInnodbStatusInDeadlockExceptions && sqlException.getSQLState() != null && LOCK_DEADLOCK_ERROR_CODES.contains(sqlException.getErrorCode())) {
            this.lock.lock();
            try {
                lockLogger.debug("AbstractQueryProtocol.exceptionWithQuery locked");
                this.cmdPrologue();
                Results results = new Results();
                this.executeQuery(this.isMasterConnection(), results, "SHOW ENGINE INNODB STATUS");
                results.commandEnd();
                SelectResultSet rs = results.getResultSet();
                if (rs.next()) {
                    OceanBaseSqlException oceanBaseSqlException = ex.withDeadLockInfo(rs.getString(3));
                    return oceanBaseSqlException;
                }
            }
            catch (SQLException sQLException) {
            }
            finally {
                this.lock.unlock();
                lockLogger.debug("AbstractQueryProtocol.exceptionWithQuery unlocked");
            }
        }
        return ex;
    }

    @Override
    public ServerPrepareResult prepare(String sql, boolean executeOnMaster) throws SQLException {
        ServerPrepareResult pr;
        UUID spanId;
        block5: {
            this.cmdPrologue();
            spanId = null;
            this.lock.lock();
            lockLogger.debug("AbstractQueryProtocol.prepare locked");
            spanId = this.ob20BeginTraceAndSpan("prepare");
            logger.debug("preparing sql: {}", (Object)sql);
            if (!this.options.cachePrepStmts || !this.options.useServerPrepStmts || (pr = (ServerPrepareResult)this.serverPrepareStatementCache.get(this.database + "-" + sql)) == null || !pr.incrementShareCounter()) break block5;
            ServerPrepareResult serverPrepareResult = pr;
            this.ob20EndSpanAndTrace(spanId);
            this.lock.unlock();
            lockLogger.debug("AbstractQueryProtocol.prepare unlocked");
            return serverPrepareResult;
        }
        try {
            this.writer.startPacket(0);
            this.writer.write(22);
            this.writer.write(sql.getBytes(this.options.getCharacterEncoding()));
            this.writer.flush();
            pr = ComStmtPrepare.read(this.reader, this.eofDeprecated, this, sql);
            this.ob20EndSpanAndTrace(spanId);
            this.lock.unlock();
            lockLogger.debug("AbstractQueryProtocol.prepare unlocked");
            return pr;
        }
        catch (IOException e) {
            try {
                throw this.exceptionWithQuery(sql, this.handleIoException(e), this.explicitClosed);
            }
            catch (Throwable throwable) {
                this.ob20EndSpanAndTrace(spanId);
                this.lock.unlock();
                lockLogger.debug("AbstractQueryProtocol.prepare unlocked");
                throw throwable;
            }
        }
    }

    @Override
    public void executeQuery(String sql) throws SQLException {
        this.executeQuery(this.isMasterConnection(), new Results(), sql);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void executeQuery(boolean mustExecuteOnMaster, Results results, String sql) throws SQLException {
        this.cmdPrologue();
        UUID spanId = null;
        this.lock.lock();
        try {
            lockLogger.debug("AbstractQueryProtocol.executeQuery locked");
            spanId = this.ob20BeginTraceAndSpan("execute query");
            this.writer.startPacket(0);
            this.writer.write(3);
            this.writer.write(sql.getBytes(this.options.getCharacterEncoding()));
            this.writer.flush();
            this.getResult(results);
            this.ob20EndSpanAndTrace(spanId);
            this.lock.unlock();
            lockLogger.debug("AbstractQueryProtocol.executeQuery unlocked");
            return;
        }
        catch (SQLException sqlException) {
            try {
                if (!"70100".equals(sqlException.getSQLState())) throw this.exceptionWithQuery(sql, sqlException, this.explicitClosed);
                if (1927 != sqlException.getErrorCode()) throw this.exceptionWithQuery(sql, sqlException, this.explicitClosed);
                throw this.handleIoException(sqlException);
                catch (IOException e) {
                    throw this.exceptionWithQuery(sql, this.handleIoException(e), this.explicitClosed);
                }
            }
            catch (Throwable throwable) {
                this.ob20EndSpanAndTrace(spanId);
                this.lock.unlock();
                lockLogger.debug("AbstractQueryProtocol.executeQuery unlocked");
                throw throwable;
            }
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void executeQuery(boolean mustExecuteOnMaster, Results results, String sql, Charset charset) throws SQLException {
        this.cmdPrologue();
        UUID spanId = null;
        this.lock.lock();
        try {
            lockLogger.debug("AbstractQueryProtocol.executeQuery locked");
            spanId = this.ob20BeginTraceAndSpan("execute query");
            this.writer.startPacket(0);
            this.writer.write(3);
            this.writer.write(sql.getBytes(charset));
            this.writer.flush();
            this.getResult(results);
            this.ob20EndSpanAndTrace(spanId);
            this.lock.unlock();
            lockLogger.debug("AbstractQueryProtocol.executeQuery unlocked");
            return;
        }
        catch (SQLException sqlException) {
            try {
                throw this.exceptionWithQuery(sql, sqlException, this.explicitClosed);
                catch (IOException e) {
                    throw this.exceptionWithQuery(sql, this.handleIoException(e), this.explicitClosed);
                }
            }
            catch (Throwable throwable) {
                this.ob20EndSpanAndTrace(spanId);
                this.lock.unlock();
                lockLogger.debug("AbstractQueryProtocol.executeQuery unlocked");
                throw throwable;
            }
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void executeQuery(boolean mustExecuteOnMaster, Results results, ClientPrepareResult clientPrepareResult, ParameterHolder[] parameters) throws SQLException {
        this.cmdPrologue();
        UUID spanId = null;
        this.lock.lock();
        try {
            lockLogger.debug("AbstractQueryProtocol.executeQuery locked");
            spanId = this.ob20BeginTraceAndSpan("execute query");
            if (clientPrepareResult.getParamCount() == 0 && !clientPrepareResult.isQueryMultiValuesRewritable()) {
                if (clientPrepareResult.getQueryParts().size() == 1) {
                    ComQuery.sendDirect(this.writer, clientPrepareResult.getQueryParts().get(0));
                } else {
                    ComQuery.sendMultiDirect(this.writer, clientPrepareResult.getQueryParts());
                }
            } else {
                ComQuery.sendSubCmd(this.writer, clientPrepareResult, parameters, -1);
            }
            this.getResult(results);
            this.ob20EndSpanAndTrace(spanId);
            this.lock.unlock();
            lockLogger.debug("AbstractQueryProtocol.executeQuery unlocked");
            return;
        }
        catch (SQLException queryException) {
            try {
                throw this.exceptionWithQuery(parameters, clientPrepareResult, queryException, false);
                catch (IOException e) {
                    throw this.exceptionWithQuery(parameters, clientPrepareResult, this.handleIoException(e), false);
                }
            }
            catch (Throwable throwable) {
                this.ob20EndSpanAndTrace(spanId);
                this.lock.unlock();
                lockLogger.debug("AbstractQueryProtocol.executeQuery unlocked");
                throw throwable;
            }
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void executeQuery(boolean mustExecuteOnMaster, Results results, ClientPrepareResult clientPrepareResult, ParameterHolder[] parameters, int queryTimeout) throws SQLException {
        this.cmdPrologue();
        UUID spanId = null;
        this.lock.lock();
        try {
            lockLogger.debug("AbstractQueryProtocol.executeQuery locked");
            spanId = this.ob20BeginTraceAndSpan("execute query");
            if (clientPrepareResult.getParamCount() == 0 && !clientPrepareResult.isQueryMultiValuesRewritable()) {
                if (clientPrepareResult.getQueryParts().size() == 1) {
                    ComQuery.sendDirect(this.writer, clientPrepareResult.getQueryParts().get(0), queryTimeout);
                } else {
                    ComQuery.sendMultiDirect(this.writer, clientPrepareResult.getQueryParts(), queryTimeout);
                }
            } else {
                ComQuery.sendSubCmd(this.writer, clientPrepareResult, parameters, queryTimeout);
            }
            this.getResult(results);
            this.ob20EndSpanAndTrace(spanId);
            this.lock.unlock();
            lockLogger.debug("AbstractQueryProtocol.executeQuery unlocked");
            return;
        }
        catch (SQLException queryException) {
            try {
                throw this.exceptionWithQuery(parameters, clientPrepareResult, queryException, false);
                catch (IOException e) {
                    throw this.exceptionWithQuery(parameters, clientPrepareResult, this.handleIoException(e), false);
                }
            }
            catch (Throwable throwable) {
                this.ob20EndSpanAndTrace(spanId);
                this.lock.unlock();
                lockLogger.debug("AbstractQueryProtocol.executeQuery unlocked");
                throw throwable;
            }
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void executePreparedQuery(boolean mustExecuteOnMaster, ServerPrepareResult serverPrepareResult, Results results, ParameterHolder[] parameters) throws SQLException {
        this.cmdPrologue();
        UUID spanId = null;
        this.lock.lock();
        try {
            ColumnDefinition[] ci;
            int parameterCount;
            block15: {
                int i;
                block13: {
                    block14: {
                        block12: {
                            lockLogger.debug("AbstractQueryProtocol.executePreparedQuery locked");
                            spanId = this.ob20BeginTraceAndSpan("execute prepared query");
                            parameterCount = serverPrepareResult.getParameters().length;
                            if (!this.isOracleMode()) break block12;
                            if ((!this.options.useServerPrepStmts || !this.options.usePieceData) && (results == null || results.getStatement() == null || !results.getStatement().isInternal())) break block13;
                            break block14;
                        }
                        for (i = 0; i < parameterCount; ++i) {
                            if (!parameters[i].isLongData()) continue;
                            ((LongDataParameterHolder)parameters[i]).writeLongData(this.writer, this.options, serverPrepareResult.getStatementId(), (short)i);
                        }
                        break block15;
                    }
                    for (i = 0; i < parameterCount; ++i) {
                        if (!parameters[i].isLongData()) continue;
                        boolean continueWrite = true;
                        boolean first = true;
                        while (continueWrite) {
                            this.writer.startPacket(0);
                            this.writer.write(-94);
                            this.writer.writeInt(serverPrepareResult.getStatementId());
                            this.writer.writeShort((short)i);
                            continueWrite = ((LongDataParameterHolder)parameters[i]).writePieceData(this.writer, first, this.options);
                            first = false;
                            this.getResult(new Results());
                        }
                    }
                    break block15;
                }
                for (i = 0; i < parameterCount; ++i) {
                    if (!parameters[i].isLongData()) continue;
                    throw new SQLException("Not supported send long data on ob oracle. Recommended URL options: useServerPrepStmts=true&usePieceData=true");
                }
            }
            this.writer.setTimeZone(this.getServerTimeZone());
            boolean withRefCursor = false;
            for (ColumnDefinition columnDefinition : ci = serverPrepareResult.getColumns()) {
                if (columnDefinition.getColumnType() != ColumnType.CURSOR) continue;
                withRefCursor = true;
                break;
            }
            byte cursorFlag = 0;
            if (!withRefCursor && results.getStatement().getSqlType() == 1 && (this.isOracleMode() && !this.options.extendOracleResultSetClass || !this.isOracleMode() && this.options.useCursorFetch && results.getFetchSize() > 0 && results.getResultSetScrollType() == 1003 && results.getResultSetConcurrency() == 1007)) {
                cursorFlag = 1;
                results.setToCursorFetch(true);
                results.setStatementId(serverPrepareResult.getStatementId());
            } else {
                cursorFlag = 0;
            }
            ComStmtExecute.send(this.writer, serverPrepareResult.getStatementId(), parameters, parameterCount, serverPrepareResult.getParameterTypeHeader(), cursorFlag, this);
            this.getResult(results);
            results.setToCursorFetch(false);
            this.ob20EndSpanAndTrace(spanId);
            this.lock.unlock();
            lockLogger.debug("AbstractQueryProtocol.executePreparedQuery unlocked");
            return;
        }
        catch (SQLException qex) {
            try {
                throw this.exceptionWithQuery(parameters, serverPrepareResult, qex, false);
                catch (IOException e) {
                    throw this.exceptionWithQuery(parameters, serverPrepareResult, this.handleIoException(e), false);
                }
            }
            catch (Throwable throwable) {
                this.ob20EndSpanAndTrace(spanId);
                this.lock.unlock();
                lockLogger.debug("AbstractQueryProtocol.executePreparedQuery unlocked");
                throw throwable;
            }
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ServerPrepareResult executePreparedQuery(int parameterCount, ParameterHolder[] parameters, ServerPrepareResult serverPrepareResult, Results results) throws SQLException {
        this.cmdPrologue();
        UUID spanId = null;
        this.lock.lock();
        try {
            block17: {
                int i;
                block15: {
                    block16: {
                        block14: {
                            lockLogger.debug("AbstractQueryProtocol.executePreparedQuery locked");
                            spanId = this.ob20BeginTraceAndSpan("prepare and execute query");
                            if (!this.isOracleMode()) break block14;
                            if ((!this.options.useServerPrepStmts || !this.options.usePieceData) && (results == null || results.getStatement() == null || !results.getStatement().isInternal())) break block15;
                            break block16;
                        }
                        for (i = 0; i < parameters.length; ++i) {
                            if (!parameters[i].isLongData()) continue;
                            ((LongDataParameterHolder)parameters[i]).writeLongData(this.writer, this.options, serverPrepareResult.getStatementId(), (short)i);
                        }
                        break block17;
                    }
                    for (i = 0; i < parameterCount; ++i) {
                        if (!parameters[i].isLongData()) continue;
                        if (serverPrepareResult == null) {
                            serverPrepareResult = this.prepare(results.getStatement().getActualSql(), true);
                        }
                        boolean continueWrite = true;
                        boolean first = true;
                        while (continueWrite) {
                            this.writer.startPacket(0);
                            this.writer.write(-94);
                            this.writer.writeInt(serverPrepareResult.getStatementId());
                            this.writer.writeShort((short)i);
                            continueWrite = ((LongDataParameterHolder)parameters[i]).writePieceData(this.writer, first, this.options);
                            first = false;
                            this.getResult(new Results());
                        }
                    }
                    break block17;
                }
                for (i = 0; i < parameterCount; ++i) {
                    if (!parameters[i].isLongData()) continue;
                    throw new SQLException("Not supported send long data on ob oracle. Recommended URL options: useServerPrepStmts=true&usePieceData=true");
                }
            }
            this.writer.setTimeZone(this.getServerTimeZone());
            boolean withRefCursor = false;
            if (serverPrepareResult != null) {
                ColumnDefinition[] ci;
                for (ColumnDefinition columnDefinition : ci = serverPrepareResult.getColumns()) {
                    if (columnDefinition.getColumnType() != ColumnType.CURSOR) continue;
                    withRefCursor = true;
                    break;
                }
            }
            byte cursorFlag = 0;
            if (!withRefCursor && results.getStatement().getSqlType() == 1) {
                cursorFlag = 1;
                results.setToCursorFetch(true);
            } else {
                cursorFlag = 0;
            }
            ComStmtPrepareExecute.send(this.writer, results, parameterCount, parameters, serverPrepareResult != null && serverPrepareResult.isReturnByPrepareExecute() ? serverPrepareResult.getParameterTypeHeader() : null, cursorFlag, this, serverPrepareResult);
            serverPrepareResult = ComStmtPrepareExecute.read(this, this.reader, serverPrepareResult != null && serverPrepareResult.isReturnByPrepareExecute() ? serverPrepareResult : null, results);
            results.setToCursorFetch(false);
            ServerPrepareResult serverPrepareResult2 = serverPrepareResult;
            this.ob20EndSpanAndTrace(spanId);
            this.lock.unlock();
            lockLogger.debug("AbstractQueryProtocol.executePreparedQuery unlocked");
            return serverPrepareResult2;
        }
        catch (SQLException qex) {
            try {
                throw this.exceptionWithQuery(results.getParameters(), serverPrepareResult, qex, false);
                catch (IOException e) {
                    throw this.exceptionWithQuery(results.getParameters(), serverPrepareResult, this.handleIoException(e), false);
                }
            }
            catch (Throwable throwable) {
                this.ob20EndSpanAndTrace(spanId);
                this.lock.unlock();
                lockLogger.debug("AbstractQueryProtocol.executePreparedQuery unlocked");
                throw throwable;
            }
        }
    }

    @Override
    public boolean executeBatchClient(boolean mustExecuteOnMaster, Results results, ClientPrepareResult prepareResult, List<ParameterHolder[]> parametersList, boolean hasLongData) throws SQLException {
        if (this.options.rewriteBatchedStatements) {
            if (prepareResult.isQueryMultiValuesRewritable() && results.getAutoGeneratedKeys() == 2) {
                if (this.options.rewriteInsertByMultiQueries) {
                    this.executeBatchRewrite(results, prepareResult, parametersList, false);
                } else {
                    this.executeBatchRewrite(results, prepareResult, parametersList, true);
                }
                return true;
            }
            if (prepareResult.isQueryMultipleRewritable()) {
                if (this.options.useBulkStmts && !hasLongData && results.getAutoGeneratedKeys() == 2 && this.versionGreaterOrEqual(10, 2, 7) && this.executeBulkBatch(results, prepareResult.getSql(), null, parametersList)) {
                    return true;
                }
                this.executeBatchRewrite(results, prepareResult, parametersList, false);
                return true;
            }
        }
        if (this.options.useBulkStmts && !hasLongData && results.getAutoGeneratedKeys() == 2 && this.versionGreaterOrEqual(10, 2, 7) && this.executeBulkBatch(results, prepareResult.getSql(), null, parametersList)) {
            return true;
        }
        if (this.options.useBatchMultiSend.booleanValue()) {
            this.executeBatchMulti(results, prepareResult, parametersList);
            return true;
        }
        return false;
    }

    /*
     * Exception decompiling
     */
    private boolean executeBulkBatch(Results results, String sql, ServerPrepareResult serverPrepareResult, List<ParameterHolder[]> parametersList) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void initializeBatchReader() {
        if (this.options.useBatchMultiSend.booleanValue()) {
            this.readScheduler = SchedulerServiceProviderHolder.getBulkScheduler();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeBatchMulti(Results results, final ClientPrepareResult clientPrepareResult, final List<ParameterHolder[]> parametersList) throws SQLException {
        this.cmdPrologue();
        UUID spanId = null;
        this.lock.lock();
        try {
            lockLogger.debug("AbstractQueryProtocol.executeBatchMulti locked");
            spanId = this.ob20BeginTraceAndSpan("execute batch multi");
            this.initializeBatchReader();
            new AbstractMultiSend(this, this.writer, results, clientPrepareResult, parametersList, this.readScheduler){

                @Override
                public void sendCmd(PacketOutputStream writer, Results results, List<ParameterHolder[]> parametersList2, List<String> queries, int paramCount, BulkStatus status, PrepareResult prepareResult) throws IOException, SQLException {
                    ParameterHolder[] parameters = parametersList2.get(status.sendCmdCounter);
                    ComQuery.sendSubCmd(writer, clientPrepareResult, parameters, -1);
                }

                @Override
                public SQLException handleResultException(SQLException qex, Results results, List<ParameterHolder[]> parametersList2, List<String> queries, int currentCounter, int sendCmdCounter, int paramCount, PrepareResult prepareResult) {
                    int counter = results.getCurrentStatNumber() - 1;
                    ParameterHolder[] parameters = parametersList2.get(counter);
                    List<byte[]> queryParts = clientPrepareResult.getQueryParts();
                    StringBuilder sql = new StringBuilder(new String(queryParts.get(0)));
                    for (int i = 0; i < paramCount; ++i) {
                        sql.append(parameters[i].toString()).append(new String(queryParts.get(i + 1)));
                    }
                    return AbstractQueryProtocol.this.exceptionWithQuery(sql.toString(), qex, AbstractQueryProtocol.this.explicitClosed);
                }

                @Override
                public int getParamCount() {
                    return clientPrepareResult.getQueryParts().size() - 1;
                }

                @Override
                public int getTotalExecutionNumber() {
                    return parametersList.size();
                }
            }.executeBatch();
            this.ob20EndSpanAndTrace(spanId);
            this.lock.unlock();
            lockLogger.debug("AbstractQueryProtocol.executeBatchMulti unlocked");
        }
        catch (Throwable throwable) {
            this.ob20EndSpanAndTrace(spanId);
            this.lock.unlock();
            lockLogger.debug("AbstractQueryProtocol.executeBatchMulti unlocked");
            throw throwable;
        }
    }

    @Override
    public void executeBatchStmt(boolean mustExecuteOnMaster, Results results, List<String> queries) throws SQLException {
        this.cmdPrologue();
        results.setExecuteBatchStmt(true);
        if (this.options.rewriteBatchedStatements) {
            boolean canAggregateSemiColumn = true;
            for (String query : queries) {
                if (ClientPrepareResult.canAggregateSemiColon(query, this.noBackslashEscapes(), this.isOracleMode())) continue;
                canAggregateSemiColumn = false;
                break;
            }
            if (this.isInterrupted()) {
                throw new SQLTimeoutException("Timeout during batch execution");
            }
            if (canAggregateSemiColumn) {
                this.executeBatchAggregateSemiColon(results, queries);
            } else {
                this.executeBatch(results, queries);
            }
        } else {
            this.executeBatch(results, queries);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeBatch(Results results, final List<String> queries) throws SQLException {
        UUID spanId;
        block8: {
            spanId = null;
            this.lock.lock();
            try {
                lockLogger.debug("AbstractQueryProtocol.executeBatch locked");
                spanId = this.ob20BeginTraceAndSpan("execute batch");
                if (this.options.useBatchMultiSend.booleanValue()) break block8;
                String sql = null;
                OceanBaseSqlException exception = null;
                for (int i = 0; i < queries.size() && !this.isInterrupted(); ++i) {
                    try {
                        sql = queries.get(i);
                        this.writer.startPacket(0);
                        this.writer.write(3);
                        this.writer.write(sql);
                        this.writer.flush();
                        this.getResult(results);
                        continue;
                    }
                    catch (SQLException sqlException) {
                        if (exception != null) continue;
                        exception = this.exceptionWithQuery(sql, sqlException, this.explicitClosed);
                        if (this.options.continueBatchOnError) continue;
                        throw exception;
                    }
                    catch (IOException e) {
                        if (exception != null) continue;
                        exception = this.exceptionWithQuery(sql, this.handleIoException(e), this.explicitClosed);
                        if (this.options.continueBatchOnError) continue;
                        throw exception;
                    }
                }
                this.stopIfInterrupted();
                if (exception != null) {
                    throw exception;
                }
                this.ob20EndSpanAndTrace(spanId);
                this.lock.unlock();
                lockLogger.debug("AbstractQueryProtocol.executeBatch unlocked");
                return;
            }
            catch (Throwable throwable) {
                this.ob20EndSpanAndTrace(spanId);
                this.lock.unlock();
                lockLogger.debug("AbstractQueryProtocol.executeBatch unlocked");
                throw throwable;
            }
        }
        this.initializeBatchReader();
        new AbstractMultiSend(this, this.writer, results, queries, this.readScheduler){

            @Override
            public void sendCmd(PacketOutputStream pos, Results results, List<ParameterHolder[]> parametersList, List<String> queries2, int paramCount, BulkStatus status, PrepareResult prepareResult) throws IOException {
                String sql = queries2.get(status.sendCmdCounter);
                pos.startPacket(0);
                pos.write(3);
                pos.write(sql);
                pos.flush();
            }

            @Override
            public SQLException handleResultException(SQLException qex, Results results, List<ParameterHolder[]> parametersList, List<String> queries2, int currentCounter, int sendCmdCounter, int paramCount, PrepareResult prepareResult) {
                String sql = queries2.get(currentCounter + sendCmdCounter);
                return AbstractQueryProtocol.this.exceptionWithQuery(sql, qex, AbstractQueryProtocol.this.explicitClosed);
            }

            @Override
            public int getParamCount() {
                return -1;
            }

            @Override
            public int getTotalExecutionNumber() {
                return queries.size();
            }
        }.executeBatch();
        this.ob20EndSpanAndTrace(spanId);
        this.lock.unlock();
        lockLogger.debug("AbstractQueryProtocol.executeBatch unlocked");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeBatchAggregateSemiColon(Results results, List<String> queries) throws SQLException {
        UUID spanId = null;
        this.lock.lock();
        try {
            lockLogger.debug("AbstractQueryProtocol.executeBatchAggregateSemiColon locked");
            spanId = this.ob20BeginTraceAndSpan("execute batch aggregate semicolon");
            String firstSql = null;
            int currentIndex = 0;
            int totalQueries = queries.size();
            OceanBaseSqlException exception = null;
            do {
                try {
                    firstSql = queries.get(currentIndex++);
                    if (totalQueries == 1) {
                        this.writer.startPacket(0);
                        this.writer.write(3);
                        this.writer.write(firstSql);
                        this.writer.flush();
                    } else {
                        currentIndex = ComQuery.sendBatchAggregateSemiColon(this.writer, firstSql, queries, currentIndex);
                    }
                    this.getResult(results);
                }
                catch (SQLException sqlException) {
                    if (exception == null) {
                        exception = this.exceptionWithQuery(firstSql, sqlException, this.explicitClosed);
                        if (!this.options.continueBatchOnError) {
                            throw exception;
                        }
                    }
                }
                catch (IOException e) {
                    throw this.exceptionWithQuery(firstSql, this.handleIoException(e), this.explicitClosed);
                }
                this.stopIfInterrupted();
            } while (currentIndex < totalQueries);
            if (exception != null) {
                throw exception;
            }
            this.ob20EndSpanAndTrace(spanId);
            this.lock.unlock();
            lockLogger.debug("AbstractQueryProtocol.executeBatchAggregateSemiColon unlocked");
        }
        catch (Throwable throwable) {
            this.ob20EndSpanAndTrace(spanId);
            this.lock.unlock();
            lockLogger.debug("AbstractQueryProtocol.executeBatchAggregateSemiColon unlocked");
            throw throwable;
        }
    }

    private void executeBatchRewrite(Results results, ClientPrepareResult prepareResult, List<ParameterHolder[]> parameterList, boolean rewriteValues) throws SQLException {
        this.cmdPrologue();
        UUID spanId = null;
        int currentIndex = 0;
        int totalParameterList = parameterList.size();
        this.lock.lock();
        try {
            lockLogger.debug("AbstractQueryProtocol.executeBatchRewrite locked");
            spanId = this.ob20BeginTraceAndSpan("execute batch rewrite");
            do {
                currentIndex = ComQuery.sendRewriteCmd(this.writer, prepareResult.getQueryParts(), currentIndex, prepareResult.getParamCount(), parameterList, rewriteValues);
                this.getResult(results);
                if (!Thread.currentThread().isInterrupted()) continue;
                throw new SQLException("Interrupted during batch", SqlStates.INTERRUPTED_EXCEPTION.getSqlState(), -1);
            } while (currentIndex < totalParameterList);
        }
        catch (SQLException sqlEx) {
            throw OceanBaseSqlException.of(sqlEx, prepareResult.getSql());
        }
        catch (IOException e) {
            throw this.exceptionWithQuery(parameterList.get(currentIndex), prepareResult, this.handleIoException(e), this.explicitClosed);
        }
        finally {
            results.setRewritten(rewriteValues);
            this.ob20EndSpanAndTrace(spanId);
            this.lock.unlock();
            lockLogger.debug("AbstractQueryProtocol.executeBatchRewrite unlocked");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ServerPrepareResult executeBatchServer(ServerPrepareResult serverPrepareResult, Results results, String sql, final List<ParameterHolder[]> parametersList, boolean hasLongData) throws SQLException {
        this.cmdPrologue();
        if (this.options.useBulkStmts && !hasLongData && results.getAutoGeneratedKeys() == 2 && this.versionGreaterOrEqual(10, 2, 7) && this.executeBulkBatch(results, sql, serverPrepareResult, parametersList)) {
            results.setBatchSucceed(true);
            return serverPrepareResult;
        }
        if (!this.options.useBatchMultiSend.booleanValue()) {
            results.setBatchSucceed(false);
            return serverPrepareResult;
        }
        UUID spanId = null;
        this.lock.lock();
        try {
            lockLogger.debug("AbstractQueryProtocol.executeBatchServer locked");
            spanId = this.ob20BeginTraceAndSpan("execute batch on server");
            this.initializeBatchReader();
            final ServerPrepareResult tempServerPrepareResult = null;
            serverPrepareResult = (ServerPrepareResult)new AbstractMultiSend(this, this.writer, results, tempServerPrepareResult, parametersList, true, sql, this.readScheduler){

                @Override
                public void sendCmd(PacketOutputStream writer, Results results, List<ParameterHolder[]> parametersList2, List<String> queries, int paramCount, BulkStatus status, PrepareResult prepareResult) throws SQLException, IOException {
                    ParameterHolder[] parameters = parametersList2.get(status.sendCmdCounter);
                    if (parameters.length < paramCount) {
                        throw new SQLException("Parameter at position " + (paramCount - 1) + " is not set", "07004");
                    }
                    if (AbstractQueryProtocol.this.isOracleMode()) {
                        if (AbstractQueryProtocol.this.options.useServerPrepStmts && AbstractQueryProtocol.this.options.usePieceData) {
                            for (int i = 0; i < paramCount; ++i) {
                                if (!parameters[i].isLongData()) continue;
                                writer.startPacket(0);
                                writer.write(-94);
                                writer.writeInt(this.statementId);
                                writer.writeShort((short)i);
                                writer.writeShort((short)3);
                                parameters[i].writeBinary(writer);
                                writer.flush();
                            }
                        } else {
                            for (int i = 0; i < paramCount; ++i) {
                                if (!parameters[i].isLongData()) continue;
                                throw new SQLException("Not supported send long data on ob oracle. Recommended URL options: useServerPrepStmts=true&usePieceData=true");
                            }
                        }
                    } else {
                        for (int i = 0; i < paramCount; ++i) {
                            if (!parameters[i].isLongData()) continue;
                            ((LongDataParameterHolder)parameters[i]).writeLongData(writer, AbstractQueryProtocol.this.options, this.statementId, (short)i);
                        }
                    }
                    if (AbstractQueryProtocol.this.supportStmtPrepareExecute()) {
                        results.setParameters(parameters);
                        ComStmtPrepareExecute.send(writer, results, paramCount, parameters, tempServerPrepareResult != null ? tempServerPrepareResult.getParameterTypeHeader() : null, (byte)0, this.getProtocol(), tempServerPrepareResult);
                    } else {
                        ComStmtExecute.send(writer, this.statementId, parameters, paramCount, this.parameterTypeHeader, (byte)0, this.getProtocol());
                    }
                }

                @Override
                public SQLException handleResultException(SQLException qex, Results results, List<ParameterHolder[]> parametersList2, List<String> queries, int currentCounter, int sendCmdCounter, int paramCount, PrepareResult prepareResult) {
                    return OceanBaseSqlException.of(qex, prepareResult.getSql());
                }

                @Override
                public int getParamCount() {
                    return this.getPrepareResult() == null ? ((ParameterHolder[])parametersList.get(0)).length : ((ServerPrepareResult)this.getPrepareResult()).getParameters().length;
                }

                @Override
                public int getTotalExecutionNumber() {
                    return parametersList.size();
                }
            }.executeBatch();
            results.setBatchSucceed(true);
            ServerPrepareResult serverPrepareResult2 = serverPrepareResult;
            this.ob20EndSpanAndTrace(spanId);
            this.lock.unlock();
            lockLogger.debug("AbstractQueryProtocol.executeBatchServer unlocked");
            return serverPrepareResult2;
        }
        catch (Throwable throwable) {
            this.ob20EndSpanAndTrace(spanId);
            this.lock.unlock();
            lockLogger.debug("AbstractQueryProtocol.executeBatchServer unlocked");
            throw throwable;
        }
    }

    @Override
    public ColumnDefinition[] fetchRowViaCursor(int cursorId, int fetchSize, Results results) throws SQLException {
        UUID spanId;
        block5: {
            this.cmdPrologue();
            spanId = null;
            this.lock.lock();
            lockLogger.debug("AbstractQueryProtocol.fetchRowViaCursor locked");
            spanId = this.ob20BeginTraceAndSpan("fetch row");
            this.writer.startPacket(0);
            this.writer.write(28);
            this.writer.writeInt(cursorId);
            this.writer.writeInt(fetchSize);
            this.writer.flush();
            if (!this.isOracleMode()) break block5;
            ColumnDefinition[] columnDefinitionArray = this.getResultWithoutValue(results);
            this.ob20EndSpanAndTrace(spanId);
            this.lock.unlock();
            lockLogger.debug("AbstractQueryProtocol.fetchRowViaCursor unlocked");
            return columnDefinitionArray;
        }
        try {
            ColumnDefinition[] columnDefinitionArray = null;
            this.ob20EndSpanAndTrace(spanId);
            this.lock.unlock();
            lockLogger.debug("AbstractQueryProtocol.fetchRowViaCursor unlocked");
            return columnDefinitionArray;
        }
        catch (IOException e) {
            try {
                throw this.exceptionWithQuery(" fetchRowViaCursor failed.", this.handleIoException(e), this.explicitClosed);
            }
            catch (Throwable throwable) {
                this.ob20EndSpanAndTrace(spanId);
                this.lock.unlock();
                lockLogger.debug("AbstractQueryProtocol.fetchRowViaCursor unlocked");
                throw throwable;
            }
        }
    }

    @Override
    public ColumnDefinition[] fetchRowViaCursorForOracle(int cursorId, int numRows, byte offsetType, int offset, Results results) throws SQLException {
        UUID spanId;
        block5: {
            this.cmdPrologue();
            spanId = null;
            this.lock.lock();
            lockLogger.debug("AbstractQueryProtocol.fetchRowViaCursorForOracle locked");
            spanId = this.ob20BeginTraceAndSpan("fetch row for oracle");
            this.writer.startPacket(0);
            this.writer.write(28);
            this.writer.writeInt(cursorId);
            this.writer.writeInt(numRows);
            this.writer.writeShort(offsetType);
            this.writer.writeInt(offset);
            this.writer.writeInt(1);
            this.writer.flush();
            if (!this.isOracleMode()) break block5;
            ColumnDefinition[] columnDefinitionArray = this.getResultWithoutValue(results);
            this.ob20EndSpanAndTrace(spanId);
            this.lock.unlock();
            lockLogger.debug("AbstractQueryProtocol.fetchRowViaCursorForOracle unlocked");
            return columnDefinitionArray;
        }
        try {
            ColumnDefinition[] columnDefinitionArray = null;
            this.ob20EndSpanAndTrace(spanId);
            this.lock.unlock();
            lockLogger.debug("AbstractQueryProtocol.fetchRowViaCursorForOracle unlocked");
            return columnDefinitionArray;
        }
        catch (IOException e) {
            try {
                throw this.exceptionWithQuery(" fetchRowViaCursorForOracle failed.", this.handleIoException(e), this.explicitClosed);
            }
            catch (Throwable throwable) {
                this.ob20EndSpanAndTrace(spanId);
                this.lock.unlock();
                lockLogger.debug("AbstractQueryProtocol.fetchRowViaCursorForOracle unlocked");
                throw throwable;
            }
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void executePreparedQueryArrayBinding(boolean mustExecuteOnMaster, ServerPrepareResult serverPrepareResult, Results results, List<ParameterHolder[]> queryParameters, int queryParameterSize) throws SQLException {
        this.cmdPrologue();
        UUID spanId = null;
        this.lock.lock();
        try {
            int n;
            ColumnDefinition[] i222;
            boolean withRefCursor;
            lockLogger.debug("AbstractQueryProtocol.executePreparedQueryArrayBinding locked");
            spanId = this.ob20BeginTraceAndSpan("execute prepared query by array binding");
            int paramCount = serverPrepareResult.getParameters().length;
            int j = 0;
            while (true) {
                ParameterHolder[] parameters;
                if (j < queryParameterSize) {
                    parameters = queryParameters.get(j);
                } else {
                    ColumnDefinition[] ci;
                    this.writer.setTimeZone(this.getServerTimeZone());
                    withRefCursor = false;
                    i222 = ci = serverPrepareResult.getColumns();
                    n = i222.length;
                    break;
                }
                for (int i222 = 0; i222 < paramCount; ++i222) {
                    if (!parameters[i222].isLongData()) continue;
                    throw new SQLException("Not supported send long data on ob oracle");
                }
                ++j;
            }
            for (int k = 0; k < n; ++k) {
                ColumnDefinition columnDefinition = i222[k];
                if (columnDefinition.getColumnType() != ColumnType.CURSOR) continue;
                withRefCursor = true;
                break;
            }
            byte cursorFlag = 0;
            if (!withRefCursor && results.getStatement().getSqlType() == 1 && (this.isOracleMode() && !this.options.extendOracleResultSetClass || !this.isOracleMode() && this.options.useCursorFetch && results.getFetchSize() > 0 && results.getResultSetScrollType() == 1003 && results.getResultSetConcurrency() == 1007)) {
                cursorFlag = 1;
                results.setToCursorFetch(true);
                results.setStatementId(serverPrepareResult.getStatementId());
            } else {
                cursorFlag = 0;
            }
            ComStmtExecute.sendArrayBinding(this.writer, serverPrepareResult.getStatementId(), queryParameters, queryParameterSize, paramCount, serverPrepareResult.getParameterTypeHeader(), cursorFlag, this);
            this.getResult(results);
            results.setToCursorFetch(false);
            this.ob20EndSpanAndTrace(spanId);
            this.lock.unlock();
            lockLogger.debug("AbstractQueryProtocol.executePreparedQueryArrayBinding unlocked");
            return;
        }
        catch (SQLException qex) {
            try {
                throw this.exceptionWithQuery(null, serverPrepareResult, qex, false);
                catch (IOException e) {
                    throw this.exceptionWithQuery(null, serverPrepareResult, this.handleIoException(e), false);
                }
            }
            catch (Throwable throwable) {
                this.ob20EndSpanAndTrace(spanId);
                this.lock.unlock();
                lockLogger.debug("AbstractQueryProtocol.executePreparedQueryArrayBinding unlocked");
                throw throwable;
            }
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ServerPrepareResult executePreparedQueryArrayBinding(int parameterCount, boolean mustExecuteOnMaster, ServerPrepareResult serverPrepareResult, Results results, List<ParameterHolder[]> queryParameters, int queryParamtersSize) throws SQLException {
        block17: {
            block16: {
                this.cmdPrologue();
                spanId = null;
                this.lock.lock();
                try {
                    AbstractQueryProtocol.lockLogger.debug("AbstractQueryProtocol.prepare executePreparedQueryArrayBinding");
                    spanId = this.ob20BeginTraceAndSpan("execute query to be prepared by array binding");
                    if (this.options.usePieceData) {
                        firstPrepared = true;
                        i = 0;
                        break block16;
                    }
                    for (j = 0; j < queryParamtersSize; ++j) {
                        parameters = queryParameters.get(j);
                        for (i = 0; i < parameterCount; ++i) {
                            if (!parameters[i].isLongData()) continue;
                            throw new SQLException("Not supported send long data on ob oracle. Recommended URL options: usePieceData=true");
                        }
                    }
                    ** GOTO lbl34
                }
                catch (SQLException qex) {
                    try {
                        throw this.exceptionWithQuery(results.getParameters(), serverPrepareResult, qex, false);
                        catch (IOException e) {
                            throw this.exceptionWithQuery(results.getParameters(), serverPrepareResult, this.handleIoException(e), false);
                        }
                    }
                    catch (Throwable var14_24) {
                        this.ob20EndSpanAndTrace(spanId);
                        this.lock.unlock();
                        AbstractQueryProtocol.lockLogger.debug("AbstractQueryProtocol.prepare executePreparedQueryArrayBinding");
                        throw var14_24;
                    }
                }
            }
            while (true) {
                block19: {
                    block20: {
                        block18: {
                            if (i >= parameterCount) break block18;
                            holder = queryParameters.get(0)[i];
                            if (!holder.isLongData()) break block19;
                            break block20;
                        }
                        this.writer.setTimeZone(this.getServerTimeZone());
                        withRefCursor = false;
                        if (serverPrepareResult != null) {
                            i = ci = serverPrepareResult.getColumns();
                            var11_18 = i.length;
                            break;
                        }
                        break block17;
                    }
                    for (j = 0; j < queryParamtersSize; ++j) {
                        holder = queryParameters.get(j)[i];
                        continueWrite = true;
                        first = true;
                        while (continueWrite) {
                            if (firstPrepared) {
                                serverPrepareResult = this.prepare(results.getStatement().getActualSql(), true);
                                serverPrepareResult.resetParameterTypeHeader();
                                firstPrepared = false;
                            }
                            this.writer.startPacket(0);
                            this.writer.write(-94);
                            this.writer.writeInt(serverPrepareResult.getStatementId());
                            this.writer.writeShort((short)i);
                            continueWrite = ((LongDataParameterHolder)holder).writePieceData(this.writer, first, this.options);
                            first = false;
                            this.getResult(new Results());
                        }
                    }
                }
                ++i;
            }
            for (var12_20 = 0; var12_20 < var11_18; ++var12_20) {
                columnDefinition = i[var12_20];
                if (columnDefinition.getColumnType() != ColumnType.CURSOR) continue;
                withRefCursor = true;
                break;
            }
        }
        cursorFlag = 0;
        if (!withRefCursor && results.getStatement().getSqlType() == 1 && this.isOracleMode() && !this.options.extendOracleResultSetClass) {
            cursorFlag = 1;
            results.setToCursorFetch(true);
        } else {
            cursorFlag = 0;
        }
        stmtId = serverPrepareResult != null ? serverPrepareResult.getStatementId() : results.getStatementId();
        ComStmtPrepareExecute.sendArrayBinding(this.writer, stmtId, queryParameters, queryParamtersSize, parameterCount, serverPrepareResult != null ? serverPrepareResult.getParameterTypeHeader() : null, cursorFlag, this, results, serverPrepareResult);
        serverPrepareResult = ComStmtPrepareExecute.read(this, this.reader, serverPrepareResult, results);
        results.setToCursorFetch(false);
        var11_19 = serverPrepareResult;
        this.ob20EndSpanAndTrace(spanId);
        this.lock.unlock();
        AbstractQueryProtocol.lockLogger.debug("AbstractQueryProtocol.prepare executePreparedQueryArrayBinding");
        return var11_19;
    }

    @Override
    public long getLastPacketCostTime() throws SQLException {
        if (!this.enableNetworkStatistics) {
            throw new SQLException("Cant get network cost info while setNetworkStatisticsFlag(true)");
        }
        return this.reader.getTimestampAfterRead() - this.writer.getTimestampBeforeFlush();
    }

    @Override
    public boolean getNetworkStatisticsFlag() {
        return this.enableNetworkStatistics;
    }

    @Override
    public void setNetworkStatisticsFlag(boolean flag) {
        this.enableNetworkStatistics = flag;
        this.writer.enableNetworkStatistics(flag);
        this.reader.enableNetworkStatistics(flag);
    }

    @Override
    public long getLastPacketResponseTimestamp() {
        return this.reader.getTimestampAfterRead();
    }

    @Override
    public long getLastPacketSendTimestamp() {
        return this.writer.getTimestampBeforeFlush();
    }

    @Override
    public void clearNetworkStatistics() {
        this.writer.clearNetworkStatistics();
        this.reader.clearNetworkStatistics();
    }

    @Override
    public void changeUser(String user, String pwd) throws SQLException {
        this.cmdPrologue();
        UUID spanId = null;
        this.lock.lock();
        try {
            lockLogger.debug("AbstractQueryProtocol.changeUser locked");
            spanId = this.ob20BeginTraceAndSpan("change user");
            Credential credential = new Credential(user, pwd, this.options.useProxyUser);
            this.urlParser.setConnectedUsername(credential.getUser());
            String clientIp = this.socket.getLocalAddress().getHostAddress();
            SendHandshakeResponsePacket.sendChangeUser(this.writer, credential, this.host, this.database, this.clientCapabilities, this.serverCapabilities, this.exchangeCharset, (byte)(Boolean.TRUE.equals(this.options.useSsl) ? 2 : 1), this.options, this.authenticationPluginType, this.seed, clientIp, this.isOracleMode());
            this.getResult(new Results());
            this.setUsername(user);
            this.postConnectionQueries();
            this.ob20EndSpanAndTrace(spanId);
            this.lock.unlock();
            lockLogger.debug("AbstractQueryProtocol.changeUser unlocked");
        }
        catch (IOException e) {
            try {
                throw this.exceptionWithQuery(" change user failed.", this.handleIoException(e), this.explicitClosed);
            }
            catch (Throwable throwable) {
                this.ob20EndSpanAndTrace(spanId);
                this.lock.unlock();
                lockLogger.debug("AbstractQueryProtocol.changeUser unlocked");
                throw throwable;
            }
        }
    }

    @Override
    public void rollback() throws SQLException {
        block8: {
            this.cmdPrologue();
            this.lock.lock();
            try {
                lockLogger.debug("AbstractQueryProtocol.rollback locked");
                if (!this.inTransaction()) break block8;
                UUID spanId = this.ob20BeginTraceAndSpan("rollback");
                try {
                    this.executeQuery("ROLLBACK");
                    this.ob20EndSpanAndTrace(spanId);
                }
                catch (Exception exception) {
                    this.ob20EndSpanAndTrace(spanId);
                }
                catch (Throwable throwable) {
                    this.ob20EndSpanAndTrace(spanId);
                    throw throwable;
                }
            }
            catch (Exception e) {
                throw e;
            }
            finally {
                this.lock.unlock();
                lockLogger.debug("AbstractQueryProtocol.rollback unlocked");
            }
        }
    }

    @Override
    public void setUsername(String username) {
        this.username = username;
    }

    @Override
    public boolean forceReleasePrepareStatement(int statementId) throws SQLException {
        this.lock.lock();
        UUID spanId = null;
        try {
            lockLogger.debug("AbstractQueryProtocol.forceReleasePrepareStatement locked");
            spanId = this.ob20BeginTraceAndSpan("close prepared statement");
            this.checkClose();
            this.writer.startPacket(0);
            this.writer.write(25);
            this.writer.writeInt(statementId);
            this.writer.flush();
            boolean bl = true;
            this.ob20EndSpanAndTrace(spanId);
            this.lock.unlock();
            lockLogger.debug("AbstractQueryProtocol.forceReleasePrepareStatement unlocked");
            return bl;
        }
        catch (IOException e) {
            try {
                this.connected = false;
                this.whyConnectedIsFalse();
                throw new SQLNonTransientConnectionException("Could not deallocate query: " + e.getMessage(), "08000", e);
            }
            catch (Throwable throwable) {
                this.ob20EndSpanAndTrace(spanId);
                this.lock.unlock();
                lockLogger.debug("AbstractQueryProtocol.forceReleasePrepareStatement unlocked");
                throw throwable;
            }
        }
    }

    @Override
    public boolean ping() throws SQLException {
        this.cmdPrologue();
        UUID spanId = null;
        this.lock.lock();
        try {
            lockLogger.debug("AbstractQueryProtocol.ping locked");
            spanId = this.ob20BeginTraceAndSpan("ping");
            this.writer.startPacket(0);
            this.writer.write(14);
            this.writer.flush();
            Buffer buffer = this.reader.getPacket(true);
            boolean bl = buffer.getByteAt(0) == 0;
            this.ob20EndSpanAndTrace(spanId);
            this.lock.unlock();
            lockLogger.debug("AbstractQueryProtocol.ping unlocked");
            return bl;
        }
        catch (IOException e) {
            try {
                this.connected = false;
                this.whyConnectedIsFalse();
                throw new SQLNonTransientConnectionException("Could not ping: " + e.getMessage(), "08000", e);
            }
            catch (Throwable throwable) {
                this.ob20EndSpanAndTrace(spanId);
                this.lock.unlock();
                lockLogger.debug("AbstractQueryProtocol.ping unlocked");
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isValid(int timeout) throws SQLException {
        int initialTimeout = -1;
        try {
            initialTimeout = this.socketTimeout;
            if (initialTimeout == 0) {
                this.changeSocketSoTimeout(timeout);
            }
            if (this.isMasterConnection() && !this.galeraAllowedStates.isEmpty()) {
                Results results = new Results();
                this.executeQuery(true, results, "show status like 'wsrep_local_state'");
                results.commandEnd();
                SelectResultSet rs = results.getResultSet();
                boolean bl = rs != null && rs.next() && this.galeraAllowedStates.contains(rs.getString(2));
                return bl;
            }
            boolean results = this.ping();
            return results;
        }
        catch (SocketException socketException) {
            logger.trace("Connection is not valid", socketException);
            this.connected = false;
            this.whyConnectedIsFalse();
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (initialTimeout != -1) {
                    this.changeSocketSoTimeout(initialTimeout);
                }
            }
            catch (SocketException socketException) {
                logger.warn("Could not set socket timeout back to " + initialTimeout, socketException);
                this.connected = false;
                this.whyConnectedIsFalse();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getCatalog() throws SQLException {
        if (this.sessionStateAware()) {
            if (this.database != null && this.database.isEmpty()) {
                return "";
            }
            return this.database;
        }
        this.cmdPrologue();
        this.lock.lock();
        try {
            lockLogger.debug("AbstractQueryProtocol.getCatalog locked");
            Results results = new Results();
            this.executeQuery(this.isMasterConnection(), results, "select database()");
            results.commandEnd();
            SelectResultSet rs = results.getResultSet();
            if (rs.next()) {
                String string = this.database = rs.getString(1);
                return string;
            }
            String string = null;
            return string;
        }
        finally {
            this.lock.unlock();
            lockLogger.debug("AbstractQueryProtocol.getCatalog unlocked");
        }
    }

    @Override
    public void setCatalog(String database) throws SQLException {
        this.cmdPrologue();
        UUID spanId = null;
        this.lock.lock();
        try {
            lockLogger.debug("AbstractQueryProtocol.setCatalog locked");
            spanId = this.ob20BeginTraceAndSpan("set setCatalog");
            SendChangeDbPacket.send(this.writer, database);
            Buffer buffer = this.reader.getPacket(true);
            if (buffer.getByteAt(0) == -1) {
                ErrorPacket ep = new ErrorPacket(buffer);
                throw new SQLException("Could not select database '" + database + "' : " + ep.getMessage(), ep.getSqlState(), ep.getErrorCode());
            }
            this.database = database;
            this.ob20EndSpanAndTrace(spanId);
            this.lock.unlock();
            lockLogger.debug("AbstractQueryProtocol.setCatalog unlocked");
        }
        catch (IOException e) {
            try {
                throw this.exceptionWithQuery("COM_INIT_DB", this.handleIoException(e), false);
            }
            catch (Throwable throwable) {
                this.ob20EndSpanAndTrace(spanId);
                this.lock.unlock();
                lockLogger.debug("AbstractQueryProtocol.setCatalog unlocked");
                throw throwable;
            }
        }
    }

    @Override
    public void resetDatabase() throws SQLException {
        if (!this.database.equals(this.urlParser.getDatabase())) {
            this.setCatalog(this.urlParser.getDatabase());
        }
    }

    @Override
    public void cancelCurrentQuery() throws SQLException {
        try (MasterProtocol copiedProtocol = new MasterProtocol(this.urlParser, new GlobalStateInfo(), new ReentrantLock(), this.traceCache);){
            copiedProtocol.setHostAddress(this.getHostAddress());
            copiedProtocol.connect();
            copiedProtocol.executeQuery("KILL QUERY " + this.serverThreadId);
        }
        catch (IOException e) {
            throw ExceptionFactory.INSTANCE.create(String.format("Could not connect to %s. %s%s", this.getHostAddress(), e.getMessage(), this.getTraces()), "08000", e);
        }
        this.interrupted = true;
    }

    @Override
    public boolean getAutocommit() {
        return this.autoCommit;
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        if (this.autoCommit == autoCommit) {
            return;
        }
        this.executeQuery("set autocommit = " + (autoCommit ? "1" : "0"));
        this.autoCommit = autoCommit;
    }

    @Override
    public boolean inTransaction() {
        return (this.serverStatus & 1) != 0;
    }

    @Override
    public void closeExplicit() {
        this.explicitClosed = true;
        this.close();
    }

    @Override
    public void releasePrepareStatement(ServerPrepareResult serverPrepareResult) throws SQLException {
        serverPrepareResult.decrementShareCounter();
        if (serverPrepareResult.canBeDeallocate()) {
            logger.debug("closing [ps-id={}] {}", (Object)serverPrepareResult.getStatementId(), (Object)serverPrepareResult.getSql());
            this.forceReleasePrepareStatement(serverPrepareResult.getStatementId());
            if (this.options.cachePrepStmts && this.options.useServerPrepStmts) {
                this.serverPrepareStatementCache.remove(this.database + "-" + serverPrepareResult.getSql());
            }
            serverPrepareResult.release();
        }
    }

    @Override
    public long getMaxRows() {
        return this.maxRows;
    }

    @Override
    public void setMaxRows(long max) throws SQLException {
        if (this.maxRows != max) {
            if (max == 0L) {
                if (this.isOracleMode() && Version.compare(this.getObServerVersion(), "4.2.4") >= 0) {
                    this.executeQuery("set @@_ORACLE_SQL_SELECT_LIMIT=DEFAULT");
                } else {
                    this.executeQuery("set @@SQL_SELECT_LIMIT=DEFAULT");
                }
            } else if (this.isOracleMode() && Version.compare(this.getObServerVersion(), "4.2.4") >= 0) {
                this.executeQuery("set @@_ORACLE_SQL_SELECT_LIMIT=" + max);
            } else {
                this.executeQuery("set @@SQL_SELECT_LIMIT=" + max);
            }
            this.maxRows = max;
        }
    }

    @Override
    public void setLocalInfileInputStream(InputStream inputStream) {
        this.localInfileInputStream = inputStream;
    }

    @Override
    public int getTimeout() {
        return this.socketTimeout;
    }

    @Override
    public void setTimeout(int timeout) throws SocketException {
        this.lock.lock();
        try {
            lockLogger.debug("AbstractQueryProtocol.setTimeout locked");
            this.changeSocketSoTimeout(timeout);
        }
        finally {
            this.lock.unlock();
            lockLogger.debug("AbstractQueryProtocol.setTimeout unlocked");
        }
    }

    @Override
    public void setReadonly(boolean readOnly) throws SQLException {
        if (this.options.assureReadOnly && this.readOnly != readOnly && this.versionGreaterOrEqual(5, 6, 5)) {
            this.executeQuery("SET SESSION TRANSACTION " + (readOnly ? "READ ONLY" : "READ WRITE"));
        }
        this.readOnly = readOnly;
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
        this.cmdPrologue();
        this.lock.lock();
        try {
            lockLogger.debug("AbstractQueryProtocol.setTransactionIsolation locked");
            if (this.transactionIsolationLevel == level) {
                return;
            }
            String query = "SET SESSION TRANSACTION ISOLATION LEVEL";
            switch (level) {
                case 1: {
                    query = query + " READ UNCOMMITTED";
                    break;
                }
                case 2: {
                    query = query + " READ COMMITTED";
                    break;
                }
                case 4: {
                    query = query + " REPEATABLE READ";
                    break;
                }
                case 8: {
                    query = query + " SERIALIZABLE";
                    break;
                }
                default: {
                    throw new SQLException("Unsupported transaction isolation level");
                }
            }
            this.executeQuery(query);
            this.transactionIsolationLevel = level;
        }
        finally {
            this.lock.unlock();
            lockLogger.debug("AbstractQueryProtocol.setTransactionIsolation unlocked");
        }
    }

    @Override
    public int getTransactionIsolationLevel() {
        return this.transactionIsolationLevel;
    }

    private void checkClose() throws SQLException {
        if (!this.connected) {
            throw new SQLException("Connection is close", "08000", 1220);
        }
    }

    @Override
    public void getResult(Results results) throws SQLException {
        this.reader.startReceiveResponse();
        try {
            this.readPacket(results);
            while (this.hasMoreResults()) {
                this.readPacket(results);
            }
        }
        finally {
            this.reader.endReceiveResponse(results.getSql());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ColumnDefinition[] getResultWithoutValue(Results results) throws SQLException {
        this.reader.startReceiveResponse();
        try {
            Buffer buffer;
            ColumnDefinition[] ci = null;
            try {
                buffer = this.reader.getPacket(true);
            }
            catch (IOException e) {
                throw this.handleIoException(e);
            }
            switch (buffer.getByteAt(0)) {
                case 0: {
                    this.readOkPacket(buffer, results);
                    break;
                }
                case -1: {
                    throw this.readErrorPacket(buffer, results);
                }
                case -5: {
                    this.readLocalInfilePacket(buffer, results);
                    break;
                }
                default: {
                    ci = this.readResultSetColumnDef(buffer, results);
                }
            }
            ColumnDefinition[] columnDefinitionArray = ci;
            return columnDefinitionArray;
        }
        finally {
            this.reader.endReceiveResponse(results.getSql());
        }
    }

    private ColumnDefinition[] readResultSetColumnDef(Buffer buffer, Results results) throws SQLException {
        long fieldCount = buffer.getLengthEncodedNumeric();
        try {
            ColumnDefinition[] ci = new ColumnDefinition[(int)fieldCount];
            int i = 0;
            while ((long)i < fieldCount) {
                ci[i] = new ColumnDefinition(this.reader.getPacket(false), this.isOracleMode(), this.options.getCharacterEncoding());
                ++i;
            }
            if (!this.eofDeprecated) {
                Buffer bufferEof = this.reader.getPacket(true);
                if (bufferEof.readByte() != -2) {
                    throw new IOException("Packets out of order when reading field packets, expected was EOF stream." + (this.options.enablePacketDebug ? this.getTraces() : "Packet contents (hex) = " + Utils.hexdump(this.options.maxQuerySizeToLog, 0, bufferEof.limit, (byte[][])new byte[][]{bufferEof.buf})));
                }
                bufferEof.skipBytes(2);
                bufferEof.readShort();
            }
            return ci;
        }
        catch (IOException e) {
            throw this.handleIoException(e);
        }
    }

    private void readPacket(Results results) throws SQLException {
        Buffer buffer;
        try {
            buffer = this.reader.getPacket(true);
        }
        catch (IOException e) {
            throw this.handleIoException(e);
        }
        switch (buffer.getByteAt(0)) {
            case 0: {
                this.readOkPacket(buffer, results);
                break;
            }
            case -1: {
                throw this.readErrorPacket(buffer, results);
            }
            case -5: {
                this.readLocalInfilePacket(buffer, results);
                break;
            }
            default: {
                long fieldCount = buffer.getLengthEncodedNumeric();
                ColumnDefinition[] columns = new ColumnDefinition[(int)fieldCount];
                this.readResultSet(columns, results);
            }
        }
    }

    private void handleStateChange(Buffer buf, Results results) {
        Buffer stateInfo = buf.getLengthEncodedBuffer();
        block10: while (stateInfo.remaining() > 0) {
            switch (stateInfo.readByte()) {
                case 0: {
                    Buffer sessionVariableBuf = stateInfo.getLengthEncodedBuffer();
                    String variable = sessionVariableBuf.readStringLengthEncoded(StandardCharsets.UTF_8);
                    String value = sessionVariableBuf.readStringLengthEncoded(StandardCharsets.UTF_8);
                    logger.debug("System variable change :  {} = {}", (Object)variable, (Object)value);
                    switch (variable) {
                        case "auto_increment_increment": {
                            this.autoIncrementIncrement = Integer.parseInt(value);
                            results.setAutoIncrement(this.autoIncrementIncrement);
                            break;
                        }
                    }
                    continue block10;
                }
                case 1: {
                    Buffer sessionSchemaBuf = stateInfo.getLengthEncodedBuffer();
                    this.database = sessionSchemaBuf.readStringLengthEncoded(StandardCharsets.UTF_8);
                    logger.debug("Database change : now is '{}'", (Object)this.database);
                    continue block10;
                }
            }
            stateInfo.skipLengthEncodedBytes();
        }
    }

    @Override
    public int getAutoIncrementIncrement() throws SQLException {
        if (!this.options.connectProxy && this.autoIncrementIncrement == 0) {
            try {
                Results results = new Results();
                this.executeQuery(true, results, "select @@auto_increment_increment");
                results.commandEnd();
                SelectResultSet rs = results.getResultSet();
                rs.next();
                this.autoIncrementIncrement = rs.getInt(1);
            }
            catch (SQLException e) {
                if (e.getSQLState().startsWith("08")) {
                    throw e;
                }
                this.autoIncrementIncrement = 1;
            }
        }
        return this.autoIncrementIncrement;
    }

    @Override
    public void readOkPacket(Buffer buffer, Results results) {
        buffer.skipByte();
        long updateCount = buffer.getLengthEncodedNumeric();
        long insertId = buffer.getLengthEncodedNumeric();
        this.serverStatus = buffer.readShort();
        this.hasWarnings = buffer.readShort() > 0;
        String serverInfo = null;
        if (buffer.remaining() > 0) {
            if (this.sessionStateAware()) {
                serverInfo = buffer.readStringLengthEncoded(this.getWriter().getCharset());
                if (buffer.remaining() > 0 && (this.serverStatus & 0x4000) != 0) {
                    this.handleStateChange(buffer, results);
                }
            } else {
                serverInfo = buffer.readStringRestOfPacket(this.getWriter().getCharset());
            }
        }
        results.addStats(updateCount, insertId, this.hasMoreResults(), serverInfo);
    }

    @Override
    public SQLException readErrorPacket(Buffer buffer, Results results) {
        this.removeHasMoreResults();
        this.hasWarnings = false;
        ErrorPacket ep = new ErrorPacket(buffer);
        results.addStatsError(false);
        this.serverStatus = (short)(this.serverStatus | 1);
        this.removeActiveStreamingResult();
        if (1054 == ep.getErrorCode()) {
            return new SQLException(ep.getMessage() + "\nIf column exists but type cannot be identified (example 'select ? `field1` from dual'). Use CAST function to solve this problem (example 'select CAST(? as integer) `field1` from dual')", ep.getSqlState(), ep.getErrorCode());
        }
        return new SQLException(ep.getMessage(), ep.getSqlState(), ep.getErrorCode());
    }

    private void readLocalInfilePacket(Buffer buffer, Results results) throws SQLException {
        UUID spanId = this.ob20BeginTraceAndSpan("read local infile packet");
        int seq = 2;
        buffer.getLengthEncodedNumeric();
        String fileName = buffer.readStringNullEnd(StandardCharsets.UTF_8);
        try {
            InputStream is;
            this.writer.startPacket(seq);
            if (this.localInfileInputStream == null) {
                if (!this.getUrlParser().getOptions().allowLoadLocalInfile) {
                    this.writer.writeEmptyPacket();
                    this.reader.getPacket(true);
                    throw new SQLException("Usage of LOCAL INFILE is disabled. To use it enable it via the connection property allowLoadLocalInfile=true", SqlStates.FEATURE_NOT_SUPPORTED.getSqlState(), -1);
                }
                ServiceLoader<LocalInfileInterceptor> loader = ServiceLoader.load(LocalInfileInterceptor.class);
                for (LocalInfileInterceptor interceptor : loader) {
                    if (interceptor.validate(fileName)) continue;
                    this.writer.writeEmptyPacket();
                    this.reader.getPacket(true);
                    throw new SQLException("LOAD DATA LOCAL INFILE request to send local file named \"" + fileName + "\" not validated by interceptor \"" + interceptor.getClass().getName() + "\"");
                }
                if (results.getSql() == null) {
                    this.writer.writeEmptyPacket();
                    this.reader.getPacket(true);
                    throw new SQLException("LOAD DATA LOCAL INFILE not permit in batch. file '" + fileName + "'", SqlStates.INVALID_AUTHORIZATION.getSqlState(), -1);
                }
                try {
                    URL url = new URL(fileName);
                    is = url.openStream();
                }
                catch (IOException ioe) {
                    try {
                        is = new FileInputStream(fileName);
                    }
                    catch (FileNotFoundException f) {
                        this.writer.writeEmptyPacket();
                        this.reader.getPacket(true);
                        throw new SQLException("Could not send file : " + f.getMessage(), "22000", -1, f);
                    }
                }
            } else {
                is = this.localInfileInputStream;
                this.localInfileInputStream = null;
            }
            try {
                int len;
                byte[] buf = new byte[8192];
                while ((len = is.read(buf)) > 0) {
                    this.writer.startPacket(seq++);
                    this.writer.write(buf, 0, len);
                    this.writer.flushLoadDataLocalFile();
                }
                this.writer.writeEmptyPacket();
            }
            catch (IOException ioe) {
                throw this.handleIoException(ioe);
            }
            finally {
                is.close();
            }
            this.getResult(results);
        }
        catch (IOException e) {
            throw this.handleIoException(e);
        }
        finally {
            this.ob20EndSpanAndTrace(spanId);
        }
    }

    @Override
    public void readResultSet(ColumnDefinition[] ci, Results results) throws SQLException {
        try {
            for (int i = 0; i < ci.length; ++i) {
                ci[i] = new ColumnDefinition(this.reader.getPacket(false), this.isOracleMode(), this.options.getCharacterEncoding());
            }
            boolean callableResult = false;
            boolean isPsOutParamter = false;
            if (!this.eofDeprecated) {
                Buffer bufferEof = this.reader.getPacket(true);
                if (bufferEof.readByte() != -2) {
                    throw new IOException("Packets out of order when reading field packets, expected was EOF stream." + (this.options.enablePacketDebug ? this.getTraces() : "Packet contents (hex) = " + Utils.hexdump(this.options.maxQuerySizeToLog, 0, bufferEof.limit, (byte[][])new byte[][]{bufferEof.buf})));
                }
                bufferEof.skipBytes(2);
                short currentStatus = bufferEof.readShort();
                this.serverStatus = (short)(this.serverStatus | (short)(currentStatus & 1));
                callableResult = (currentStatus & 0x1000) != 0;
            }
            this.reader.getLogger().trace("Got column definition.");
            SelectResultSet selectResultSet = results.isToCursorFetch() || results.isToPrepareExecute() && !results.isInternalResult() && !callableResult ? (!this.isOracleMode() || results.getResultSetScrollType() == 1003 || results.getResultSetScrollType() == 1004 && results.getResultSetConcurrency() == 1007 ? new CursorResultSet(ci, results, this, callableResult, this.eofDeprecated, isPsOutParamter) : new SensitiveCursorResultSet(ci, results, this, callableResult, this.eofDeprecated, isPsOutParamter)) : new SelectResultSet(ci, results, this, this.reader, callableResult, this.eofDeprecated, isPsOutParamter);
            results.addResultSet(selectResultSet, this.hasMoreResults() || results.getFetchSize() > 0);
        }
        catch (IOException e) {
            throw this.handleIoException(e);
        }
    }

    @Override
    public void prologProxy(ServerPrepareResult serverPrepareResult, long maxRows, boolean hasProxy, OceanBaseConnection connection, OceanBaseStatement statement) throws SQLException {
        this.prolog(maxRows, hasProxy, connection, statement);
    }

    @Override
    public void prolog(long maxRows, boolean hasProxy, OceanBaseConnection connection, OceanBaseStatement statement) throws SQLException {
        if (this.explicitClosed) {
            throw new SQLNonTransientConnectionException("execute() is called on closed connection", "08000");
        }
        if (!hasProxy && this.shouldReconnectWithoutProxy()) {
            try {
                this.connectWithoutProxy();
            }
            catch (SQLException qe) {
                throw ExceptionFactory.of((int)this.serverThreadId, this.options).create(qe);
            }
        }
        try {
            this.setMaxRows(maxRows);
        }
        catch (SQLException qe) {
            throw ExceptionFactory.of((int)this.serverThreadId, this.options).create(qe);
        }
        connection.reenableWarnings();
    }

    @Override
    public ServerPrepareResult addPrepareInCache(String key, ServerPrepareResult serverPrepareResult) {
        return this.serverPrepareStatementCache.put(key, serverPrepareResult);
    }

    private void cmdPrologue() throws SQLException {
        if (this.activeStreamingResult != null) {
            if (!this.options.clobberStreamingResults) {
                throw new SQLException("Streaming result set " + this.activeStreamingResult + " is still active. No statements may be issued when any streaming result sets are open and in use on a given connection. Ensure that you have called .close() on any active streaming result sets before attempting more queries.");
            }
            this.activeStreamingResult.loadFully(true, this);
            this.activeStreamingResult = null;
        }
        if (this.activeFutureTask != null) {
            try {
                this.activeFutureTask.get();
            }
            catch (ExecutionException executionException) {
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
                throw new SQLException("Interrupted reading remaining batch response ", SqlStates.INTERRUPTED_EXCEPTION.getSqlState(), -1, interruptedException);
            }
            this.activeFutureTask = null;
        }
        if (!this.connected) {
            throw this.exceptionFactory.create("Connection is closed", "08000", 1220);
        }
        this.interrupted = false;
    }

    @Override
    public void resetStateAfterFailover(long maxRows, int transactionIsolationLevel, String database, boolean autocommit) throws SQLException {
        this.setMaxRows(maxRows);
        if (transactionIsolationLevel != 0) {
            this.setTransactionIsolation(transactionIsolationLevel);
        }
        if (database != null && !"".equals(database) && !this.getDatabase().equals(database)) {
            this.setCatalog(database);
        }
        if (this.getAutocommit() != autocommit) {
            this.executeQuery("set autocommit=" + (autocommit ? "1" : "0"));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public SQLException handleIoException(Exception initialException) {
        boolean maxSizeError;
        boolean mustReconnect = this.options.autoReconnect;
        if (initialException instanceof MaxAllowedPacketException) {
            maxSizeError = true;
            if (!((MaxAllowedPacketException)initialException).isMustReconnect()) return new SQLNonTransientConnectionException(initialException.getMessage() + this.getTraces(), SqlStates.UNDEFINED_SQLSTATE.getSqlState(), initialException);
            mustReconnect = true;
        } else {
            maxSizeError = this.writer.exceedMaxLength();
            if (maxSizeError) {
                mustReconnect = true;
            }
        }
        if (mustReconnect && !this.explicitClosed) {
            String traces = this.getTraces();
            this.connect();
            try {
                this.resetStateAfterFailover(this.getMaxRows(), this.getTransactionIsolationLevel(), this.getDatabase(), this.getAutocommit());
                if (maxSizeError) {
                    return new SQLTransientConnectionException("Could not send query: query size is >= to max_allowed_packet (" + this.writer.getMaxAllowedPacket() + ")" + traces, "HY000", initialException);
                }
                this.cleanMemory();
                return new SQLTransientConnectionException(initialException.getMessage() + traces, "HY000", initialException);
            }
            catch (SQLException queryException) {
                try {
                    return new SQLTransientConnectionException("reconnection succeed, but resetting previous state failed" + traces, "HY000", initialException);
                }
                catch (IOException | SQLException queryException2) {
                    this.connected = false;
                    this.whyConnectedIsFalse();
                    return new SQLNonTransientConnectionException(initialException.getMessage() + "\nError during reconnection" + traces, "08000", queryException2);
                }
            }
        }
        this.connected = false;
        this.whyConnectedIsFalse();
        return new SQLNonTransientConnectionException(initialException.getMessage() + this.getTraces(), "08000", initialException);
    }

    @Override
    public void setActiveFutureTask(FutureTask activeFutureTask) {
        this.activeFutureTask = activeFutureTask;
    }

    @Override
    public void interrupt() {
        this.interrupted = true;
    }

    @Override
    public boolean isInterrupted() {
        return this.interrupted;
    }

    @Override
    public void stopIfInterrupted() throws SQLTimeoutException {
        if (this.isInterrupted()) {
            throw new SQLTimeoutException("Timeout during batch execution");
        }
    }

    @Override
    public long getChecksum() {
        return this.checksum;
    }

    @Override
    public void setChecksum(long checksum) {
        this.checksum = checksum;
    }

    @Override
    public void resetChecksum() {
        this.checksum = 1L;
    }

    @Override
    public int getIterationCount() {
        return this.iterationCount;
    }

    @Override
    public void setIterationCount(int iterationCount) {
        this.iterationCount = iterationCount;
    }

    @Override
    public int getExecuteMode() {
        return this.executeMode;
    }

    @Override
    public void setExecuteMode(int executeMode) {
        this.executeMode = executeMode;
    }

    @Override
    public void setComStmtPrepareExecuteField(int iterationCount, int executeMode, long checksum) {
        this.iterationCount = iterationCount;
        this.executeMode = executeMode;
        this.checksum = checksum;
    }

    private UUID ob20BeginTraceAndSpan(String tagStr) {
        this.ob20BeginTrace();
        return this.ob20BeginSpan(tagStr);
    }

    private void ob20BeginTrace() {
        if (this.enableFullLinkTrace) {
            try {
                if (this.fullLinkTrace.isShowTraceEnabled() || !this.inTransaction()) {
                    this.fullLinkTrace.beginTrace();
                }
            }
            catch (Exception e) {
                try {
                    logger.warn("ob20BeginTrace failed.", e);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    private UUID ob20BeginSpan(String tagStr) {
        UUID spanId = null;
        if (this.enableFullLinkTrace) {
            try {
                spanId = this.fullLinkTrace.beginSpan(0);
                this.fullLinkTrace.setSpanTag(1, FullLinkTrace.TagKey.COMMAND_NAME.getString(), tagStr);
                this.fullLinkTrace.setSpanTag(1, FullLinkTrace.TagKey.CLIENT_HOST.getString(), this.socket.getLocalAddress().getHostAddress() + ":" + this.socket.getLocalPort());
                this.fullLinkTrace.buildRequest(this.ob20);
            }
            catch (Exception e) {
                try {
                    logger.warn("ob20BeginSpan failed.", e);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return spanId;
    }

    private void ob20EndSpanAndTrace(UUID spanId) {
        if (this.enableFullLinkTrace) {
            try {
                if (spanId != null) {
                    this.fullLinkTrace.endSpan(spanId);
                    if (this.fullLinkTrace.isShowTraceEnabled() || !this.inTransaction()) {
                        this.fullLinkTrace.endTrace();
                    }
                }
            }
            catch (Exception e) {
                try {
                    logger.warn("ob20EndSpanAndTrace failed.", e);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }
}

