/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.jdbc.internal.com.read.dao;

import com.oceanbase.jdbc.internal.com.read.dao.CmdInformation;
import com.oceanbase.jdbc.internal.com.read.resultset.SelectResultSet;
import com.oceanbase.jdbc.internal.protocol.Protocol;
import java.sql.ResultSet;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;

public class CmdInformationBatch
implements CmdInformation {
    private final Queue<Long> insertIds = new ConcurrentLinkedQueue<Long>();
    private final Queue<Long> updateCounts = new ConcurrentLinkedQueue<Long>();
    private final int expectedSize;
    private final int autoIncrement;
    private int insertIdNumber = 0;
    private boolean hasException;
    private boolean rewritten;
    private String serverInfo;

    public CmdInformationBatch(int expectedSize, int autoIncrement) {
        this.expectedSize = expectedSize;
        this.autoIncrement = autoIncrement;
    }

    @Override
    public void addErrorStat() {
        this.hasException = true;
        this.updateCounts.add(-3L);
    }

    @Override
    public void reset() {
        this.insertIds.clear();
        this.updateCounts.clear();
        this.insertIdNumber = 0;
        this.hasException = false;
        this.rewritten = false;
    }

    @Override
    public void addResultSetStat() {
        this.updateCounts.add(-1L);
    }

    @Override
    public void addSuccessStat(long updateCount, long insertId) {
        this.insertIds.add(insertId);
        this.insertIdNumber = (int)((long)this.insertIdNumber + updateCount);
        this.updateCounts.add(updateCount);
    }

    @Override
    public void addSuccessStat(long updateCount, long insertId, boolean containOnDuplicateKey, String serverInfo) {
        if (containOnDuplicateKey && updateCount == 0L) {
            updateCount = 1L;
        }
        this.addSuccessStat(updateCount, insertId);
        this.serverInfo = serverInfo;
    }

    @Override
    public int[] getUpdateCounts() {
        if (this.rewritten) {
            int resultValue;
            int[] ret = new int[this.expectedSize];
            if (this.hasException) {
                resultValue = -3;
            } else if (this.expectedSize == 1) {
                resultValue = this.updateCounts.element().intValue();
            } else {
                resultValue = 0;
                Iterator iterator = this.updateCounts.iterator();
                while (iterator.hasNext()) {
                    if (((Long)iterator.next()).intValue() == 0) continue;
                    resultValue = -2;
                }
            }
            Arrays.fill(ret, resultValue);
            return ret;
        }
        int[] ret = new int[Math.max(this.updateCounts.size(), this.expectedSize)];
        Iterator iterator = this.updateCounts.iterator();
        int pos = 0;
        while (iterator.hasNext()) {
            ret[pos++] = ((Long)iterator.next()).intValue();
        }
        while (pos < ret.length) {
            ret[pos++] = -3;
        }
        return ret;
    }

    @Override
    public int[] getServerUpdateCounts() {
        int[] ret = new int[this.updateCounts.size()];
        Iterator iterator = this.updateCounts.iterator();
        int pos = 0;
        while (iterator.hasNext()) {
            ret[pos++] = ((Long)iterator.next()).intValue();
        }
        return ret;
    }

    @Override
    public long[] getLargeUpdateCounts() {
        if (this.rewritten) {
            long resultValue;
            long[] ret = new long[this.expectedSize];
            if (this.hasException) {
                resultValue = -3L;
            } else if (this.expectedSize == 1) {
                resultValue = this.updateCounts.element();
            } else {
                resultValue = 0L;
                Iterator iterator = this.updateCounts.iterator();
                while (iterator.hasNext()) {
                    if (((Long)iterator.next()).intValue() == 0) continue;
                    resultValue = -2L;
                }
            }
            Arrays.fill(ret, resultValue);
            return ret;
        }
        long[] ret = new long[Math.max(this.updateCounts.size(), this.expectedSize)];
        Iterator iterator = this.updateCounts.iterator();
        int pos = 0;
        while (iterator.hasNext()) {
            ret[pos++] = (Long)iterator.next();
        }
        while (pos < ret.length) {
            ret[pos++] = -3L;
        }
        return ret;
    }

    @Override
    public int getUpdateCount() {
        Long updateCount = this.updateCounts.peek();
        return updateCount == null ? -1 : updateCount.intValue();
    }

    @Override
    public long getLargeUpdateCount() {
        Long updateCount = this.updateCounts.peek();
        return updateCount == null ? -1L : updateCount;
    }

    @Override
    public String getServerInfo() {
        return this.serverInfo;
    }

    @Override
    public ResultSet getBatchGeneratedKeys(Protocol protocol) {
        long[] ret = new long[this.insertIdNumber == 0 ? this.insertIds.size() : this.insertIdNumber];
        int position = 0;
        Iterator idIterator = this.insertIds.iterator();
        for (Long updateCountLong : this.updateCounts) {
            long insertId;
            int updateCount = updateCountLong.intValue();
            if (updateCount == -3 || updateCount == -1 || (insertId = ((Long)idIterator.next()).longValue()) <= 0L) continue;
            for (int i = 0; i < updateCount; ++i) {
                ret[position++] = insertId + (long)(i * this.autoIncrement);
            }
        }
        return SelectResultSet.createGeneratedData(ret, protocol, true);
    }

    @Override
    public ResultSet getGeneratedKeys(Protocol protocol, String sql) {
        long[] ret = new long[this.insertIdNumber == 0 ? this.insertIds.size() : this.insertIdNumber];
        int position = 0;
        Iterator idIterator = this.insertIds.iterator();
        for (Long updateCountLong : this.updateCounts) {
            long insertId;
            int updateCount = 0;
            updateCount = protocol.getOptions().useAffectedRows ? 1 : updateCountLong.intValue();
            if (updateCount == -3 || updateCount == -1 || (insertId = ((Long)idIterator.next()).longValue()) <= 0L) continue;
            for (int i = 0; i < updateCount; ++i) {
                ret[position++] = insertId + (long)(i * this.autoIncrement);
            }
        }
        return SelectResultSet.createGeneratedData(ret, protocol, true);
    }

    @Override
    public int getCurrentStatNumber() {
        return this.updateCounts.size();
    }

    @Override
    public boolean moreResults() {
        return false;
    }

    @Override
    public boolean isCurrentUpdateCount() {
        return false;
    }

    @Override
    public void setRewrite(boolean rewritten) {
        this.rewritten = rewritten;
    }

    @Override
    public boolean getRewrite() {
        return this.rewritten;
    }
}

