/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.zuul.util;

import com.netflix.zuul.exception.ZuulException;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.http.HttpContent;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.GZIPOutputStream;

public class Gzipper {
    private final ByteArrayOutputStream baos;
    private final GZIPOutputStream gzos;

    public Gzipper() throws RuntimeException {
        try {
            this.baos = new ByteArrayOutputStream(256);
            this.gzos = new GZIPOutputStream((OutputStream)this.baos, true);
        }
        catch (IOException e) {
            throw new RuntimeException("Error finalizing the GzipOutputstream", e);
        }
    }

    private void write(ByteBuf bb) throws IOException {
        int offset;
        byte[] bytes;
        int length = bb.readableBytes();
        if (bb.hasArray()) {
            bytes = bb.array();
            offset = bb.arrayOffset();
        } else {
            bytes = new byte[length];
            bb.getBytes(bb.readerIndex(), bytes);
            offset = 0;
        }
        this.gzos.write(bytes, offset, length);
    }

    public void write(HttpContent chunk) {
        try {
            this.write(chunk.content());
            this.gzos.flush();
        }
        catch (IOException ioEx) {
            throw new ZuulException(ioEx, "Error Gzipping response content chunk", true);
        }
        finally {
            chunk.release();
        }
    }

    public void finish() throws RuntimeException {
        try {
            this.gzos.finish();
            this.gzos.flush();
            this.gzos.close();
        }
        catch (IOException ioEx) {
            throw new ZuulException(ioEx, "Error finalizing the GzipOutputStream", true);
        }
    }

    public ByteBuf getByteBuf() {
        ByteBuf copy = Unpooled.copiedBuffer((byte[])this.baos.toByteArray());
        this.baos.reset();
        return copy;
    }
}

