/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.zuul.origins;

import com.netflix.client.config.CommonClientConfigKey;
import com.netflix.client.config.DefaultClientConfigImpl;
import com.netflix.client.config.IClientConfig;
import com.netflix.config.CachedDynamicBooleanProperty;
import com.netflix.config.CachedDynamicIntProperty;
import com.netflix.loadbalancer.Server;
import com.netflix.loadbalancer.reactive.ExecutionContext;
import com.netflix.niws.loadbalancer.DiscoveryEnabledServer;
import com.netflix.spectator.api.Counter;
import com.netflix.spectator.api.Registry;
import com.netflix.zuul.context.SessionContext;
import com.netflix.zuul.exception.ErrorType;
import com.netflix.zuul.message.http.HttpRequestMessage;
import com.netflix.zuul.message.http.HttpResponseMessage;
import com.netflix.zuul.netty.NettyRequestAttemptFactory;
import com.netflix.zuul.netty.SpectatorUtils;
import com.netflix.zuul.netty.connectionpool.ClientChannelManager;
import com.netflix.zuul.netty.connectionpool.DefaultClientChannelManager;
import com.netflix.zuul.netty.connectionpool.PooledConnection;
import com.netflix.zuul.niws.RequestAttempt;
import com.netflix.zuul.origins.NettyOrigin;
import com.netflix.zuul.origins.OriginConcurrencyExceededException;
import com.netflix.zuul.passport.CurrentPassport;
import com.netflix.zuul.stats.Timing;
import com.netflix.zuul.stats.status.StatusCategory;
import com.netflix.zuul.stats.status.StatusCategoryUtils;
import com.netflix.zuul.stats.status.ZuulStatusCategory;
import io.netty.channel.EventLoop;
import io.netty.util.concurrent.Promise;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.lang3.StringUtils;

public class BasicNettyOrigin
implements NettyOrigin {
    private final String name;
    private final String vip;
    private final Registry registry;
    private final IClientConfig config;
    private final ClientChannelManager clientChannelManager;
    private final NettyRequestAttemptFactory requestAttemptFactory;
    private final AtomicInteger concurrentRequests;
    private final Counter rejectedRequests;
    private final CachedDynamicIntProperty concurrencyMax;
    private final CachedDynamicBooleanProperty concurrencyProtectionEnabled;

    public BasicNettyOrigin(String name, String vip, Registry registry) {
        this.name = name;
        this.vip = vip;
        this.registry = registry;
        this.config = this.setupClientConfig(name);
        this.clientChannelManager = new DefaultClientChannelManager(name, vip, this.config, registry);
        this.clientChannelManager.init();
        this.requestAttemptFactory = new NettyRequestAttemptFactory();
        this.concurrentRequests = SpectatorUtils.newGauge("zuul.origin.concurrent.requests", name, new AtomicInteger(0));
        this.rejectedRequests = SpectatorUtils.newCounter("zuul.origin.rejected.requests", name);
        this.concurrencyMax = new CachedDynamicIntProperty("zuul.origin." + name + ".concurrency.max.requests", 200);
        this.concurrencyProtectionEnabled = new CachedDynamicBooleanProperty("zuul.origin." + name + ".concurrency.protect.enabled", true);
    }

    protected IClientConfig setupClientConfig(String name) {
        DefaultClientConfigImpl niwsClientConfig = DefaultClientConfigImpl.getClientConfigWithDefaultValues((String)name);
        niwsClientConfig.set(CommonClientConfigKey.ClientClassName, (Object)name);
        niwsClientConfig.loadProperties(name);
        return niwsClientConfig;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getVip() {
        return this.vip;
    }

    @Override
    public boolean isAvailable() {
        return this.clientChannelManager.isAvailable();
    }

    @Override
    public boolean isCold() {
        return this.clientChannelManager.isCold();
    }

    @Override
    public Promise<PooledConnection> connectToOrigin(HttpRequestMessage zuulReq, EventLoop eventLoop, int attemptNumber, CurrentPassport passport, AtomicReference<Server> chosenServer, AtomicReference<String> chosenHostAddr) {
        return this.clientChannelManager.acquire(eventLoop, null, zuulReq.getMethod().toUpperCase(), zuulReq.getPath(), attemptNumber, passport, chosenServer, chosenHostAddr);
    }

    @Override
    public Timing getProxyTiming(HttpRequestMessage zuulReq) {
        return new Timing(this.name);
    }

    @Override
    public int getMaxRetriesForRequest(SessionContext context) {
        return (Integer)this.config.get(CommonClientConfigKey.MaxAutoRetriesNextServer, (Object)0);
    }

    @Override
    public RequestAttempt newRequestAttempt(Server server, SessionContext zuulCtx, int attemptNum) {
        return new RequestAttempt(server, this.config, attemptNum, (Integer)this.config.get(CommonClientConfigKey.ReadTimeout));
    }

    @Override
    public String getIpAddrFromServer(Server server) {
        String ip;
        DiscoveryEnabledServer discoveryServer;
        if (server instanceof DiscoveryEnabledServer && (discoveryServer = (DiscoveryEnabledServer)server).getInstanceInfo() != null && StringUtils.isNotBlank((CharSequence)(ip = discoveryServer.getInstanceInfo().getIPAddr()))) {
            return ip;
        }
        return null;
    }

    @Override
    public IClientConfig getClientConfig() {
        return this.config;
    }

    @Override
    public Registry getSpectatorRegistry() {
        return this.registry;
    }

    @Override
    public ExecutionContext<?> getExecutionContext(HttpRequestMessage zuulRequest) {
        ExecutionContext execCtx = (ExecutionContext)zuulRequest.getContext().get("rest_exec_ctx");
        if (execCtx == null) {
            IClientConfig overriddenClientConfig = (IClientConfig)zuulRequest.getContext().get("rest_client_config");
            if (overriddenClientConfig == null) {
                overriddenClientConfig = new DefaultClientConfigImpl();
                zuulRequest.getContext().put("rest_client_config", overriddenClientConfig);
            }
            ExecutionContext context = new ExecutionContext((Object)zuulRequest, overriddenClientConfig, this.config, null);
            context.put("vip", (Object)this.getVip());
            context.put("clientName", (Object)this.getName());
            zuulRequest.getContext().set("rest_exec_ctx", context);
            execCtx = context;
        }
        return execCtx;
    }

    @Override
    public void recordFinalError(HttpRequestMessage requestMsg, Throwable throwable) {
        if (throwable == null) {
            return;
        }
        SessionContext zuulCtx = requestMsg.getContext();
        ErrorType et = this.requestAttemptFactory.mapNettyToOutboundErrorType(throwable);
        StatusCategory nfs = et.getStatusCategory();
        zuulCtx.set("status_category", nfs);
        zuulCtx.set("origin_status_category", nfs);
        zuulCtx.setError(throwable);
    }

    @Override
    public void recordFinalResponse(HttpResponseMessage resp) {
        if (resp != null) {
            SessionContext zuulCtx = resp.getContext();
            int originStatusCode = resp.getStatus();
            zuulCtx.set("origin_status", originStatusCode);
            ZuulStatusCategory originNfs = ZuulStatusCategory.SUCCESS;
            if (originStatusCode == 503) {
                originNfs = ZuulStatusCategory.FAILURE_ORIGIN_THROTTLED;
            } else if (StatusCategoryUtils.isResponseHttpErrorStatus(originStatusCode)) {
                originNfs = ZuulStatusCategory.FAILURE_ORIGIN;
            }
            zuulCtx.set("origin_status_category", originNfs);
            StatusCategoryUtils.storeStatusCategoryIfNotAlreadyFailure(zuulCtx, originNfs);
        }
    }

    @Override
    public void preRequestChecks(HttpRequestMessage zuulRequest) {
        if (this.concurrencyProtectionEnabled.get() && this.concurrentRequests.get() > this.concurrencyMax.get()) {
            this.rejectedRequests.increment();
            throw new OriginConcurrencyExceededException(this.getName());
        }
        this.concurrentRequests.incrementAndGet();
    }

    @Override
    public void recordProxyRequestEnd() {
        this.concurrentRequests.decrementAndGet();
    }

    @Override
    public double getErrorPercentage() {
        return 0.0;
    }

    @Override
    public double getErrorAllPercentage() {
        return 0.0;
    }

    @Override
    public void onRequestExecutionStart(HttpRequestMessage zuulReq) {
    }

    @Override
    public void onRequestStartWithServer(HttpRequestMessage zuulReq, Server originServer, int attemptNum) {
    }

    @Override
    public void onRequestExceptionWithServer(HttpRequestMessage zuulReq, Server originServer, int attemptNum, Throwable t) {
    }

    @Override
    public void onRequestExecutionSuccess(HttpRequestMessage zuulReq, HttpResponseMessage zuulResp, Server originServer, int attemptNum) {
    }

    @Override
    public void onRequestExecutionFailed(HttpRequestMessage zuulReq, Server originServer, int attemptNum, Throwable t) {
    }

    @Override
    public void adjustRetryPolicyIfNeeded(HttpRequestMessage zuulRequest) {
    }

    @Override
    public void recordSuccessResponse() {
    }
}

