/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.zuul.netty.server.push;

import com.netflix.netty.common.channel.config.ChannelConfig;
import com.netflix.zuul.netty.server.BaseZuulChannelInitializer;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.group.ChannelGroup;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpServerCodec;

public abstract class PushChannelInitializer
extends BaseZuulChannelInitializer {
    public PushChannelInitializer(int port, ChannelConfig channelConfig, ChannelConfig channelDependencies, ChannelGroup channels) {
        super(port, channelConfig, channelDependencies, channels);
    }

    @Override
    protected void addHttp1Handlers(ChannelPipeline pipeline) {
        pipeline.addLast("codec", (ChannelHandler)new HttpServerCodec(MAX_INITIAL_LINE_LENGTH.get(), MAX_HEADER_SIZE.get(), MAX_CHUNK_SIZE.get(), false));
        pipeline.addLast(new ChannelHandler[]{new HttpObjectAggregator(8192)});
    }

    @Override
    protected void addHttpRelatedHandlers(ChannelPipeline pipeline) {
        pipeline.addLast(new ChannelHandler[]{this.stripInboundProxyHeadersHandler});
    }

    protected void initChannel(Channel ch) throws Exception {
        ChannelPipeline pipeline = ch.pipeline();
        this.storeChannel(ch);
        this.addTcpRelatedHandlers(pipeline);
        this.addHttp1Handlers(pipeline);
        this.addHttpRelatedHandlers(pipeline);
        this.addPushHandlers(pipeline);
    }

    protected abstract void addPushHandlers(ChannelPipeline var1);
}

