/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.zuul.netty.server;

import com.netflix.appinfo.InstanceInfo;
import com.netflix.config.DynamicBooleanProperty;
import com.netflix.netty.common.CategorizedThreadFactory;
import com.netflix.netty.common.LeastConnsEventLoopChooserFactory;
import com.netflix.netty.common.metrics.EventLoopGroupMetrics;
import com.netflix.netty.common.status.ServerStatusManager;
import com.netflix.zuul.netty.server.ClientConnectionsShutdown;
import com.netflix.zuul.netty.server.DefaultEventLoopConfig;
import com.netflix.zuul.netty.server.EventLoopConfig;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.DefaultSelectStrategyFactory;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.epoll.EpollChannelOption;
import io.netty.channel.epoll.EpollEventLoopGroup;
import io.netty.channel.epoll.EpollServerSocketChannel;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.util.concurrent.DefaultEventExecutorChooserFactory;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.EventExecutorChooserFactory;
import io.netty.util.concurrent.ThreadPerTaskExecutor;
import java.lang.constant.Constable;
import java.nio.channels.spi.SelectorProvider;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Server {
    public static final DynamicBooleanProperty USE_EPOLL = new DynamicBooleanProperty("zuul.server.netty.socket.epoll", false);
    private static final Logger LOG = LoggerFactory.getLogger(Server.class);
    private static final DynamicBooleanProperty USE_LEASTCONNS_FOR_EVENTLOOPS = new DynamicBooleanProperty("zuul.server.eventloops.use_leastconns", false);
    private final EventLoopGroupMetrics eventLoopGroupMetrics;
    private final Thread jvmShutdownHook;
    private ServerGroup serverGroup;
    private final ClientConnectionsShutdown clientConnectionsShutdown;
    private final ServerStatusManager serverStatusManager;
    private final Map<Integer, ChannelInitializer> portsToChannelInitializers;
    private final EventLoopConfig eventLoopConfig;

    public Server(Map<Integer, ChannelInitializer> portsToChannelInitializers, ServerStatusManager serverStatusManager, ClientConnectionsShutdown clientConnectionsShutdown, EventLoopGroupMetrics eventLoopGroupMetrics) {
        this(portsToChannelInitializers, serverStatusManager, clientConnectionsShutdown, eventLoopGroupMetrics, new DefaultEventLoopConfig());
    }

    public Server(Map<Integer, ChannelInitializer> portsToChannelInitializers, ServerStatusManager serverStatusManager, ClientConnectionsShutdown clientConnectionsShutdown, EventLoopGroupMetrics eventLoopGroupMetrics, EventLoopConfig eventLoopConfig) {
        this.portsToChannelInitializers = portsToChannelInitializers;
        this.serverStatusManager = serverStatusManager;
        this.clientConnectionsShutdown = clientConnectionsShutdown;
        this.eventLoopConfig = eventLoopConfig;
        this.eventLoopGroupMetrics = eventLoopGroupMetrics;
        this.jvmShutdownHook = new Thread(() -> this.stop(), "Zuul-JVM-shutdown-hook");
    }

    public void stop() {
        LOG.warn("Shutting down Zuul.");
        this.serverGroup.stop();
        try {
            Runtime.getRuntime().removeShutdownHook(this.jvmShutdownHook);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        LOG.warn("Completed zuul shutdown.");
    }

    public void start(boolean sync) {
        this.serverGroup = new ServerGroup("Salamander", this.eventLoopConfig.acceptorCount(), this.eventLoopConfig.eventLoopCount(), this.eventLoopGroupMetrics);
        this.serverGroup.initializeTransport();
        try {
            ArrayList<ChannelFuture> allBindFutures = new ArrayList<ChannelFuture>();
            for (Map.Entry<Integer, ChannelInitializer> entry : this.portsToChannelInitializers.entrySet()) {
                allBindFutures.add(this.setupServerBootstrap(entry.getKey(), entry.getValue()));
            }
            for (ChannelFuture f : allBindFutures) {
                ChannelFuture cf = f.channel().closeFuture();
                if (!sync) continue;
                cf.sync();
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    public void waitForEachEventLoop() throws InterruptedException, ExecutionException {
        for (EventExecutor exec : this.serverGroup.clientToProxyWorkerPool) {
            exec.submit(() -> {}).get();
        }
    }

    private ChannelFuture setupServerBootstrap(int port, ChannelInitializer channelInitializer) throws InterruptedException {
        ServerBootstrap serverBootstrap = new ServerBootstrap().group(this.serverGroup.clientToProxyBossPool, this.serverGroup.clientToProxyWorkerPool);
        HashMap<ChannelOption, Constable> channelOptions = new HashMap<ChannelOption, Constable>();
        channelOptions.put(ChannelOption.SO_BACKLOG, Integer.valueOf(128));
        channelOptions.put(ChannelOption.SO_LINGER, Integer.valueOf(-1));
        channelOptions.put(ChannelOption.TCP_NODELAY, Boolean.valueOf(true));
        channelOptions.put(ChannelOption.SO_KEEPALIVE, Boolean.valueOf(true));
        if (USE_EPOLL.get()) {
            LOG.warn("Proxy listening with TCP transport using EPOLL");
            serverBootstrap = (ServerBootstrap)serverBootstrap.channel(EpollServerSocketChannel.class);
            channelOptions.put(EpollChannelOption.TCP_DEFER_ACCEPT, Integer.valueOf(-1));
        } else {
            LOG.warn("Proxy listening with TCP transport using NIO");
            serverBootstrap = (ServerBootstrap)serverBootstrap.channel(NioServerSocketChannel.class);
        }
        for (Map.Entry optionEntry : channelOptions.entrySet()) {
            serverBootstrap = (ServerBootstrap)serverBootstrap.option((ChannelOption)optionEntry.getKey(), optionEntry.getValue());
        }
        serverBootstrap.childHandler((ChannelHandler)channelInitializer);
        serverBootstrap.validate();
        LOG.info("Binding to port: " + port);
        this.serverStatusManager.localStatus(InstanceInfo.InstanceStatus.UP);
        return serverBootstrap.bind(port).sync();
    }

    public void postEventLoopCreationHook(EventLoopGroup clientToProxyBossPool, EventLoopGroup clientToProxyWorkerPool) {
    }

    private class ServerGroup {
        private final String name;
        private final int acceptorThreads;
        private final int workerThreads;
        private final EventLoopGroupMetrics eventLoopGroupMetrics;
        private EventLoopGroup clientToProxyBossPool;
        private EventLoopGroup clientToProxyWorkerPool;
        private volatile boolean stopped = false;

        private ServerGroup(String name, int acceptorThreads, int workerThreads, EventLoopGroupMetrics eventLoopGroupMetrics) {
            this.name = name;
            this.acceptorThreads = acceptorThreads;
            this.workerThreads = workerThreads;
            this.eventLoopGroupMetrics = eventLoopGroupMetrics;
            Thread.setDefaultUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

                @Override
                public void uncaughtException(Thread t, Throwable e) {
                    LOG.error("Uncaught throwable", e);
                }
            });
            Runtime.getRuntime().addShutdownHook(new Thread(() -> this.stop(), "Zuul-ServerGroup-JVM-shutdown-hook"));
        }

        private void initializeTransport() {
            Object chooserFactory = USE_LEASTCONNS_FOR_EVENTLOOPS.get() ? new LeastConnsEventLoopChooserFactory(this.eventLoopGroupMetrics) : DefaultEventExecutorChooserFactory.INSTANCE;
            CategorizedThreadFactory workerThreadFactory = new CategorizedThreadFactory(this.name + "-ClientToZuulWorker");
            ThreadPerTaskExecutor workerExecutor = new ThreadPerTaskExecutor((ThreadFactory)workerThreadFactory);
            if (USE_EPOLL.get()) {
                this.clientToProxyBossPool = new EpollEventLoopGroup(this.acceptorThreads, (ThreadFactory)new CategorizedThreadFactory(this.name + "-ClientToZuulAcceptor"));
                this.clientToProxyWorkerPool = new EpollEventLoopGroup(this.workerThreads, (Executor)workerExecutor, (EventExecutorChooserFactory)chooserFactory, DefaultSelectStrategyFactory.INSTANCE);
            } else {
                this.clientToProxyBossPool = new NioEventLoopGroup(this.acceptorThreads, (ThreadFactory)new CategorizedThreadFactory(this.name + "-ClientToZuulAcceptor"));
                this.clientToProxyWorkerPool = new NioEventLoopGroup(this.workerThreads, (Executor)workerExecutor, (EventExecutorChooserFactory)chooserFactory, SelectorProvider.provider(), DefaultSelectStrategyFactory.INSTANCE);
                ((NioEventLoopGroup)this.clientToProxyWorkerPool).setIoRatio(90);
            }
            Server.this.postEventLoopCreationHook(this.clientToProxyBossPool, this.clientToProxyWorkerPool);
        }

        private synchronized void stop() {
            LOG.warn("Shutting down");
            if (this.stopped) {
                LOG.warn("Already stopped");
                return;
            }
            Server.this.serverStatusManager.localStatus(InstanceInfo.InstanceStatus.DOWN);
            Server.this.clientConnectionsShutdown.gracefullyShutdownClientChannels();
            LOG.warn("Shutting down event loops");
            ArrayList<EventLoopGroup> allEventLoopGroups = new ArrayList<EventLoopGroup>();
            allEventLoopGroups.add(this.clientToProxyBossPool);
            allEventLoopGroups.add(this.clientToProxyWorkerPool);
            for (EventLoopGroup group : allEventLoopGroups) {
                group.shutdownGracefully();
            }
            for (EventLoopGroup group : allEventLoopGroups) {
                try {
                    group.awaitTermination(20L, TimeUnit.SECONDS);
                }
                catch (InterruptedException ie) {
                    LOG.warn("Interrupted while shutting down event loop");
                }
            }
            this.stopped = true;
            LOG.warn("Done shutting down");
        }
    }
}

