/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.zuul.netty.insights;

import com.netflix.spectator.api.Registry;
import com.netflix.zuul.passport.CurrentPassport;
import com.netflix.zuul.passport.PassportState;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandler;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelOutboundHandler;
import io.netty.channel.ChannelOutboundHandlerAdapter;
import io.netty.channel.ChannelPromise;
import io.netty.channel.CombinedChannelDuplexHandler;
import io.netty.channel.unix.Errors;
import io.netty.handler.timeout.IdleStateEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PassportStateServerHandler
extends CombinedChannelDuplexHandler {
    private static final Logger LOG = LoggerFactory.getLogger(PassportStateServerHandler.class);
    private static Registry registry;

    public PassportStateServerHandler(Registry registry) {
        super((ChannelInboundHandler)new InboundHandler(), (ChannelOutboundHandler)new OutboundHandler());
        PassportStateServerHandler.registry = registry;
    }

    private static CurrentPassport passport(ChannelHandlerContext ctx) {
        return CurrentPassport.fromChannel(ctx.channel());
    }

    protected static void incrementExceptionCounter(Throwable throwable, String handler) {
        registry.counter("server.connection.exception", new String[]{"handler", handler, "id", throwable.getClass().getSimpleName()}).increment();
    }

    private static class OutboundHandler
    extends ChannelOutboundHandlerAdapter {
        private OutboundHandler() {
        }

        public void close(ChannelHandlerContext ctx, ChannelPromise promise) throws Exception {
            PassportStateServerHandler.passport(ctx).add(PassportState.SERVER_CH_CLOSE);
            super.close(ctx, promise);
        }

        public void disconnect(ChannelHandlerContext ctx, ChannelPromise promise) throws Exception {
            PassportStateServerHandler.passport(ctx).add(PassportState.SERVER_CH_DISCONNECT);
            super.disconnect(ctx, promise);
        }

        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
            PassportStateServerHandler.passport(ctx).add(PassportState.SERVER_CH_EXCEPTION);
            if (cause instanceof Errors.NativeIoException) {
                LOG.debug("PassportStateServerHandler Outbound NativeIoException " + cause);
                PassportStateServerHandler.incrementExceptionCounter(cause, "PassportStateServerHandler.Outbound");
            } else {
                super.exceptionCaught(ctx, cause);
            }
        }
    }

    private static class InboundHandler
    extends ChannelInboundHandlerAdapter {
        private InboundHandler() {
        }

        public void channelActive(ChannelHandlerContext ctx) throws Exception {
            PassportStateServerHandler.passport(ctx).add(PassportState.SERVER_CH_ACTIVE);
            super.channelActive(ctx);
        }

        public void channelInactive(ChannelHandlerContext ctx) throws Exception {
            PassportStateServerHandler.passport(ctx).add(PassportState.SERVER_CH_INACTIVE);
            super.channelInactive(ctx);
        }

        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
            PassportStateServerHandler.passport(ctx).add(PassportState.SERVER_CH_EXCEPTION);
            if (cause instanceof Errors.NativeIoException) {
                LOG.debug("PassportStateServerHandler Inbound NativeIoException " + cause);
                PassportStateServerHandler.incrementExceptionCounter(cause, "PassportStateServerHandler.Inbound");
            } else {
                super.exceptionCaught(ctx, cause);
            }
        }

        public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
            CurrentPassport passport;
            if (evt instanceof IdleStateEvent && (passport = CurrentPassport.fromChannel(ctx.channel())) != null) {
                passport.add(PassportState.SERVER_CH_IDLE_TIMEOUT);
            }
            super.userEventTriggered(ctx, evt);
        }
    }
}

