/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.zuul.netty.connectionpool;

import com.google.common.collect.Sets;
import com.netflix.appinfo.InstanceInfo;
import com.netflix.client.config.CommonClientConfigKey;
import com.netflix.client.config.IClientConfig;
import com.netflix.loadbalancer.DynamicServerListLoadBalancer;
import com.netflix.loadbalancer.LoadBalancerStats;
import com.netflix.loadbalancer.Server;
import com.netflix.loadbalancer.ServerStats;
import com.netflix.loadbalancer.ZoneAwareLoadBalancer;
import com.netflix.niws.loadbalancer.DiscoveryEnabledServer;
import com.netflix.spectator.api.Counter;
import com.netflix.spectator.api.Id;
import com.netflix.spectator.api.Registry;
import com.netflix.spectator.api.Timer;
import com.netflix.spectator.api.histogram.PercentileTimer;
import com.netflix.zuul.exception.OutboundErrorType;
import com.netflix.zuul.netty.SpectatorUtils;
import com.netflix.zuul.netty.connectionpool.ClientChannelManager;
import com.netflix.zuul.netty.connectionpool.ConnectionPoolConfig;
import com.netflix.zuul.netty.connectionpool.ConnectionPoolConfigImpl;
import com.netflix.zuul.netty.connectionpool.DefaultOriginChannelInitializer;
import com.netflix.zuul.netty.connectionpool.IConnectionPool;
import com.netflix.zuul.netty.connectionpool.NettyClientConnectionFactory;
import com.netflix.zuul.netty.connectionpool.OriginChannelInitializer;
import com.netflix.zuul.netty.connectionpool.OriginConnectException;
import com.netflix.zuul.netty.connectionpool.PerServerConnectionPool;
import com.netflix.zuul.netty.connectionpool.PooledConnection;
import com.netflix.zuul.netty.connectionpool.PooledConnectionFactory;
import com.netflix.zuul.passport.CurrentPassport;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoop;
import io.netty.handler.timeout.IdleStateHandler;
import io.netty.util.concurrent.Promise;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultClientChannelManager
implements ClientChannelManager {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultClientChannelManager.class);
    public static final String METRIC_PREFIX = "connectionpool";
    private final DynamicServerListLoadBalancer loadBalancer;
    private final ConnectionPoolConfig connPoolConfig;
    private final IClientConfig clientConfig;
    private final Registry spectatorRegistry;
    private final String vip;
    private static final Throwable SHUTTING_DOWN_ERR = new IllegalStateException("ConnectionPool is shutting down now.");
    private volatile boolean shuttingDown = false;
    private final Counter createNewConnCounter;
    private final Counter createConnSucceededCounter;
    private final Counter createConnFailedCounter;
    private final Counter closeConnCounter;
    private final Counter requestConnCounter;
    private final Counter reuseConnCounter;
    private final Counter releaseConnCounter;
    private final Counter alreadyClosedCounter;
    private final Counter connTakenFromPoolIsNotOpen;
    private final Counter maxConnsPerHostExceededCounter;
    private final Counter closeWrtBusyConnCounter;
    private final PercentileTimer connEstablishTimer;
    private final AtomicInteger connsInPool;
    private final AtomicInteger connsInUse;
    private final ConcurrentHashMap<Server, IConnectionPool> perServerPools;
    private NettyClientConnectionFactory clientConnFactory;
    private OriginChannelInitializer channelInitializer;
    public static final String IDLE_STATE_HANDLER_NAME = "idleStateHandler";

    public DefaultClientChannelManager(String originName, String vip, IClientConfig clientConfig, Registry spectatorRegistry) {
        this.loadBalancer = this.createLoadBalancer(clientConfig);
        this.vip = vip;
        this.clientConfig = clientConfig;
        this.spectatorRegistry = spectatorRegistry;
        this.perServerPools = new ConcurrentHashMap(200);
        this.loadBalancer.addServerListChangeListener((oldList, newList) -> this.removeMissingServerConnectionPools(oldList, newList));
        this.connPoolConfig = new ConnectionPoolConfigImpl(originName, this.clientConfig);
        this.createNewConnCounter = SpectatorUtils.newCounter("connectionpool_create", originName);
        this.createConnSucceededCounter = SpectatorUtils.newCounter("connectionpool_create_success", originName);
        this.createConnFailedCounter = SpectatorUtils.newCounter("connectionpool_create_fail", originName);
        this.closeConnCounter = SpectatorUtils.newCounter("connectionpool_close", originName);
        this.requestConnCounter = SpectatorUtils.newCounter("connectionpool_request", originName);
        this.reuseConnCounter = SpectatorUtils.newCounter("connectionpool_reuse", originName);
        this.releaseConnCounter = SpectatorUtils.newCounter("connectionpool_release", originName);
        this.alreadyClosedCounter = SpectatorUtils.newCounter("connectionpool_alreadyClosed", originName);
        this.connTakenFromPoolIsNotOpen = SpectatorUtils.newCounter("connectionpool_fromPoolIsClosed", originName);
        this.maxConnsPerHostExceededCounter = SpectatorUtils.newCounter("connectionpool_maxConnsPerHostExceeded", originName);
        this.closeWrtBusyConnCounter = SpectatorUtils.newCounter("connectionpool_closeWrtBusyConnCounter", originName);
        this.connEstablishTimer = PercentileTimer.get((Registry)spectatorRegistry, (Id)spectatorRegistry.createId("connectionpool_createTiming", new String[]{"id", originName}));
        this.connsInPool = SpectatorUtils.newGauge("connectionpool_inPool", originName, new AtomicInteger());
        this.connsInUse = SpectatorUtils.newGauge("connectionpool_inUse", originName, new AtomicInteger());
    }

    @Override
    public void init() {
        this.channelInitializer = this.createChannelInitializer(this.clientConfig, this.connPoolConfig, this.spectatorRegistry);
        this.clientConnFactory = this.createNettyClientConnectionFactory(this.connPoolConfig, this.channelInitializer);
    }

    protected OriginChannelInitializer createChannelInitializer(IClientConfig clientConfig, ConnectionPoolConfig connPoolConfig, Registry registry) {
        return new DefaultOriginChannelInitializer(connPoolConfig, registry);
    }

    protected NettyClientConnectionFactory createNettyClientConnectionFactory(ConnectionPoolConfig connPoolConfig, ChannelInitializer<? extends Channel> clientConnInitializer) {
        return new NettyClientConnectionFactory(connPoolConfig, clientConnInitializer);
    }

    protected DynamicServerListLoadBalancer createLoadBalancer(IClientConfig clientConfig) {
        DynamicServerListLoadBalancer lb;
        String defaultLoadBalancerClassName = this.getLoadBalancerClass().getName();
        String loadBalancerClassName = (String)clientConfig.get(CommonClientConfigKey.NFLoadBalancerClassName, (Object)defaultLoadBalancerClassName);
        try {
            Class<?> clazz = Class.forName(loadBalancerClassName);
            lb = (DynamicServerListLoadBalancer)clazz.newInstance();
            lb.initWithNiwsConfig(clientConfig);
        }
        catch (Exception e) {
            throw new IllegalStateException("Could not instantiate requested class for LoadBalancer! loadBalancerClassNam=" + String.valueOf(loadBalancerClassName), e);
        }
        return lb;
    }

    protected Class<? extends DynamicServerListLoadBalancer> getLoadBalancerClass() {
        return ZoneAwareLoadBalancer.class;
    }

    protected void removeMissingServerConnectionPools(List<Server> oldList, List<Server> newList) {
        HashSet<Server> oldSet = new HashSet<Server>(oldList);
        HashSet<Server> newSet = new HashSet<Server>(newList);
        Sets.SetView removedSet = Sets.difference(oldSet, newSet);
        if (!removedSet.isEmpty()) {
            LOG.debug("Removing connection pools for missing servers. vip = " + this.vip + ". " + removedSet.size() + " servers gone.");
            for (Server s : removedSet) {
                IConnectionPool pool = this.perServerPools.remove(s);
                if (pool == null) continue;
                pool.shutdown();
            }
        }
    }

    @Override
    public ConnectionPoolConfig getConfig() {
        return this.connPoolConfig;
    }

    @Override
    public boolean isAvailable() {
        return !this.loadBalancer.getReachableServers().isEmpty();
    }

    @Override
    public boolean isCold() {
        return false;
    }

    @Override
    public int getInflightRequestsCount() {
        return this.channelInitializer.getHttpMetricsHandler().getInflightRequestsCount();
    }

    @Override
    public void shutdown() {
        this.shuttingDown = true;
        this.loadBalancer.shutdown();
        for (IConnectionPool pool : this.perServerPools.values()) {
            pool.shutdown();
        }
    }

    @Override
    public boolean release(PooledConnection conn) {
        conn.stopRequestTimer();
        this.releaseConnCounter.increment();
        this.connsInUse.decrementAndGet();
        ServerStats stats = conn.getServerStats();
        stats.decrementActiveRequestsCount();
        stats.incrementNumRequests();
        if (this.shuttingDown) {
            return false;
        }
        boolean released = false;
        if (conn.isShouldClose() || conn.getUsageCount() > (long)this.connPoolConfig.getMaxRequestsPerConnection()) {
            conn.setInPool(false);
            conn.close();
        } else if (stats.isCircuitBreakerTripped()) {
            conn.setInPool(false);
            conn.close();
        } else if (!conn.isActive()) {
            this.alreadyClosedCounter.increment();
            conn.updateServerStats();
            conn.setInPool(false);
        } else {
            this.releaseHandlers(conn);
            IConnectionPool pool = this.perServerPools.get(conn.getServer());
            if (pool != null) {
                released = pool.release(conn);
            } else {
                conn.setInPool(false);
                released = false;
                conn.close();
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("PooledConnection released: " + conn.toString());
            }
        }
        return released;
    }

    protected void releaseHandlers(PooledConnection conn) {
        ChannelPipeline pipeline = conn.getChannel().pipeline();
        DefaultClientChannelManager.removeHandlerFromPipeline("_origin_response_receiver", pipeline);
        pipeline.addAfter("PassportStateHttpClientHandler", IDLE_STATE_HANDLER_NAME, (ChannelHandler)new IdleStateHandler(0L, 0L, (long)this.connPoolConfig.getIdleTimeout(), TimeUnit.MILLISECONDS));
    }

    public static void removeHandlerFromPipeline(String handlerName, ChannelPipeline pipeline) {
        if (pipeline.get(handlerName) != null) {
            pipeline.remove(handlerName);
        }
    }

    @Override
    public boolean remove(PooledConnection conn) {
        if (conn == null) {
            return false;
        }
        if (!conn.isInPool()) {
            return false;
        }
        IConnectionPool pool = this.perServerPools.get(conn.getServer());
        if (pool != null) {
            return pool.remove(conn);
        }
        conn.setInPool(false);
        this.connsInPool.decrementAndGet();
        return false;
    }

    @Override
    public Promise<PooledConnection> acquire(EventLoop eventLoop) {
        return this.acquire(eventLoop, null, null, null, 1, CurrentPassport.create(), new AtomicReference<Server>(), new AtomicReference<String>());
    }

    @Override
    public Promise<PooledConnection> acquire(EventLoop eventLoop, Object key, String httpMethod, String uri, int attemptNum, CurrentPassport passport, AtomicReference<Server> selectedServer, AtomicReference<String> selectedHostAdddr) {
        if (attemptNum < 1) {
            throw new IllegalArgumentException("attemptNum must be greater than zero");
        }
        if (this.shuttingDown) {
            Promise promise = eventLoop.newPromise();
            promise.setFailure(SHUTTING_DOWN_ERR);
            return promise;
        }
        Server chosenServer = this.loadBalancer.chooseServer(key);
        if (chosenServer == null) {
            Promise promise = eventLoop.newPromise();
            promise.setFailure((Throwable)new OriginConnectException("No servers available", OutboundErrorType.NO_AVAILABLE_SERVERS));
            return promise;
        }
        InstanceInfo instanceInfo = chosenServer instanceof DiscoveryEnabledServer ? ((DiscoveryEnabledServer)chosenServer).getInstanceInfo() : new InstanceInfo(chosenServer.getId(), null, null, chosenServer.getHost(), chosenServer.getId(), null, null, null, null, null, null, null, null, 0, null, null, null, null, null, null, null, null, null, null, null, null);
        selectedServer.set(chosenServer);
        IConnectionPool pool = this.perServerPools.computeIfAbsent(chosenServer, s -> {
            LoadBalancerStats lbStats = this.loadBalancer.getLoadBalancerStats();
            ServerStats stats = lbStats.getSingleServerStat(chosenServer);
            DefaultClientChannelManager clientChannelMgr = this;
            PooledConnectionFactory pcf = this.createPooledConnectionFactory(chosenServer, instanceInfo, stats, clientChannelMgr, this.closeConnCounter, this.closeWrtBusyConnCounter);
            return this.createConnectionPool(chosenServer, stats, instanceInfo, this.clientConnFactory, pcf, this.connPoolConfig, this.clientConfig, this.createNewConnCounter, this.createConnSucceededCounter, this.createConnFailedCounter, this.requestConnCounter, this.reuseConnCounter, this.connTakenFromPoolIsNotOpen, this.maxConnsPerHostExceededCounter, this.connEstablishTimer, this.connsInPool, this.connsInUse);
        });
        return pool.acquire(eventLoop, null, httpMethod, uri, attemptNum, passport, selectedHostAdddr);
    }

    protected PooledConnectionFactory createPooledConnectionFactory(Server chosenServer, InstanceInfo instanceInfo, ServerStats stats, ClientChannelManager clientChannelMgr, Counter closeConnCounter, Counter closeWrtBusyConnCounter) {
        return ch -> new PooledConnection(ch, chosenServer, clientChannelMgr, instanceInfo, stats, closeConnCounter, closeWrtBusyConnCounter);
    }

    protected IConnectionPool createConnectionPool(Server chosenServer, ServerStats stats, InstanceInfo instanceInfo, NettyClientConnectionFactory clientConnFactory, PooledConnectionFactory pcf, ConnectionPoolConfig connPoolConfig, IClientConfig clientConfig, Counter createNewConnCounter, Counter createConnSucceededCounter, Counter createConnFailedCounter, Counter requestConnCounter, Counter reuseConnCounter, Counter connTakenFromPoolIsNotOpen, Counter maxConnsPerHostExceededCounter, PercentileTimer connEstablishTimer, AtomicInteger connsInPool, AtomicInteger connsInUse) {
        return new PerServerConnectionPool(chosenServer, stats, instanceInfo, clientConnFactory, pcf, connPoolConfig, clientConfig, createNewConnCounter, createConnSucceededCounter, createConnFailedCounter, requestConnCounter, reuseConnCounter, connTakenFromPoolIsNotOpen, maxConnsPerHostExceededCounter, (Timer)connEstablishTimer, connsInPool, connsInUse);
    }

    @Override
    public int getConnsInPool() {
        return this.connsInPool.get();
    }

    @Override
    public int getConnsInUse() {
        return this.connsInUse.get();
    }

    public DynamicServerListLoadBalancer getLoadBalancer() {
        return this.loadBalancer;
    }

    public IClientConfig getClientConfig() {
        return this.loadBalancer.getClientConfig();
    }

    protected ConcurrentHashMap<Server, IConnectionPool> getPerServerPools() {
        return this.perServerPools;
    }
}

