/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.zuul.message.http;

import com.netflix.zuul.message.HeaderName;
import java.util.concurrent.ConcurrentHashMap;

public class HttpHeaderNamesCache {
    private final ConcurrentHashMap<String, HeaderName> cache;
    private final int maxSize;

    public HttpHeaderNamesCache(int initialSize, int maxSize) {
        this.cache = new ConcurrentHashMap(initialSize);
        this.maxSize = maxSize;
    }

    public boolean isFull() {
        return this.cache.size() >= this.maxSize;
    }

    public HeaderName get(String name) {
        HeaderName hn = this.cache.get(name);
        if (hn == null) {
            hn = this.isFull() ? new HeaderName(name) : this.cache.computeIfAbsent(name, newName -> new HeaderName((String)newName));
        }
        return hn;
    }
}

