/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.netty.common.metrics;

import com.netflix.netty.common.HttpLifecycleChannelHandler;
import com.netflix.netty.common.metrics.EventLoopGroupMetrics;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.util.AttributeKey;

public class PerEventLoopMetricsChannelHandler {
    private static final AttributeKey<Object> ATTR_REQ_INFLIGHT = AttributeKey.newInstance((String)"_eventloop_metrics_inflight");
    private static final Object INFLIGHT = "eventloop_is_inflight";
    private final EventLoopGroupMetrics groupMetrics;

    public PerEventLoopMetricsChannelHandler(EventLoopGroupMetrics groupMetrics) {
        this.groupMetrics = groupMetrics;
    }

    @ChannelHandler.Sharable
    public class HttpRequests
    extends ChannelInboundHandlerAdapter {
        public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
            if (evt instanceof HttpLifecycleChannelHandler.StartEvent) {
                this.incrementCurrentRequestsInFlight(ctx);
            } else if (evt instanceof HttpLifecycleChannelHandler.CompleteEvent) {
                this.decrementCurrentRequestsIfOneInflight(ctx);
            }
            super.userEventTriggered(ctx, evt);
        }

        private void incrementCurrentRequestsInFlight(ChannelHandlerContext ctx) {
            PerEventLoopMetricsChannelHandler.this.groupMetrics.getForCurrentEventLoop().incrementCurrentRequests();
            ctx.channel().attr(ATTR_REQ_INFLIGHT).set(INFLIGHT);
        }

        private void decrementCurrentRequestsIfOneInflight(ChannelHandlerContext ctx) {
            if (ctx.channel().attr(ATTR_REQ_INFLIGHT).getAndRemove() != null) {
                PerEventLoopMetricsChannelHandler.this.groupMetrics.getForCurrentEventLoop().decrementCurrentRequests();
            }
        }
    }

    @ChannelHandler.Sharable
    public class Connections
    extends ChannelInboundHandlerAdapter {
        public void channelActive(ChannelHandlerContext ctx) throws Exception {
            PerEventLoopMetricsChannelHandler.this.groupMetrics.getForCurrentEventLoop().incrementCurrentConnections();
            super.channelActive(ctx);
        }

        public void channelInactive(ChannelHandlerContext ctx) throws Exception {
            try {
                super.channelInactive(ctx);
            }
            finally {
                PerEventLoopMetricsChannelHandler.this.groupMetrics.getForCurrentEventLoop().decrementCurrentConnections();
            }
        }
    }
}

